"""SelectedDesignConstraintsCollection"""
from __future__ import annotations

from typing import TYPE_CHECKING, ClassVar

from mastapy._private._internal.dataclasses import extended_dataclass
from mastapy._private._internal.python_net import python_net_import
from mastapy._private import _0
from mastapy._private._internal.cast_exception import CastException
from mastapy._private._internal import utility

_SELECTED_DESIGN_CONSTRAINTS_COLLECTION = python_net_import(
    "SMT.MastaAPI.Gears.GearDesigns", "SelectedDesignConstraintsCollection"
)

if TYPE_CHECKING:
    from typing import Any, Type, TypeVar

    Self = TypeVar("Self", bound="SelectedDesignConstraintsCollection")
    CastSelf = TypeVar(
        "CastSelf",
        bound="SelectedDesignConstraintsCollection._Cast_SelectedDesignConstraintsCollection",
    )


__docformat__ = "restructuredtext en"
__all__ = ("SelectedDesignConstraintsCollection",)


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class _Cast_SelectedDesignConstraintsCollection:
    """Special nested class for casting SelectedDesignConstraintsCollection to subclasses."""

    __parent__: "SelectedDesignConstraintsCollection"

    @property
    def selected_design_constraints_collection(
        self: "CastSelf",
    ) -> "SelectedDesignConstraintsCollection":
        return self.__parent__

    def __getattr__(self: "CastSelf", name: str) -> "Any":
        try:
            return self.__getattribute__(name)
        except AttributeError:
            class_name = utility.camel(name)
            raise CastException(
                f'Detected an invalid cast. Cannot cast to type "{class_name}"'
            ) from None


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class SelectedDesignConstraintsCollection(_0.APIBase):
    """SelectedDesignConstraintsCollection

    This is a mastapy class.
    """

    TYPE: ClassVar["Type"] = _SELECTED_DESIGN_CONSTRAINTS_COLLECTION

    wrapped: "Any"

    def __post_init__(self: "Self") -> None:
        """Override of the post initialisation magic method."""
        if not hasattr(self.wrapped, "reference_count"):
            self.wrapped.reference_count = 0

        self.wrapped.reference_count += 1

    @property
    def cast_to(self: "Self") -> "_Cast_SelectedDesignConstraintsCollection":
        """Cast to another type.

        Returns:
            _Cast_SelectedDesignConstraintsCollection
        """
        return _Cast_SelectedDesignConstraintsCollection(self)
