"""RootStressSurfaceChartOption"""
from __future__ import annotations

from typing import TYPE_CHECKING
from enum import Enum

from mastapy._private._internal.python_net import python_net_import

_ROOT_STRESS_SURFACE_CHART_OPTION = python_net_import(
    "SMT.MastaAPI.Gears.GearDesigns.Cylindrical", "RootStressSurfaceChartOption"
)

if TYPE_CHECKING:
    from typing import Any, Type, TypeVar

    Self = TypeVar("Self", bound="RootStressSurfaceChartOption")
    CastSelf = TypeVar(
        "CastSelf",
        bound="RootStressSurfaceChartOption._Cast_RootStressSurfaceChartOption",
    )


__docformat__ = "restructuredtext en"
__all__ = ("RootStressSurfaceChartOption",)


class RootStressSurfaceChartOption(Enum):
    """RootStressSurfaceChartOption

    This is a mastapy class.

    Note:
        This class is an Enum.
    """

    @classmethod
    def type_(cls) -> "Type":
        return _ROOT_STRESS_SURFACE_CHART_OPTION

    DISTANCE_ALONG_FILLET = 0
    DIAMETER = 1
    RADIUS = 2


def __enum_setattr(self: "Self", attr: str, value: "Any") -> None:
    raise AttributeError("Cannot set the attributes of an Enum.") from None


def __enum_delattr(self: "Self", attr: str) -> None:
    raise AttributeError("Cannot delete the attributes of an Enum.") from None


RootStressSurfaceChartOption.__setattr__ = __enum_setattr
RootStressSurfaceChartOption.__delattr__ = __enum_delattr
