"""MicroGeometryDesignSpaceSearchChartInformation"""
from __future__ import annotations

from typing import TYPE_CHECKING, ClassVar

from mastapy._private._internal.dataclasses import extended_dataclass
from mastapy._private._internal.python_net import (
    pythonnet_property_get,
    python_net_import,
)
from mastapy._private._internal import constructor, utility
from mastapy._private.gears.gear_set_pareto_optimiser import _929, _942
from mastapy._private.gears.ltca.cylindrical import _885
from mastapy._private._internal.cast_exception import CastException

_MICRO_GEOMETRY_DESIGN_SPACE_SEARCH_CHART_INFORMATION = python_net_import(
    "SMT.MastaAPI.Gears.GearSetParetoOptimiser",
    "MicroGeometryDesignSpaceSearchChartInformation",
)

if TYPE_CHECKING:
    from typing import Any, Type, TypeVar

    from mastapy._private.gears.gear_set_pareto_optimiser import _941

    Self = TypeVar("Self", bound="MicroGeometryDesignSpaceSearchChartInformation")
    CastSelf = TypeVar(
        "CastSelf",
        bound="MicroGeometryDesignSpaceSearchChartInformation._Cast_MicroGeometryDesignSpaceSearchChartInformation",
    )


__docformat__ = "restructuredtext en"
__all__ = ("MicroGeometryDesignSpaceSearchChartInformation",)


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class _Cast_MicroGeometryDesignSpaceSearchChartInformation:
    """Special nested class for casting MicroGeometryDesignSpaceSearchChartInformation to subclasses."""

    __parent__: "MicroGeometryDesignSpaceSearchChartInformation"

    @property
    def chart_info_base(self: "CastSelf") -> "_929.ChartInfoBase":
        return self.__parent__._cast(_929.ChartInfoBase)

    @property
    def micro_geometry_design_space_search_chart_information(
        self: "CastSelf",
    ) -> "MicroGeometryDesignSpaceSearchChartInformation":
        return self.__parent__

    def __getattr__(self: "CastSelf", name: str) -> "Any":
        try:
            return self.__getattribute__(name)
        except AttributeError:
            class_name = utility.camel(name)
            raise CastException(
                f'Detected an invalid cast. Cannot cast to type "{class_name}"'
            ) from None


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class MicroGeometryDesignSpaceSearchChartInformation(
    _929.ChartInfoBase[
        _885.CylindricalGearSetLoadDistributionAnalysis,
        _942.MicroGeometryDesignSpaceSearchCandidate,
    ]
):
    """MicroGeometryDesignSpaceSearchChartInformation

    This is a mastapy class.
    """

    TYPE: ClassVar["Type"] = _MICRO_GEOMETRY_DESIGN_SPACE_SEARCH_CHART_INFORMATION

    wrapped: "Any"

    def __post_init__(self: "Self") -> None:
        """Override of the post initialisation magic method."""
        if not hasattr(self.wrapped, "reference_count"):
            self.wrapped.reference_count = 0

        self.wrapped.reference_count += 1

    @property
    def optimiser(self: "Self") -> "_941.MicroGeometryDesignSpaceSearch":
        """mastapy._private.gears.gear_set_pareto_optimiser.MicroGeometryDesignSpaceSearch

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "Optimiser")

        if temp is None:
            return None

        type_ = temp.GetType()
        return constructor.new(type_.Namespace, type_.Name)(temp)

    @property
    def cast_to(self: "Self") -> "_Cast_MicroGeometryDesignSpaceSearchChartInformation":
        """Cast to another type.

        Returns:
            _Cast_MicroGeometryDesignSpaceSearchChartInformation
        """
        return _Cast_MicroGeometryDesignSpaceSearchChartInformation(self)
