"""MetalPlasticOrPlasticMetalVDI2736MeshSingleFlankRating"""
from __future__ import annotations

from typing import TYPE_CHECKING, ClassVar

from mastapy._private._internal.dataclasses import extended_dataclass
from mastapy._private._internal.python_net import python_net_import
from mastapy._private.gears.rating.cylindrical.plastic_vdi2736 import _505
from mastapy._private._internal.cast_exception import CastException
from mastapy._private._internal import utility

_METAL_PLASTIC_OR_PLASTIC_METAL_VDI2736_MESH_SINGLE_FLANK_RATING = python_net_import(
    "SMT.MastaAPI.Gears.Rating.Cylindrical.PlasticVDI2736",
    "MetalPlasticOrPlasticMetalVDI2736MeshSingleFlankRating",
)

if TYPE_CHECKING:
    from typing import Any, Type, TypeVar

    from mastapy._private.gears.rating.cylindrical.iso6336 import _531
    from mastapy._private.gears.rating.cylindrical import _480
    from mastapy._private.gears.rating import _379

    Self = TypeVar(
        "Self", bound="MetalPlasticOrPlasticMetalVDI2736MeshSingleFlankRating"
    )
    CastSelf = TypeVar(
        "CastSelf",
        bound="MetalPlasticOrPlasticMetalVDI2736MeshSingleFlankRating._Cast_MetalPlasticOrPlasticMetalVDI2736MeshSingleFlankRating",
    )


__docformat__ = "restructuredtext en"
__all__ = ("MetalPlasticOrPlasticMetalVDI2736MeshSingleFlankRating",)


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class _Cast_MetalPlasticOrPlasticMetalVDI2736MeshSingleFlankRating:
    """Special nested class for casting MetalPlasticOrPlasticMetalVDI2736MeshSingleFlankRating to subclasses."""

    __parent__: "MetalPlasticOrPlasticMetalVDI2736MeshSingleFlankRating"

    @property
    def plastic_gear_vdi2736_abstract_mesh_single_flank_rating(
        self: "CastSelf",
    ) -> "_505.PlasticGearVDI2736AbstractMeshSingleFlankRating":
        return self.__parent__._cast(
            _505.PlasticGearVDI2736AbstractMeshSingleFlankRating
        )

    @property
    def iso6336_abstract_mesh_single_flank_rating(
        self: "CastSelf",
    ) -> "_531.ISO6336AbstractMeshSingleFlankRating":
        from mastapy._private.gears.rating.cylindrical.iso6336 import _531

        return self.__parent__._cast(_531.ISO6336AbstractMeshSingleFlankRating)

    @property
    def cylindrical_mesh_single_flank_rating(
        self: "CastSelf",
    ) -> "_480.CylindricalMeshSingleFlankRating":
        from mastapy._private.gears.rating.cylindrical import _480

        return self.__parent__._cast(_480.CylindricalMeshSingleFlankRating)

    @property
    def mesh_single_flank_rating(self: "CastSelf") -> "_379.MeshSingleFlankRating":
        from mastapy._private.gears.rating import _379

        return self.__parent__._cast(_379.MeshSingleFlankRating)

    @property
    def metal_plastic_or_plastic_metal_vdi2736_mesh_single_flank_rating(
        self: "CastSelf",
    ) -> "MetalPlasticOrPlasticMetalVDI2736MeshSingleFlankRating":
        return self.__parent__

    def __getattr__(self: "CastSelf", name: str) -> "Any":
        try:
            return self.__getattribute__(name)
        except AttributeError:
            class_name = utility.camel(name)
            raise CastException(
                f'Detected an invalid cast. Cannot cast to type "{class_name}"'
            ) from None


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class MetalPlasticOrPlasticMetalVDI2736MeshSingleFlankRating(
    _505.PlasticGearVDI2736AbstractMeshSingleFlankRating
):
    """MetalPlasticOrPlasticMetalVDI2736MeshSingleFlankRating

    This is a mastapy class.
    """

    TYPE: ClassVar[
        "Type"
    ] = _METAL_PLASTIC_OR_PLASTIC_METAL_VDI2736_MESH_SINGLE_FLANK_RATING

    wrapped: "Any"

    def __post_init__(self: "Self") -> None:
        """Override of the post initialisation magic method."""
        if not hasattr(self.wrapped, "reference_count"):
            self.wrapped.reference_count = 0

        self.wrapped.reference_count += 1

    @property
    def cast_to(
        self: "Self",
    ) -> "_Cast_MetalPlasticOrPlasticMetalVDI2736MeshSingleFlankRating":
        """Cast to another type.

        Returns:
            _Cast_MetalPlasticOrPlasticMetalVDI2736MeshSingleFlankRating
        """
        return _Cast_MetalPlasticOrPlasticMetalVDI2736MeshSingleFlankRating(self)
