"""CADFaceGroup"""
from __future__ import annotations

from typing import TYPE_CHECKING, ClassVar

from mastapy._private._internal.dataclasses import extended_dataclass
from mastapy._private._internal.type_enforcement import enforce_parameter_types
from mastapy._private._internal.python_net import (
    pythonnet_method_call,
    python_net_import,
)
from mastapy._private._internal import constructor, utility
from mastapy._private import _0
from mastapy._private._internal.cast_exception import CastException

_CAD_FACE_GROUP = python_net_import("SMT.MastaAPI.Geometry.TwoD", "CADFaceGroup")

if TYPE_CHECKING:
    from typing import Any, Type, TypeVar

    from mastapy._private.geometry.two_d import _322

    Self = TypeVar("Self", bound="CADFaceGroup")
    CastSelf = TypeVar("CastSelf", bound="CADFaceGroup._Cast_CADFaceGroup")


__docformat__ = "restructuredtext en"
__all__ = ("CADFaceGroup",)


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class _Cast_CADFaceGroup:
    """Special nested class for casting CADFaceGroup to subclasses."""

    __parent__: "CADFaceGroup"

    @property
    def cad_face_group(self: "CastSelf") -> "CADFaceGroup":
        return self.__parent__

    def __getattr__(self: "CastSelf", name: str) -> "Any":
        try:
            return self.__getattribute__(name)
        except AttributeError:
            class_name = utility.camel(name)
            raise CastException(
                f'Detected an invalid cast. Cannot cast to type "{class_name}"'
            ) from None


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class CADFaceGroup(_0.APIBase):
    """CADFaceGroup

    This is a mastapy class.
    """

    TYPE: ClassVar["Type"] = _CAD_FACE_GROUP

    wrapped: "Any"

    def __post_init__(self: "Self") -> None:
        """Override of the post initialisation magic method."""
        if not hasattr(self.wrapped, "reference_count"):
            self.wrapped.reference_count = 0

        self.wrapped.reference_count += 1

    @enforce_parameter_types
    def add_face(self: "Self", moniker: "str") -> "_322.CADFace":
        """mastapy._private.geometry.two_d.CADFace

        Args:
            moniker (str)
        """
        moniker = str(moniker)
        method_result = pythonnet_method_call(
            self.wrapped, "AddFace", moniker if moniker else ""
        )
        type_ = method_result.GetType()
        return (
            constructor.new(type_.Namespace, type_.Name)(method_result)
            if method_result is not None
            else None
        )

    @property
    def cast_to(self: "Self") -> "_Cast_CADFaceGroup":
        """Cast to another type.

        Returns:
            _Cast_CADFaceGroup
        """
        return _Cast_CADFaceGroup(self)
