"""InternalExternalType"""
from __future__ import annotations

from typing import TYPE_CHECKING
from enum import Enum

from mastapy._private._internal.python_net import python_net_import

_INTERNAL_EXTERNAL_TYPE = python_net_import(
    "SMT.MastaAPI.Geometry.TwoD", "InternalExternalType"
)

if TYPE_CHECKING:
    from typing import Any, Type, TypeVar

    Self = TypeVar("Self", bound="InternalExternalType")
    CastSelf = TypeVar(
        "CastSelf", bound="InternalExternalType._Cast_InternalExternalType"
    )


__docformat__ = "restructuredtext en"
__all__ = ("InternalExternalType",)


class InternalExternalType(Enum):
    """InternalExternalType

    This is a mastapy class.

    Note:
        This class is an Enum.
    """

    @classmethod
    def type_(cls) -> "Type":
        return _INTERNAL_EXTERNAL_TYPE

    INTERNAL = 0
    EXTERNAL = 1


def __enum_setattr(self: "Self", attr: str, value: "Any") -> None:
    raise AttributeError("Cannot set the attributes of an Enum.") from None


def __enum_delattr(self: "Self", attr: str) -> None:
    raise AttributeError("Cannot delete the attributes of an Enum.") from None


InternalExternalType.__setattr__ = __enum_setattr
InternalExternalType.__delattr__ = __enum_delattr
