"""StressCyclesDataForTheBendingSNCurveOfAPlasticMaterial"""
from __future__ import annotations

from typing import TYPE_CHECKING, ClassVar

from mastapy._private._internal.dataclasses import extended_dataclass
from mastapy._private._internal.type_enforcement import enforce_parameter_types
from mastapy._private._internal.python_net import (
    pythonnet_property_get,
    pythonnet_property_set,
    python_net_import,
)
from mastapy._private._internal import utility
from mastapy._private.materials import _249
from mastapy._private._internal.cast_exception import CastException

_STRESS_CYCLES_DATA_FOR_THE_BENDING_SN_CURVE_OF_A_PLASTIC_MATERIAL = python_net_import(
    "SMT.MastaAPI.Materials", "StressCyclesDataForTheBendingSNCurveOfAPlasticMaterial"
)

if TYPE_CHECKING:
    from typing import Any, Type, TypeVar

    Self = TypeVar(
        "Self", bound="StressCyclesDataForTheBendingSNCurveOfAPlasticMaterial"
    )
    CastSelf = TypeVar(
        "CastSelf",
        bound="StressCyclesDataForTheBendingSNCurveOfAPlasticMaterial._Cast_StressCyclesDataForTheBendingSNCurveOfAPlasticMaterial",
    )


__docformat__ = "restructuredtext en"
__all__ = ("StressCyclesDataForTheBendingSNCurveOfAPlasticMaterial",)


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class _Cast_StressCyclesDataForTheBendingSNCurveOfAPlasticMaterial:
    """Special nested class for casting StressCyclesDataForTheBendingSNCurveOfAPlasticMaterial to subclasses."""

    __parent__: "StressCyclesDataForTheBendingSNCurveOfAPlasticMaterial"

    @property
    def abstract_stress_cycles_data_for_an_sn_curve_of_a_plastic_material(
        self: "CastSelf",
    ) -> "_249.AbstractStressCyclesDataForAnSNCurveOfAPlasticMaterial":
        return self.__parent__._cast(
            _249.AbstractStressCyclesDataForAnSNCurveOfAPlasticMaterial
        )

    @property
    def stress_cycles_data_for_the_bending_sn_curve_of_a_plastic_material(
        self: "CastSelf",
    ) -> "StressCyclesDataForTheBendingSNCurveOfAPlasticMaterial":
        return self.__parent__

    def __getattr__(self: "CastSelf", name: str) -> "Any":
        try:
            return self.__getattribute__(name)
        except AttributeError:
            class_name = utility.camel(name)
            raise CastException(
                f'Detected an invalid cast. Cannot cast to type "{class_name}"'
            ) from None


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class StressCyclesDataForTheBendingSNCurveOfAPlasticMaterial(
    _249.AbstractStressCyclesDataForAnSNCurveOfAPlasticMaterial
):
    """StressCyclesDataForTheBendingSNCurveOfAPlasticMaterial

    This is a mastapy class.
    """

    TYPE: ClassVar[
        "Type"
    ] = _STRESS_CYCLES_DATA_FOR_THE_BENDING_SN_CURVE_OF_A_PLASTIC_MATERIAL

    wrapped: "Any"

    def __post_init__(self: "Self") -> None:
        """Override of the post initialisation magic method."""
        if not hasattr(self.wrapped, "reference_count"):
            self.wrapped.reference_count = 0

        self.wrapped.reference_count += 1

    @property
    def bending_fatigue_strength_under_pulsating_stress(self: "Self") -> "float":
        """float"""
        temp = pythonnet_property_get(
            self.wrapped, "BendingFatigueStrengthUnderPulsatingStress"
        )

        if temp is None:
            return 0.0

        return temp

    @bending_fatigue_strength_under_pulsating_stress.setter
    @enforce_parameter_types
    def bending_fatigue_strength_under_pulsating_stress(
        self: "Self", value: "float"
    ) -> None:
        pythonnet_property_set(
            self.wrapped,
            "BendingFatigueStrengthUnderPulsatingStress",
            float(value) if value is not None else 0.0,
        )

    @property
    def cast_to(
        self: "Self",
    ) -> "_Cast_StressCyclesDataForTheBendingSNCurveOfAPlasticMaterial":
        """Cast to another type.

        Returns:
            _Cast_StressCyclesDataForTheBendingSNCurveOfAPlasticMaterial
        """
        return _Cast_StressCyclesDataForTheBendingSNCurveOfAPlasticMaterial(self)
