"""PowerLoss"""
from __future__ import annotations

from typing import TYPE_CHECKING, ClassVar

from mastapy._private._internal.dataclasses import extended_dataclass
from mastapy._private._internal.python_net import (
    pythonnet_property_get,
    python_net_import,
)
from mastapy._private._internal import utility
from mastapy._private import _0
from mastapy._private._internal.cast_exception import CastException

_POWER_LOSS = python_net_import("SMT.MastaAPI.Materials.Efficiency", "PowerLoss")

if TYPE_CHECKING:
    from typing import Any, Type, TypeVar

    from mastapy._private.materials.efficiency import _307, _309

    Self = TypeVar("Self", bound="PowerLoss")
    CastSelf = TypeVar("CastSelf", bound="PowerLoss._Cast_PowerLoss")


__docformat__ = "restructuredtext en"
__all__ = ("PowerLoss",)


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class _Cast_PowerLoss:
    """Special nested class for casting PowerLoss to subclasses."""

    __parent__: "PowerLoss"

    @property
    def independent_power_loss(self: "CastSelf") -> "_307.IndependentPowerLoss":
        from mastapy._private.materials.efficiency import _307

        return self.__parent__._cast(_307.IndependentPowerLoss)

    @property
    def load_and_speed_combined_power_loss(
        self: "CastSelf",
    ) -> "_309.LoadAndSpeedCombinedPowerLoss":
        from mastapy._private.materials.efficiency import _309

        return self.__parent__._cast(_309.LoadAndSpeedCombinedPowerLoss)

    @property
    def power_loss(self: "CastSelf") -> "PowerLoss":
        return self.__parent__

    def __getattr__(self: "CastSelf", name: str) -> "Any":
        try:
            return self.__getattribute__(name)
        except AttributeError:
            class_name = utility.camel(name)
            raise CastException(
                f'Detected an invalid cast. Cannot cast to type "{class_name}"'
            ) from None


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class PowerLoss(_0.APIBase):
    """PowerLoss

    This is a mastapy class.
    """

    TYPE: ClassVar["Type"] = _POWER_LOSS

    wrapped: "Any"

    def __post_init__(self: "Self") -> None:
        """Override of the post initialisation magic method."""
        if not hasattr(self.wrapped, "reference_count"):
            self.wrapped.reference_count = 0

        self.wrapped.reference_count += 1

    @property
    def power_loss_calculation_details(self: "Self") -> "str":
        """str

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "PowerLossCalculationDetails")

        if temp is None:
            return ""

        return temp

    @property
    def total_power_loss(self: "Self") -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "TotalPowerLoss")

        if temp is None:
            return 0.0

        return temp

    @property
    def cast_to(self: "Self") -> "_Cast_PowerLoss":
        """Cast to another type.

        Returns:
            _Cast_PowerLoss
        """
        return _Cast_PowerLoss(self)
