"""ValueInputOption"""
from __future__ import annotations

from typing import TYPE_CHECKING
from enum import Enum

from mastapy._private._internal.python_net import python_net_import

_VALUE_INPUT_OPTION = python_net_import(
    "SMT.MastaAPI.NodalAnalysis", "ValueInputOption"
)

if TYPE_CHECKING:
    from typing import Any, Type, TypeVar

    Self = TypeVar("Self", bound="ValueInputOption")
    CastSelf = TypeVar("CastSelf", bound="ValueInputOption._Cast_ValueInputOption")


__docformat__ = "restructuredtext en"
__all__ = ("ValueInputOption",)


class ValueInputOption(Enum):
    """ValueInputOption

    This is a mastapy class.

    Note:
        This class is an Enum.
    """

    @classmethod
    def type_(cls) -> "Type":
        return _VALUE_INPUT_OPTION

    CONSTANT = 0
    VARYING_WITH_TIME = 1
    VARYING_WITH_ANGLE = 2
    VARYING_WITH_POSITION = 3
    VARYING_WITH_ANGLE_AND_SPEED = 4


def __enum_setattr(self: "Self", attr: str, value: "Any") -> None:
    raise AttributeError("Cannot set the attributes of an Enum.") from None


def __enum_delattr(self: "Self", attr: str) -> None:
    raise AttributeError("Cannot delete the attributes of an Enum.") from None


ValueInputOption.__setattr__ = __enum_setattr
ValueInputOption.__delattr__ = __enum_delattr
