"""ReductionModeType"""
from __future__ import annotations

from typing import TYPE_CHECKING
from enum import Enum

from mastapy._private._internal.python_net import python_net_import

_REDUCTION_MODE_TYPE = python_net_import(
    "SMT.MastaAPI.NodalAnalysis.ComponentModeSynthesis", "ReductionModeType"
)

if TYPE_CHECKING:
    from typing import Any, Type, TypeVar

    Self = TypeVar("Self", bound="ReductionModeType")
    CastSelf = TypeVar("CastSelf", bound="ReductionModeType._Cast_ReductionModeType")


__docformat__ = "restructuredtext en"
__all__ = ("ReductionModeType",)


class ReductionModeType(Enum):
    """ReductionModeType

    This is a mastapy class.

    Note:
        This class is an Enum.
    """

    @classmethod
    def type_(cls) -> "Type":
        return _REDUCTION_MODE_TYPE

    INTERNAL = 0
    EXTERNAL = 1


def __enum_setattr(self: "Self", attr: str, value: "Any") -> None:
    raise AttributeError("Cannot set the attributes of an Enum.") from None


def __enum_delattr(self: "Self", attr: str) -> None:
    raise AttributeError("Cannot delete the attributes of an Enum.") from None


ReductionModeType.__setattr__ = __enum_setattr
ReductionModeType.__delattr__ = __enum_delattr
