"""AdvancedTimeSteppingAnalysisForModulationOptions"""
from __future__ import annotations

from typing import TYPE_CHECKING, ClassVar

from mastapy._private._internal.dataclasses import extended_dataclass
from mastapy._private._internal.type_enforcement import enforce_parameter_types
from mastapy._private._internal.sentinels import ListWithSelectedItem_None
from mastapy._private._internal.python_net import (
    pythonnet_property_get,
    pythonnet_property_set,
    python_net_import,
)
from mastapy._private._internal import constructor, conversion, utility
from mastapy._private._internal.implicit import list_with_selected_item
from mastapy._private.system_model.analyses_and_results.static_loads import _6952
from mastapy._private import _0
from mastapy._private._internal.cast_exception import CastException

_ADVANCED_TIME_STEPPING_ANALYSIS_FOR_MODULATION_OPTIONS = python_net_import(
    "SMT.MastaAPI.SystemModel.AnalysesAndResults.AdvancedTimeSteppingAnalysesForModulation",
    "AdvancedTimeSteppingAnalysisForModulationOptions",
)

if TYPE_CHECKING:
    from typing import Any, Type, TypeVar

    from mastapy._private.system_model.analyses_and_results.static_loads import (
        _6960,
        _7043,
    )
    from mastapy._private.system_model.analyses_and_results import _2768

    Self = TypeVar("Self", bound="AdvancedTimeSteppingAnalysisForModulationOptions")
    CastSelf = TypeVar(
        "CastSelf",
        bound="AdvancedTimeSteppingAnalysisForModulationOptions._Cast_AdvancedTimeSteppingAnalysisForModulationOptions",
    )


__docformat__ = "restructuredtext en"
__all__ = ("AdvancedTimeSteppingAnalysisForModulationOptions",)


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class _Cast_AdvancedTimeSteppingAnalysisForModulationOptions:
    """Special nested class for casting AdvancedTimeSteppingAnalysisForModulationOptions to subclasses."""

    __parent__: "AdvancedTimeSteppingAnalysisForModulationOptions"

    @property
    def advanced_time_stepping_analysis_for_modulation_options(
        self: "CastSelf",
    ) -> "AdvancedTimeSteppingAnalysisForModulationOptions":
        return self.__parent__

    def __getattr__(self: "CastSelf", name: str) -> "Any":
        try:
            return self.__getattribute__(name)
        except AttributeError:
            class_name = utility.camel(name)
            raise CastException(
                f'Detected an invalid cast. Cannot cast to type "{class_name}"'
            ) from None


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class AdvancedTimeSteppingAnalysisForModulationOptions(_0.APIBase):
    """AdvancedTimeSteppingAnalysisForModulationOptions

    This is a mastapy class.
    """

    TYPE: ClassVar["Type"] = _ADVANCED_TIME_STEPPING_ANALYSIS_FOR_MODULATION_OPTIONS

    wrapped: "Any"

    def __post_init__(self: "Self") -> None:
        """Override of the post initialisation magic method."""
        if not hasattr(self.wrapped, "reference_count"):
            self.wrapped.reference_count = 0

        self.wrapped.reference_count += 1

    @property
    def advanced_time_stepping_analysis_method(
        self: "Self",
    ) -> "_6960.AdvancedTimeSteppingAnalysisForModulationType":
        """mastapy._private.system_model.analyses_and_results.static_loads.AdvancedTimeSteppingAnalysisForModulationType"""
        temp = pythonnet_property_get(
            self.wrapped, "AdvancedTimeSteppingAnalysisMethod"
        )

        if temp is None:
            return None

        value = conversion.pn_to_mp_enum(
            temp,
            "SMT.MastaAPI.SystemModel.AnalysesAndResults.StaticLoads.AdvancedTimeSteppingAnalysisForModulationType",
        )

        if value is None:
            return None

        return constructor.new_from_mastapy(
            "mastapy._private.system_model.analyses_and_results.static_loads._6960",
            "AdvancedTimeSteppingAnalysisForModulationType",
        )(value)

    @advanced_time_stepping_analysis_method.setter
    @enforce_parameter_types
    def advanced_time_stepping_analysis_method(
        self: "Self", value: "_6960.AdvancedTimeSteppingAnalysisForModulationType"
    ) -> None:
        value = conversion.mp_to_pn_enum(
            value,
            "SMT.MastaAPI.SystemModel.AnalysesAndResults.StaticLoads.AdvancedTimeSteppingAnalysisForModulationType",
        )
        pythonnet_property_set(
            self.wrapped, "AdvancedTimeSteppingAnalysisMethod", value
        )

    @property
    def include_time_offset_for_steady_state(self: "Self") -> "bool":
        """bool"""
        temp = pythonnet_property_get(self.wrapped, "IncludeTimeOffsetForSteadyState")

        if temp is None:
            return False

        return temp

    @include_time_offset_for_steady_state.setter
    @enforce_parameter_types
    def include_time_offset_for_steady_state(self: "Self", value: "bool") -> None:
        pythonnet_property_set(
            self.wrapped,
            "IncludeTimeOffsetForSteadyState",
            bool(value) if value is not None else False,
        )

    @property
    def load_case_for_advanced_time_stepping_analysis_for_modulation_time_options_and_active_fe_parts(
        self: "Self",
    ) -> "list_with_selected_item.ListWithSelectedItem_StaticLoadCase":
        """ListWithSelectedItem[mastapy._private.system_model.analyses_and_results.static_loads.StaticLoadCase]"""
        temp = pythonnet_property_get(
            self.wrapped,
            "LoadCaseForAdvancedTimeSteppingAnalysisForModulationTimeOptionsAndActiveFEParts",
        )

        if temp is None:
            return None

        selected_value = temp.SelectedValue

        if selected_value is None:
            return ListWithSelectedItem_None(temp)

        return constructor.new_from_mastapy(
            "mastapy._private._internal.implicit.list_with_selected_item",
            "ListWithSelectedItem_StaticLoadCase",
        )(temp)

    @load_case_for_advanced_time_stepping_analysis_for_modulation_time_options_and_active_fe_parts.setter
    @enforce_parameter_types
    def load_case_for_advanced_time_stepping_analysis_for_modulation_time_options_and_active_fe_parts(
        self: "Self", value: "_6952.StaticLoadCase"
    ) -> None:
        wrapper_type = (
            list_with_selected_item.ListWithSelectedItem_StaticLoadCase.wrapper_type()
        )
        enclosed_type = (
            list_with_selected_item.ListWithSelectedItem_StaticLoadCase.implicit_type()
        )
        value = wrapper_type[enclosed_type](
            value.wrapped if value is not None else None
        )
        pythonnet_property_set(
            self.wrapped,
            "LoadCaseForAdvancedTimeSteppingAnalysisForModulationTimeOptionsAndActiveFEParts",
            value,
        )

    @property
    def number_of_periods_for_advanced_time_stepping_analysis(self: "Self") -> "float":
        """float"""
        temp = pythonnet_property_get(
            self.wrapped, "NumberOfPeriodsForAdvancedTimeSteppingAnalysis"
        )

        if temp is None:
            return 0.0

        return temp

    @number_of_periods_for_advanced_time_stepping_analysis.setter
    @enforce_parameter_types
    def number_of_periods_for_advanced_time_stepping_analysis(
        self: "Self", value: "float"
    ) -> None:
        pythonnet_property_set(
            self.wrapped,
            "NumberOfPeriodsForAdvancedTimeSteppingAnalysis",
            float(value) if value is not None else 0.0,
        )

    @property
    def number_of_steps_for_advanced_time_stepping_analysis(self: "Self") -> "int":
        """int"""
        temp = pythonnet_property_get(
            self.wrapped, "NumberOfStepsForAdvancedTimeSteppingAnalysis"
        )

        if temp is None:
            return 0

        return temp

    @number_of_steps_for_advanced_time_stepping_analysis.setter
    @enforce_parameter_types
    def number_of_steps_for_advanced_time_stepping_analysis(
        self: "Self", value: "int"
    ) -> None:
        pythonnet_property_set(
            self.wrapped,
            "NumberOfStepsForAdvancedTimeSteppingAnalysis",
            int(value) if value is not None else 0,
        )

    @property
    def number_of_times_per_quasi_step(self: "Self") -> "int":
        """int"""
        temp = pythonnet_property_get(self.wrapped, "NumberOfTimesPerQuasiStep")

        if temp is None:
            return 0

        return temp

    @number_of_times_per_quasi_step.setter
    @enforce_parameter_types
    def number_of_times_per_quasi_step(self: "Self", value: "int") -> None:
        pythonnet_property_set(
            self.wrapped,
            "NumberOfTimesPerQuasiStep",
            int(value) if value is not None else 0,
        )

    @property
    def tolerance_for_compatibility_of_atsam_and_te_periods_check(
        self: "Self",
    ) -> "float":
        """float"""
        temp = pythonnet_property_get(
            self.wrapped, "ToleranceForCompatibilityOfATSAMAndTEPeriodsCheck"
        )

        if temp is None:
            return 0.0

        return temp

    @tolerance_for_compatibility_of_atsam_and_te_periods_check.setter
    @enforce_parameter_types
    def tolerance_for_compatibility_of_atsam_and_te_periods_check(
        self: "Self", value: "float"
    ) -> None:
        pythonnet_property_set(
            self.wrapped,
            "ToleranceForCompatibilityOfATSAMAndTEPeriodsCheck",
            float(value) if value is not None else 0.0,
        )

    @property
    def use_this_load_case_for_load_case_for_advanced_time_stepping_analysis_for_modulation_time_options_and_active_fe_parts(
        self: "Self",
    ) -> "bool":
        """bool"""
        temp = pythonnet_property_get(
            self.wrapped,
            "UseThisLoadCaseForLoadCaseForAdvancedTimeSteppingAnalysisForModulationTimeOptionsAndActiveFEParts",
        )

        if temp is None:
            return False

        return temp

    @use_this_load_case_for_load_case_for_advanced_time_stepping_analysis_for_modulation_time_options_and_active_fe_parts.setter
    @enforce_parameter_types
    def use_this_load_case_for_load_case_for_advanced_time_stepping_analysis_for_modulation_time_options_and_active_fe_parts(
        self: "Self", value: "bool"
    ) -> None:
        pythonnet_property_set(
            self.wrapped,
            "UseThisLoadCaseForLoadCaseForAdvancedTimeSteppingAnalysisForModulationTimeOptionsAndActiveFEParts",
            bool(value) if value is not None else False,
        )

    @property
    def gear_set_load_case_within_load_case_for_advanced_time_stepping_analysis_for_modulation(
        self: "Self",
    ) -> "_7043.GearSetLoadCase":
        """mastapy._private.system_model.analyses_and_results.static_loads.GearSetLoadCase

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(
            self.wrapped,
            "GearSetLoadCaseWithinLoadCaseForAdvancedTimeSteppingAnalysisForModulation",
        )

        if temp is None:
            return None

        type_ = temp.GetType()
        return constructor.new(type_.Namespace, type_.Name)(temp)

    @property
    def time_options(self: "Self") -> "_2768.TimeOptions":
        """mastapy._private.system_model.analyses_and_results.TimeOptions

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "TimeOptions")

        if temp is None:
            return None

        type_ = temp.GetType()
        return constructor.new(type_.Namespace, type_.Name)(temp)

    @property
    def cast_to(
        self: "Self",
    ) -> "_Cast_AdvancedTimeSteppingAnalysisForModulationOptions":
        """Cast to another type.

        Returns:
            _Cast_AdvancedTimeSteppingAnalysisForModulationOptions
        """
        return _Cast_AdvancedTimeSteppingAnalysisForModulationOptions(self)
