"""GearMeshMisalignmentExcitationDetail"""
from __future__ import annotations

from typing import TYPE_CHECKING, ClassVar

from mastapy._private._internal.dataclasses import extended_dataclass
from mastapy._private._internal.python_net import python_net_import
from mastapy._private.system_model.analyses_and_results.harmonic_analyses import _5885
from mastapy._private._internal.cast_exception import CastException
from mastapy._private._internal import utility

_GEAR_MESH_MISALIGNMENT_EXCITATION_DETAIL = python_net_import(
    "SMT.MastaAPI.SystemModel.AnalysesAndResults.HarmonicAnalyses",
    "GearMeshMisalignmentExcitationDetail",
)

if TYPE_CHECKING:
    from typing import Any, Type, TypeVar

    from mastapy._private.system_model.analyses_and_results.harmonic_analyses import (
        _5810,
    )

    Self = TypeVar("Self", bound="GearMeshMisalignmentExcitationDetail")
    CastSelf = TypeVar(
        "CastSelf",
        bound="GearMeshMisalignmentExcitationDetail._Cast_GearMeshMisalignmentExcitationDetail",
    )


__docformat__ = "restructuredtext en"
__all__ = ("GearMeshMisalignmentExcitationDetail",)


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class _Cast_GearMeshMisalignmentExcitationDetail:
    """Special nested class for casting GearMeshMisalignmentExcitationDetail to subclasses."""

    __parent__: "GearMeshMisalignmentExcitationDetail"

    @property
    def gear_mesh_excitation_detail(
        self: "CastSelf",
    ) -> "_5885.GearMeshExcitationDetail":
        return self.__parent__._cast(_5885.GearMeshExcitationDetail)

    @property
    def abstract_periodic_excitation_detail(
        self: "CastSelf",
    ) -> "_5810.AbstractPeriodicExcitationDetail":
        from mastapy._private.system_model.analyses_and_results.harmonic_analyses import (
            _5810,
        )

        return self.__parent__._cast(_5810.AbstractPeriodicExcitationDetail)

    @property
    def gear_mesh_misalignment_excitation_detail(
        self: "CastSelf",
    ) -> "GearMeshMisalignmentExcitationDetail":
        return self.__parent__

    def __getattr__(self: "CastSelf", name: str) -> "Any":
        try:
            return self.__getattribute__(name)
        except AttributeError:
            class_name = utility.camel(name)
            raise CastException(
                f'Detected an invalid cast. Cannot cast to type "{class_name}"'
            ) from None


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class GearMeshMisalignmentExcitationDetail(_5885.GearMeshExcitationDetail):
    """GearMeshMisalignmentExcitationDetail

    This is a mastapy class.
    """

    TYPE: ClassVar["Type"] = _GEAR_MESH_MISALIGNMENT_EXCITATION_DETAIL

    wrapped: "Any"

    def __post_init__(self: "Self") -> None:
        """Override of the post initialisation magic method."""
        if not hasattr(self.wrapped, "reference_count"):
            self.wrapped.reference_count = 0

        self.wrapped.reference_count += 1

    @property
    def cast_to(self: "Self") -> "_Cast_GearMeshMisalignmentExcitationDetail":
        """Cast to another type.

        Returns:
            _Cast_GearMeshMisalignmentExcitationDetail
        """
        return _Cast_GearMeshMisalignmentExcitationDetail(self)
