"""HarmonicAnalysisRootAssemblyExportOptions"""
from __future__ import annotations

from typing import TYPE_CHECKING, ClassVar

from mastapy._private._internal.dataclasses import extended_dataclass
from mastapy._private._internal.type_enforcement import enforce_parameter_types
from mastapy._private._internal.python_net import (
    pythonnet_method_call,
    pythonnet_property_get,
    pythonnet_property_set,
    python_net_import,
)
from mastapy._private._internal import conversion, utility
from mastapy._private.system_model.analyses_and_results.harmonic_analyses import _5894
from mastapy._private.system_model.analyses_and_results import _2739
from mastapy._private.system_model.part_model import _2531
from mastapy._private._internal.cast_exception import CastException

_HARMONIC_ANALYSIS_ROOT_ASSEMBLY_EXPORT_OPTIONS = python_net_import(
    "SMT.MastaAPI.SystemModel.AnalysesAndResults.HarmonicAnalyses",
    "HarmonicAnalysisRootAssemblyExportOptions",
)

if TYPE_CHECKING:
    from typing import Any, Type, List, TypeVar

    Self = TypeVar("Self", bound="HarmonicAnalysisRootAssemblyExportOptions")
    CastSelf = TypeVar(
        "CastSelf",
        bound="HarmonicAnalysisRootAssemblyExportOptions._Cast_HarmonicAnalysisRootAssemblyExportOptions",
    )


__docformat__ = "restructuredtext en"
__all__ = ("HarmonicAnalysisRootAssemblyExportOptions",)


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class _Cast_HarmonicAnalysisRootAssemblyExportOptions:
    """Special nested class for casting HarmonicAnalysisRootAssemblyExportOptions to subclasses."""

    __parent__: "HarmonicAnalysisRootAssemblyExportOptions"

    @property
    def harmonic_analysis_export_options(
        self: "CastSelf",
    ) -> "_5894.HarmonicAnalysisExportOptions":
        return self.__parent__._cast(_5894.HarmonicAnalysisExportOptions)

    @property
    def harmonic_analysis_root_assembly_export_options(
        self: "CastSelf",
    ) -> "HarmonicAnalysisRootAssemblyExportOptions":
        return self.__parent__

    def __getattr__(self: "CastSelf", name: str) -> "Any":
        try:
            return self.__getattribute__(name)
        except AttributeError:
            class_name = utility.camel(name)
            raise CastException(
                f'Detected an invalid cast. Cannot cast to type "{class_name}"'
            ) from None


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class HarmonicAnalysisRootAssemblyExportOptions(
    _5894.HarmonicAnalysisExportOptions[
        _2739.IHaveRootHarmonicAnalysisResults, _2531.RootAssembly
    ]
):
    """HarmonicAnalysisRootAssemblyExportOptions

    This is a mastapy class.
    """

    TYPE: ClassVar["Type"] = _HARMONIC_ANALYSIS_ROOT_ASSEMBLY_EXPORT_OPTIONS

    wrapped: "Any"

    def __post_init__(self: "Self") -> None:
        """Override of the post initialisation magic method."""
        if not hasattr(self.wrapped, "reference_count"):
            self.wrapped.reference_count = 0

        self.wrapped.reference_count += 1

    @property
    def include_all_fe_models(self: "Self") -> "bool":
        """bool"""
        temp = pythonnet_property_get(self.wrapped, "IncludeAllFEModels")

        if temp is None:
            return False

        return temp

    @include_all_fe_models.setter
    @enforce_parameter_types
    def include_all_fe_models(self: "Self", value: "bool") -> None:
        pythonnet_property_set(
            self.wrapped,
            "IncludeAllFEModels",
            bool(value) if value is not None else False,
        )

    @property
    def include_all_shafts(self: "Self") -> "bool":
        """bool"""
        temp = pythonnet_property_get(self.wrapped, "IncludeAllShafts")

        if temp is None:
            return False

        return temp

    @include_all_shafts.setter
    @enforce_parameter_types
    def include_all_shafts(self: "Self", value: "bool") -> None:
        pythonnet_property_set(
            self.wrapped,
            "IncludeAllShafts",
            bool(value) if value is not None else False,
        )

    @property
    def status_message_for_export(self: "Self") -> "str":
        """str

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "StatusMessageForExport")

        if temp is None:
            return ""

        return temp

    @enforce_parameter_types
    def export_to_folder(self: "Self", folder_path: "str") -> "List[str]":
        """List[str]

        Args:
            folder_path (str)
        """
        folder_path = str(folder_path)
        return conversion.pn_to_mp_objects_in_list(
            pythonnet_method_call(
                self.wrapped, "ExportToFolder", folder_path if folder_path else ""
            ),
            str,
        )

    @property
    def cast_to(self: "Self") -> "_Cast_HarmonicAnalysisRootAssemblyExportOptions":
        """Cast to another type.

        Returns:
            _Cast_HarmonicAnalysisRootAssemblyExportOptions
        """
        return _Cast_HarmonicAnalysisRootAssemblyExportOptions(self)
