"""OptionsWhenExternalFEFileAlreadyExists"""
from __future__ import annotations

from typing import TYPE_CHECKING, ClassVar

from mastapy._private._internal.dataclasses import extended_dataclass
from mastapy._private._internal.type_enforcement import enforce_parameter_types
from mastapy._private._internal.python_net import (
    pythonnet_method_call,
    pythonnet_property_get,
    pythonnet_property_set,
    python_net_import,
)
from mastapy._private._internal import conversion, utility
from mastapy._private import _0
from mastapy._private._internal.cast_exception import CastException

_OPTIONS_WHEN_EXTERNAL_FE_FILE_ALREADY_EXISTS = python_net_import(
    "SMT.MastaAPI.SystemModel.FE", "OptionsWhenExternalFEFileAlreadyExists"
)

if TYPE_CHECKING:
    from typing import Any, Type, List, TypeVar

    Self = TypeVar("Self", bound="OptionsWhenExternalFEFileAlreadyExists")
    CastSelf = TypeVar(
        "CastSelf",
        bound="OptionsWhenExternalFEFileAlreadyExists._Cast_OptionsWhenExternalFEFileAlreadyExists",
    )


__docformat__ = "restructuredtext en"
__all__ = ("OptionsWhenExternalFEFileAlreadyExists",)


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class _Cast_OptionsWhenExternalFEFileAlreadyExists:
    """Special nested class for casting OptionsWhenExternalFEFileAlreadyExists to subclasses."""

    __parent__: "OptionsWhenExternalFEFileAlreadyExists"

    @property
    def options_when_external_fe_file_already_exists(
        self: "CastSelf",
    ) -> "OptionsWhenExternalFEFileAlreadyExists":
        return self.__parent__

    def __getattr__(self: "CastSelf", name: str) -> "Any":
        try:
            return self.__getattribute__(name)
        except AttributeError:
            class_name = utility.camel(name)
            raise CastException(
                f'Detected an invalid cast. Cannot cast to type "{class_name}"'
            ) from None


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class OptionsWhenExternalFEFileAlreadyExists(_0.APIBase):
    """OptionsWhenExternalFEFileAlreadyExists

    This is a mastapy class.
    """

    TYPE: ClassVar["Type"] = _OPTIONS_WHEN_EXTERNAL_FE_FILE_ALREADY_EXISTS

    wrapped: "Any"

    def __post_init__(self: "Self") -> None:
        """Override of the post initialisation magic method."""
        if not hasattr(self.wrapped, "reference_count"):
            self.wrapped.reference_count = 0

        self.wrapped.reference_count += 1

    @property
    def append_current_date_and_time_to_new_file_names(self: "Self") -> "bool":
        """bool"""
        temp = pythonnet_property_get(
            self.wrapped, "AppendCurrentDateAndTimeToNewFileNames"
        )

        if temp is None:
            return False

        return temp

    @append_current_date_and_time_to_new_file_names.setter
    @enforce_parameter_types
    def append_current_date_and_time_to_new_file_names(
        self: "Self", value: "bool"
    ) -> None:
        pythonnet_property_set(
            self.wrapped,
            "AppendCurrentDateAndTimeToNewFileNames",
            bool(value) if value is not None else False,
        )

    @property
    def output_mesh_file_path(self: "Self") -> "str":
        """str

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "OutputMeshFilePath")

        if temp is None:
            return ""

        return temp

    @property
    def output_vectors_file_path(self: "Self") -> "str":
        """str

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "OutputVectorsFilePath")

        if temp is None:
            return ""

        return temp

    @property
    def overwrite_existing_mesh_file(self: "Self") -> "bool":
        """bool"""
        temp = pythonnet_property_get(self.wrapped, "OverwriteExistingMeshFile")

        if temp is None:
            return False

        return temp

    @overwrite_existing_mesh_file.setter
    @enforce_parameter_types
    def overwrite_existing_mesh_file(self: "Self", value: "bool") -> None:
        pythonnet_property_set(
            self.wrapped,
            "OverwriteExistingMeshFile",
            bool(value) if value is not None else False,
        )

    @property
    def overwrite_existing_vectors_file(self: "Self") -> "bool":
        """bool"""
        temp = pythonnet_property_get(self.wrapped, "OverwriteExistingVectorsFile")

        if temp is None:
            return False

        return temp

    @overwrite_existing_vectors_file.setter
    @enforce_parameter_types
    def overwrite_existing_vectors_file(self: "Self", value: "bool") -> None:
        pythonnet_property_set(
            self.wrapped,
            "OverwriteExistingVectorsFile",
            bool(value) if value is not None else False,
        )

    @property
    def report_names(self: "Self") -> "List[str]":
        """List[str]

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "ReportNames")

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp, str)

        if value is None:
            return None

        return value

    @enforce_parameter_types
    def output_default_report_to(self: "Self", file_path: "str") -> None:
        """Method does not return.

        Args:
            file_path (str)
        """
        file_path = str(file_path)
        pythonnet_method_call(
            self.wrapped, "OutputDefaultReportTo", file_path if file_path else ""
        )

    def get_default_report_with_encoded_images(self: "Self") -> "str":
        """str"""
        method_result = pythonnet_method_call(
            self.wrapped, "GetDefaultReportWithEncodedImages"
        )
        return method_result

    @enforce_parameter_types
    def output_active_report_to(self: "Self", file_path: "str") -> None:
        """Method does not return.

        Args:
            file_path (str)
        """
        file_path = str(file_path)
        pythonnet_method_call(
            self.wrapped, "OutputActiveReportTo", file_path if file_path else ""
        )

    @enforce_parameter_types
    def output_active_report_as_text_to(self: "Self", file_path: "str") -> None:
        """Method does not return.

        Args:
            file_path (str)
        """
        file_path = str(file_path)
        pythonnet_method_call(
            self.wrapped, "OutputActiveReportAsTextTo", file_path if file_path else ""
        )

    def get_active_report_with_encoded_images(self: "Self") -> "str":
        """str"""
        method_result = pythonnet_method_call(
            self.wrapped, "GetActiveReportWithEncodedImages"
        )
        return method_result

    @enforce_parameter_types
    def output_named_report_to(
        self: "Self", report_name: "str", file_path: "str"
    ) -> None:
        """Method does not return.

        Args:
            report_name (str)
            file_path (str)
        """
        report_name = str(report_name)
        file_path = str(file_path)
        pythonnet_method_call(
            self.wrapped,
            "OutputNamedReportTo",
            report_name if report_name else "",
            file_path if file_path else "",
        )

    @enforce_parameter_types
    def output_named_report_as_masta_report(
        self: "Self", report_name: "str", file_path: "str"
    ) -> None:
        """Method does not return.

        Args:
            report_name (str)
            file_path (str)
        """
        report_name = str(report_name)
        file_path = str(file_path)
        pythonnet_method_call(
            self.wrapped,
            "OutputNamedReportAsMastaReport",
            report_name if report_name else "",
            file_path if file_path else "",
        )

    @enforce_parameter_types
    def output_named_report_as_text_to(
        self: "Self", report_name: "str", file_path: "str"
    ) -> None:
        """Method does not return.

        Args:
            report_name (str)
            file_path (str)
        """
        report_name = str(report_name)
        file_path = str(file_path)
        pythonnet_method_call(
            self.wrapped,
            "OutputNamedReportAsTextTo",
            report_name if report_name else "",
            file_path if file_path else "",
        )

    @enforce_parameter_types
    def get_named_report_with_encoded_images(self: "Self", report_name: "str") -> "str":
        """str

        Args:
            report_name (str)
        """
        report_name = str(report_name)
        method_result = pythonnet_method_call(
            self.wrapped,
            "GetNamedReportWithEncodedImages",
            report_name if report_name else "",
        )
        return method_result

    @property
    def cast_to(self: "Self") -> "_Cast_OptionsWhenExternalFEFileAlreadyExists":
        """Cast to another type.

        Returns:
            _Cast_OptionsWhenExternalFEFileAlreadyExists
        """
        return _Cast_OptionsWhenExternalFEFileAlreadyExists(self)
