"""DesignEntityExcitationDescription"""
from __future__ import annotations

from typing import TYPE_CHECKING, ClassVar

from mastapy._private._internal.dataclasses import extended_dataclass
from mastapy._private._internal.python_net import (
    pythonnet_property_get,
    python_net_import,
)
from mastapy._private._internal import utility
from mastapy._private import _0
from mastapy._private._internal.cast_exception import CastException

_DESIGN_ENTITY_EXCITATION_DESCRIPTION = python_net_import(
    "SMT.MastaAPI.Utility.ModalAnalysis", "DesignEntityExcitationDescription"
)

if TYPE_CHECKING:
    from typing import Any, Type, TypeVar

    Self = TypeVar("Self", bound="DesignEntityExcitationDescription")
    CastSelf = TypeVar(
        "CastSelf",
        bound="DesignEntityExcitationDescription._Cast_DesignEntityExcitationDescription",
    )


__docformat__ = "restructuredtext en"
__all__ = ("DesignEntityExcitationDescription",)


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class _Cast_DesignEntityExcitationDescription:
    """Special nested class for casting DesignEntityExcitationDescription to subclasses."""

    __parent__: "DesignEntityExcitationDescription"

    @property
    def design_entity_excitation_description(
        self: "CastSelf",
    ) -> "DesignEntityExcitationDescription":
        return self.__parent__

    def __getattr__(self: "CastSelf", name: str) -> "Any":
        try:
            return self.__getattribute__(name)
        except AttributeError:
            class_name = utility.camel(name)
            raise CastException(
                f'Detected an invalid cast. Cannot cast to type "{class_name}"'
            ) from None


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class DesignEntityExcitationDescription(_0.APIBase):
    """DesignEntityExcitationDescription

    This is a mastapy class.
    """

    TYPE: ClassVar["Type"] = _DESIGN_ENTITY_EXCITATION_DESCRIPTION

    wrapped: "Any"

    def __post_init__(self: "Self") -> None:
        """Override of the post initialisation magic method."""
        if not hasattr(self.wrapped, "reference_count"):
            self.wrapped.reference_count = 0

        self.wrapped.reference_count += 1

    @property
    def excitation_frequency(self: "Self") -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "ExcitationFrequency")

        if temp is None:
            return 0.0

        return temp

    @property
    def harmonic_index(self: "Self") -> "int":
        """int

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "HarmonicIndex")

        if temp is None:
            return 0

        return temp

    @property
    def order(self: "Self") -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "Order")

        if temp is None:
            return 0.0

        return temp

    @property
    def cast_to(self: "Self") -> "_Cast_DesignEntityExcitationDescription":
        """Cast to another type.

        Returns:
            _Cast_DesignEntityExcitationDescription
        """
        return _Cast_DesignEntityExcitationDescription(self)
