"""InverseShortLength"""
from __future__ import annotations

from typing import TYPE_CHECKING, ClassVar

from mastapy._private._internal.dataclasses import extended_dataclass
from mastapy._private._internal.python_net import python_net_import
from mastapy._private.utility.units_and_measurements import _1655
from mastapy._private._internal.cast_exception import CastException
from mastapy._private._internal import utility

_INVERSE_SHORT_LENGTH = python_net_import(
    "SMT.MastaAPI.Utility.UnitsAndMeasurements.Measurements", "InverseShortLength"
)

if TYPE_CHECKING:
    from typing import Any, Type, TypeVar

    Self = TypeVar("Self", bound="InverseShortLength")
    CastSelf = TypeVar("CastSelf", bound="InverseShortLength._Cast_InverseShortLength")


__docformat__ = "restructuredtext en"
__all__ = ("InverseShortLength",)


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class _Cast_InverseShortLength:
    """Special nested class for casting InverseShortLength to subclasses."""

    __parent__: "InverseShortLength"

    @property
    def measurement_base(self: "CastSelf") -> "_1655.MeasurementBase":
        return self.__parent__._cast(_1655.MeasurementBase)

    @property
    def inverse_short_length(self: "CastSelf") -> "InverseShortLength":
        return self.__parent__

    def __getattr__(self: "CastSelf", name: str) -> "Any":
        try:
            return self.__getattribute__(name)
        except AttributeError:
            class_name = utility.camel(name)
            raise CastException(
                f'Detected an invalid cast. Cannot cast to type "{class_name}"'
            ) from None


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class InverseShortLength(_1655.MeasurementBase):
    """InverseShortLength

    This is a mastapy class.
    """

    TYPE: ClassVar["Type"] = _INVERSE_SHORT_LENGTH

    wrapped: "Any"

    def __post_init__(self: "Self") -> None:
        """Override of the post initialisation magic method."""
        if not hasattr(self.wrapped, "reference_count"):
            self.wrapped.reference_count = 0

        self.wrapped.reference_count += 1

    @property
    def cast_to(self: "Self") -> "_Cast_InverseShortLength":
        """Cast to another type.

        Returns:
            _Cast_InverseShortLength
        """
        return _Cast_InverseShortLength(self)
