# Generated by Django 5.0.9 on 2024-12-03 16:06

from django.db import migrations, models
from django.db.models.functions import RowNumber


def migrate_order(apps, schema_editor):
    ReviewQuestion = apps.get_model("wbhuman_resources", "ReviewQuestion")
    Review = apps.get_model("wbhuman_resources", "Review")
    ReviewQuestionCategory = apps.get_model("wbhuman_resources", "ReviewQuestionCategory")

    for review in Review.objects.all():
        questions = ReviewQuestion.objects.filter(review=review).annotate(
            row_number=models.Window(
                expression=RowNumber(),
            )
        )
        for question in questions:
            question.order = question.row_number
            question.save()

    for row_number, category in enumerate(ReviewQuestionCategory.objects.order_by("order"), start=1):
        category.order = row_number
        category.save()


class Migration(migrations.Migration):
    dependencies = [
        ("wbhuman_resources", "0021_alter_position_color"),
    ]

    operations = [
        migrations.RemoveField(
            model_name="review",
            name="editable_mode",
        ),
        migrations.RunPython(migrate_order),
        migrations.AlterModelOptions(
            name="reviewquestion",
            options={
                "ordering": ("review", "category", "order"),
                "verbose_name": "Review Question",
                "verbose_name_plural": "Review Questions",
            },
        ),
        migrations.AlterField(
            model_name="reviewquestion",
            name="order",
            field=models.PositiveIntegerField(db_index=True, editable=False, verbose_name="order"),
        ),
        migrations.AlterModelOptions(
            name="reviewquestioncategory",
            options={
                "ordering": ("order",),
                "verbose_name": "Review Question Category",
                "verbose_name_plural": "Review Question Categories",
            },
        ),
        migrations.AlterField(
            model_name="reviewquestioncategory",
            name="order",
            field=models.PositiveIntegerField(db_index=True, editable=False, verbose_name="order"),
        ),
    ]
