import numpy as np

def color_to_html(color,alpha=1):
	return "rgba("+str(int(color[0]))+","+str(int(color[1]))+","+str(int(color[2]))+","+str(alpha)+")"

class Palette(object):
	def __init__(self,colors_array):
		self.colors_array=colors_array
		self.len=len(colors_array)
	
	def __getitem__(self, key):
		return np.asarray(self.colors_array[key%self.len]).astype(int)
	
	def get_html(self,key,alpha=1):
		col=self[key]
		return color_to_html(col,alpha=alpha)
	
	def from_floats(colors_array):
		obj=Palette((np.asarray(colors_array)*255).astype(int))
		return obj
	
	def from_ints(colors_array):
		obj=Palette(np.asarray(colors_array).astype(int))
		return obj

#from matplotlib.cm.tab10:
qualitative10=Palette.from_floats((
	(0.12156862745098039, 0.4666666666666667, 0.7058823529411765),
	(1.0, 0.4980392156862745, 0.054901960784313725),
	(0.17254901960784313, 0.6274509803921569, 0.17254901960784313),
	(0.8392156862745098, 0.15294117647058825, 0.1568627450980392),
	(0.5803921568627451, 0.403921568627451, 0.7411764705882353),
	(0.5490196078431373, 0.33725490196078434, 0.29411764705882354),
	(0.8901960784313725, 0.4666666666666667, 0.7607843137254902),
	(0.4980392156862745, 0.4980392156862745, 0.4980392156862745),
	(0.7372549019607844, 0.7411764705882353, 0.13333333333333333),
	(0.09019607843137255, 0.7450980392156863, 0.8117647058823529)
))

#from matplotlib.cm.Drak2:
dark2=Palette.from_floats((
	(0.10588235294117647, 0.6196078431372549, 0.4666666666666667),
	(0.8509803921568627, 0.37254901960784315, 0.00784313725490196),
	(0.4588235294117647, 0.4392156862745098, 0.7019607843137254),
	(0.9058823529411765, 0.1607843137254902, 0.5411764705882353),
	(0.4, 0.6509803921568628, 0.11764705882352941),
	(0.9019607843137255, 0.6705882352941176, 0.00784313725490196),
	(0.6509803921568628, 0.4627450980392157, 0.11372549019607843),
	(0.4, 0.4, 0.4)
))
