# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetKnowledgebasesResult',
    'AwaitableGetKnowledgebasesResult',
    'get_knowledgebases',
    'get_knowledgebases_output',
]

@pulumi.output_type
class GetKnowledgebasesResult:
    """
    A collection of values returned by getKnowledgebases.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, knowledge_base_collections=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if knowledge_base_collections and not isinstance(knowledge_base_collections, list):
            raise TypeError("Expected argument 'knowledge_base_collections' to be a list")
        pulumi.set(__self__, "knowledge_base_collections", knowledge_base_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        The compartment Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the knowledge base.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The name of the knowledge base.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetKnowledgebasesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the knowledge base.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="knowledgeBaseCollections")
    def knowledge_base_collections(self) -> Sequence['outputs.GetKnowledgebasesKnowledgeBaseCollectionResult']:
        """
        The list of knowledge_base_collection.
        """
        return pulumi.get(self, "knowledge_base_collections")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current lifecycle state of the knowledge base.
        """
        return pulumi.get(self, "state")


class AwaitableGetKnowledgebasesResult(GetKnowledgebasesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKnowledgebasesResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            knowledge_base_collections=self.knowledge_base_collections,
            state=self.state)


def get_knowledgebases(compartment_id: Optional[str] = None,
                       display_name: Optional[str] = None,
                       filters: Optional[Sequence[Union['GetKnowledgebasesFilterArgs', 'GetKnowledgebasesFilterArgsDict']]] = None,
                       id: Optional[str] = None,
                       state: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKnowledgebasesResult:
    """
    This data source provides the list of Knowledge Bases in Oracle Cloud Infrastructure ADM service.

    Returns a list of KnowledgeBases based on the specified query parameters.
    At least id or compartmentId query parameter must be provided.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_knowledge_bases = oci.Adm.get_knowledgebases(compartment_id=compartment_id,
        display_name=knowledge_base_display_name,
        id=knowledge_base_id,
        state=knowledge_base_state)
    ```


    :param str compartment_id: A filter to return only resources that belong to the specified compartment identifier. Required only if the id query param is not specified.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str id: A filter to return only resources that match the specified identifier. Required only if the compartmentId query parameter is not specified.
    :param str state: A filter to return only Knowledge Bases that match the specified lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Adm/getKnowledgebases:getKnowledgebases', __args__, opts=opts, typ=GetKnowledgebasesResult).value

    return AwaitableGetKnowledgebasesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        knowledge_base_collections=pulumi.get(__ret__, 'knowledge_base_collections'),
        state=pulumi.get(__ret__, 'state'))
def get_knowledgebases_output(compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                              display_name: Optional[pulumi.Input[Optional[str]]] = None,
                              filters: Optional[pulumi.Input[Optional[Sequence[Union['GetKnowledgebasesFilterArgs', 'GetKnowledgebasesFilterArgsDict']]]]] = None,
                              id: Optional[pulumi.Input[Optional[str]]] = None,
                              state: Optional[pulumi.Input[Optional[str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKnowledgebasesResult]:
    """
    This data source provides the list of Knowledge Bases in Oracle Cloud Infrastructure ADM service.

    Returns a list of KnowledgeBases based on the specified query parameters.
    At least id or compartmentId query parameter must be provided.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_knowledge_bases = oci.Adm.get_knowledgebases(compartment_id=compartment_id,
        display_name=knowledge_base_display_name,
        id=knowledge_base_id,
        state=knowledge_base_state)
    ```


    :param str compartment_id: A filter to return only resources that belong to the specified compartment identifier. Required only if the id query param is not specified.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str id: A filter to return only resources that match the specified identifier. Required only if the compartmentId query parameter is not specified.
    :param str state: A filter to return only Knowledge Bases that match the specified lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Adm/getKnowledgebases:getKnowledgebases', __args__, opts=opts, typ=GetKnowledgebasesResult)
    return __ret__.apply(lambda __response__: GetKnowledgebasesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        knowledge_base_collections=pulumi.get(__response__, 'knowledge_base_collections'),
        state=pulumi.get(__response__, 'state')))
