# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetMonitoredInstancesResult',
    'AwaitableGetMonitoredInstancesResult',
    'get_monitored_instances',
    'get_monitored_instances_output',
]

@pulumi.output_type
class GetMonitoredInstancesResult:
    """
    A collection of values returned by getMonitoredInstances.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, monitored_instance_collections=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if monitored_instance_collections and not isinstance(monitored_instance_collections, list):
            raise TypeError("Expected argument 'monitored_instance_collections' to be a list")
        pulumi.set(__self__, "monitored_instance_collections", monitored_instance_collections)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly name of the monitored instance. It is binded to [Compute Instance](https://docs.cloud.oracle.com/iaas/Content/Compute/Concepts/computeoverview.htm). DisplayName is fetched from [Core Service API](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/Instance/).
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetMonitoredInstancesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="monitoredInstanceCollections")
    def monitored_instance_collections(self) -> Sequence['outputs.GetMonitoredInstancesMonitoredInstanceCollectionResult']:
        """
        The list of monitored_instance_collection.
        """
        return pulumi.get(self, "monitored_instance_collections")


class AwaitableGetMonitoredInstancesResult(GetMonitoredInstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMonitoredInstancesResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            monitored_instance_collections=self.monitored_instance_collections)


def get_monitored_instances(compartment_id: Optional[str] = None,
                            display_name: Optional[str] = None,
                            filters: Optional[Sequence[Union['GetMonitoredInstancesFilterArgs', 'GetMonitoredInstancesFilterArgsDict']]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMonitoredInstancesResult:
    """
    This data source provides the list of Monitored Instances in Oracle Cloud Infrastructure Appmgmt Control service.

    Returns a list of monitored instances.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_monitored_instances = oci.AppMgmtControl.get_monitored_instances(compartment_id=compartment_id,
        display_name=monitored_instance_display_name)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:AppMgmtControl/getMonitoredInstances:getMonitoredInstances', __args__, opts=opts, typ=GetMonitoredInstancesResult).value

    return AwaitableGetMonitoredInstancesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        monitored_instance_collections=pulumi.get(__ret__, 'monitored_instance_collections'))
def get_monitored_instances_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                   display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                   filters: Optional[pulumi.Input[Optional[Sequence[Union['GetMonitoredInstancesFilterArgs', 'GetMonitoredInstancesFilterArgsDict']]]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMonitoredInstancesResult]:
    """
    This data source provides the list of Monitored Instances in Oracle Cloud Infrastructure Appmgmt Control service.

    Returns a list of monitored instances.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_monitored_instances = oci.AppMgmtControl.get_monitored_instances(compartment_id=compartment_id,
        display_name=monitored_instance_display_name)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:AppMgmtControl/getMonitoredInstances:getMonitoredInstances', __args__, opts=opts, typ=GetMonitoredInstancesResult)
    return __ret__.apply(lambda __response__: GetMonitoredInstancesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        monitored_instance_collections=pulumi.get(__response__, 'monitored_instance_collections')))
