# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ExecutionActionArgs', 'ExecutionAction']

@pulumi.input_type
class ExecutionActionArgs:
    def __init__(__self__, *,
                 action_type: pulumi.Input[str],
                 execution_window_id: pulumi.Input[str],
                 action_members: Optional[pulumi.Input[Sequence[pulumi.Input['ExecutionActionActionMemberArgs']]]] = None,
                 action_params: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a ExecutionAction resource.
        :param pulumi.Input[str] action_type: The action type of the execution action being performed
        :param pulumi.Input[str] execution_window_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the execution window resource the execution action belongs to.
        :param pulumi.Input[Sequence[pulumi.Input['ExecutionActionActionMemberArgs']]] action_members: (Updatable) List of action members of this execution action.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] action_params: (Updatable) Map<ParamName, ParamValue> where a key value pair describes the specific action parameter. Example: `{"count": "3"}`
        :param pulumi.Input[str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "action_type", action_type)
        pulumi.set(__self__, "execution_window_id", execution_window_id)
        if action_members is not None:
            pulumi.set(__self__, "action_members", action_members)
        if action_params is not None:
            pulumi.set(__self__, "action_params", action_params)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> pulumi.Input[str]:
        """
        The action type of the execution action being performed
        """
        return pulumi.get(self, "action_type")

    @action_type.setter
    def action_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "action_type", value)

    @property
    @pulumi.getter(name="executionWindowId")
    def execution_window_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the execution window resource the execution action belongs to.
        """
        return pulumi.get(self, "execution_window_id")

    @execution_window_id.setter
    def execution_window_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "execution_window_id", value)

    @property
    @pulumi.getter(name="actionMembers")
    def action_members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExecutionActionActionMemberArgs']]]]:
        """
        (Updatable) List of action members of this execution action.
        """
        return pulumi.get(self, "action_members")

    @action_members.setter
    def action_members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExecutionActionActionMemberArgs']]]]):
        pulumi.set(self, "action_members", value)

    @property
    @pulumi.getter(name="actionParams")
    def action_params(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Map<ParamName, ParamValue> where a key value pair describes the specific action parameter. Example: `{"count": "3"}`
        """
        return pulumi.get(self, "action_params")

    @action_params.setter
    def action_params(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "action_params", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _ExecutionActionState:
    def __init__(__self__, *,
                 action_members: Optional[pulumi.Input[Sequence[pulumi.Input['ExecutionActionActionMemberArgs']]]] = None,
                 action_params: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 action_type: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 estimated_time_in_mins: Optional[pulumi.Input[int]] = None,
                 execution_action_order: Optional[pulumi.Input[int]] = None,
                 execution_window_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 lifecycle_substate: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 total_time_taken_in_mins: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering ExecutionAction resources.
        :param pulumi.Input[Sequence[pulumi.Input['ExecutionActionActionMemberArgs']]] action_members: (Updatable) List of action members of this execution action.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] action_params: (Updatable) Map<ParamName, ParamValue> where a key value pair describes the specific action parameter. Example: `{"count": "3"}`
        :param pulumi.Input[str] action_type: The action type of the execution action being performed
        :param pulumi.Input[str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] description: Description of the execution action.
        :param pulumi.Input[str] display_name: The user-friendly name for the execution action. The name does not need to be unique.
        :param pulumi.Input[int] estimated_time_in_mins: The estimated time of the execution action in minutes.
        :param pulumi.Input[int] execution_action_order: The priority order of the execution action.
        :param pulumi.Input[str] execution_window_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the execution window resource the execution action belongs to.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[str] lifecycle_substate: The current sub-state of the execution action. Valid states are DURATION_EXCEEDED, MAINTENANCE_IN_PROGRESS and WAITING.
        :param pulumi.Input[str] state: The current state of the execution action. Valid states are SCHEDULED, IN_PROGRESS, FAILED, CANCELED, UPDATING, DELETED, SUCCEEDED and PARTIAL_SUCCESS.
        :param pulumi.Input[str] time_created: The date and time the execution action was created.
        :param pulumi.Input[str] time_updated: The last date and time that the execution action was updated.
        :param pulumi.Input[int] total_time_taken_in_mins: The total time taken by corresponding resource activity in minutes.
        """
        if action_members is not None:
            pulumi.set(__self__, "action_members", action_members)
        if action_params is not None:
            pulumi.set(__self__, "action_params", action_params)
        if action_type is not None:
            pulumi.set(__self__, "action_type", action_type)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if estimated_time_in_mins is not None:
            pulumi.set(__self__, "estimated_time_in_mins", estimated_time_in_mins)
        if execution_action_order is not None:
            pulumi.set(__self__, "execution_action_order", execution_action_order)
        if execution_window_id is not None:
            pulumi.set(__self__, "execution_window_id", execution_window_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if lifecycle_substate is not None:
            pulumi.set(__self__, "lifecycle_substate", lifecycle_substate)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if total_time_taken_in_mins is not None:
            pulumi.set(__self__, "total_time_taken_in_mins", total_time_taken_in_mins)

    @property
    @pulumi.getter(name="actionMembers")
    def action_members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExecutionActionActionMemberArgs']]]]:
        """
        (Updatable) List of action members of this execution action.
        """
        return pulumi.get(self, "action_members")

    @action_members.setter
    def action_members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExecutionActionActionMemberArgs']]]]):
        pulumi.set(self, "action_members", value)

    @property
    @pulumi.getter(name="actionParams")
    def action_params(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Map<ParamName, ParamValue> where a key value pair describes the specific action parameter. Example: `{"count": "3"}`
        """
        return pulumi.get(self, "action_params")

    @action_params.setter
    def action_params(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "action_params", value)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> Optional[pulumi.Input[str]]:
        """
        The action type of the execution action being performed
        """
        return pulumi.get(self, "action_type")

    @action_type.setter
    def action_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action_type", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the execution action.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The user-friendly name for the execution action. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="estimatedTimeInMins")
    def estimated_time_in_mins(self) -> Optional[pulumi.Input[int]]:
        """
        The estimated time of the execution action in minutes.
        """
        return pulumi.get(self, "estimated_time_in_mins")

    @estimated_time_in_mins.setter
    def estimated_time_in_mins(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "estimated_time_in_mins", value)

    @property
    @pulumi.getter(name="executionActionOrder")
    def execution_action_order(self) -> Optional[pulumi.Input[int]]:
        """
        The priority order of the execution action.
        """
        return pulumi.get(self, "execution_action_order")

    @execution_action_order.setter
    def execution_action_order(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "execution_action_order", value)

    @property
    @pulumi.getter(name="executionWindowId")
    def execution_window_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the execution window resource the execution action belongs to.
        """
        return pulumi.get(self, "execution_window_id")

    @execution_window_id.setter
    def execution_window_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "execution_window_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="lifecycleSubstate")
    def lifecycle_substate(self) -> Optional[pulumi.Input[str]]:
        """
        The current sub-state of the execution action. Valid states are DURATION_EXCEEDED, MAINTENANCE_IN_PROGRESS and WAITING.
        """
        return pulumi.get(self, "lifecycle_substate")

    @lifecycle_substate.setter
    def lifecycle_substate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_substate", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the execution action. Valid states are SCHEDULED, IN_PROGRESS, FAILED, CANCELED, UPDATING, DELETED, SUCCEEDED and PARTIAL_SUCCESS.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the execution action was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The last date and time that the execution action was updated.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="totalTimeTakenInMins")
    def total_time_taken_in_mins(self) -> Optional[pulumi.Input[int]]:
        """
        The total time taken by corresponding resource activity in minutes.
        """
        return pulumi.get(self, "total_time_taken_in_mins")

    @total_time_taken_in_mins.setter
    def total_time_taken_in_mins(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "total_time_taken_in_mins", value)


class ExecutionAction(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action_members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExecutionActionActionMemberArgs', 'ExecutionActionActionMemberArgsDict']]]]] = None,
                 action_params: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 action_type: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 execution_window_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        This resource provides the Execution Action resource in Oracle Cloud Infrastructure Database service.

        Creates an execution action resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_execution_action = oci.database.ExecutionAction("test_execution_action",
            action_type=execution_action_action_type,
            execution_window_id=test_execution_window["id"],
            action_members=[{
                "member_id": test_member["id"],
                "member_order": execution_action_action_members_member_order,
                "estimated_time_in_mins": execution_action_action_members_estimated_time_in_mins,
                "status": execution_action_action_members_status,
                "total_time_taken_in_mins": execution_action_action_members_total_time_taken_in_mins,
            }],
            action_params=execution_action_action_params,
            compartment_id=compartment_id,
            defined_tags=execution_action_defined_tags,
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        ExecutionActions can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/executionAction:ExecutionAction test_execution_action "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ExecutionActionActionMemberArgs', 'ExecutionActionActionMemberArgsDict']]]] action_members: (Updatable) List of action members of this execution action.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] action_params: (Updatable) Map<ParamName, ParamValue> where a key value pair describes the specific action parameter. Example: `{"count": "3"}`
        :param pulumi.Input[str] action_type: The action type of the execution action being performed
        :param pulumi.Input[str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] execution_window_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the execution window resource the execution action belongs to.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExecutionActionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Execution Action resource in Oracle Cloud Infrastructure Database service.

        Creates an execution action resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_execution_action = oci.database.ExecutionAction("test_execution_action",
            action_type=execution_action_action_type,
            execution_window_id=test_execution_window["id"],
            action_members=[{
                "member_id": test_member["id"],
                "member_order": execution_action_action_members_member_order,
                "estimated_time_in_mins": execution_action_action_members_estimated_time_in_mins,
                "status": execution_action_action_members_status,
                "total_time_taken_in_mins": execution_action_action_members_total_time_taken_in_mins,
            }],
            action_params=execution_action_action_params,
            compartment_id=compartment_id,
            defined_tags=execution_action_defined_tags,
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        ExecutionActions can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/executionAction:ExecutionAction test_execution_action "id"
        ```

        :param str resource_name: The name of the resource.
        :param ExecutionActionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExecutionActionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action_members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExecutionActionActionMemberArgs', 'ExecutionActionActionMemberArgsDict']]]]] = None,
                 action_params: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 action_type: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 execution_window_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExecutionActionArgs.__new__(ExecutionActionArgs)

            __props__.__dict__["action_members"] = action_members
            __props__.__dict__["action_params"] = action_params
            if action_type is None and not opts.urn:
                raise TypeError("Missing required property 'action_type'")
            __props__.__dict__["action_type"] = action_type
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            if execution_window_id is None and not opts.urn:
                raise TypeError("Missing required property 'execution_window_id'")
            __props__.__dict__["execution_window_id"] = execution_window_id
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["description"] = None
            __props__.__dict__["display_name"] = None
            __props__.__dict__["estimated_time_in_mins"] = None
            __props__.__dict__["execution_action_order"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["lifecycle_substate"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["total_time_taken_in_mins"] = None
        super(ExecutionAction, __self__).__init__(
            'oci:Database/executionAction:ExecutionAction',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action_members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExecutionActionActionMemberArgs', 'ExecutionActionActionMemberArgsDict']]]]] = None,
            action_params: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            action_type: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            estimated_time_in_mins: Optional[pulumi.Input[int]] = None,
            execution_action_order: Optional[pulumi.Input[int]] = None,
            execution_window_id: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            lifecycle_substate: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            total_time_taken_in_mins: Optional[pulumi.Input[int]] = None) -> 'ExecutionAction':
        """
        Get an existing ExecutionAction resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ExecutionActionActionMemberArgs', 'ExecutionActionActionMemberArgsDict']]]] action_members: (Updatable) List of action members of this execution action.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] action_params: (Updatable) Map<ParamName, ParamValue> where a key value pair describes the specific action parameter. Example: `{"count": "3"}`
        :param pulumi.Input[str] action_type: The action type of the execution action being performed
        :param pulumi.Input[str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] description: Description of the execution action.
        :param pulumi.Input[str] display_name: The user-friendly name for the execution action. The name does not need to be unique.
        :param pulumi.Input[int] estimated_time_in_mins: The estimated time of the execution action in minutes.
        :param pulumi.Input[int] execution_action_order: The priority order of the execution action.
        :param pulumi.Input[str] execution_window_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the execution window resource the execution action belongs to.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[str] lifecycle_substate: The current sub-state of the execution action. Valid states are DURATION_EXCEEDED, MAINTENANCE_IN_PROGRESS and WAITING.
        :param pulumi.Input[str] state: The current state of the execution action. Valid states are SCHEDULED, IN_PROGRESS, FAILED, CANCELED, UPDATING, DELETED, SUCCEEDED and PARTIAL_SUCCESS.
        :param pulumi.Input[str] time_created: The date and time the execution action was created.
        :param pulumi.Input[str] time_updated: The last date and time that the execution action was updated.
        :param pulumi.Input[int] total_time_taken_in_mins: The total time taken by corresponding resource activity in minutes.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExecutionActionState.__new__(_ExecutionActionState)

        __props__.__dict__["action_members"] = action_members
        __props__.__dict__["action_params"] = action_params
        __props__.__dict__["action_type"] = action_type
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["estimated_time_in_mins"] = estimated_time_in_mins
        __props__.__dict__["execution_action_order"] = execution_action_order
        __props__.__dict__["execution_window_id"] = execution_window_id
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["lifecycle_substate"] = lifecycle_substate
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["total_time_taken_in_mins"] = total_time_taken_in_mins
        return ExecutionAction(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="actionMembers")
    def action_members(self) -> pulumi.Output[Sequence['outputs.ExecutionActionActionMember']]:
        """
        (Updatable) List of action members of this execution action.
        """
        return pulumi.get(self, "action_members")

    @property
    @pulumi.getter(name="actionParams")
    def action_params(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Map<ParamName, ParamValue> where a key value pair describes the specific action parameter. Example: `{"count": "3"}`
        """
        return pulumi.get(self, "action_params")

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> pulumi.Output[str]:
        """
        The action type of the execution action being performed
        """
        return pulumi.get(self, "action_type")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Description of the execution action.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        The user-friendly name for the execution action. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="estimatedTimeInMins")
    def estimated_time_in_mins(self) -> pulumi.Output[int]:
        """
        The estimated time of the execution action in minutes.
        """
        return pulumi.get(self, "estimated_time_in_mins")

    @property
    @pulumi.getter(name="executionActionOrder")
    def execution_action_order(self) -> pulumi.Output[int]:
        """
        The priority order of the execution action.
        """
        return pulumi.get(self, "execution_action_order")

    @property
    @pulumi.getter(name="executionWindowId")
    def execution_window_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the execution window resource the execution action belongs to.
        """
        return pulumi.get(self, "execution_window_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="lifecycleSubstate")
    def lifecycle_substate(self) -> pulumi.Output[str]:
        """
        The current sub-state of the execution action. Valid states are DURATION_EXCEEDED, MAINTENANCE_IN_PROGRESS and WAITING.
        """
        return pulumi.get(self, "lifecycle_substate")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the execution action. Valid states are SCHEDULED, IN_PROGRESS, FAILED, CANCELED, UPDATING, DELETED, SUCCEEDED and PARTIAL_SUCCESS.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the execution action was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The last date and time that the execution action was updated.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="totalTimeTakenInMins")
    def total_time_taken_in_mins(self) -> pulumi.Output[int]:
        """
        The total time taken by corresponding resource activity in minutes.
        """
        return pulumi.get(self, "total_time_taken_in_mins")

