# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetExternalMySqlDatabaseResult',
    'AwaitableGetExternalMySqlDatabaseResult',
    'get_external_my_sql_database',
    'get_external_my_sql_database_output',
]

@pulumi.output_type
class GetExternalMySqlDatabaseResult:
    """
    A collection of values returned by getExternalMySqlDatabase.
    """
    def __init__(__self__, compartment_id=None, db_name=None, external_database_id=None, external_my_sql_database_id=None, id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if db_name and not isinstance(db_name, str):
            raise TypeError("Expected argument 'db_name' to be a str")
        pulumi.set(__self__, "db_name", db_name)
        if external_database_id and not isinstance(external_database_id, str):
            raise TypeError("Expected argument 'external_database_id' to be a str")
        pulumi.set(__self__, "external_database_id", external_database_id)
        if external_my_sql_database_id and not isinstance(external_my_sql_database_id, str):
            raise TypeError("Expected argument 'external_my_sql_database_id' to be a str")
        pulumi.set(__self__, "external_my_sql_database_id", external_my_sql_database_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        OCID of compartment for the External MySQL Database.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> str:
        """
        Display Name of the External MySQL Database.
        """
        return pulumi.get(self, "db_name")

    @property
    @pulumi.getter(name="externalDatabaseId")
    def external_database_id(self) -> str:
        """
        OCID of External MySQL Database.
        """
        return pulumi.get(self, "external_database_id")

    @property
    @pulumi.getter(name="externalMySqlDatabaseId")
    def external_my_sql_database_id(self) -> str:
        return pulumi.get(self, "external_my_sql_database_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")


class AwaitableGetExternalMySqlDatabaseResult(GetExternalMySqlDatabaseResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExternalMySqlDatabaseResult(
            compartment_id=self.compartment_id,
            db_name=self.db_name,
            external_database_id=self.external_database_id,
            external_my_sql_database_id=self.external_my_sql_database_id,
            id=self.id)


def get_external_my_sql_database(external_my_sql_database_id: Optional[str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExternalMySqlDatabaseResult:
    """
    This data source provides details about a specific External My Sql Database resource in Oracle Cloud Infrastructure Database Management service.

    Retrieves the external MySQL database information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_my_sql_database = oci.DatabaseManagement.get_external_my_sql_database(external_my_sql_database_id=test_external_my_sql_database_oci_database_management_external_my_sql_database["id"])
    ```


    :param str external_my_sql_database_id: The OCID of the External MySQL Database.
    """
    __args__ = dict()
    __args__['externalMySqlDatabaseId'] = external_my_sql_database_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getExternalMySqlDatabase:getExternalMySqlDatabase', __args__, opts=opts, typ=GetExternalMySqlDatabaseResult).value

    return AwaitableGetExternalMySqlDatabaseResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        db_name=pulumi.get(__ret__, 'db_name'),
        external_database_id=pulumi.get(__ret__, 'external_database_id'),
        external_my_sql_database_id=pulumi.get(__ret__, 'external_my_sql_database_id'),
        id=pulumi.get(__ret__, 'id'))
def get_external_my_sql_database_output(external_my_sql_database_id: Optional[pulumi.Input[str]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetExternalMySqlDatabaseResult]:
    """
    This data source provides details about a specific External My Sql Database resource in Oracle Cloud Infrastructure Database Management service.

    Retrieves the external MySQL database information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_my_sql_database = oci.DatabaseManagement.get_external_my_sql_database(external_my_sql_database_id=test_external_my_sql_database_oci_database_management_external_my_sql_database["id"])
    ```


    :param str external_my_sql_database_id: The OCID of the External MySQL Database.
    """
    __args__ = dict()
    __args__['externalMySqlDatabaseId'] = external_my_sql_database_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DatabaseManagement/getExternalMySqlDatabase:getExternalMySqlDatabase', __args__, opts=opts, typ=GetExternalMySqlDatabaseResult)
    return __ret__.apply(lambda __response__: GetExternalMySqlDatabaseResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        db_name=pulumi.get(__response__, 'db_name'),
        external_database_id=pulumi.get(__response__, 'external_database_id'),
        external_my_sql_database_id=pulumi.get(__response__, 'external_my_sql_database_id'),
        id=pulumi.get(__response__, 'id')))
