# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetManagedDatabaseUserResult',
    'AwaitableGetManagedDatabaseUserResult',
    'get_managed_database_user',
    'get_managed_database_user_output',
]

@pulumi.output_type
class GetManagedDatabaseUserResult:
    """
    A collection of values returned by getManagedDatabaseUser.
    """
    def __init__(__self__, all_shared=None, authentication=None, common=None, consumer_group=None, default_collation=None, default_tablespace=None, editions_enabled=None, external_name=None, external_shared=None, id=None, implicit=None, inherited=None, local_temp_tablespace=None, managed_database_id=None, name=None, opc_named_credential_id=None, oracle_maintained=None, password_versions=None, profile=None, proxy_connect=None, status=None, temp_tablespace=None, time_created=None, time_expiring=None, time_last_login=None, time_locked=None, time_password_changed=None, user_name=None):
        if all_shared and not isinstance(all_shared, str):
            raise TypeError("Expected argument 'all_shared' to be a str")
        pulumi.set(__self__, "all_shared", all_shared)
        if authentication and not isinstance(authentication, str):
            raise TypeError("Expected argument 'authentication' to be a str")
        pulumi.set(__self__, "authentication", authentication)
        if common and not isinstance(common, str):
            raise TypeError("Expected argument 'common' to be a str")
        pulumi.set(__self__, "common", common)
        if consumer_group and not isinstance(consumer_group, str):
            raise TypeError("Expected argument 'consumer_group' to be a str")
        pulumi.set(__self__, "consumer_group", consumer_group)
        if default_collation and not isinstance(default_collation, str):
            raise TypeError("Expected argument 'default_collation' to be a str")
        pulumi.set(__self__, "default_collation", default_collation)
        if default_tablespace and not isinstance(default_tablespace, str):
            raise TypeError("Expected argument 'default_tablespace' to be a str")
        pulumi.set(__self__, "default_tablespace", default_tablespace)
        if editions_enabled and not isinstance(editions_enabled, str):
            raise TypeError("Expected argument 'editions_enabled' to be a str")
        pulumi.set(__self__, "editions_enabled", editions_enabled)
        if external_name and not isinstance(external_name, str):
            raise TypeError("Expected argument 'external_name' to be a str")
        pulumi.set(__self__, "external_name", external_name)
        if external_shared and not isinstance(external_shared, str):
            raise TypeError("Expected argument 'external_shared' to be a str")
        pulumi.set(__self__, "external_shared", external_shared)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if implicit and not isinstance(implicit, str):
            raise TypeError("Expected argument 'implicit' to be a str")
        pulumi.set(__self__, "implicit", implicit)
        if inherited and not isinstance(inherited, str):
            raise TypeError("Expected argument 'inherited' to be a str")
        pulumi.set(__self__, "inherited", inherited)
        if local_temp_tablespace and not isinstance(local_temp_tablespace, str):
            raise TypeError("Expected argument 'local_temp_tablespace' to be a str")
        pulumi.set(__self__, "local_temp_tablespace", local_temp_tablespace)
        if managed_database_id and not isinstance(managed_database_id, str):
            raise TypeError("Expected argument 'managed_database_id' to be a str")
        pulumi.set(__self__, "managed_database_id", managed_database_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if opc_named_credential_id and not isinstance(opc_named_credential_id, str):
            raise TypeError("Expected argument 'opc_named_credential_id' to be a str")
        pulumi.set(__self__, "opc_named_credential_id", opc_named_credential_id)
        if oracle_maintained and not isinstance(oracle_maintained, str):
            raise TypeError("Expected argument 'oracle_maintained' to be a str")
        pulumi.set(__self__, "oracle_maintained", oracle_maintained)
        if password_versions and not isinstance(password_versions, str):
            raise TypeError("Expected argument 'password_versions' to be a str")
        pulumi.set(__self__, "password_versions", password_versions)
        if profile and not isinstance(profile, str):
            raise TypeError("Expected argument 'profile' to be a str")
        pulumi.set(__self__, "profile", profile)
        if proxy_connect and not isinstance(proxy_connect, str):
            raise TypeError("Expected argument 'proxy_connect' to be a str")
        pulumi.set(__self__, "proxy_connect", proxy_connect)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if temp_tablespace and not isinstance(temp_tablespace, str):
            raise TypeError("Expected argument 'temp_tablespace' to be a str")
        pulumi.set(__self__, "temp_tablespace", temp_tablespace)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_expiring and not isinstance(time_expiring, str):
            raise TypeError("Expected argument 'time_expiring' to be a str")
        pulumi.set(__self__, "time_expiring", time_expiring)
        if time_last_login and not isinstance(time_last_login, str):
            raise TypeError("Expected argument 'time_last_login' to be a str")
        pulumi.set(__self__, "time_last_login", time_last_login)
        if time_locked and not isinstance(time_locked, str):
            raise TypeError("Expected argument 'time_locked' to be a str")
        pulumi.set(__self__, "time_locked", time_locked)
        if time_password_changed and not isinstance(time_password_changed, str):
            raise TypeError("Expected argument 'time_password_changed' to be a str")
        pulumi.set(__self__, "time_password_changed", time_password_changed)
        if user_name and not isinstance(user_name, str):
            raise TypeError("Expected argument 'user_name' to be a str")
        pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="allShared")
    def all_shared(self) -> str:
        """
        In a sharded database, indicates whether the user is created with shard DDL enabled (YES) or not (NO).
        """
        return pulumi.get(self, "all_shared")

    @property
    @pulumi.getter
    def authentication(self) -> str:
        """
        The authentication mechanism for the user.
        """
        return pulumi.get(self, "authentication")

    @property
    @pulumi.getter
    def common(self) -> str:
        """
        Indicates whether a given user is common(Y) or local(N).
        """
        return pulumi.get(self, "common")

    @property
    @pulumi.getter(name="consumerGroup")
    def consumer_group(self) -> str:
        """
        The initial resource consumer group for the User.
        """
        return pulumi.get(self, "consumer_group")

    @property
    @pulumi.getter(name="defaultCollation")
    def default_collation(self) -> str:
        """
        The default collation for the user schema.
        """
        return pulumi.get(self, "default_collation")

    @property
    @pulumi.getter(name="defaultTablespace")
    def default_tablespace(self) -> str:
        """
        The default tablespace for data.
        """
        return pulumi.get(self, "default_tablespace")

    @property
    @pulumi.getter(name="editionsEnabled")
    def editions_enabled(self) -> str:
        """
        Indicates whether editions have been enabled for the corresponding user (Y) or not (N).
        """
        return pulumi.get(self, "editions_enabled")

    @property
    @pulumi.getter(name="externalName")
    def external_name(self) -> str:
        """
        The external name of the user.
        """
        return pulumi.get(self, "external_name")

    @property
    @pulumi.getter(name="externalShared")
    def external_shared(self) -> str:
        """
        In a federated sharded database, indicates whether the user is an external shard user (YES) or not (NO).
        """
        return pulumi.get(self, "external_shared")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def implicit(self) -> str:
        """
        Indicates whether the user is a common user created by an implicit application (YES) or not (NO).
        """
        return pulumi.get(self, "implicit")

    @property
    @pulumi.getter
    def inherited(self) -> str:
        """
        Indicates whether the user definition is inherited from another container (YES) or not (NO).
        """
        return pulumi.get(self, "inherited")

    @property
    @pulumi.getter(name="localTempTablespace")
    def local_temp_tablespace(self) -> str:
        """
        The default local temporary tablespace for the user.
        """
        return pulumi.get(self, "local_temp_tablespace")

    @property
    @pulumi.getter(name="managedDatabaseId")
    def managed_database_id(self) -> str:
        return pulumi.get(self, "managed_database_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the User.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="opcNamedCredentialId")
    def opc_named_credential_id(self) -> Optional[str]:
        return pulumi.get(self, "opc_named_credential_id")

    @property
    @pulumi.getter(name="oracleMaintained")
    def oracle_maintained(self) -> str:
        """
        Indicates whether the user was created and is maintained by Oracle-supplied scripts (such as catalog.sql or catproc.sql).
        """
        return pulumi.get(self, "oracle_maintained")

    @property
    @pulumi.getter(name="passwordVersions")
    def password_versions(self) -> str:
        """
        The list of existing versions of the password hashes (also known as "verifiers") for the account.
        """
        return pulumi.get(self, "password_versions")

    @property
    @pulumi.getter
    def profile(self) -> str:
        """
        The profile name of the user.
        """
        return pulumi.get(self, "profile")

    @property
    @pulumi.getter(name="proxyConnect")
    def proxy_connect(self) -> str:
        """
        Indicates whether a user can connect directly (N) or whether the account can only be proxied (Y) by users who have proxy privileges for this account (that is, by users who have been granted the "connect through" privilege for this account).
        """
        return pulumi.get(self, "proxy_connect")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the user account.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="tempTablespace")
    def temp_tablespace(self) -> str:
        """
        The name of the default tablespace for temporary tables or the name of a tablespace group.
        """
        return pulumi.get(self, "temp_tablespace")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the user was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeExpiring")
    def time_expiring(self) -> str:
        """
        The date and time of the expiration of the user account.
        """
        return pulumi.get(self, "time_expiring")

    @property
    @pulumi.getter(name="timeLastLogin")
    def time_last_login(self) -> str:
        """
        The date and time of the last user login. This column is not populated when a user connects to the database with administrative privileges, that is, AS { SYSASM | SYSBACKUP | SYSDBA | SYSDG | SYSOPER | SYSRAC | SYSKM }.
        """
        return pulumi.get(self, "time_last_login")

    @property
    @pulumi.getter(name="timeLocked")
    def time_locked(self) -> str:
        """
        The date the account was locked, if the status of the account is LOCKED.
        """
        return pulumi.get(self, "time_locked")

    @property
    @pulumi.getter(name="timePasswordChanged")
    def time_password_changed(self) -> str:
        """
        The date and time when the user password was last set. This column is populated only when the value of the AUTHENTICATION_TYPE column is PASSWORD. Otherwise, this column is null.
        """
        return pulumi.get(self, "time_password_changed")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> str:
        return pulumi.get(self, "user_name")


class AwaitableGetManagedDatabaseUserResult(GetManagedDatabaseUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedDatabaseUserResult(
            all_shared=self.all_shared,
            authentication=self.authentication,
            common=self.common,
            consumer_group=self.consumer_group,
            default_collation=self.default_collation,
            default_tablespace=self.default_tablespace,
            editions_enabled=self.editions_enabled,
            external_name=self.external_name,
            external_shared=self.external_shared,
            id=self.id,
            implicit=self.implicit,
            inherited=self.inherited,
            local_temp_tablespace=self.local_temp_tablespace,
            managed_database_id=self.managed_database_id,
            name=self.name,
            opc_named_credential_id=self.opc_named_credential_id,
            oracle_maintained=self.oracle_maintained,
            password_versions=self.password_versions,
            profile=self.profile,
            proxy_connect=self.proxy_connect,
            status=self.status,
            temp_tablespace=self.temp_tablespace,
            time_created=self.time_created,
            time_expiring=self.time_expiring,
            time_last_login=self.time_last_login,
            time_locked=self.time_locked,
            time_password_changed=self.time_password_changed,
            user_name=self.user_name)


def get_managed_database_user(managed_database_id: Optional[str] = None,
                              opc_named_credential_id: Optional[str] = None,
                              user_name: Optional[str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedDatabaseUserResult:
    """
    This data source provides details about a specific Managed Database User resource in Oracle Cloud Infrastructure Database Management service.

    Gets the details of the user specified by managedDatabaseId and userName.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_database_user = oci.DatabaseManagement.get_managed_database_user(managed_database_id=test_managed_database["id"],
        user_name=test_user["name"],
        opc_named_credential_id=managed_database_user_opc_named_credential_id)
    ```


    :param str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param str opc_named_credential_id: The OCID of the Named Credential.
    :param str user_name: The name of the user whose details are to be viewed.
    """
    __args__ = dict()
    __args__['managedDatabaseId'] = managed_database_id
    __args__['opcNamedCredentialId'] = opc_named_credential_id
    __args__['userName'] = user_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getManagedDatabaseUser:getManagedDatabaseUser', __args__, opts=opts, typ=GetManagedDatabaseUserResult).value

    return AwaitableGetManagedDatabaseUserResult(
        all_shared=pulumi.get(__ret__, 'all_shared'),
        authentication=pulumi.get(__ret__, 'authentication'),
        common=pulumi.get(__ret__, 'common'),
        consumer_group=pulumi.get(__ret__, 'consumer_group'),
        default_collation=pulumi.get(__ret__, 'default_collation'),
        default_tablespace=pulumi.get(__ret__, 'default_tablespace'),
        editions_enabled=pulumi.get(__ret__, 'editions_enabled'),
        external_name=pulumi.get(__ret__, 'external_name'),
        external_shared=pulumi.get(__ret__, 'external_shared'),
        id=pulumi.get(__ret__, 'id'),
        implicit=pulumi.get(__ret__, 'implicit'),
        inherited=pulumi.get(__ret__, 'inherited'),
        local_temp_tablespace=pulumi.get(__ret__, 'local_temp_tablespace'),
        managed_database_id=pulumi.get(__ret__, 'managed_database_id'),
        name=pulumi.get(__ret__, 'name'),
        opc_named_credential_id=pulumi.get(__ret__, 'opc_named_credential_id'),
        oracle_maintained=pulumi.get(__ret__, 'oracle_maintained'),
        password_versions=pulumi.get(__ret__, 'password_versions'),
        profile=pulumi.get(__ret__, 'profile'),
        proxy_connect=pulumi.get(__ret__, 'proxy_connect'),
        status=pulumi.get(__ret__, 'status'),
        temp_tablespace=pulumi.get(__ret__, 'temp_tablespace'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_expiring=pulumi.get(__ret__, 'time_expiring'),
        time_last_login=pulumi.get(__ret__, 'time_last_login'),
        time_locked=pulumi.get(__ret__, 'time_locked'),
        time_password_changed=pulumi.get(__ret__, 'time_password_changed'),
        user_name=pulumi.get(__ret__, 'user_name'))
def get_managed_database_user_output(managed_database_id: Optional[pulumi.Input[str]] = None,
                                     opc_named_credential_id: Optional[pulumi.Input[Optional[str]]] = None,
                                     user_name: Optional[pulumi.Input[str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetManagedDatabaseUserResult]:
    """
    This data source provides details about a specific Managed Database User resource in Oracle Cloud Infrastructure Database Management service.

    Gets the details of the user specified by managedDatabaseId and userName.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_database_user = oci.DatabaseManagement.get_managed_database_user(managed_database_id=test_managed_database["id"],
        user_name=test_user["name"],
        opc_named_credential_id=managed_database_user_opc_named_credential_id)
    ```


    :param str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param str opc_named_credential_id: The OCID of the Named Credential.
    :param str user_name: The name of the user whose details are to be viewed.
    """
    __args__ = dict()
    __args__['managedDatabaseId'] = managed_database_id
    __args__['opcNamedCredentialId'] = opc_named_credential_id
    __args__['userName'] = user_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DatabaseManagement/getManagedDatabaseUser:getManagedDatabaseUser', __args__, opts=opts, typ=GetManagedDatabaseUserResult)
    return __ret__.apply(lambda __response__: GetManagedDatabaseUserResult(
        all_shared=pulumi.get(__response__, 'all_shared'),
        authentication=pulumi.get(__response__, 'authentication'),
        common=pulumi.get(__response__, 'common'),
        consumer_group=pulumi.get(__response__, 'consumer_group'),
        default_collation=pulumi.get(__response__, 'default_collation'),
        default_tablespace=pulumi.get(__response__, 'default_tablespace'),
        editions_enabled=pulumi.get(__response__, 'editions_enabled'),
        external_name=pulumi.get(__response__, 'external_name'),
        external_shared=pulumi.get(__response__, 'external_shared'),
        id=pulumi.get(__response__, 'id'),
        implicit=pulumi.get(__response__, 'implicit'),
        inherited=pulumi.get(__response__, 'inherited'),
        local_temp_tablespace=pulumi.get(__response__, 'local_temp_tablespace'),
        managed_database_id=pulumi.get(__response__, 'managed_database_id'),
        name=pulumi.get(__response__, 'name'),
        opc_named_credential_id=pulumi.get(__response__, 'opc_named_credential_id'),
        oracle_maintained=pulumi.get(__response__, 'oracle_maintained'),
        password_versions=pulumi.get(__response__, 'password_versions'),
        profile=pulumi.get(__response__, 'profile'),
        proxy_connect=pulumi.get(__response__, 'proxy_connect'),
        status=pulumi.get(__response__, 'status'),
        temp_tablespace=pulumi.get(__response__, 'temp_tablespace'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_expiring=pulumi.get(__response__, 'time_expiring'),
        time_last_login=pulumi.get(__response__, 'time_last_login'),
        time_locked=pulumi.get(__response__, 'time_locked'),
        time_password_changed=pulumi.get(__response__, 'time_password_changed'),
        user_name=pulumi.get(__response__, 'user_name')))
