# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDatabaseSecurityConfigsResult',
    'AwaitableGetDatabaseSecurityConfigsResult',
    'get_database_security_configs',
    'get_database_security_configs_output',
]

@pulumi.output_type
class GetDatabaseSecurityConfigsResult:
    """
    A collection of values returned by getDatabaseSecurityConfigs.
    """
    def __init__(__self__, access_level=None, compartment_id=None, compartment_id_in_subtree=None, database_security_config_collections=None, database_security_config_id=None, display_name=None, filters=None, id=None, state=None, target_id=None, time_created_greater_than_or_equal_to=None, time_created_less_than=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if database_security_config_collections and not isinstance(database_security_config_collections, list):
            raise TypeError("Expected argument 'database_security_config_collections' to be a list")
        pulumi.set(__self__, "database_security_config_collections", database_security_config_collections)
        if database_security_config_id and not isinstance(database_security_config_id, str):
            raise TypeError("Expected argument 'database_security_config_id' to be a str")
        pulumi.set(__self__, "database_security_config_id", database_security_config_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if target_id and not isinstance(target_id, str):
            raise TypeError("Expected argument 'target_id' to be a str")
        pulumi.set(__self__, "target_id", target_id)
        if time_created_greater_than_or_equal_to and not isinstance(time_created_greater_than_or_equal_to, str):
            raise TypeError("Expected argument 'time_created_greater_than_or_equal_to' to be a str")
        pulumi.set(__self__, "time_created_greater_than_or_equal_to", time_created_greater_than_or_equal_to)
        if time_created_less_than and not isinstance(time_created_less_than, str):
            raise TypeError("Expected argument 'time_created_less_than' to be a str")
        pulumi.set(__self__, "time_created_less_than", time_created_less_than)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[str]:
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment containing the database security config.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter(name="databaseSecurityConfigCollections")
    def database_security_config_collections(self) -> Sequence['outputs.GetDatabaseSecurityConfigsDatabaseSecurityConfigCollectionResult']:
        """
        The list of database_security_config_collection.
        """
        return pulumi.get(self, "database_security_config_collections")

    @property
    @pulumi.getter(name="databaseSecurityConfigId")
    def database_security_config_id(self) -> Optional[str]:
        return pulumi.get(self, "database_security_config_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The display name of the database security config.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDatabaseSecurityConfigsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the database security config.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[str]:
        """
        The target OCID corresponding to the database security config.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="timeCreatedGreaterThanOrEqualTo")
    def time_created_greater_than_or_equal_to(self) -> Optional[str]:
        return pulumi.get(self, "time_created_greater_than_or_equal_to")

    @property
    @pulumi.getter(name="timeCreatedLessThan")
    def time_created_less_than(self) -> Optional[str]:
        return pulumi.get(self, "time_created_less_than")


class AwaitableGetDatabaseSecurityConfigsResult(GetDatabaseSecurityConfigsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatabaseSecurityConfigsResult(
            access_level=self.access_level,
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            database_security_config_collections=self.database_security_config_collections,
            database_security_config_id=self.database_security_config_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state,
            target_id=self.target_id,
            time_created_greater_than_or_equal_to=self.time_created_greater_than_or_equal_to,
            time_created_less_than=self.time_created_less_than)


def get_database_security_configs(access_level: Optional[str] = None,
                                  compartment_id: Optional[str] = None,
                                  compartment_id_in_subtree: Optional[bool] = None,
                                  database_security_config_id: Optional[str] = None,
                                  display_name: Optional[str] = None,
                                  filters: Optional[Sequence[Union['GetDatabaseSecurityConfigsFilterArgs', 'GetDatabaseSecurityConfigsFilterArgsDict']]] = None,
                                  state: Optional[str] = None,
                                  target_id: Optional[str] = None,
                                  time_created_greater_than_or_equal_to: Optional[str] = None,
                                  time_created_less_than: Optional[str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatabaseSecurityConfigsResult:
    """
    This data source provides the list of Database Security Configs in Oracle Cloud Infrastructure Data Safe service.

    Retrieves a list of all database security configurations in Data Safe.

    The ListDatabaseSecurityConfigs operation returns only the database security configurations in the specified `compartmentId`.

    The parameter `accessLevel` specifies whether to return only those compartments for which the
    requestor has INSPECT permissions on at least one resource directly
    or indirectly (ACCESSIBLE) (the resource can be in a subcompartment) or to return Not Authorized if
    Principal doesn't have access to even one of the child compartments. This is valid only when
    `compartmentIdInSubtree` is set to `true`.

    The parameter `compartmentIdInSubtree` applies when you perform ListDatabaseSecurityConfigs on the
    `compartmentId` passed and when it is set to true, the entire hierarchy of compartments can be returned.
    To get a full list of all compartments and subcompartments in the tenancy (root compartment),
    set the parameter `compartmentIdInSubtree` to true and `accessLevel` to ACCESSIBLE.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_database_security_configs = oci.DataSafe.get_database_security_configs(compartment_id=compartment_id,
        access_level=database_security_config_access_level,
        compartment_id_in_subtree=database_security_config_compartment_id_in_subtree,
        database_security_config_id=test_database_security_config["id"],
        display_name=database_security_config_display_name,
        state=database_security_config_state,
        target_id=test_target["id"],
        time_created_greater_than_or_equal_to=database_security_config_time_created_greater_than_or_equal_to,
        time_created_less_than=database_security_config_time_created_less_than)
    ```


    :param str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param str database_security_config_id: An optional filter to return only resources that match the specified OCID of the database security configuration resource.
    :param str display_name: A filter to return only resources that match the specified display name.
    :param str state: The current state of the database security configuration.
    :param str target_id: A filter to return only items related to a specific target OCID.
    :param str time_created_greater_than_or_equal_to: A filter to return only the resources that were created after the specified date and time, as defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Using TimeCreatedGreaterThanOrEqualToQueryParam parameter retrieves all resources created after that date.
           
           **Example:** 2016-12-19T16:39:57.600Z
    :param str time_created_less_than: Search for resources that were created before a specific date. Specifying this parameter corresponding `timeCreatedLessThan` parameter will retrieve all resources created before the specified created date, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by RFC 3339.
           
           **Example:** 2016-12-19T16:39:57.600Z
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['databaseSecurityConfigId'] = database_security_config_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['targetId'] = target_id
    __args__['timeCreatedGreaterThanOrEqualTo'] = time_created_greater_than_or_equal_to
    __args__['timeCreatedLessThan'] = time_created_less_than
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getDatabaseSecurityConfigs:getDatabaseSecurityConfigs', __args__, opts=opts, typ=GetDatabaseSecurityConfigsResult).value

    return AwaitableGetDatabaseSecurityConfigsResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        database_security_config_collections=pulumi.get(__ret__, 'database_security_config_collections'),
        database_security_config_id=pulumi.get(__ret__, 'database_security_config_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        target_id=pulumi.get(__ret__, 'target_id'),
        time_created_greater_than_or_equal_to=pulumi.get(__ret__, 'time_created_greater_than_or_equal_to'),
        time_created_less_than=pulumi.get(__ret__, 'time_created_less_than'))
def get_database_security_configs_output(access_level: Optional[pulumi.Input[Optional[str]]] = None,
                                         compartment_id: Optional[pulumi.Input[str]] = None,
                                         compartment_id_in_subtree: Optional[pulumi.Input[Optional[bool]]] = None,
                                         database_security_config_id: Optional[pulumi.Input[Optional[str]]] = None,
                                         display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                         filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDatabaseSecurityConfigsFilterArgs', 'GetDatabaseSecurityConfigsFilterArgsDict']]]]] = None,
                                         state: Optional[pulumi.Input[Optional[str]]] = None,
                                         target_id: Optional[pulumi.Input[Optional[str]]] = None,
                                         time_created_greater_than_or_equal_to: Optional[pulumi.Input[Optional[str]]] = None,
                                         time_created_less_than: Optional[pulumi.Input[Optional[str]]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDatabaseSecurityConfigsResult]:
    """
    This data source provides the list of Database Security Configs in Oracle Cloud Infrastructure Data Safe service.

    Retrieves a list of all database security configurations in Data Safe.

    The ListDatabaseSecurityConfigs operation returns only the database security configurations in the specified `compartmentId`.

    The parameter `accessLevel` specifies whether to return only those compartments for which the
    requestor has INSPECT permissions on at least one resource directly
    or indirectly (ACCESSIBLE) (the resource can be in a subcompartment) or to return Not Authorized if
    Principal doesn't have access to even one of the child compartments. This is valid only when
    `compartmentIdInSubtree` is set to `true`.

    The parameter `compartmentIdInSubtree` applies when you perform ListDatabaseSecurityConfigs on the
    `compartmentId` passed and when it is set to true, the entire hierarchy of compartments can be returned.
    To get a full list of all compartments and subcompartments in the tenancy (root compartment),
    set the parameter `compartmentIdInSubtree` to true and `accessLevel` to ACCESSIBLE.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_database_security_configs = oci.DataSafe.get_database_security_configs(compartment_id=compartment_id,
        access_level=database_security_config_access_level,
        compartment_id_in_subtree=database_security_config_compartment_id_in_subtree,
        database_security_config_id=test_database_security_config["id"],
        display_name=database_security_config_display_name,
        state=database_security_config_state,
        target_id=test_target["id"],
        time_created_greater_than_or_equal_to=database_security_config_time_created_greater_than_or_equal_to,
        time_created_less_than=database_security_config_time_created_less_than)
    ```


    :param str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param str database_security_config_id: An optional filter to return only resources that match the specified OCID of the database security configuration resource.
    :param str display_name: A filter to return only resources that match the specified display name.
    :param str state: The current state of the database security configuration.
    :param str target_id: A filter to return only items related to a specific target OCID.
    :param str time_created_greater_than_or_equal_to: A filter to return only the resources that were created after the specified date and time, as defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Using TimeCreatedGreaterThanOrEqualToQueryParam parameter retrieves all resources created after that date.
           
           **Example:** 2016-12-19T16:39:57.600Z
    :param str time_created_less_than: Search for resources that were created before a specific date. Specifying this parameter corresponding `timeCreatedLessThan` parameter will retrieve all resources created before the specified created date, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by RFC 3339.
           
           **Example:** 2016-12-19T16:39:57.600Z
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['databaseSecurityConfigId'] = database_security_config_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['targetId'] = target_id
    __args__['timeCreatedGreaterThanOrEqualTo'] = time_created_greater_than_or_equal_to
    __args__['timeCreatedLessThan'] = time_created_less_than
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getDatabaseSecurityConfigs:getDatabaseSecurityConfigs', __args__, opts=opts, typ=GetDatabaseSecurityConfigsResult)
    return __ret__.apply(lambda __response__: GetDatabaseSecurityConfigsResult(
        access_level=pulumi.get(__response__, 'access_level'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        database_security_config_collections=pulumi.get(__response__, 'database_security_config_collections'),
        database_security_config_id=pulumi.get(__response__, 'database_security_config_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state'),
        target_id=pulumi.get(__response__, 'target_id'),
        time_created_greater_than_or_equal_to=pulumi.get(__response__, 'time_created_greater_than_or_equal_to'),
        time_created_less_than=pulumi.get(__response__, 'time_created_less_than')))
