# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDiscoveryJobLogsResult',
    'AwaitableGetDiscoveryJobLogsResult',
    'get_discovery_job_logs',
    'get_discovery_job_logs_output',
]

@pulumi.output_type
class GetDiscoveryJobLogsResult:
    """
    A collection of values returned by getDiscoveryJobLogs.
    """
    def __init__(__self__, discovery_job_id=None, discovery_job_log_collections=None, filters=None, id=None, log_type=None):
        if discovery_job_id and not isinstance(discovery_job_id, str):
            raise TypeError("Expected argument 'discovery_job_id' to be a str")
        pulumi.set(__self__, "discovery_job_id", discovery_job_id)
        if discovery_job_log_collections and not isinstance(discovery_job_log_collections, list):
            raise TypeError("Expected argument 'discovery_job_log_collections' to be a list")
        pulumi.set(__self__, "discovery_job_log_collections", discovery_job_log_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if log_type and not isinstance(log_type, str):
            raise TypeError("Expected argument 'log_type' to be a str")
        pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="discoveryJobId")
    def discovery_job_id(self) -> str:
        return pulumi.get(self, "discovery_job_id")

    @property
    @pulumi.getter(name="discoveryJobLogCollections")
    def discovery_job_log_collections(self) -> Sequence['outputs.GetDiscoveryJobLogsDiscoveryJobLogCollectionResult']:
        """
        The list of discovery_job_log_collection.
        """
        return pulumi.get(self, "discovery_job_log_collections")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDiscoveryJobLogsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> Optional[str]:
        """
        Type of log (INFO, WARNING, ERROR or SUCCESS)
        """
        return pulumi.get(self, "log_type")


class AwaitableGetDiscoveryJobLogsResult(GetDiscoveryJobLogsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDiscoveryJobLogsResult(
            discovery_job_id=self.discovery_job_id,
            discovery_job_log_collections=self.discovery_job_log_collections,
            filters=self.filters,
            id=self.id,
            log_type=self.log_type)


def get_discovery_job_logs(discovery_job_id: Optional[str] = None,
                           filters: Optional[Sequence[Union['GetDiscoveryJobLogsFilterArgs', 'GetDiscoveryJobLogsFilterArgsDict']]] = None,
                           log_type: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDiscoveryJobLogsResult:
    """
    This data source provides the list of Discovery Job Logs in Oracle Cloud Infrastructure Stack Monitoring service.

    API to get all the logs of a Discovery Job.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_discovery_job_logs = oci.StackMonitoring.get_discovery_job_logs(discovery_job_id=test_discovery_job["id"],
        log_type=discovery_job_log_log_type)
    ```


    :param str discovery_job_id: The Discovery Job ID
    :param str log_type: The log type like INFO, WARNING, ERROR, SUCCESS
    """
    __args__ = dict()
    __args__['discoveryJobId'] = discovery_job_id
    __args__['filters'] = filters
    __args__['logType'] = log_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:StackMonitoring/getDiscoveryJobLogs:getDiscoveryJobLogs', __args__, opts=opts, typ=GetDiscoveryJobLogsResult).value

    return AwaitableGetDiscoveryJobLogsResult(
        discovery_job_id=pulumi.get(__ret__, 'discovery_job_id'),
        discovery_job_log_collections=pulumi.get(__ret__, 'discovery_job_log_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        log_type=pulumi.get(__ret__, 'log_type'))
def get_discovery_job_logs_output(discovery_job_id: Optional[pulumi.Input[str]] = None,
                                  filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDiscoveryJobLogsFilterArgs', 'GetDiscoveryJobLogsFilterArgsDict']]]]] = None,
                                  log_type: Optional[pulumi.Input[Optional[str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDiscoveryJobLogsResult]:
    """
    This data source provides the list of Discovery Job Logs in Oracle Cloud Infrastructure Stack Monitoring service.

    API to get all the logs of a Discovery Job.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_discovery_job_logs = oci.StackMonitoring.get_discovery_job_logs(discovery_job_id=test_discovery_job["id"],
        log_type=discovery_job_log_log_type)
    ```


    :param str discovery_job_id: The Discovery Job ID
    :param str log_type: The log type like INFO, WARNING, ERROR, SUCCESS
    """
    __args__ = dict()
    __args__['discoveryJobId'] = discovery_job_id
    __args__['filters'] = filters
    __args__['logType'] = log_type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:StackMonitoring/getDiscoveryJobLogs:getDiscoveryJobLogs', __args__, opts=opts, typ=GetDiscoveryJobLogsResult)
    return __ret__.apply(lambda __response__: GetDiscoveryJobLogsResult(
        discovery_job_id=pulumi.get(__response__, 'discovery_job_id'),
        discovery_job_log_collections=pulumi.get(__response__, 'discovery_job_log_collections'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        log_type=pulumi.get(__response__, 'log_type')))
