# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'SecretRotationConfigArgs',
    'SecretRotationConfigArgsDict',
    'SecretRotationConfigTargetSystemDetailsArgs',
    'SecretRotationConfigTargetSystemDetailsArgsDict',
    'SecretSecretContentArgs',
    'SecretSecretContentArgsDict',
    'SecretSecretGenerationContextArgs',
    'SecretSecretGenerationContextArgsDict',
    'SecretSecretRuleArgs',
    'SecretSecretRuleArgsDict',
    'GetSecretsFilterArgs',
    'GetSecretsFilterArgsDict',
]

MYPY = False

if not MYPY:
    class SecretRotationConfigArgsDict(TypedDict):
        target_system_details: pulumi.Input['SecretRotationConfigTargetSystemDetailsArgsDict']
        """
        (Updatable) The TargetSystemDetails provides the targetSystem type and type-specific connection metadata
        """
        is_scheduled_rotation_enabled: NotRequired[pulumi.Input[bool]]
        """
        (Updatable) Enables auto rotation, when set to true rotationInterval must be set.
        """
        rotation_interval: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The time interval that indicates the frequency for rotating secret data, as described in ISO 8601 format. The minimum value is 1 day and maximum value is 360 days. For example, if you want to set the time interval for rotating a secret data as 30 days, the duration is expressed as "P30D."
        """
elif False:
    SecretRotationConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecretRotationConfigArgs:
    def __init__(__self__, *,
                 target_system_details: pulumi.Input['SecretRotationConfigTargetSystemDetailsArgs'],
                 is_scheduled_rotation_enabled: Optional[pulumi.Input[bool]] = None,
                 rotation_interval: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['SecretRotationConfigTargetSystemDetailsArgs'] target_system_details: (Updatable) The TargetSystemDetails provides the targetSystem type and type-specific connection metadata
        :param pulumi.Input[bool] is_scheduled_rotation_enabled: (Updatable) Enables auto rotation, when set to true rotationInterval must be set.
        :param pulumi.Input[str] rotation_interval: (Updatable) The time interval that indicates the frequency for rotating secret data, as described in ISO 8601 format. The minimum value is 1 day and maximum value is 360 days. For example, if you want to set the time interval for rotating a secret data as 30 days, the duration is expressed as "P30D."
        """
        pulumi.set(__self__, "target_system_details", target_system_details)
        if is_scheduled_rotation_enabled is not None:
            pulumi.set(__self__, "is_scheduled_rotation_enabled", is_scheduled_rotation_enabled)
        if rotation_interval is not None:
            pulumi.set(__self__, "rotation_interval", rotation_interval)

    @property
    @pulumi.getter(name="targetSystemDetails")
    def target_system_details(self) -> pulumi.Input['SecretRotationConfigTargetSystemDetailsArgs']:
        """
        (Updatable) The TargetSystemDetails provides the targetSystem type and type-specific connection metadata
        """
        return pulumi.get(self, "target_system_details")

    @target_system_details.setter
    def target_system_details(self, value: pulumi.Input['SecretRotationConfigTargetSystemDetailsArgs']):
        pulumi.set(self, "target_system_details", value)

    @property
    @pulumi.getter(name="isScheduledRotationEnabled")
    def is_scheduled_rotation_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Enables auto rotation, when set to true rotationInterval must be set.
        """
        return pulumi.get(self, "is_scheduled_rotation_enabled")

    @is_scheduled_rotation_enabled.setter
    def is_scheduled_rotation_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_scheduled_rotation_enabled", value)

    @property
    @pulumi.getter(name="rotationInterval")
    def rotation_interval(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The time interval that indicates the frequency for rotating secret data, as described in ISO 8601 format. The minimum value is 1 day and maximum value is 360 days. For example, if you want to set the time interval for rotating a secret data as 30 days, the duration is expressed as "P30D."
        """
        return pulumi.get(self, "rotation_interval")

    @rotation_interval.setter
    def rotation_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rotation_interval", value)


if not MYPY:
    class SecretRotationConfigTargetSystemDetailsArgsDict(TypedDict):
        target_system_type: pulumi.Input[str]
        """
        (Updatable) Unique identifier of the target system that Vault Secret connects to.
        """
        adb_id: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The unique identifier (OCID) for the autonomous database that Vault Secret connects to.
        """
        function_id: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The unique identifier (OCID) of the Oracle Cloud Infrastructure Functions that vault secret connects to.
        """
elif False:
    SecretRotationConfigTargetSystemDetailsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecretRotationConfigTargetSystemDetailsArgs:
    def __init__(__self__, *,
                 target_system_type: pulumi.Input[str],
                 adb_id: Optional[pulumi.Input[str]] = None,
                 function_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] target_system_type: (Updatable) Unique identifier of the target system that Vault Secret connects to.
        :param pulumi.Input[str] adb_id: (Updatable) The unique identifier (OCID) for the autonomous database that Vault Secret connects to.
        :param pulumi.Input[str] function_id: (Updatable) The unique identifier (OCID) of the Oracle Cloud Infrastructure Functions that vault secret connects to.
        """
        pulumi.set(__self__, "target_system_type", target_system_type)
        if adb_id is not None:
            pulumi.set(__self__, "adb_id", adb_id)
        if function_id is not None:
            pulumi.set(__self__, "function_id", function_id)

    @property
    @pulumi.getter(name="targetSystemType")
    def target_system_type(self) -> pulumi.Input[str]:
        """
        (Updatable) Unique identifier of the target system that Vault Secret connects to.
        """
        return pulumi.get(self, "target_system_type")

    @target_system_type.setter
    def target_system_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_system_type", value)

    @property
    @pulumi.getter(name="adbId")
    def adb_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The unique identifier (OCID) for the autonomous database that Vault Secret connects to.
        """
        return pulumi.get(self, "adb_id")

    @adb_id.setter
    def adb_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "adb_id", value)

    @property
    @pulumi.getter(name="functionId")
    def function_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The unique identifier (OCID) of the Oracle Cloud Infrastructure Functions that vault secret connects to.
        """
        return pulumi.get(self, "function_id")

    @function_id.setter
    def function_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function_id", value)


if not MYPY:
    class SecretSecretContentArgsDict(TypedDict):
        content_type: pulumi.Input[str]
        """
        (Updatable) The base64-encoded content of the secret.
        """
        content: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The base64-encoded content of the secret.
        """
        name: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Names should be unique within a secret. Valid characters are uppercase or lowercase letters, numbers, hyphens, underscores, and periods.
        """
        stage: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The rotation state of the secret content. The default is `CURRENT`, meaning that the secret is currently in use. A secret version that you mark as `PENDING` is staged and available for use, but you don't yet want to rotate it into current, active use. For example, you might create or update a secret and mark its rotation state as `PENDING` if you haven't yet updated the secret on the target system. When creating a secret, only the value `CURRENT` is applicable, although the value `LATEST` is also automatically applied. When updating a secret, you can specify a version's rotation state as either `CURRENT` or `PENDING`.
        """
elif False:
    SecretSecretContentArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecretSecretContentArgs:
    def __init__(__self__, *,
                 content_type: pulumi.Input[str],
                 content: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 stage: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] content_type: (Updatable) The base64-encoded content of the secret.
        :param pulumi.Input[str] content: (Updatable) The base64-encoded content of the secret.
        :param pulumi.Input[str] name: (Updatable) Names should be unique within a secret. Valid characters are uppercase or lowercase letters, numbers, hyphens, underscores, and periods.
        :param pulumi.Input[str] stage: (Updatable) The rotation state of the secret content. The default is `CURRENT`, meaning that the secret is currently in use. A secret version that you mark as `PENDING` is staged and available for use, but you don't yet want to rotate it into current, active use. For example, you might create or update a secret and mark its rotation state as `PENDING` if you haven't yet updated the secret on the target system. When creating a secret, only the value `CURRENT` is applicable, although the value `LATEST` is also automatically applied. When updating a secret, you can specify a version's rotation state as either `CURRENT` or `PENDING`.
        """
        pulumi.set(__self__, "content_type", content_type)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if stage is not None:
            pulumi.set(__self__, "stage", stage)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> pulumi.Input[str]:
        """
        (Updatable) The base64-encoded content of the secret.
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The base64-encoded content of the secret.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Names should be unique within a secret. Valid characters are uppercase or lowercase letters, numbers, hyphens, underscores, and periods.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def stage(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The rotation state of the secret content. The default is `CURRENT`, meaning that the secret is currently in use. A secret version that you mark as `PENDING` is staged and available for use, but you don't yet want to rotate it into current, active use. For example, you might create or update a secret and mark its rotation state as `PENDING` if you haven't yet updated the secret on the target system. When creating a secret, only the value `CURRENT` is applicable, although the value `LATEST` is also automatically applied. When updating a secret, you can specify a version's rotation state as either `CURRENT` or `PENDING`.
        """
        return pulumi.get(self, "stage")

    @stage.setter
    def stage(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stage", value)


if not MYPY:
    class SecretSecretGenerationContextArgsDict(TypedDict):
        generation_template: pulumi.Input[str]
        """
        (Updatable) Name of random bytes generation template for generating random byte type secret.
        """
        generation_type: pulumi.Input[str]
        """
        (Updatable) Name of the predefined secret generation type.
        """
        passphrase_length: NotRequired[pulumi.Input[int]]
        """
        (Updatable) Length of the passphrase to be generated
        """
        secret_template: NotRequired[pulumi.Input[str]]
        """
        (Updatable) SecretTemplate captures structure in which customer wants to store secrets. This is optional and a default structure is available for each secret type.  The template can have any structure with static values that are not generated. Within the template, you can insert predefined placeholders to store secrets.  These placeholders are later replaced with the generated content and saved as a Base64 encoded content.
        """
elif False:
    SecretSecretGenerationContextArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecretSecretGenerationContextArgs:
    def __init__(__self__, *,
                 generation_template: pulumi.Input[str],
                 generation_type: pulumi.Input[str],
                 passphrase_length: Optional[pulumi.Input[int]] = None,
                 secret_template: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] generation_template: (Updatable) Name of random bytes generation template for generating random byte type secret.
        :param pulumi.Input[str] generation_type: (Updatable) Name of the predefined secret generation type.
        :param pulumi.Input[int] passphrase_length: (Updatable) Length of the passphrase to be generated
        :param pulumi.Input[str] secret_template: (Updatable) SecretTemplate captures structure in which customer wants to store secrets. This is optional and a default structure is available for each secret type.  The template can have any structure with static values that are not generated. Within the template, you can insert predefined placeholders to store secrets.  These placeholders are later replaced with the generated content and saved as a Base64 encoded content.
        """
        pulumi.set(__self__, "generation_template", generation_template)
        pulumi.set(__self__, "generation_type", generation_type)
        if passphrase_length is not None:
            pulumi.set(__self__, "passphrase_length", passphrase_length)
        if secret_template is not None:
            pulumi.set(__self__, "secret_template", secret_template)

    @property
    @pulumi.getter(name="generationTemplate")
    def generation_template(self) -> pulumi.Input[str]:
        """
        (Updatable) Name of random bytes generation template for generating random byte type secret.
        """
        return pulumi.get(self, "generation_template")

    @generation_template.setter
    def generation_template(self, value: pulumi.Input[str]):
        pulumi.set(self, "generation_template", value)

    @property
    @pulumi.getter(name="generationType")
    def generation_type(self) -> pulumi.Input[str]:
        """
        (Updatable) Name of the predefined secret generation type.
        """
        return pulumi.get(self, "generation_type")

    @generation_type.setter
    def generation_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "generation_type", value)

    @property
    @pulumi.getter(name="passphraseLength")
    def passphrase_length(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Length of the passphrase to be generated
        """
        return pulumi.get(self, "passphrase_length")

    @passphrase_length.setter
    def passphrase_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "passphrase_length", value)

    @property
    @pulumi.getter(name="secretTemplate")
    def secret_template(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) SecretTemplate captures structure in which customer wants to store secrets. This is optional and a default structure is available for each secret type.  The template can have any structure with static values that are not generated. Within the template, you can insert predefined placeholders to store secrets.  These placeholders are later replaced with the generated content and saved as a Base64 encoded content.
        """
        return pulumi.get(self, "secret_template")

    @secret_template.setter
    def secret_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_template", value)


if not MYPY:
    class SecretSecretRuleArgsDict(TypedDict):
        rule_type: pulumi.Input[str]
        """
        (Updatable) The type of rule, which either controls when the secret contents expire or whether they can be reused.
        """
        is_enforced_on_deleted_secret_versions: NotRequired[pulumi.Input[bool]]
        """
        (Updatable) A property indicating whether the rule is applied even if the secret version with the content you are trying to reuse was deleted.
        """
        is_secret_content_retrieval_blocked_on_expiry: NotRequired[pulumi.Input[bool]]
        """
        (Updatable) A property indicating whether to block retrieval of the secret content, on expiry. The default is false. If the secret has already expired and you would like to retrieve the secret contents, you need to edit the secret rule to disable this property, to allow reading the secret content.
        """
        secret_version_expiry_interval: NotRequired[pulumi.Input[str]]
        """
        (Updatable) A property indicating how long the secret contents will be considered valid, expressed in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601#Time_intervals) format. The secret needs to be updated when the secret content expires. The timer resets after you update the secret contents. The minimum value is 1 day and the maximum value is 90 days for this property. Currently, only intervals expressed in days are supported. For example, pass `P3D` to have the secret version expire every 3 days.
        """
        time_of_absolute_expiry: NotRequired[pulumi.Input[str]]
        """
        (Updatable) An optional property indicating the absolute time when this secret will expire, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. The minimum number of days from current time is 1 day and the maximum number of days from current time is 365 days. Example: `2019-04-03T21:10:29.600Z`
        """
elif False:
    SecretSecretRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecretSecretRuleArgs:
    def __init__(__self__, *,
                 rule_type: pulumi.Input[str],
                 is_enforced_on_deleted_secret_versions: Optional[pulumi.Input[bool]] = None,
                 is_secret_content_retrieval_blocked_on_expiry: Optional[pulumi.Input[bool]] = None,
                 secret_version_expiry_interval: Optional[pulumi.Input[str]] = None,
                 time_of_absolute_expiry: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] rule_type: (Updatable) The type of rule, which either controls when the secret contents expire or whether they can be reused.
        :param pulumi.Input[bool] is_enforced_on_deleted_secret_versions: (Updatable) A property indicating whether the rule is applied even if the secret version with the content you are trying to reuse was deleted.
        :param pulumi.Input[bool] is_secret_content_retrieval_blocked_on_expiry: (Updatable) A property indicating whether to block retrieval of the secret content, on expiry. The default is false. If the secret has already expired and you would like to retrieve the secret contents, you need to edit the secret rule to disable this property, to allow reading the secret content.
        :param pulumi.Input[str] secret_version_expiry_interval: (Updatable) A property indicating how long the secret contents will be considered valid, expressed in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601#Time_intervals) format. The secret needs to be updated when the secret content expires. The timer resets after you update the secret contents. The minimum value is 1 day and the maximum value is 90 days for this property. Currently, only intervals expressed in days are supported. For example, pass `P3D` to have the secret version expire every 3 days.
        :param pulumi.Input[str] time_of_absolute_expiry: (Updatable) An optional property indicating the absolute time when this secret will expire, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. The minimum number of days from current time is 1 day and the maximum number of days from current time is 365 days. Example: `2019-04-03T21:10:29.600Z`
        """
        pulumi.set(__self__, "rule_type", rule_type)
        if is_enforced_on_deleted_secret_versions is not None:
            pulumi.set(__self__, "is_enforced_on_deleted_secret_versions", is_enforced_on_deleted_secret_versions)
        if is_secret_content_retrieval_blocked_on_expiry is not None:
            pulumi.set(__self__, "is_secret_content_retrieval_blocked_on_expiry", is_secret_content_retrieval_blocked_on_expiry)
        if secret_version_expiry_interval is not None:
            pulumi.set(__self__, "secret_version_expiry_interval", secret_version_expiry_interval)
        if time_of_absolute_expiry is not None:
            pulumi.set(__self__, "time_of_absolute_expiry", time_of_absolute_expiry)

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> pulumi.Input[str]:
        """
        (Updatable) The type of rule, which either controls when the secret contents expire or whether they can be reused.
        """
        return pulumi.get(self, "rule_type")

    @rule_type.setter
    def rule_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_type", value)

    @property
    @pulumi.getter(name="isEnforcedOnDeletedSecretVersions")
    def is_enforced_on_deleted_secret_versions(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) A property indicating whether the rule is applied even if the secret version with the content you are trying to reuse was deleted.
        """
        return pulumi.get(self, "is_enforced_on_deleted_secret_versions")

    @is_enforced_on_deleted_secret_versions.setter
    def is_enforced_on_deleted_secret_versions(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_enforced_on_deleted_secret_versions", value)

    @property
    @pulumi.getter(name="isSecretContentRetrievalBlockedOnExpiry")
    def is_secret_content_retrieval_blocked_on_expiry(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) A property indicating whether to block retrieval of the secret content, on expiry. The default is false. If the secret has already expired and you would like to retrieve the secret contents, you need to edit the secret rule to disable this property, to allow reading the secret content.
        """
        return pulumi.get(self, "is_secret_content_retrieval_blocked_on_expiry")

    @is_secret_content_retrieval_blocked_on_expiry.setter
    def is_secret_content_retrieval_blocked_on_expiry(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_secret_content_retrieval_blocked_on_expiry", value)

    @property
    @pulumi.getter(name="secretVersionExpiryInterval")
    def secret_version_expiry_interval(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A property indicating how long the secret contents will be considered valid, expressed in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601#Time_intervals) format. The secret needs to be updated when the secret content expires. The timer resets after you update the secret contents. The minimum value is 1 day and the maximum value is 90 days for this property. Currently, only intervals expressed in days are supported. For example, pass `P3D` to have the secret version expire every 3 days.
        """
        return pulumi.get(self, "secret_version_expiry_interval")

    @secret_version_expiry_interval.setter
    def secret_version_expiry_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_version_expiry_interval", value)

    @property
    @pulumi.getter(name="timeOfAbsoluteExpiry")
    def time_of_absolute_expiry(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) An optional property indicating the absolute time when this secret will expire, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. The minimum number of days from current time is 1 day and the maximum number of days from current time is 365 days. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_of_absolute_expiry")

    @time_of_absolute_expiry.setter
    def time_of_absolute_expiry(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_of_absolute_expiry", value)


if not MYPY:
    class GetSecretsFilterArgsDict(TypedDict):
        name: str
        """
        The secret name.
        """
        values: Sequence[str]
        regex: NotRequired[bool]
elif False:
    GetSecretsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetSecretsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The secret name.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The secret name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


