# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetZprPoliciesResult',
    'AwaitableGetZprPoliciesResult',
    'get_zpr_policies',
    'get_zpr_policies_output',
]

@pulumi.output_type
class GetZprPoliciesResult:
    """
    A collection of values returned by getZprPolicies.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, name=None, state=None, zpr_policies=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if zpr_policies and not isinstance(zpr_policies, list):
            raise TypeError("Expected argument 'zpr_policies' to be a list")
        pulumi.set(__self__, "zpr_policies", zpr_policies)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetZprPoliciesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name you assign to the ZprPolicy during creation. The name must be unique across all ZPL policies in the tenancy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the ZprPolicy.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="zprPolicies")
    def zpr_policies(self) -> Sequence['outputs.GetZprPoliciesZprPolicyResult']:
        """
        The list of zpr_policies.
        """
        return pulumi.get(self, "zpr_policies")


class AwaitableGetZprPoliciesResult(GetZprPoliciesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZprPoliciesResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            name=self.name,
            state=self.state,
            zpr_policies=self.zpr_policies)


def get_zpr_policies(compartment_id: Optional[str] = None,
                     filters: Optional[Sequence[Union['GetZprPoliciesFilterArgs', 'GetZprPoliciesFilterArgsDict']]] = None,
                     name: Optional[str] = None,
                     state: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZprPoliciesResult:
    """
    This data source provides the list of Zpr Policies in Oracle Cloud Infrastructure Zpr service.

    Gets a list of ZprPolicies.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_zpr_policies = oci.Zpr.get_zpr_policies(compartment_id=tenancy_ocid,
        name=zpr_policy_name,
        state=zpr_policy_state)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param str name: A filter to return only resources that match the entire display name given.
    :param str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Zpr/getZprPolicies:getZprPolicies', __args__, opts=opts, typ=GetZprPoliciesResult).value

    return AwaitableGetZprPoliciesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        state=pulumi.get(__ret__, 'state'),
        zpr_policies=pulumi.get(__ret__, 'zpr_policies'))
def get_zpr_policies_output(compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                            filters: Optional[pulumi.Input[Optional[Sequence[Union['GetZprPoliciesFilterArgs', 'GetZprPoliciesFilterArgsDict']]]]] = None,
                            name: Optional[pulumi.Input[Optional[str]]] = None,
                            state: Optional[pulumi.Input[Optional[str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetZprPoliciesResult]:
    """
    This data source provides the list of Zpr Policies in Oracle Cloud Infrastructure Zpr service.

    Gets a list of ZprPolicies.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_zpr_policies = oci.Zpr.get_zpr_policies(compartment_id=tenancy_ocid,
        name=zpr_policy_name,
        state=zpr_policy_state)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param str name: A filter to return only resources that match the entire display name given.
    :param str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Zpr/getZprPolicies:getZprPolicies', __args__, opts=opts, typ=GetZprPoliciesResult)
    return __ret__.apply(lambda __response__: GetZprPoliciesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        state=pulumi.get(__response__, 'state'),
        zpr_policies=pulumi.get(__response__, 'zpr_policies')))
