#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Thu Oct  8 19:02:33 2020 by generateDS.py version 2.35.15.
# Python 3.8.1 (v3.8.1:1b293b6006, Dec 18 2019, 14:08:53)  [Clang 6.0 (clang-600.0.57)]
#
# Command line options:
#   ('--no-namespace-defs', '')
#   ('-o', './pycanpar/CanparAddonsService.py')
#
# Command line arguments:
#   ./schemas/CanparAddonsService.xsd
#
# Command line:
#   /Users/danielkobina/Workspace/project/purplship-carriers/.venv/purplship-carriers/bin/generateDS --no-namespace-defs -o "./pycanpar/CanparAddonsService.py" ./schemas/CanparAddonsService.xsd
#
# Current working directory (os.getcwd()):
#   py-canpar
#

from six.moves import zip_longest
import os
import sys
import re as re_
import base64
import datetime as datetime_
import decimal as decimal_
try:
    from lxml import etree as etree_
except ImportError:
    from xml.etree import ElementTree as etree_


Validate_simpletypes_ = True
SaveElementTreeNode = True
if sys.version_info.major == 2:
    BaseStrType_ = basestring
else:
    BaseStrType_ = str


def parsexml_(infile, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    try:
        if isinstance(infile, os.PathLike):
            infile = os.path.join(infile)
    except AttributeError:
        pass
    doc = etree_.parse(infile, parser=parser, **kwargs)
    return doc

def parsexmlstring_(instring, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    element = etree_.fromstring(instring, parser=parser, **kwargs)
    return element

#
# Namespace prefix definition table (and other attributes, too)
#
# The module generatedsnamespaces, if it is importable, must contain
# a dictionary named GeneratedsNamespaceDefs.  This Python dictionary
# should map element type names (strings) to XML schema namespace prefix
# definitions.  The export method for any class for which there is
# a namespace prefix definition, will export that definition in the
# XML representation of that element.  See the export method of
# any generated element type class for an example of the use of this
# table.
# A sample table is:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceDefs = {
#         "ElementtypeA": "http://www.xxx.com/namespaceA",
#         "ElementtypeB": "http://www.xxx.com/namespaceB",
#     }
#
# Additionally, the generatedsnamespaces module can contain a python
# dictionary named GenerateDSNamespaceTypePrefixes that associates element
# types with the namespace prefixes that are to be added to the
# "xsi:type" attribute value.  See the exportAttributes method of
# any generated element type and the generation of "xsi:type" for an
# example of the use of this table.
# An example table:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceTypePrefixes = {
#         "ElementtypeC": "aaa:",
#         "ElementtypeD": "bbb:",
#     }
#

try:
    from generatedsnamespaces import GenerateDSNamespaceDefs as GenerateDSNamespaceDefs_
except ImportError:
    GenerateDSNamespaceDefs_ = {}
try:
    from generatedsnamespaces import GenerateDSNamespaceTypePrefixes as GenerateDSNamespaceTypePrefixes_
except ImportError:
    GenerateDSNamespaceTypePrefixes_ = {}

#
# You can replace the following class definition by defining an
# importable module named "generatedscollector" containing a class
# named "GdsCollector".  See the default class definition below for
# clues about the possible content of that class.
#
try:
    from generatedscollector import GdsCollector as GdsCollector_
except ImportError:

    class GdsCollector_(object):

        def __init__(self, messages=None):
            if messages is None:
                self.messages = []
            else:
                self.messages = messages

        def add_message(self, msg):
            self.messages.append(msg)

        def get_messages(self):
            return self.messages

        def clear_messages(self):
            self.messages = []

        def print_messages(self):
            for msg in self.messages:
                print("Warning: {}".format(msg))

        def write_messages(self, outstream):
            for msg in self.messages:
                outstream.write("Warning: {}\n".format(msg))


#
# The super-class for enum types
#

try:
    from enum import Enum
except ImportError:
    Enum = object

#
# The root super-class for element type classes
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError as exp:
    
    class GeneratedsSuper(object):
        __hash__ = object.__hash__
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_parse_string(self, input_data, node=None, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node=None, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_parse_integer(self, input_data, node=None, input_name=''):
            try:
                ival = int(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires integer value: %s' % exp)
            return ival
        def gds_validate_integer(self, input_data, node=None, input_name=''):
            try:
                value = int(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires integer value')
            return value
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_integer_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    int(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integer valuess')
            return values
        def gds_format_float(self, input_data, input_name=''):
            return ('%.15f' % input_data).rstrip('0')
        def gds_parse_float(self, input_data, node=None, input_name=''):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires float or double value: %s' % exp)
            return fval_
        def gds_validate_float(self, input_data, node=None, input_name=''):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires float value')
            return value
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_float_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of float values')
            return values
        def gds_format_decimal(self, input_data, input_name=''):
            return ('%s' % input_data).rstrip('0')
        def gds_parse_decimal(self, input_data, node=None, input_name=''):
            try:
                decimal_value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires decimal value')
            return decimal_value
        def gds_validate_decimal(self, input_data, node=None, input_name=''):
            try:
                value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires decimal value')
            return value
        def gds_format_decimal_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_decimal_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    decimal_.Decimal(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of decimal values')
            return values
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_parse_double(self, input_data, node=None, input_name=''):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires double or float value: %s' % exp)
            return fval_
        def gds_validate_double(self, input_data, node=None, input_name=''):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires double or float value')
            return value
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_double_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(
                        node, 'Requires sequence of double or float values')
            return values
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_parse_boolean(self, input_data, node=None, input_name=''):
            if input_data in ('true', '1'):
                bval = True
            elif input_data in ('false', '0'):
                bval = False
            else:
                raise_parse_error(node, 'Requires boolean value')
            return bval
        def gds_validate_boolean(self, input_data, node=None, input_name=''):
            if input_data not in (True, 1, False, 0, ):
                raise_parse_error(
                    node,
                    'Requires boolean value '
                    '(one of True, 1, False, 0)')
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_boolean_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in (True, 1, False, 0, ):
                    raise_parse_error(
                        node,
                        'Requires sequence of boolean values '
                        '(one of True, 1, False, 0)')
            return values
        def gds_validate_datetime(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split('.')
            if len(time_parts) > 1:
                micro_seconds = int(float('0.' + time_parts[1]) * 1000000)
                input_data = '%s.%s' % (
                    time_parts[0], "{}".format(micro_seconds).rjust(6, "0"), )
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(
                                hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_validate_simple_patterns(self, patterns, target):
            # pat is a list of lists of strings/patterns.
            # The target value must match at least one of the patterns
            # in order for the test to succeed.
            found1 = True
            for patterns1 in patterns:
                found2 = False
                for patterns2 in patterns1:
                    mo = re_.search(patterns2, target)
                    if mo is not None and len(mo.group(0)) == len(target):
                        found2 = True
                        break
                if not found2:
                    found1 = False
                    break
            return found1
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_check_cardinality_(
                self, value, input_name,
                min_occurs=0, max_occurs=1, required=None):
            if value is None:
                length = 0
            elif isinstance(value, list):
                length = len(value)
            else:
                length = 1
            if required is not None :
                if required and length < 1:
                    self.gds_collector_.add_message(
                        "Required value {}{} is missing".format(
                            input_name, self.gds_get_node_lineno_()))
            if length < min_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is below "
                    "the minimum allowed, "
                    "expected at least {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(),
                        min_occurs, length))
            elif length > max_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is above "
                    "the maximum allowed, "
                    "expected at most {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(),
                        max_occurs, length))
        def gds_validate_builtin_ST_(
                self, validator, value, input_name,
                min_occurs=None, max_occurs=None, required=None):
            if value is not None:
                try:
                    validator(value, input_name=input_name)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))
        def gds_validate_defined_ST_(
                self, validator, value, input_name,
                min_occurs=None, max_occurs=None, required=None):
            if value is not None:
                try:
                    validator(value)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            # provide default value in case option --disable-xml is used.
            content = ""
            content = etree_.tostring(node, encoding="unicode")
            return content
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.items()))
        @staticmethod
        def gds_encode(instring):
            if sys.version_info.major == 2:
                if ExternalEncoding:
                    encoding = ExternalEncoding
                else:
                    encoding = 'utf-8'
                return instring.encode(encoding)
            else:
                return instring
        @staticmethod
        def convert_unicode(instring):
            if isinstance(instring, str):
                result = quote_xml(instring)
            elif sys.version_info.major == 2 and isinstance(instring, unicode):
                result = quote_xml(instring).encode('utf8')
            else:
                result = GeneratedsSuper.gds_encode(str(instring))
            return result
        def __eq__(self, other):
            def excl_select_objs_(obj):
                return (obj[0] != 'parent_object_' and
                        obj[0] != 'gds_collector_')
            if type(self) != type(other):
                return False
            return all(x == y for x, y in zip_longest(
                filter(excl_select_objs_, self.__dict__.items()),
                filter(excl_select_objs_, other.__dict__.items())))
        def __ne__(self, other):
            return not self.__eq__(other)
        # Django ETL transform hooks.
        def gds_djo_etl_transform(self):
            pass
        def gds_djo_etl_transform_db_obj(self, dbobj):
            pass
        # SQLAlchemy ETL transform hooks.
        def gds_sqa_etl_transform(self):
            return 0, None
        def gds_sqa_etl_transform_db_obj(self, dbobj):
            pass
        def gds_get_node_lineno_(self):
            if (hasattr(self, "gds_elementtree_node_") and
                    self.gds_elementtree_node_ is not None):
                return ' near line {}'.format(
                    self.gds_elementtree_node_.sourceline)
            else:
                return ""
    
    
    def getSubclassFromModule_(module, class_):
        '''Get the subclass of a class from a specific module.'''
        name = class_.__name__ + 'Sub'
        if hasattr(module, name):
            return getattr(module, name)
        else:
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = ''
# Set this to false in order to deactivate during export, the use of
# name space prefixes captured from the input document.
UseCapturedNS_ = True
CapturedNsmap_ = {}
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')
CDATA_pattern_ = re_.compile(r"<!\[CDATA\[.*?\]\]>", re_.DOTALL)

# Change this to redirect the generated superclass module to use a
# specific subclass module.
CurrentSubclassModule_ = None

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    "Escape markup chars, but do not modify CDATA sections."
    if not inStr:
        return ''
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s2 = ''
    pos = 0
    matchobjects = CDATA_pattern_.finditer(s1)
    for mo in matchobjects:
        s3 = s1[pos:mo.start()]
        s2 += quote_xml_aux(s3)
        s2 += s1[mo.start():mo.end()]
        pos = mo.end()
    s3 = s1[pos:]
    s2 += quote_xml_aux(s3)
    return s2


def quote_xml_aux(inStr):
    s1 = inStr.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


def encode_str_2_3(instr):
    return instr


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    if node is not None:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace,
               pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(
                outfile, level, namespace, name_=name,
                pretty_print=pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name,
                base64.b64encode(self.value),
                self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(
                element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0,
            optional=0, child_attrs=None, choice=None):
        self.name = name
        self.data_type = data_type
        self.container = container
        self.child_attrs = child_attrs
        self.choice = choice
        self.optional = optional
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container
    def set_child_attrs(self, child_attrs): self.child_attrs = child_attrs
    def get_child_attrs(self): return self.child_attrs
    def set_choice(self, choice): self.choice = choice
    def get_choice(self): return self.choice
    def set_optional(self, optional): self.optional = optional
    def get_optional(self): return self.optional


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class getVersionResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getVersionResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getVersionResponse.subclass:
            return getVersionResponse.subclass(*args_, **kwargs_)
        else:
            return getVersionResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getVersionResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getVersionResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getVersionResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getVersionResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getVersionResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getVersionResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getVersionResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = GetVersionRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class getVersionResponse


class getStatusResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getStatusResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getStatusResponse.subclass:
            return getStatusResponse.subclass(*args_, **kwargs_)
        else:
            return getStatusResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getStatusResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getStatusResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getStatusResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getStatusResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getStatusResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getStatusResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getStatusResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = GetStatusRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class getStatusResponse


class searchLoomisExpressTerminalLocation(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchLoomisExpressTerminalLocation)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchLoomisExpressTerminalLocation.subclass:
            return searchLoomisExpressTerminalLocation.subclass(*args_, **kwargs_)
        else:
            return searchLoomisExpressTerminalLocation(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchLoomisExpressTerminalLocation', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchLoomisExpressTerminalLocation')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchLoomisExpressTerminalLocation':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchLoomisExpressTerminalLocation')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchLoomisExpressTerminalLocation', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchLoomisExpressTerminalLocation'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchLoomisExpressTerminalLocation', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SearchTerminalLocationRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class searchLoomisExpressTerminalLocation


class searchLoomisExpressTerminalLocationResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchLoomisExpressTerminalLocationResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchLoomisExpressTerminalLocationResponse.subclass:
            return searchLoomisExpressTerminalLocationResponse.subclass(*args_, **kwargs_)
        else:
            return searchLoomisExpressTerminalLocationResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchLoomisExpressTerminalLocationResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchLoomisExpressTerminalLocationResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchLoomisExpressTerminalLocationResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchLoomisExpressTerminalLocationResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchLoomisExpressTerminalLocationResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchLoomisExpressTerminalLocationResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchLoomisExpressTerminalLocationResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SearchTerminalLocationRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class searchLoomisExpressTerminalLocationResponse


class searchDropOffLocationByPostalCode(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchDropOffLocationByPostalCode)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchDropOffLocationByPostalCode.subclass:
            return searchDropOffLocationByPostalCode.subclass(*args_, **kwargs_)
        else:
            return searchDropOffLocationByPostalCode(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchDropOffLocationByPostalCode', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchDropOffLocationByPostalCode')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchDropOffLocationByPostalCode':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchDropOffLocationByPostalCode')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchDropOffLocationByPostalCode', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchDropOffLocationByPostalCode'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchDropOffLocationByPostalCode', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SearchDropOffLocationByPostalCodeRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class searchDropOffLocationByPostalCode


class searchDropOffLocationByPostalCodeResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchDropOffLocationByPostalCodeResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchDropOffLocationByPostalCodeResponse.subclass:
            return searchDropOffLocationByPostalCodeResponse.subclass(*args_, **kwargs_)
        else:
            return searchDropOffLocationByPostalCodeResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchDropOffLocationByPostalCodeResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchDropOffLocationByPostalCodeResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchDropOffLocationByPostalCodeResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchDropOffLocationByPostalCodeResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchDropOffLocationByPostalCodeResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchDropOffLocationByPostalCodeResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchDropOffLocationByPostalCodeResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SearchDropOffLocationByPostalCodeRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class searchDropOffLocationByPostalCodeResponse


class searchPickUpTagByAuthorizationNum(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchPickUpTagByAuthorizationNum)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchPickUpTagByAuthorizationNum.subclass:
            return searchPickUpTagByAuthorizationNum.subclass(*args_, **kwargs_)
        else:
            return searchPickUpTagByAuthorizationNum(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchPickUpTagByAuthorizationNum', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchPickUpTagByAuthorizationNum')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchPickUpTagByAuthorizationNum':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchPickUpTagByAuthorizationNum')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchPickUpTagByAuthorizationNum', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchPickUpTagByAuthorizationNum'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchPickUpTagByAuthorizationNum', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SearchPickUpTagByAuthorizationNumRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class searchPickUpTagByAuthorizationNum


class searchPickUpTagByAuthorizationNumResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchPickUpTagByAuthorizationNumResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchPickUpTagByAuthorizationNumResponse.subclass:
            return searchPickUpTagByAuthorizationNumResponse.subclass(*args_, **kwargs_)
        else:
            return searchPickUpTagByAuthorizationNumResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchPickUpTagByAuthorizationNumResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchPickUpTagByAuthorizationNumResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchPickUpTagByAuthorizationNumResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchPickUpTagByAuthorizationNumResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchPickUpTagByAuthorizationNumResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchPickUpTagByAuthorizationNumResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchPickUpTagByAuthorizationNumResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SearchPickUpTagByAuthorizationNumRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class searchPickUpTagByAuthorizationNumResponse


class manifestImport(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, manifestImport)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if manifestImport.subclass:
            return manifestImport.subclass(*args_, **kwargs_)
        else:
            return manifestImport(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='manifestImport', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('manifestImport')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'manifestImport':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='manifestImport')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='manifestImport', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='manifestImport'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='manifestImport', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = ManifestImportRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class manifestImport


class manifestImportResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, manifestImportResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if manifestImportResponse.subclass:
            return manifestImportResponse.subclass(*args_, **kwargs_)
        else:
            return manifestImportResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='manifestImportResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('manifestImportResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'manifestImportResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='manifestImportResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='manifestImportResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='manifestImportResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='manifestImportResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = ManifestImportRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class manifestImportResponse


class searchPickupById(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchPickupById)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchPickupById.subclass:
            return searchPickupById.subclass(*args_, **kwargs_)
        else:
            return searchPickupById(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchPickupById', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchPickupById')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchPickupById':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchPickupById')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchPickupById', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchPickupById'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchPickupById', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SearchPickupByIdRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class searchPickupById


class searchPickupByIdResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchPickupByIdResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchPickupByIdResponse.subclass:
            return searchPickupByIdResponse.subclass(*args_, **kwargs_)
        else:
            return searchPickupByIdResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchPickupByIdResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchPickupByIdResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchPickupByIdResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchPickupByIdResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchPickupByIdResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchPickupByIdResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchPickupByIdResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SearchPickupByIdRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class searchPickupByIdResponse


class trackByBarcodeV2(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, trackByBarcodeV2)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if trackByBarcodeV2.subclass:
            return trackByBarcodeV2.subclass(*args_, **kwargs_)
        else:
            return trackByBarcodeV2(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='trackByBarcodeV2', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('trackByBarcodeV2')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'trackByBarcodeV2':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='trackByBarcodeV2')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='trackByBarcodeV2', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='trackByBarcodeV2'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='trackByBarcodeV2', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = TrackByBarcodeV2Rq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class trackByBarcodeV2


class trackByBarcodeV2Response(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, trackByBarcodeV2Response)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if trackByBarcodeV2Response.subclass:
            return trackByBarcodeV2Response.subclass(*args_, **kwargs_)
        else:
            return trackByBarcodeV2Response(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='trackByBarcodeV2Response', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('trackByBarcodeV2Response')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'trackByBarcodeV2Response':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='trackByBarcodeV2Response')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='trackByBarcodeV2Response', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='trackByBarcodeV2Response'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='trackByBarcodeV2Response', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = TrackByBarcodeV2Rs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class trackByBarcodeV2Response


class getPickupDay(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getPickupDay)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getPickupDay.subclass:
            return getPickupDay.subclass(*args_, **kwargs_)
        else:
            return getPickupDay(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getPickupDay', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getPickupDay')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getPickupDay':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getPickupDay')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getPickupDay', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getPickupDay'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getPickupDay', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = GetPickupDayRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class getPickupDay


class getPickupDayResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getPickupDayResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getPickupDayResponse.subclass:
            return getPickupDayResponse.subclass(*args_, **kwargs_)
        else:
            return getPickupDayResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getPickupDayResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getPickupDayResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getPickupDayResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getPickupDayResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getPickupDayResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getPickupDayResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getPickupDayResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = GetPickupDayRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class getPickupDayResponse


class cancelPickup(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, cancelPickup)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if cancelPickup.subclass:
            return cancelPickup.subclass(*args_, **kwargs_)
        else:
            return cancelPickup(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='cancelPickup', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('cancelPickup')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'cancelPickup':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='cancelPickup')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='cancelPickup', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='cancelPickup'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='cancelPickup', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = CancelPickupRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class cancelPickup


class cancelPickupResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, cancelPickupResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if cancelPickupResponse.subclass:
            return cancelPickupResponse.subclass(*args_, **kwargs_)
        else:
            return cancelPickupResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='cancelPickupResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('cancelPickupResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'cancelPickupResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='cancelPickupResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='cancelPickupResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='cancelPickupResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='cancelPickupResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = CancelPickupRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class cancelPickupResponse


class trackByDateLite(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, trackByDateLite)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if trackByDateLite.subclass:
            return trackByDateLite.subclass(*args_, **kwargs_)
        else:
            return trackByDateLite(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='trackByDateLite', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('trackByDateLite')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'trackByDateLite':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='trackByDateLite')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='trackByDateLite', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='trackByDateLite'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='trackByDateLite', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = TrackByDateLiteRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class trackByDateLite


class trackByDateLiteResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, trackByDateLiteResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if trackByDateLiteResponse.subclass:
            return trackByDateLiteResponse.subclass(*args_, **kwargs_)
        else:
            return trackByDateLiteResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='trackByDateLiteResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('trackByDateLiteResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'trackByDateLiteResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='trackByDateLiteResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='trackByDateLiteResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='trackByDateLiteResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='trackByDateLiteResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = TrackByDateLiteRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class trackByDateLiteResponse


class schedulePickupV2(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, schedulePickupV2)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if schedulePickupV2.subclass:
            return schedulePickupV2.subclass(*args_, **kwargs_)
        else:
            return schedulePickupV2(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='schedulePickupV2', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('schedulePickupV2')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'schedulePickupV2':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='schedulePickupV2')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='schedulePickupV2', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='schedulePickupV2'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='schedulePickupV2', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SchedulePickupV2Rq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class schedulePickupV2


class schedulePickupV2Response(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, schedulePickupV2Response)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if schedulePickupV2Response.subclass:
            return schedulePickupV2Response.subclass(*args_, **kwargs_)
        else:
            return schedulePickupV2Response(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='schedulePickupV2Response', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('schedulePickupV2Response')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'schedulePickupV2Response':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='schedulePickupV2Response')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='schedulePickupV2Response', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='schedulePickupV2Response'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='schedulePickupV2Response', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SchedulePickupV2Rs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class schedulePickupV2Response


class schedulePickup(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, schedulePickup)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if schedulePickup.subclass:
            return schedulePickup.subclass(*args_, **kwargs_)
        else:
            return schedulePickup(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='schedulePickup', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('schedulePickup')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'schedulePickup':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='schedulePickup')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='schedulePickup', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='schedulePickup'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='schedulePickup', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SchedulePickupRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class schedulePickup


class schedulePickupResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, schedulePickupResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if schedulePickupResponse.subclass:
            return schedulePickupResponse.subclass(*args_, **kwargs_)
        else:
            return schedulePickupResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='schedulePickupResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('schedulePickupResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'schedulePickupResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='schedulePickupResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='schedulePickupResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='schedulePickupResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='schedulePickupResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SchedulePickupRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class schedulePickupResponse


class trackByDate(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, trackByDate)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if trackByDate.subclass:
            return trackByDate.subclass(*args_, **kwargs_)
        else:
            return trackByDate(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='trackByDate', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('trackByDate')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'trackByDate':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='trackByDate')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='trackByDate', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='trackByDate'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='trackByDate', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = TrackByDateRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class trackByDate


class trackByDateResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, trackByDateResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if trackByDateResponse.subclass:
            return trackByDateResponse.subclass(*args_, **kwargs_)
        else:
            return trackByDateResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='trackByDateResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('trackByDateResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'trackByDateResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='trackByDateResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='trackByDateResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='trackByDateResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='trackByDateResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = TrackByDateRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class trackByDateResponse


class getCutoffTime(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getCutoffTime)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getCutoffTime.subclass:
            return getCutoffTime.subclass(*args_, **kwargs_)
        else:
            return getCutoffTime(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getCutoffTime', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getCutoffTime')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getCutoffTime':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getCutoffTime')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getCutoffTime', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getCutoffTime'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getCutoffTime', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = GetCutoffTimeRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class getCutoffTime


class getCutoffTimeResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getCutoffTimeResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getCutoffTimeResponse.subclass:
            return getCutoffTimeResponse.subclass(*args_, **kwargs_)
        else:
            return getCutoffTimeResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getCutoffTimeResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getCutoffTimeResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getCutoffTimeResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getCutoffTimeResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getCutoffTimeResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getCutoffTimeResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getCutoffTimeResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = GetCutoffTimeRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class getCutoffTimeResponse


class trackByBarcode(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, trackByBarcode)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if trackByBarcode.subclass:
            return trackByBarcode.subclass(*args_, **kwargs_)
        else:
            return trackByBarcode(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='trackByBarcode', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('trackByBarcode')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'trackByBarcode':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='trackByBarcode')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='trackByBarcode', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='trackByBarcode'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='trackByBarcode', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = TrackByBarcodeRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class trackByBarcode


class trackByBarcodeResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, trackByBarcodeResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if trackByBarcodeResponse.subclass:
            return trackByBarcodeResponse.subclass(*args_, **kwargs_)
        else:
            return trackByBarcodeResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='trackByBarcodeResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('trackByBarcodeResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'trackByBarcodeResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='trackByBarcodeResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='trackByBarcodeResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='trackByBarcodeResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='trackByBarcodeResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = TrackByBarcodeRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class trackByBarcodeResponse


class getPickupInfo(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getPickupInfo)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getPickupInfo.subclass:
            return getPickupInfo.subclass(*args_, **kwargs_)
        else:
            return getPickupInfo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getPickupInfo', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getPickupInfo')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getPickupInfo':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getPickupInfo')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getPickupInfo', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getPickupInfo'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getPickupInfo', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = GetPickupInfoRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class getPickupInfo


class getPickupInfoResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getPickupInfoResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getPickupInfoResponse.subclass:
            return getPickupInfoResponse.subclass(*args_, **kwargs_)
        else:
            return getPickupInfoResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getPickupInfoResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getPickupInfoResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getPickupInfoResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getPickupInfoResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getPickupInfoResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getPickupInfoResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getPickupInfoResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = GetPickupInfoRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class getPickupInfoResponse


class getReturnTag(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getReturnTag)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getReturnTag.subclass:
            return getReturnTag.subclass(*args_, **kwargs_)
        else:
            return getReturnTag(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getReturnTag', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getReturnTag')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getReturnTag':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getReturnTag')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getReturnTag', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getReturnTag'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getReturnTag', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = GetReturnTagRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class getReturnTag


class getReturnTagResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getReturnTagResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getReturnTagResponse.subclass:
            return getReturnTagResponse.subclass(*args_, **kwargs_)
        else:
            return getReturnTagResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getReturnTagResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getReturnTagResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getReturnTagResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getReturnTagResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getReturnTagResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getReturnTagResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getReturnTagResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = GetReturnTagRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class getReturnTagResponse


class voidPickUpTag(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, voidPickUpTag)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if voidPickUpTag.subclass:
            return voidPickUpTag.subclass(*args_, **kwargs_)
        else:
            return voidPickUpTag(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='voidPickUpTag', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('voidPickUpTag')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'voidPickUpTag':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='voidPickUpTag')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='voidPickUpTag', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='voidPickUpTag'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='voidPickUpTag', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = VoidPickUpTagRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class voidPickUpTag


class voidPickUpTagResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, voidPickUpTagResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if voidPickUpTagResponse.subclass:
            return voidPickUpTagResponse.subclass(*args_, **kwargs_)
        else:
            return voidPickUpTagResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='voidPickUpTagResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('voidPickUpTagResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'voidPickUpTagResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='voidPickUpTagResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='voidPickUpTagResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='voidPickUpTagResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='voidPickUpTagResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = VoidPickUpTagRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class voidPickUpTagResponse


class importEvents(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, importEvents)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if importEvents.subclass:
            return importEvents.subclass(*args_, **kwargs_)
        else:
            return importEvents(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='importEvents', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('importEvents')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'importEvents':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='importEvents')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='importEvents', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='importEvents'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='importEvents', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = ImportEventsRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class importEvents


class importEventsResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, importEventsResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if importEventsResponse.subclass:
            return importEventsResponse.subclass(*args_, **kwargs_)
        else:
            return importEventsResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='importEventsResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('importEventsResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'importEventsResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='importEventsResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='importEventsResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='importEventsResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='importEventsResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = ImportEventsRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class importEventsResponse


class processPickUpTag(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, processPickUpTag)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if processPickUpTag.subclass:
            return processPickUpTag.subclass(*args_, **kwargs_)
        else:
            return processPickUpTag(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='processPickUpTag', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('processPickUpTag')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'processPickUpTag':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='processPickUpTag')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='processPickUpTag', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='processPickUpTag'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='processPickUpTag', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = ProcessPickUpTagRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class processPickUpTag


class processPickUpTagResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, processPickUpTagResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if processPickUpTagResponse.subclass:
            return processPickUpTagResponse.subclass(*args_, **kwargs_)
        else:
            return processPickUpTagResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='processPickUpTagResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('processPickUpTagResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'processPickUpTagResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='processPickUpTagResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='processPickUpTagResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='processPickUpTagResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='processPickUpTagResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = ProcessPickUpTagRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class processPickUpTagResponse


class searchPickupByPickupDate(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchPickupByPickupDate)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchPickupByPickupDate.subclass:
            return searchPickupByPickupDate.subclass(*args_, **kwargs_)
        else:
            return searchPickupByPickupDate(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchPickupByPickupDate', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchPickupByPickupDate')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchPickupByPickupDate':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchPickupByPickupDate')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchPickupByPickupDate', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchPickupByPickupDate'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchPickupByPickupDate', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SearchPickupByPickupDateRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class searchPickupByPickupDate


class searchPickupByPickupDateResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchPickupByPickupDateResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchPickupByPickupDateResponse.subclass:
            return searchPickupByPickupDateResponse.subclass(*args_, **kwargs_)
        else:
            return searchPickupByPickupDateResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchPickupByPickupDateResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchPickupByPickupDateResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchPickupByPickupDateResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchPickupByPickupDateResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchPickupByPickupDateResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchPickupByPickupDateResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchPickupByPickupDateResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SearchPickupByPickupDateRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class searchPickupByPickupDateResponse


class searchPickupByPickupDateV2(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchPickupByPickupDateV2)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchPickupByPickupDateV2.subclass:
            return searchPickupByPickupDateV2.subclass(*args_, **kwargs_)
        else:
            return searchPickupByPickupDateV2(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchPickupByPickupDateV2', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchPickupByPickupDateV2')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchPickupByPickupDateV2':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchPickupByPickupDateV2')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchPickupByPickupDateV2', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchPickupByPickupDateV2'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchPickupByPickupDateV2', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SearchPickupByPickupDateV2Rq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class searchPickupByPickupDateV2


class searchPickupByPickupDateV2Response(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchPickupByPickupDateV2Response)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchPickupByPickupDateV2Response.subclass:
            return searchPickupByPickupDateV2Response.subclass(*args_, **kwargs_)
        else:
            return searchPickupByPickupDateV2Response(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchPickupByPickupDateV2Response', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchPickupByPickupDateV2Response')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchPickupByPickupDateV2Response':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchPickupByPickupDateV2Response')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchPickupByPickupDateV2Response', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchPickupByPickupDateV2Response'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchPickupByPickupDateV2Response', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SearchPickupByPickupDateV2Rs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class searchPickupByPickupDateV2Response


class exportAddressBookFromCanshipWeb(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, exportAddressBookFromCanshipWeb)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if exportAddressBookFromCanshipWeb.subclass:
            return exportAddressBookFromCanshipWeb.subclass(*args_, **kwargs_)
        else:
            return exportAddressBookFromCanshipWeb(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='exportAddressBookFromCanshipWeb', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('exportAddressBookFromCanshipWeb')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'exportAddressBookFromCanshipWeb':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='exportAddressBookFromCanshipWeb')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='exportAddressBookFromCanshipWeb', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='exportAddressBookFromCanshipWeb'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='exportAddressBookFromCanshipWeb', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = ExportAddressBookFromCanshipWebRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class exportAddressBookFromCanshipWeb


class exportAddressBookFromCanshipWebResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, exportAddressBookFromCanshipWebResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if exportAddressBookFromCanshipWebResponse.subclass:
            return exportAddressBookFromCanshipWebResponse.subclass(*args_, **kwargs_)
        else:
            return exportAddressBookFromCanshipWebResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='exportAddressBookFromCanshipWebResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('exportAddressBookFromCanshipWebResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'exportAddressBookFromCanshipWebResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='exportAddressBookFromCanshipWebResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='exportAddressBookFromCanshipWebResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='exportAddressBookFromCanshipWebResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='exportAddressBookFromCanshipWebResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = ExportAddressBookFromCanshipWebRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class exportAddressBookFromCanshipWebResponse


class trackByReferenceLoomis(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, trackByReferenceLoomis)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if trackByReferenceLoomis.subclass:
            return trackByReferenceLoomis.subclass(*args_, **kwargs_)
        else:
            return trackByReferenceLoomis(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='trackByReferenceLoomis', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('trackByReferenceLoomis')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'trackByReferenceLoomis':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='trackByReferenceLoomis')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='trackByReferenceLoomis', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='trackByReferenceLoomis'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='trackByReferenceLoomis', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = TrackByReferenceLoomisRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class trackByReferenceLoomis


class trackByReferenceLoomisResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, trackByReferenceLoomisResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if trackByReferenceLoomisResponse.subclass:
            return trackByReferenceLoomisResponse.subclass(*args_, **kwargs_)
        else:
            return trackByReferenceLoomisResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='trackByReferenceLoomisResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('trackByReferenceLoomisResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'trackByReferenceLoomisResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='trackByReferenceLoomisResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='trackByReferenceLoomisResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='trackByReferenceLoomisResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='trackByReferenceLoomisResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = TrackByBarcodeRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class trackByReferenceLoomisResponse


class searchPickUpTagByShippingDate(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchPickUpTagByShippingDate)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchPickUpTagByShippingDate.subclass:
            return searchPickUpTagByShippingDate.subclass(*args_, **kwargs_)
        else:
            return searchPickUpTagByShippingDate(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchPickUpTagByShippingDate', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchPickUpTagByShippingDate')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchPickUpTagByShippingDate':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchPickUpTagByShippingDate')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchPickUpTagByShippingDate', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchPickUpTagByShippingDate'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchPickUpTagByShippingDate', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SearchPickUpTagByShippingDateRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class searchPickUpTagByShippingDate


class searchPickUpTagByShippingDateResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchPickUpTagByShippingDateResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchPickUpTagByShippingDateResponse.subclass:
            return searchPickUpTagByShippingDateResponse.subclass(*args_, **kwargs_)
        else:
            return searchPickUpTagByShippingDateResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchPickUpTagByShippingDateResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchPickUpTagByShippingDateResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchPickUpTagByShippingDateResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchPickUpTagByShippingDateResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchPickUpTagByShippingDateResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchPickUpTagByShippingDateResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchPickUpTagByShippingDateResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SearchPickUpTagByShippingDateRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class searchPickUpTagByShippingDateResponse


class checkOfflineRatesPackage(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, checkOfflineRatesPackage)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if checkOfflineRatesPackage.subclass:
            return checkOfflineRatesPackage.subclass(*args_, **kwargs_)
        else:
            return checkOfflineRatesPackage(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='checkOfflineRatesPackage', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('checkOfflineRatesPackage')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'checkOfflineRatesPackage':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='checkOfflineRatesPackage')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='checkOfflineRatesPackage', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='checkOfflineRatesPackage'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='checkOfflineRatesPackage', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = CheckOfflineRatesPackageRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class checkOfflineRatesPackage


class checkOfflineRatesPackageResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, checkOfflineRatesPackageResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if checkOfflineRatesPackageResponse.subclass:
            return checkOfflineRatesPackageResponse.subclass(*args_, **kwargs_)
        else:
            return checkOfflineRatesPackageResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='checkOfflineRatesPackageResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('checkOfflineRatesPackageResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'checkOfflineRatesPackageResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='checkOfflineRatesPackageResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='checkOfflineRatesPackageResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='checkOfflineRatesPackageResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='checkOfflineRatesPackageResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = CheckOfflineRatesPackageRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class checkOfflineRatesPackageResponse


class trackByBarcodeLoomis(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, trackByBarcodeLoomis)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if trackByBarcodeLoomis.subclass:
            return trackByBarcodeLoomis.subclass(*args_, **kwargs_)
        else:
            return trackByBarcodeLoomis(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='trackByBarcodeLoomis', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('trackByBarcodeLoomis')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'trackByBarcodeLoomis':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='trackByBarcodeLoomis')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='trackByBarcodeLoomis', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='trackByBarcodeLoomis'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='trackByBarcodeLoomis', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = TrackByBarcodeRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class trackByBarcodeLoomis


class trackByBarcodeLoomisResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, trackByBarcodeLoomisResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if trackByBarcodeLoomisResponse.subclass:
            return trackByBarcodeLoomisResponse.subclass(*args_, **kwargs_)
        else:
            return trackByBarcodeLoomisResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='trackByBarcodeLoomisResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('trackByBarcodeLoomisResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'trackByBarcodeLoomisResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='trackByBarcodeLoomisResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='trackByBarcodeLoomisResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='trackByBarcodeLoomisResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='trackByBarcodeLoomisResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = TrackByBarcodeRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class trackByBarcodeLoomisResponse


class insertLiteShipment(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, insertLiteShipment)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if insertLiteShipment.subclass:
            return insertLiteShipment.subclass(*args_, **kwargs_)
        else:
            return insertLiteShipment(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='insertLiteShipment', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('insertLiteShipment')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'insertLiteShipment':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='insertLiteShipment')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='insertLiteShipment', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='insertLiteShipment'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='insertLiteShipment', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = InsertLiteShipmentRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class insertLiteShipment


class insertLiteShipmentResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, insertLiteShipmentResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if insertLiteShipmentResponse.subclass:
            return insertLiteShipmentResponse.subclass(*args_, **kwargs_)
        else:
            return insertLiteShipmentResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='insertLiteShipmentResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('insertLiteShipmentResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'insertLiteShipmentResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='insertLiteShipmentResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='insertLiteShipmentResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='insertLiteShipmentResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='insertLiteShipmentResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = InsertLiteShipmentRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class insertLiteShipmentResponse


class searchDropOffLocationByCity(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchDropOffLocationByCity)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchDropOffLocationByCity.subclass:
            return searchDropOffLocationByCity.subclass(*args_, **kwargs_)
        else:
            return searchDropOffLocationByCity(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchDropOffLocationByCity', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchDropOffLocationByCity')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchDropOffLocationByCity':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchDropOffLocationByCity')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchDropOffLocationByCity', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchDropOffLocationByCity'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchDropOffLocationByCity', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SearchDropOffLocationByCityRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class searchDropOffLocationByCity


class searchDropOffLocationByCityResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchDropOffLocationByCityResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchDropOffLocationByCityResponse.subclass:
            return searchDropOffLocationByCityResponse.subclass(*args_, **kwargs_)
        else:
            return searchDropOffLocationByCityResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchDropOffLocationByCityResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchDropOffLocationByCityResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchDropOffLocationByCityResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchDropOffLocationByCityResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchDropOffLocationByCityResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchDropOffLocationByCityResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchDropOffLocationByCityResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SearchDropOffLocationByCityRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class searchDropOffLocationByCityResponse


class searchPickupByIdV2(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchPickupByIdV2)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchPickupByIdV2.subclass:
            return searchPickupByIdV2.subclass(*args_, **kwargs_)
        else:
            return searchPickupByIdV2(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchPickupByIdV2', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchPickupByIdV2')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchPickupByIdV2':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchPickupByIdV2')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchPickupByIdV2', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchPickupByIdV2'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchPickupByIdV2', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SearchPickupByIdV2Rq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class searchPickupByIdV2


class searchPickupByIdV2Response(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchPickupByIdV2Response)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchPickupByIdV2Response.subclass:
            return searchPickupByIdV2Response.subclass(*args_, **kwargs_)
        else:
            return searchPickupByIdV2Response(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchPickupByIdV2Response', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchPickupByIdV2Response')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchPickupByIdV2Response':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchPickupByIdV2Response')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchPickupByIdV2Response', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchPickupByIdV2Response'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchPickupByIdV2Response', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SearchPickupByIdV2Rs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class searchPickupByIdV2Response


class requestOfflineRatesPackage(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, requestOfflineRatesPackage)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if requestOfflineRatesPackage.subclass:
            return requestOfflineRatesPackage.subclass(*args_, **kwargs_)
        else:
            return requestOfflineRatesPackage(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='requestOfflineRatesPackage', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('requestOfflineRatesPackage')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'requestOfflineRatesPackage':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='requestOfflineRatesPackage')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='requestOfflineRatesPackage', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='requestOfflineRatesPackage'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='requestOfflineRatesPackage', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = RequestOfflineRatesPackageRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class requestOfflineRatesPackage


class requestOfflineRatesPackageResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, requestOfflineRatesPackageResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if requestOfflineRatesPackageResponse.subclass:
            return requestOfflineRatesPackageResponse.subclass(*args_, **kwargs_)
        else:
            return requestOfflineRatesPackageResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='requestOfflineRatesPackageResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('requestOfflineRatesPackageResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'requestOfflineRatesPackageResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='requestOfflineRatesPackageResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='requestOfflineRatesPackageResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='requestOfflineRatesPackageResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='requestOfflineRatesPackageResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = RequestOfflineRatesPackageRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class requestOfflineRatesPackageResponse


class getFuelSurchargeRate(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getFuelSurchargeRate)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getFuelSurchargeRate.subclass:
            return getFuelSurchargeRate.subclass(*args_, **kwargs_)
        else:
            return getFuelSurchargeRate(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getFuelSurchargeRate', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getFuelSurchargeRate')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getFuelSurchargeRate':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getFuelSurchargeRate')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getFuelSurchargeRate', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getFuelSurchargeRate'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getFuelSurchargeRate', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = GetFuelSurchargeRateRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class getFuelSurchargeRate


class getFuelSurchargeRateResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getFuelSurchargeRateResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getFuelSurchargeRateResponse.subclass:
            return getFuelSurchargeRateResponse.subclass(*args_, **kwargs_)
        else:
            return getFuelSurchargeRateResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getFuelSurchargeRateResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getFuelSurchargeRateResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getFuelSurchargeRateResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getFuelSurchargeRateResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getFuelSurchargeRateResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getFuelSurchargeRateResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getFuelSurchargeRateResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = GetFuelSurchargeRateRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class getFuelSurchargeRateResponse


class searchTerminalLocation(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchTerminalLocation)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchTerminalLocation.subclass:
            return searchTerminalLocation.subclass(*args_, **kwargs_)
        else:
            return searchTerminalLocation(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchTerminalLocation', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchTerminalLocation')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchTerminalLocation':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchTerminalLocation')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchTerminalLocation', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchTerminalLocation'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchTerminalLocation', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SearchTerminalLocationRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class searchTerminalLocation


class searchTerminalLocationResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchTerminalLocationResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchTerminalLocationResponse.subclass:
            return searchTerminalLocationResponse.subclass(*args_, **kwargs_)
        else:
            return searchTerminalLocationResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchTerminalLocationResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchTerminalLocationResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchTerminalLocationResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchTerminalLocationResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchTerminalLocationResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchTerminalLocationResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchTerminalLocationResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SearchTerminalLocationRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class searchTerminalLocationResponse


class GetVersionRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, version=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
        self.version = version
        self.version_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetVersionRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetVersionRs.subclass:
            return GetVersionRs.subclass(*args_, **kwargs_)
        else:
            return GetVersionRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def get_version(self):
        return self.version
    def set_version(self, version):
        self.version = version
    def hasContent_(self):
        if (
            self.error is not None or
            self.version is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetVersionRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GetVersionRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GetVersionRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GetVersionRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GetVersionRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GetVersionRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetVersionRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
        if self.version is not None:
            namespaceprefix_ = self.version_nsprefix_ + ':' if (UseCapturedNS_ and self.version_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sversion>%s</%sversion>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.version), input_name='version')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
        elif nodeName_ == 'version':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'version')
            value_ = self.gds_validate_string(value_, node, 'version')
            self.version = value_
            self.version_nsprefix_ = child_.prefix
# end class GetVersionRs


class GetStatusRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, status=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
        self.status = status
        self.status_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetStatusRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetStatusRs.subclass:
            return GetStatusRs.subclass(*args_, **kwargs_)
        else:
            return GetStatusRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def get_status(self):
        return self.status
    def set_status(self, status):
        self.status = status
    def hasContent_(self):
        if (
            self.error is not None or
            self.status is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetStatusRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GetStatusRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GetStatusRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GetStatusRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GetStatusRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GetStatusRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetStatusRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
        if self.status is not None:
            namespaceprefix_ = self.status_nsprefix_ + ':' if (UseCapturedNS_ and self.status_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstatus>%s</%sstatus>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.status), input_name='status')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
        elif nodeName_ == 'status':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'status')
            value_ = self.gds_validate_string(value_, node, 'status')
            self.status = value_
            self.status_nsprefix_ = child_.prefix
# end class GetStatusRs


class SearchTerminalLocationRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, city=None, postal_code=None, province=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.city = city
        self.city_nsprefix_ = None
        self.postal_code = postal_code
        self.postal_code_nsprefix_ = None
        self.province = province
        self.province_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SearchTerminalLocationRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SearchTerminalLocationRq.subclass:
            return SearchTerminalLocationRq.subclass(*args_, **kwargs_)
        else:
            return SearchTerminalLocationRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_city(self):
        return self.city
    def set_city(self, city):
        self.city = city
    def get_postal_code(self):
        return self.postal_code
    def set_postal_code(self, postal_code):
        self.postal_code = postal_code
    def get_province(self):
        return self.province
    def set_province(self, province):
        self.province = province
    def hasContent_(self):
        if (
            self.city is not None or
            self.postal_code is not None or
            self.province is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchTerminalLocationRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SearchTerminalLocationRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SearchTerminalLocationRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SearchTerminalLocationRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SearchTerminalLocationRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SearchTerminalLocationRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchTerminalLocationRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.city is not None:
            namespaceprefix_ = self.city_nsprefix_ + ':' if (UseCapturedNS_ and self.city_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scity>%s</%scity>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.city), input_name='city')), namespaceprefix_ , eol_))
        if self.postal_code is not None:
            namespaceprefix_ = self.postal_code_nsprefix_ + ':' if (UseCapturedNS_ and self.postal_code_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spostal_code>%s</%spostal_code>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.postal_code), input_name='postal_code')), namespaceprefix_ , eol_))
        if self.province is not None:
            namespaceprefix_ = self.province_nsprefix_ + ':' if (UseCapturedNS_ and self.province_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sprovince>%s</%sprovince>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.province), input_name='province')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'city':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'city')
            value_ = self.gds_validate_string(value_, node, 'city')
            self.city = value_
            self.city_nsprefix_ = child_.prefix
        elif nodeName_ == 'postal_code':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'postal_code')
            value_ = self.gds_validate_string(value_, node, 'postal_code')
            self.postal_code = value_
            self.postal_code_nsprefix_ = child_.prefix
        elif nodeName_ == 'province':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'province')
            value_ = self.gds_validate_string(value_, node, 'province')
            self.province = value_
            self.province_nsprefix_ = child_.prefix
# end class SearchTerminalLocationRq


class SearchTerminalLocationRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, result=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
        if result is None:
            self.result = []
        else:
            self.result = result
        self.result_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SearchTerminalLocationRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SearchTerminalLocationRs.subclass:
            return SearchTerminalLocationRs.subclass(*args_, **kwargs_)
        else:
            return SearchTerminalLocationRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def get_result(self):
        return self.result
    def set_result(self, result):
        self.result = result
    def add_result(self, value):
        self.result.append(value)
    def insert_result_at(self, index, value):
        self.result.insert(index, value)
    def replace_result_at(self, index, value):
        self.result[index] = value
    def hasContent_(self):
        if (
            self.error is not None or
            self.result
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchTerminalLocationRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SearchTerminalLocationRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SearchTerminalLocationRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SearchTerminalLocationRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SearchTerminalLocationRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SearchTerminalLocationRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchTerminalLocationRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
        for result_ in self.result:
            namespaceprefix_ = self.result_nsprefix_ + ':' if (UseCapturedNS_ and self.result_nsprefix_) else ''
            result_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='result', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
        elif nodeName_ == 'result':
            obj_ = TerminalLocation.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.result.append(obj_)
            obj_.original_tagname_ = 'result'
# end class SearchTerminalLocationRs


class SearchDropOffLocationByPostalCodeRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, from_postal_code=None, to_postal_code=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.from_postal_code = from_postal_code
        self.from_postal_code_nsprefix_ = None
        self.to_postal_code = to_postal_code
        self.to_postal_code_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SearchDropOffLocationByPostalCodeRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SearchDropOffLocationByPostalCodeRq.subclass:
            return SearchDropOffLocationByPostalCodeRq.subclass(*args_, **kwargs_)
        else:
            return SearchDropOffLocationByPostalCodeRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_from_postal_code(self):
        return self.from_postal_code
    def set_from_postal_code(self, from_postal_code):
        self.from_postal_code = from_postal_code
    def get_to_postal_code(self):
        return self.to_postal_code
    def set_to_postal_code(self, to_postal_code):
        self.to_postal_code = to_postal_code
    def hasContent_(self):
        if (
            self.from_postal_code is not None or
            self.to_postal_code is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchDropOffLocationByPostalCodeRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SearchDropOffLocationByPostalCodeRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SearchDropOffLocationByPostalCodeRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SearchDropOffLocationByPostalCodeRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SearchDropOffLocationByPostalCodeRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SearchDropOffLocationByPostalCodeRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchDropOffLocationByPostalCodeRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.from_postal_code is not None:
            namespaceprefix_ = self.from_postal_code_nsprefix_ + ':' if (UseCapturedNS_ and self.from_postal_code_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfrom_postal_code>%s</%sfrom_postal_code>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.from_postal_code), input_name='from_postal_code')), namespaceprefix_ , eol_))
        if self.to_postal_code is not None:
            namespaceprefix_ = self.to_postal_code_nsprefix_ + ':' if (UseCapturedNS_ and self.to_postal_code_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sto_postal_code>%s</%sto_postal_code>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.to_postal_code), input_name='to_postal_code')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'from_postal_code':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'from_postal_code')
            value_ = self.gds_validate_string(value_, node, 'from_postal_code')
            self.from_postal_code = value_
            self.from_postal_code_nsprefix_ = child_.prefix
        elif nodeName_ == 'to_postal_code':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'to_postal_code')
            value_ = self.gds_validate_string(value_, node, 'to_postal_code')
            self.to_postal_code = value_
            self.to_postal_code_nsprefix_ = child_.prefix
# end class SearchDropOffLocationByPostalCodeRq


class SearchDropOffLocationByPostalCodeRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, result=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
        if result is None:
            self.result = []
        else:
            self.result = result
        self.result_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SearchDropOffLocationByPostalCodeRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SearchDropOffLocationByPostalCodeRs.subclass:
            return SearchDropOffLocationByPostalCodeRs.subclass(*args_, **kwargs_)
        else:
            return SearchDropOffLocationByPostalCodeRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def get_result(self):
        return self.result
    def set_result(self, result):
        self.result = result
    def add_result(self, value):
        self.result.append(value)
    def insert_result_at(self, index, value):
        self.result.insert(index, value)
    def replace_result_at(self, index, value):
        self.result[index] = value
    def hasContent_(self):
        if (
            self.error is not None or
            self.result
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchDropOffLocationByPostalCodeRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SearchDropOffLocationByPostalCodeRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SearchDropOffLocationByPostalCodeRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SearchDropOffLocationByPostalCodeRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SearchDropOffLocationByPostalCodeRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SearchDropOffLocationByPostalCodeRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchDropOffLocationByPostalCodeRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
        for result_ in self.result:
            namespaceprefix_ = self.result_nsprefix_ + ':' if (UseCapturedNS_ and self.result_nsprefix_) else ''
            result_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='result', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
        elif nodeName_ == 'result':
            obj_ = Address.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.result.append(obj_)
            obj_.original_tagname_ = 'result'
# end class SearchDropOffLocationByPostalCodeRs


class SearchPickUpTagByAuthorizationNumRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, alternative_reference=None, from_date=None, page_num=None, password=None, shipper_num=None, to_date=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.alternative_reference = alternative_reference
        self.alternative_reference_nsprefix_ = None
        if isinstance(from_date, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(from_date, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = from_date
        self.from_date = initvalue_
        self.from_date_nsprefix_ = None
        self.page_num = page_num
        self.page_num_nsprefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        self.shipper_num = shipper_num
        self.shipper_num_nsprefix_ = None
        if isinstance(to_date, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(to_date, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = to_date
        self.to_date = initvalue_
        self.to_date_nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SearchPickUpTagByAuthorizationNumRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SearchPickUpTagByAuthorizationNumRq.subclass:
            return SearchPickUpTagByAuthorizationNumRq.subclass(*args_, **kwargs_)
        else:
            return SearchPickUpTagByAuthorizationNumRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_alternative_reference(self):
        return self.alternative_reference
    def set_alternative_reference(self, alternative_reference):
        self.alternative_reference = alternative_reference
    def get_from_date(self):
        return self.from_date
    def set_from_date(self, from_date):
        self.from_date = from_date
    def get_page_num(self):
        return self.page_num
    def set_page_num(self, page_num):
        self.page_num = page_num
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_shipper_num(self):
        return self.shipper_num
    def set_shipper_num(self, shipper_num):
        self.shipper_num = shipper_num
    def get_to_date(self):
        return self.to_date
    def set_to_date(self, to_date):
        self.to_date = to_date
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.alternative_reference is not None or
            self.from_date is not None or
            self.page_num is not None or
            self.password is not None or
            self.shipper_num is not None or
            self.to_date is not None or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchPickUpTagByAuthorizationNumRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SearchPickUpTagByAuthorizationNumRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SearchPickUpTagByAuthorizationNumRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SearchPickUpTagByAuthorizationNumRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SearchPickUpTagByAuthorizationNumRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SearchPickUpTagByAuthorizationNumRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchPickUpTagByAuthorizationNumRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.alternative_reference is not None:
            namespaceprefix_ = self.alternative_reference_nsprefix_ + ':' if (UseCapturedNS_ and self.alternative_reference_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%salternative_reference>%s</%salternative_reference>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.alternative_reference), input_name='alternative_reference')), namespaceprefix_ , eol_))
        if self.from_date is not None:
            namespaceprefix_ = self.from_date_nsprefix_ + ':' if (UseCapturedNS_ and self.from_date_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfrom_date>%s</%sfrom_date>%s' % (namespaceprefix_ , self.gds_format_datetime(self.from_date, input_name='from_date'), namespaceprefix_ , eol_))
        if self.page_num is not None:
            namespaceprefix_ = self.page_num_nsprefix_ + ':' if (UseCapturedNS_ and self.page_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spage_num>%s</%spage_num>%s' % (namespaceprefix_ , self.gds_format_integer(self.page_num, input_name='page_num'), namespaceprefix_ , eol_))
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        if self.shipper_num is not None:
            namespaceprefix_ = self.shipper_num_nsprefix_ + ':' if (UseCapturedNS_ and self.shipper_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sshipper_num>%s</%sshipper_num>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.shipper_num), input_name='shipper_num')), namespaceprefix_ , eol_))
        if self.to_date is not None:
            namespaceprefix_ = self.to_date_nsprefix_ + ':' if (UseCapturedNS_ and self.to_date_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sto_date>%s</%sto_date>%s' % (namespaceprefix_ , self.gds_format_datetime(self.to_date, input_name='to_date'), namespaceprefix_ , eol_))
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'alternative_reference':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'alternative_reference')
            value_ = self.gds_validate_string(value_, node, 'alternative_reference')
            self.alternative_reference = value_
            self.alternative_reference_nsprefix_ = child_.prefix
        elif nodeName_ == 'from_date':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.from_date = dval_
            self.from_date_nsprefix_ = child_.prefix
        elif nodeName_ == 'page_num' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'page_num')
            ival_ = self.gds_validate_integer(ival_, node, 'page_num')
            self.page_num = ival_
            self.page_num_nsprefix_ = child_.prefix
        elif nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'shipper_num':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'shipper_num')
            value_ = self.gds_validate_string(value_, node, 'shipper_num')
            self.shipper_num = value_
            self.shipper_num_nsprefix_ = child_.prefix
        elif nodeName_ == 'to_date':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.to_date = dval_
            self.to_date_nsprefix_ = child_.prefix
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class SearchPickUpTagByAuthorizationNumRq


class SearchPickUpTagByAuthorizationNumRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, pickup_tag=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
        if pickup_tag is None:
            self.pickup_tag = []
        else:
            self.pickup_tag = pickup_tag
        self.pickup_tag_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SearchPickUpTagByAuthorizationNumRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SearchPickUpTagByAuthorizationNumRs.subclass:
            return SearchPickUpTagByAuthorizationNumRs.subclass(*args_, **kwargs_)
        else:
            return SearchPickUpTagByAuthorizationNumRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def get_pickup_tag(self):
        return self.pickup_tag
    def set_pickup_tag(self, pickup_tag):
        self.pickup_tag = pickup_tag
    def add_pickup_tag(self, value):
        self.pickup_tag.append(value)
    def insert_pickup_tag_at(self, index, value):
        self.pickup_tag.insert(index, value)
    def replace_pickup_tag_at(self, index, value):
        self.pickup_tag[index] = value
    def hasContent_(self):
        if (
            self.error is not None or
            self.pickup_tag
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchPickUpTagByAuthorizationNumRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SearchPickUpTagByAuthorizationNumRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SearchPickUpTagByAuthorizationNumRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SearchPickUpTagByAuthorizationNumRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SearchPickUpTagByAuthorizationNumRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SearchPickUpTagByAuthorizationNumRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchPickUpTagByAuthorizationNumRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
        for pickup_tag_ in self.pickup_tag:
            namespaceprefix_ = self.pickup_tag_nsprefix_ + ':' if (UseCapturedNS_ and self.pickup_tag_nsprefix_) else ''
            pickup_tag_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='pickup_tag', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
        elif nodeName_ == 'pickup_tag':
            obj_ = Shipment.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.pickup_tag.append(obj_)
            obj_.original_tagname_ = 'pickup_tag'
# end class SearchPickUpTagByAuthorizationNumRs


class ManifestImportRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, data=None, password=None, type_=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.data = data
        self.data_nsprefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        self.type_ = type_
        self.type__nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ManifestImportRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ManifestImportRq.subclass:
            return ManifestImportRq.subclass(*args_, **kwargs_)
        else:
            return ManifestImportRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_data(self):
        return self.data
    def set_data(self, data):
        self.data = data
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_type(self):
        return self.type_
    def set_type(self, type_):
        self.type_ = type_
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.data is not None or
            self.password is not None or
            self.type_ is not None or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ManifestImportRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ManifestImportRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ManifestImportRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ManifestImportRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ManifestImportRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ManifestImportRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ManifestImportRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.data is not None:
            namespaceprefix_ = self.data_nsprefix_ + ':' if (UseCapturedNS_ and self.data_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdata>%s</%sdata>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.data), input_name='data')), namespaceprefix_ , eol_))
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        if self.type_ is not None:
            namespaceprefix_ = self.type__nsprefix_ + ':' if (UseCapturedNS_ and self.type__nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stype>%s</%stype>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.type_), input_name='type')), namespaceprefix_ , eol_))
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'data':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'data')
            value_ = self.gds_validate_string(value_, node, 'data')
            self.data = value_
            self.data_nsprefix_ = child_.prefix
        elif nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'type':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'type')
            value_ = self.gds_validate_string(value_, node, 'type')
            self.type_ = value_
            self.type_nsprefix_ = child_.prefix
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class ManifestImportRq


class ManifestImportRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, data=None, error=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.data = data
        self.data_nsprefix_ = None
        self.error = error
        self.error_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ManifestImportRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ManifestImportRs.subclass:
            return ManifestImportRs.subclass(*args_, **kwargs_)
        else:
            return ManifestImportRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_data(self):
        return self.data
    def set_data(self, data):
        self.data = data
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def hasContent_(self):
        if (
            self.data is not None or
            self.error is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ManifestImportRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ManifestImportRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ManifestImportRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ManifestImportRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ManifestImportRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ManifestImportRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ManifestImportRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.data is not None:
            namespaceprefix_ = self.data_nsprefix_ + ':' if (UseCapturedNS_ and self.data_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdata>%s</%sdata>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.data), input_name='data')), namespaceprefix_ , eol_))
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'data':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'data')
            value_ = self.gds_validate_string(value_, node, 'data')
            self.data = value_
            self.data_nsprefix_ = child_.prefix
        elif nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
# end class ManifestImportRs


class SearchPickupByIdRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, id=None, password=None, shipper_num=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = id
        self.id_nsprefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        self.shipper_num = shipper_num
        self.shipper_num_nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SearchPickupByIdRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SearchPickupByIdRq.subclass:
            return SearchPickupByIdRq.subclass(*args_, **kwargs_)
        else:
            return SearchPickupByIdRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_shipper_num(self):
        return self.shipper_num
    def set_shipper_num(self, shipper_num):
        self.shipper_num = shipper_num
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.id is not None or
            self.password is not None or
            self.shipper_num is not None or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchPickupByIdRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SearchPickupByIdRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SearchPickupByIdRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SearchPickupByIdRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SearchPickupByIdRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SearchPickupByIdRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchPickupByIdRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.id is not None:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sid>%s</%sid>%s' % (namespaceprefix_ , self.gds_format_integer(self.id, input_name='id'), namespaceprefix_ , eol_))
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        if self.shipper_num is not None:
            namespaceprefix_ = self.shipper_num_nsprefix_ + ':' if (UseCapturedNS_ and self.shipper_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sshipper_num>%s</%sshipper_num>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.shipper_num), input_name='shipper_num')), namespaceprefix_ , eol_))
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'id' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'id')
            ival_ = self.gds_validate_integer(ival_, node, 'id')
            self.id = ival_
            self.id_nsprefix_ = child_.prefix
        elif nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'shipper_num':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'shipper_num')
            value_ = self.gds_validate_string(value_, node, 'shipper_num')
            self.shipper_num = value_
            self.shipper_num_nsprefix_ = child_.prefix
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class SearchPickupByIdRq


class SearchPickupByIdRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, pickup=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
        if pickup is None:
            self.pickup = []
        else:
            self.pickup = pickup
        self.pickup_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SearchPickupByIdRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SearchPickupByIdRs.subclass:
            return SearchPickupByIdRs.subclass(*args_, **kwargs_)
        else:
            return SearchPickupByIdRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def get_pickup(self):
        return self.pickup
    def set_pickup(self, pickup):
        self.pickup = pickup
    def add_pickup(self, value):
        self.pickup.append(value)
    def insert_pickup_at(self, index, value):
        self.pickup.insert(index, value)
    def replace_pickup_at(self, index, value):
        self.pickup[index] = value
    def hasContent_(self):
        if (
            self.error is not None or
            self.pickup
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchPickupByIdRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SearchPickupByIdRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SearchPickupByIdRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SearchPickupByIdRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SearchPickupByIdRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SearchPickupByIdRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchPickupByIdRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
        for pickup_ in self.pickup:
            namespaceprefix_ = self.pickup_nsprefix_ + ':' if (UseCapturedNS_ and self.pickup_nsprefix_) else ''
            pickup_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='pickup', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
        elif nodeName_ == 'pickup':
            obj_ = Pickup.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.pickup.append(obj_)
            obj_.original_tagname_ = 'pickup'
# end class SearchPickupByIdRs


class TrackByBarcodeV2Rq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, barcode=None, filter=None, track_shipment=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.barcode = barcode
        self.barcode_nsprefix_ = None
        self.filter = filter
        self.filter_nsprefix_ = None
        self.track_shipment = track_shipment
        self.track_shipment_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TrackByBarcodeV2Rq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TrackByBarcodeV2Rq.subclass:
            return TrackByBarcodeV2Rq.subclass(*args_, **kwargs_)
        else:
            return TrackByBarcodeV2Rq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_barcode(self):
        return self.barcode
    def set_barcode(self, barcode):
        self.barcode = barcode
    def get_filter(self):
        return self.filter
    def set_filter(self, filter):
        self.filter = filter
    def get_track_shipment(self):
        return self.track_shipment
    def set_track_shipment(self, track_shipment):
        self.track_shipment = track_shipment
    def hasContent_(self):
        if (
            self.barcode is not None or
            self.filter is not None or
            self.track_shipment is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TrackByBarcodeV2Rq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TrackByBarcodeV2Rq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TrackByBarcodeV2Rq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TrackByBarcodeV2Rq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TrackByBarcodeV2Rq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TrackByBarcodeV2Rq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TrackByBarcodeV2Rq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.barcode is not None:
            namespaceprefix_ = self.barcode_nsprefix_ + ':' if (UseCapturedNS_ and self.barcode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbarcode>%s</%sbarcode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.barcode), input_name='barcode')), namespaceprefix_ , eol_))
        if self.filter is not None:
            namespaceprefix_ = self.filter_nsprefix_ + ':' if (UseCapturedNS_ and self.filter_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfilter>%s</%sfilter>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.filter), input_name='filter')), namespaceprefix_ , eol_))
        if self.track_shipment is not None:
            namespaceprefix_ = self.track_shipment_nsprefix_ + ':' if (UseCapturedNS_ and self.track_shipment_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%strack_shipment>%s</%strack_shipment>%s' % (namespaceprefix_ , self.gds_format_boolean(self.track_shipment, input_name='track_shipment'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'barcode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'barcode')
            value_ = self.gds_validate_string(value_, node, 'barcode')
            self.barcode = value_
            self.barcode_nsprefix_ = child_.prefix
        elif nodeName_ == 'filter':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'filter')
            value_ = self.gds_validate_string(value_, node, 'filter')
            self.filter = value_
            self.filter_nsprefix_ = child_.prefix
        elif nodeName_ == 'track_shipment':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'track_shipment')
            ival_ = self.gds_validate_boolean(ival_, node, 'track_shipment')
            self.track_shipment = ival_
            self.track_shipment_nsprefix_ = child_.prefix
# end class TrackByBarcodeV2Rq


class TrackByBarcodeV2Rs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, result=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
        if result is None:
            self.result = []
        else:
            self.result = result
        self.result_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TrackByBarcodeV2Rs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TrackByBarcodeV2Rs.subclass:
            return TrackByBarcodeV2Rs.subclass(*args_, **kwargs_)
        else:
            return TrackByBarcodeV2Rs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def get_result(self):
        return self.result
    def set_result(self, result):
        self.result = result
    def add_result(self, value):
        self.result.append(value)
    def insert_result_at(self, index, value):
        self.result.insert(index, value)
    def replace_result_at(self, index, value):
        self.result[index] = value
    def hasContent_(self):
        if (
            self.error is not None or
            self.result
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TrackByBarcodeV2Rs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TrackByBarcodeV2Rs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TrackByBarcodeV2Rs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TrackByBarcodeV2Rs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TrackByBarcodeV2Rs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TrackByBarcodeV2Rs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TrackByBarcodeV2Rs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
        for result_ in self.result:
            namespaceprefix_ = self.result_nsprefix_ + ':' if (UseCapturedNS_ and self.result_nsprefix_) else ''
            result_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='result', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
        elif nodeName_ == 'result':
            obj_ = TrackingResultV2.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.result.append(obj_)
            obj_.original_tagname_ = 'result'
# end class TrackByBarcodeV2Rs


class GetPickupDayRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, from_date=None, num_of_days=None, password=None, postal_code=None, shipper_num=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if isinstance(from_date, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(from_date, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = from_date
        self.from_date = initvalue_
        self.from_date_nsprefix_ = None
        self.num_of_days = num_of_days
        self.num_of_days_nsprefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        self.postal_code = postal_code
        self.postal_code_nsprefix_ = None
        self.shipper_num = shipper_num
        self.shipper_num_nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetPickupDayRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetPickupDayRq.subclass:
            return GetPickupDayRq.subclass(*args_, **kwargs_)
        else:
            return GetPickupDayRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_from_date(self):
        return self.from_date
    def set_from_date(self, from_date):
        self.from_date = from_date
    def get_num_of_days(self):
        return self.num_of_days
    def set_num_of_days(self, num_of_days):
        self.num_of_days = num_of_days
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_postal_code(self):
        return self.postal_code
    def set_postal_code(self, postal_code):
        self.postal_code = postal_code
    def get_shipper_num(self):
        return self.shipper_num
    def set_shipper_num(self, shipper_num):
        self.shipper_num = shipper_num
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.from_date is not None or
            self.num_of_days is not None or
            self.password is not None or
            self.postal_code is not None or
            self.shipper_num is not None or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetPickupDayRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GetPickupDayRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GetPickupDayRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GetPickupDayRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GetPickupDayRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GetPickupDayRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetPickupDayRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.from_date is not None:
            namespaceprefix_ = self.from_date_nsprefix_ + ':' if (UseCapturedNS_ and self.from_date_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfrom_date>%s</%sfrom_date>%s' % (namespaceprefix_ , self.gds_format_datetime(self.from_date, input_name='from_date'), namespaceprefix_ , eol_))
        if self.num_of_days is not None:
            namespaceprefix_ = self.num_of_days_nsprefix_ + ':' if (UseCapturedNS_ and self.num_of_days_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snum_of_days>%s</%snum_of_days>%s' % (namespaceprefix_ , self.gds_format_integer(self.num_of_days, input_name='num_of_days'), namespaceprefix_ , eol_))
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        if self.postal_code is not None:
            namespaceprefix_ = self.postal_code_nsprefix_ + ':' if (UseCapturedNS_ and self.postal_code_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spostal_code>%s</%spostal_code>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.postal_code), input_name='postal_code')), namespaceprefix_ , eol_))
        if self.shipper_num is not None:
            namespaceprefix_ = self.shipper_num_nsprefix_ + ':' if (UseCapturedNS_ and self.shipper_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sshipper_num>%s</%sshipper_num>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.shipper_num), input_name='shipper_num')), namespaceprefix_ , eol_))
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'from_date':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.from_date = dval_
            self.from_date_nsprefix_ = child_.prefix
        elif nodeName_ == 'num_of_days' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'num_of_days')
            ival_ = self.gds_validate_integer(ival_, node, 'num_of_days')
            self.num_of_days = ival_
            self.num_of_days_nsprefix_ = child_.prefix
        elif nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'postal_code':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'postal_code')
            value_ = self.gds_validate_string(value_, node, 'postal_code')
            self.postal_code = value_
            self.postal_code_nsprefix_ = child_.prefix
        elif nodeName_ == 'shipper_num':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'shipper_num')
            value_ = self.gds_validate_string(value_, node, 'shipper_num')
            self.shipper_num = value_
            self.shipper_num_nsprefix_ = child_.prefix
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class GetPickupDayRq


class GetPickupDayRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, day=None, error=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if day is None:
            self.day = []
        else:
            self.day = day
        self.day_nsprefix_ = None
        self.error = error
        self.error_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetPickupDayRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetPickupDayRs.subclass:
            return GetPickupDayRs.subclass(*args_, **kwargs_)
        else:
            return GetPickupDayRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_day(self):
        return self.day
    def set_day(self, day):
        self.day = day
    def add_day(self, value):
        self.day.append(value)
    def insert_day_at(self, index, value):
        self.day.insert(index, value)
    def replace_day_at(self, index, value):
        self.day[index] = value
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def hasContent_(self):
        if (
            self.day or
            self.error is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetPickupDayRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GetPickupDayRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GetPickupDayRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GetPickupDayRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GetPickupDayRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GetPickupDayRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetPickupDayRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for day_ in self.day:
            namespaceprefix_ = self.day_nsprefix_ + ':' if (UseCapturedNS_ and self.day_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sday>%s</%sday>%s' % (namespaceprefix_ , self.gds_format_datetime(day_, input_name='day'), namespaceprefix_ , eol_))
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'day':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.day.append(dval_)
            self.day_nsprefix_ = child_.prefix
        elif nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
# end class GetPickupDayRs


class CancelPickupRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, id=None, password=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = id
        self.id_nsprefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CancelPickupRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CancelPickupRq.subclass:
            return CancelPickupRq.subclass(*args_, **kwargs_)
        else:
            return CancelPickupRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.id is not None or
            self.password is not None or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CancelPickupRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CancelPickupRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CancelPickupRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CancelPickupRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CancelPickupRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CancelPickupRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CancelPickupRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.id is not None:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sid>%s</%sid>%s' % (namespaceprefix_ , self.gds_format_integer(self.id, input_name='id'), namespaceprefix_ , eol_))
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'id' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'id')
            ival_ = self.gds_validate_integer(ival_, node, 'id')
            self.id = ival_
            self.id_nsprefix_ = child_.prefix
        elif nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class CancelPickupRq


class CancelPickupRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CancelPickupRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CancelPickupRs.subclass:
            return CancelPickupRs.subclass(*args_, **kwargs_)
        else:
            return CancelPickupRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def hasContent_(self):
        if (
            self.error is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CancelPickupRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CancelPickupRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CancelPickupRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CancelPickupRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CancelPickupRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CancelPickupRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CancelPickupRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
# end class CancelPickupRs


class TrackByDateLiteRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, date=None, page_num=None, shipper_num=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.date = date
        self.date_nsprefix_ = None
        self.page_num = page_num
        self.page_num_nsprefix_ = None
        self.shipper_num = shipper_num
        self.shipper_num_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TrackByDateLiteRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TrackByDateLiteRq.subclass:
            return TrackByDateLiteRq.subclass(*args_, **kwargs_)
        else:
            return TrackByDateLiteRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_date(self):
        return self.date
    def set_date(self, date):
        self.date = date
    def get_page_num(self):
        return self.page_num
    def set_page_num(self, page_num):
        self.page_num = page_num
    def get_shipper_num(self):
        return self.shipper_num
    def set_shipper_num(self, shipper_num):
        self.shipper_num = shipper_num
    def hasContent_(self):
        if (
            self.date is not None or
            self.page_num is not None or
            self.shipper_num is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TrackByDateLiteRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TrackByDateLiteRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TrackByDateLiteRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TrackByDateLiteRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TrackByDateLiteRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TrackByDateLiteRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TrackByDateLiteRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.date is not None:
            namespaceprefix_ = self.date_nsprefix_ + ':' if (UseCapturedNS_ and self.date_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdate>%s</%sdate>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.date), input_name='date')), namespaceprefix_ , eol_))
        if self.page_num is not None:
            namespaceprefix_ = self.page_num_nsprefix_ + ':' if (UseCapturedNS_ and self.page_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spage_num>%s</%spage_num>%s' % (namespaceprefix_ , self.gds_format_integer(self.page_num, input_name='page_num'), namespaceprefix_ , eol_))
        if self.shipper_num is not None:
            namespaceprefix_ = self.shipper_num_nsprefix_ + ':' if (UseCapturedNS_ and self.shipper_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sshipper_num>%s</%sshipper_num>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.shipper_num), input_name='shipper_num')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'date':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'date')
            value_ = self.gds_validate_string(value_, node, 'date')
            self.date = value_
            self.date_nsprefix_ = child_.prefix
        elif nodeName_ == 'page_num' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'page_num')
            ival_ = self.gds_validate_integer(ival_, node, 'page_num')
            self.page_num = ival_
            self.page_num_nsprefix_ = child_.prefix
        elif nodeName_ == 'shipper_num':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'shipper_num')
            value_ = self.gds_validate_string(value_, node, 'shipper_num')
            self.shipper_num = value_
            self.shipper_num_nsprefix_ = child_.prefix
# end class TrackByDateLiteRq


class TrackByDateLiteRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, result=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
        if result is None:
            self.result = []
        else:
            self.result = result
        self.result_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TrackByDateLiteRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TrackByDateLiteRs.subclass:
            return TrackByDateLiteRs.subclass(*args_, **kwargs_)
        else:
            return TrackByDateLiteRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def get_result(self):
        return self.result
    def set_result(self, result):
        self.result = result
    def add_result(self, value):
        self.result.append(value)
    def insert_result_at(self, index, value):
        self.result.insert(index, value)
    def replace_result_at(self, index, value):
        self.result[index] = value
    def hasContent_(self):
        if (
            self.error is not None or
            self.result
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TrackByDateLiteRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TrackByDateLiteRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TrackByDateLiteRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TrackByDateLiteRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TrackByDateLiteRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TrackByDateLiteRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TrackByDateLiteRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
        for result_ in self.result:
            namespaceprefix_ = self.result_nsprefix_ + ':' if (UseCapturedNS_ and self.result_nsprefix_) else ''
            result_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='result', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
        elif nodeName_ == 'result':
            obj_ = TrackingResultLite.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.result.append(obj_)
            obj_.original_tagname_ = 'result'
# end class TrackByDateLiteRs


class SchedulePickupV2Rq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, password=None, pickup=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        self.pickup = pickup
        self.pickup_nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SchedulePickupV2Rq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SchedulePickupV2Rq.subclass:
            return SchedulePickupV2Rq.subclass(*args_, **kwargs_)
        else:
            return SchedulePickupV2Rq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_pickup(self):
        return self.pickup
    def set_pickup(self, pickup):
        self.pickup = pickup
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.password is not None or
            self.pickup is not None or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SchedulePickupV2Rq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SchedulePickupV2Rq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SchedulePickupV2Rq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SchedulePickupV2Rq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SchedulePickupV2Rq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SchedulePickupV2Rq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SchedulePickupV2Rq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        if self.pickup is not None:
            namespaceprefix_ = self.pickup_nsprefix_ + ':' if (UseCapturedNS_ and self.pickup_nsprefix_) else ''
            self.pickup.export(outfile, level, namespaceprefix_, namespacedef_='', name_='pickup', pretty_print=pretty_print)
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'pickup':
            obj_ = PickupV2.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.pickup = obj_
            obj_.original_tagname_ = 'pickup'
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class SchedulePickupV2Rq


class SchedulePickupV2Rs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, pickup=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
        self.pickup = pickup
        self.pickup_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SchedulePickupV2Rs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SchedulePickupV2Rs.subclass:
            return SchedulePickupV2Rs.subclass(*args_, **kwargs_)
        else:
            return SchedulePickupV2Rs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def get_pickup(self):
        return self.pickup
    def set_pickup(self, pickup):
        self.pickup = pickup
    def hasContent_(self):
        if (
            self.error is not None or
            self.pickup is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SchedulePickupV2Rs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SchedulePickupV2Rs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SchedulePickupV2Rs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SchedulePickupV2Rs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SchedulePickupV2Rs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SchedulePickupV2Rs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SchedulePickupV2Rs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
        if self.pickup is not None:
            namespaceprefix_ = self.pickup_nsprefix_ + ':' if (UseCapturedNS_ and self.pickup_nsprefix_) else ''
            self.pickup.export(outfile, level, namespaceprefix_, namespacedef_='', name_='pickup', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
        elif nodeName_ == 'pickup':
            obj_ = PickupV2.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.pickup = obj_
            obj_.original_tagname_ = 'pickup'
# end class SchedulePickupV2Rs


class SchedulePickupRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, password=None, pickup=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        self.pickup = pickup
        self.pickup_nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SchedulePickupRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SchedulePickupRq.subclass:
            return SchedulePickupRq.subclass(*args_, **kwargs_)
        else:
            return SchedulePickupRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_pickup(self):
        return self.pickup
    def set_pickup(self, pickup):
        self.pickup = pickup
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.password is not None or
            self.pickup is not None or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SchedulePickupRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SchedulePickupRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SchedulePickupRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SchedulePickupRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SchedulePickupRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SchedulePickupRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SchedulePickupRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        if self.pickup is not None:
            namespaceprefix_ = self.pickup_nsprefix_ + ':' if (UseCapturedNS_ and self.pickup_nsprefix_) else ''
            self.pickup.export(outfile, level, namespaceprefix_, namespacedef_='', name_='pickup', pretty_print=pretty_print)
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'pickup':
            obj_ = Pickup.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.pickup = obj_
            obj_.original_tagname_ = 'pickup'
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class SchedulePickupRq


class SchedulePickupRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, pickup=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
        self.pickup = pickup
        self.pickup_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SchedulePickupRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SchedulePickupRs.subclass:
            return SchedulePickupRs.subclass(*args_, **kwargs_)
        else:
            return SchedulePickupRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def get_pickup(self):
        return self.pickup
    def set_pickup(self, pickup):
        self.pickup = pickup
    def hasContent_(self):
        if (
            self.error is not None or
            self.pickup is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SchedulePickupRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SchedulePickupRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SchedulePickupRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SchedulePickupRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SchedulePickupRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SchedulePickupRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SchedulePickupRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
        if self.pickup is not None:
            namespaceprefix_ = self.pickup_nsprefix_ + ':' if (UseCapturedNS_ and self.pickup_nsprefix_) else ''
            self.pickup.export(outfile, level, namespaceprefix_, namespacedef_='', name_='pickup', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
        elif nodeName_ == 'pickup':
            obj_ = Pickup.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.pickup = obj_
            obj_.original_tagname_ = 'pickup'
# end class SchedulePickupRs


class TrackByDateRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, date=None, page_num=None, shipper_num=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.date = date
        self.date_nsprefix_ = None
        self.page_num = page_num
        self.page_num_nsprefix_ = None
        self.shipper_num = shipper_num
        self.shipper_num_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TrackByDateRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TrackByDateRq.subclass:
            return TrackByDateRq.subclass(*args_, **kwargs_)
        else:
            return TrackByDateRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_date(self):
        return self.date
    def set_date(self, date):
        self.date = date
    def get_page_num(self):
        return self.page_num
    def set_page_num(self, page_num):
        self.page_num = page_num
    def get_shipper_num(self):
        return self.shipper_num
    def set_shipper_num(self, shipper_num):
        self.shipper_num = shipper_num
    def hasContent_(self):
        if (
            self.date is not None or
            self.page_num is not None or
            self.shipper_num is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TrackByDateRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TrackByDateRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TrackByDateRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TrackByDateRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TrackByDateRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TrackByDateRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TrackByDateRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.date is not None:
            namespaceprefix_ = self.date_nsprefix_ + ':' if (UseCapturedNS_ and self.date_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdate>%s</%sdate>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.date), input_name='date')), namespaceprefix_ , eol_))
        if self.page_num is not None:
            namespaceprefix_ = self.page_num_nsprefix_ + ':' if (UseCapturedNS_ and self.page_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spage_num>%s</%spage_num>%s' % (namespaceprefix_ , self.gds_format_integer(self.page_num, input_name='page_num'), namespaceprefix_ , eol_))
        if self.shipper_num is not None:
            namespaceprefix_ = self.shipper_num_nsprefix_ + ':' if (UseCapturedNS_ and self.shipper_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sshipper_num>%s</%sshipper_num>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.shipper_num), input_name='shipper_num')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'date':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'date')
            value_ = self.gds_validate_string(value_, node, 'date')
            self.date = value_
            self.date_nsprefix_ = child_.prefix
        elif nodeName_ == 'page_num' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'page_num')
            ival_ = self.gds_validate_integer(ival_, node, 'page_num')
            self.page_num = ival_
            self.page_num_nsprefix_ = child_.prefix
        elif nodeName_ == 'shipper_num':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'shipper_num')
            value_ = self.gds_validate_string(value_, node, 'shipper_num')
            self.shipper_num = value_
            self.shipper_num_nsprefix_ = child_.prefix
# end class TrackByDateRq


class TrackByDateRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, result=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
        if result is None:
            self.result = []
        else:
            self.result = result
        self.result_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TrackByDateRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TrackByDateRs.subclass:
            return TrackByDateRs.subclass(*args_, **kwargs_)
        else:
            return TrackByDateRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def get_result(self):
        return self.result
    def set_result(self, result):
        self.result = result
    def add_result(self, value):
        self.result.append(value)
    def insert_result_at(self, index, value):
        self.result.insert(index, value)
    def replace_result_at(self, index, value):
        self.result[index] = value
    def hasContent_(self):
        if (
            self.error is not None or
            self.result
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TrackByDateRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TrackByDateRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TrackByDateRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TrackByDateRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TrackByDateRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TrackByDateRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TrackByDateRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
        for result_ in self.result:
            namespaceprefix_ = self.result_nsprefix_ + ':' if (UseCapturedNS_ and self.result_nsprefix_) else ''
            result_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='result', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
        elif nodeName_ == 'result':
            obj_ = TrackingResult.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.result.append(obj_)
            obj_.original_tagname_ = 'result'
# end class TrackByDateRs


class GetCutoffTimeRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, postal_code=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.postal_code = postal_code
        self.postal_code_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetCutoffTimeRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetCutoffTimeRq.subclass:
            return GetCutoffTimeRq.subclass(*args_, **kwargs_)
        else:
            return GetCutoffTimeRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_postal_code(self):
        return self.postal_code
    def set_postal_code(self, postal_code):
        self.postal_code = postal_code
    def hasContent_(self):
        if (
            self.postal_code is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetCutoffTimeRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GetCutoffTimeRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GetCutoffTimeRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GetCutoffTimeRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GetCutoffTimeRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GetCutoffTimeRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetCutoffTimeRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.postal_code is not None:
            namespaceprefix_ = self.postal_code_nsprefix_ + ':' if (UseCapturedNS_ and self.postal_code_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spostal_code>%s</%spostal_code>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.postal_code), input_name='postal_code')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'postal_code':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'postal_code')
            value_ = self.gds_validate_string(value_, node, 'postal_code')
            self.postal_code = value_
            self.postal_code_nsprefix_ = child_.prefix
# end class GetCutoffTimeRq


class GetCutoffTimeRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, cutoff_time=None, error=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.cutoff_time = cutoff_time
        self.cutoff_time_nsprefix_ = None
        self.error = error
        self.error_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetCutoffTimeRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetCutoffTimeRs.subclass:
            return GetCutoffTimeRs.subclass(*args_, **kwargs_)
        else:
            return GetCutoffTimeRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_cutoff_time(self):
        return self.cutoff_time
    def set_cutoff_time(self, cutoff_time):
        self.cutoff_time = cutoff_time
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def hasContent_(self):
        if (
            self.cutoff_time is not None or
            self.error is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetCutoffTimeRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GetCutoffTimeRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GetCutoffTimeRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GetCutoffTimeRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GetCutoffTimeRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GetCutoffTimeRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetCutoffTimeRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.cutoff_time is not None:
            namespaceprefix_ = self.cutoff_time_nsprefix_ + ':' if (UseCapturedNS_ and self.cutoff_time_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scutoff_time>%s</%scutoff_time>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cutoff_time), input_name='cutoff_time')), namespaceprefix_ , eol_))
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'cutoff_time':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cutoff_time')
            value_ = self.gds_validate_string(value_, node, 'cutoff_time')
            self.cutoff_time = value_
            self.cutoff_time_nsprefix_ = child_.prefix
        elif nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
# end class GetCutoffTimeRs


class TrackByBarcodeRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, barcode=None, filter=None, track_shipment=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.barcode = barcode
        self.barcode_nsprefix_ = None
        self.filter = filter
        self.filter_nsprefix_ = None
        self.track_shipment = track_shipment
        self.track_shipment_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TrackByBarcodeRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TrackByBarcodeRq.subclass:
            return TrackByBarcodeRq.subclass(*args_, **kwargs_)
        else:
            return TrackByBarcodeRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_barcode(self):
        return self.barcode
    def set_barcode(self, barcode):
        self.barcode = barcode
    def get_filter(self):
        return self.filter
    def set_filter(self, filter):
        self.filter = filter
    def get_track_shipment(self):
        return self.track_shipment
    def set_track_shipment(self, track_shipment):
        self.track_shipment = track_shipment
    def hasContent_(self):
        if (
            self.barcode is not None or
            self.filter is not None or
            self.track_shipment is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TrackByBarcodeRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TrackByBarcodeRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TrackByBarcodeRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TrackByBarcodeRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TrackByBarcodeRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TrackByBarcodeRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TrackByBarcodeRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.barcode is not None:
            namespaceprefix_ = self.barcode_nsprefix_ + ':' if (UseCapturedNS_ and self.barcode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbarcode>%s</%sbarcode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.barcode), input_name='barcode')), namespaceprefix_ , eol_))
        if self.filter is not None:
            namespaceprefix_ = self.filter_nsprefix_ + ':' if (UseCapturedNS_ and self.filter_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfilter>%s</%sfilter>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.filter), input_name='filter')), namespaceprefix_ , eol_))
        if self.track_shipment is not None:
            namespaceprefix_ = self.track_shipment_nsprefix_ + ':' if (UseCapturedNS_ and self.track_shipment_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%strack_shipment>%s</%strack_shipment>%s' % (namespaceprefix_ , self.gds_format_boolean(self.track_shipment, input_name='track_shipment'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'barcode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'barcode')
            value_ = self.gds_validate_string(value_, node, 'barcode')
            self.barcode = value_
            self.barcode_nsprefix_ = child_.prefix
        elif nodeName_ == 'filter':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'filter')
            value_ = self.gds_validate_string(value_, node, 'filter')
            self.filter = value_
            self.filter_nsprefix_ = child_.prefix
        elif nodeName_ == 'track_shipment':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'track_shipment')
            ival_ = self.gds_validate_boolean(ival_, node, 'track_shipment')
            self.track_shipment = ival_
            self.track_shipment_nsprefix_ = child_.prefix
# end class TrackByBarcodeRq


class TrackByBarcodeRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, result=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
        if result is None:
            self.result = []
        else:
            self.result = result
        self.result_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TrackByBarcodeRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TrackByBarcodeRs.subclass:
            return TrackByBarcodeRs.subclass(*args_, **kwargs_)
        else:
            return TrackByBarcodeRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def get_result(self):
        return self.result
    def set_result(self, result):
        self.result = result
    def add_result(self, value):
        self.result.append(value)
    def insert_result_at(self, index, value):
        self.result.insert(index, value)
    def replace_result_at(self, index, value):
        self.result[index] = value
    def hasContent_(self):
        if (
            self.error is not None or
            self.result
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TrackByBarcodeRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TrackByBarcodeRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TrackByBarcodeRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TrackByBarcodeRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TrackByBarcodeRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TrackByBarcodeRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TrackByBarcodeRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
        for result_ in self.result:
            namespaceprefix_ = self.result_nsprefix_ + ':' if (UseCapturedNS_ and self.result_nsprefix_) else ''
            result_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='result', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
        elif nodeName_ == 'result':
            obj_ = TrackingResult.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.result.append(obj_)
            obj_.original_tagname_ = 'result'
# end class TrackByBarcodeRs


class GetPickupInfoRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, password=None, shipper_num=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        self.shipper_num = shipper_num
        self.shipper_num_nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetPickupInfoRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetPickupInfoRq.subclass:
            return GetPickupInfoRq.subclass(*args_, **kwargs_)
        else:
            return GetPickupInfoRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_shipper_num(self):
        return self.shipper_num
    def set_shipper_num(self, shipper_num):
        self.shipper_num = shipper_num
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.password is not None or
            self.shipper_num is not None or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetPickupInfoRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GetPickupInfoRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GetPickupInfoRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GetPickupInfoRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GetPickupInfoRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GetPickupInfoRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetPickupInfoRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        if self.shipper_num is not None:
            namespaceprefix_ = self.shipper_num_nsprefix_ + ':' if (UseCapturedNS_ and self.shipper_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sshipper_num>%s</%sshipper_num>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.shipper_num), input_name='shipper_num')), namespaceprefix_ , eol_))
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'shipper_num':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'shipper_num')
            value_ = self.gds_validate_string(value_, node, 'shipper_num')
            self.shipper_num = value_
            self.shipper_num_nsprefix_ = child_.prefix
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class GetPickupInfoRq


class GetPickupInfoRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, pickup_info=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
        self.pickup_info = pickup_info
        self.pickup_info_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetPickupInfoRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetPickupInfoRs.subclass:
            return GetPickupInfoRs.subclass(*args_, **kwargs_)
        else:
            return GetPickupInfoRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def get_pickup_info(self):
        return self.pickup_info
    def set_pickup_info(self, pickup_info):
        self.pickup_info = pickup_info
    def hasContent_(self):
        if (
            self.error is not None or
            self.pickup_info is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetPickupInfoRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GetPickupInfoRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GetPickupInfoRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GetPickupInfoRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GetPickupInfoRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GetPickupInfoRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetPickupInfoRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
        if self.pickup_info is not None:
            namespaceprefix_ = self.pickup_info_nsprefix_ + ':' if (UseCapturedNS_ and self.pickup_info_nsprefix_) else ''
            self.pickup_info.export(outfile, level, namespaceprefix_, namespacedef_='', name_='pickup_info', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
        elif nodeName_ == 'pickup_info':
            obj_ = PickupInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.pickup_info = obj_
            obj_.original_tagname_ = 'pickup_info'
# end class GetPickupInfoRs


class GetReturnTagRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, password=None, return_tags=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        if return_tags is None:
            self.return_tags = []
        else:
            self.return_tags = return_tags
        self.return_tags_nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetReturnTagRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetReturnTagRq.subclass:
            return GetReturnTagRq.subclass(*args_, **kwargs_)
        else:
            return GetReturnTagRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_return_tags(self):
        return self.return_tags
    def set_return_tags(self, return_tags):
        self.return_tags = return_tags
    def add_return_tags(self, value):
        self.return_tags.append(value)
    def insert_return_tags_at(self, index, value):
        self.return_tags.insert(index, value)
    def replace_return_tags_at(self, index, value):
        self.return_tags[index] = value
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.password is not None or
            self.return_tags or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetReturnTagRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GetReturnTagRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GetReturnTagRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GetReturnTagRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GetReturnTagRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GetReturnTagRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetReturnTagRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        for return_tags_ in self.return_tags:
            namespaceprefix_ = self.return_tags_nsprefix_ + ':' if (UseCapturedNS_ and self.return_tags_nsprefix_) else ''
            return_tags_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return_tags', pretty_print=pretty_print)
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'return_tags':
            obj_ = ReturnTag.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_tags.append(obj_)
            obj_.original_tagname_ = 'return_tags'
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class GetReturnTagRq


class GetReturnTagRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, result=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
        if result is None:
            self.result = []
        else:
            self.result = result
        self.result_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetReturnTagRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetReturnTagRs.subclass:
            return GetReturnTagRs.subclass(*args_, **kwargs_)
        else:
            return GetReturnTagRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def get_result(self):
        return self.result
    def set_result(self, result):
        self.result = result
    def add_result(self, value):
        self.result.append(value)
    def insert_result_at(self, index, value):
        self.result.insert(index, value)
    def replace_result_at(self, index, value):
        self.result[index] = value
    def hasContent_(self):
        if (
            self.error is not None or
            self.result
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetReturnTagRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GetReturnTagRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GetReturnTagRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GetReturnTagRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GetReturnTagRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GetReturnTagRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetReturnTagRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
        for result_ in self.result:
            namespaceprefix_ = self.result_nsprefix_ + ':' if (UseCapturedNS_ and self.result_nsprefix_) else ''
            result_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='result', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
        elif nodeName_ == 'result':
            obj_ = ReturnTag.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.result.append(obj_)
            obj_.original_tagname_ = 'result'
# end class GetReturnTagRs


class VoidPickUpTagRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, id=None, password=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = id
        self.id_nsprefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, VoidPickUpTagRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if VoidPickUpTagRq.subclass:
            return VoidPickUpTagRq.subclass(*args_, **kwargs_)
        else:
            return VoidPickUpTagRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.id is not None or
            self.password is not None or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='VoidPickUpTagRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('VoidPickUpTagRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'VoidPickUpTagRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='VoidPickUpTagRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='VoidPickUpTagRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='VoidPickUpTagRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='VoidPickUpTagRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.id is not None:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sid>%s</%sid>%s' % (namespaceprefix_ , self.gds_format_integer(self.id, input_name='id'), namespaceprefix_ , eol_))
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'id' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'id')
            ival_ = self.gds_validate_integer(ival_, node, 'id')
            self.id = ival_
            self.id_nsprefix_ = child_.prefix
        elif nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class VoidPickUpTagRq


class VoidPickUpTagRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, VoidPickUpTagRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if VoidPickUpTagRs.subclass:
            return VoidPickUpTagRs.subclass(*args_, **kwargs_)
        else:
            return VoidPickUpTagRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def hasContent_(self):
        if (
            self.error is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='VoidPickUpTagRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('VoidPickUpTagRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'VoidPickUpTagRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='VoidPickUpTagRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='VoidPickUpTagRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='VoidPickUpTagRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='VoidPickUpTagRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
# end class VoidPickUpTagRs


class ImportEventsRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, token=None, transmission=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.token = token
        self.token_nsprefix_ = None
        self.transmission = transmission
        self.transmission_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ImportEventsRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ImportEventsRq.subclass:
            return ImportEventsRq.subclass(*args_, **kwargs_)
        else:
            return ImportEventsRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_token(self):
        return self.token
    def set_token(self, token):
        self.token = token
    def get_transmission(self):
        return self.transmission
    def set_transmission(self, transmission):
        self.transmission = transmission
    def hasContent_(self):
        if (
            self.token is not None or
            self.transmission is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ImportEventsRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ImportEventsRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ImportEventsRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ImportEventsRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ImportEventsRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ImportEventsRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ImportEventsRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.token is not None:
            namespaceprefix_ = self.token_nsprefix_ + ':' if (UseCapturedNS_ and self.token_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stoken>%s</%stoken>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.token), input_name='token')), namespaceprefix_ , eol_))
        if self.transmission is not None:
            namespaceprefix_ = self.transmission_nsprefix_ + ':' if (UseCapturedNS_ and self.transmission_nsprefix_) else ''
            self.transmission.export(outfile, level, namespaceprefix_, namespacedef_='', name_='transmission', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'token':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'token')
            value_ = self.gds_validate_string(value_, node, 'token')
            self.token = value_
            self.token_nsprefix_ = child_.prefix
        elif nodeName_ == 'transmission':
            obj_ = Transmission.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.transmission = obj_
            obj_.original_tagname_ = 'transmission'
# end class ImportEventsRq


class ImportEventsRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ImportEventsRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ImportEventsRs.subclass:
            return ImportEventsRs.subclass(*args_, **kwargs_)
        else:
            return ImportEventsRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def hasContent_(self):
        if (
            self.error is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ImportEventsRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ImportEventsRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ImportEventsRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ImportEventsRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ImportEventsRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ImportEventsRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ImportEventsRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
# end class ImportEventsRs


class ProcessPickUpTagRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, password=None, pickup_tag=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        self.pickup_tag = pickup_tag
        self.pickup_tag_nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ProcessPickUpTagRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ProcessPickUpTagRq.subclass:
            return ProcessPickUpTagRq.subclass(*args_, **kwargs_)
        else:
            return ProcessPickUpTagRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_pickup_tag(self):
        return self.pickup_tag
    def set_pickup_tag(self, pickup_tag):
        self.pickup_tag = pickup_tag
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.password is not None or
            self.pickup_tag is not None or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ProcessPickUpTagRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ProcessPickUpTagRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ProcessPickUpTagRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ProcessPickUpTagRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ProcessPickUpTagRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ProcessPickUpTagRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ProcessPickUpTagRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        if self.pickup_tag is not None:
            namespaceprefix_ = self.pickup_tag_nsprefix_ + ':' if (UseCapturedNS_ and self.pickup_tag_nsprefix_) else ''
            self.pickup_tag.export(outfile, level, namespaceprefix_, namespacedef_='', name_='pickup_tag', pretty_print=pretty_print)
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'pickup_tag':
            obj_ = Shipment.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.pickup_tag = obj_
            obj_.original_tagname_ = 'pickup_tag'
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class ProcessPickUpTagRq


class ProcessPickUpTagRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, processShipmentResult=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
        self.processShipmentResult = processShipmentResult
        self.processShipmentResult_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ProcessPickUpTagRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ProcessPickUpTagRs.subclass:
            return ProcessPickUpTagRs.subclass(*args_, **kwargs_)
        else:
            return ProcessPickUpTagRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def get_processShipmentResult(self):
        return self.processShipmentResult
    def set_processShipmentResult(self, processShipmentResult):
        self.processShipmentResult = processShipmentResult
    def hasContent_(self):
        if (
            self.error is not None or
            self.processShipmentResult is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ProcessPickUpTagRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ProcessPickUpTagRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ProcessPickUpTagRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ProcessPickUpTagRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ProcessPickUpTagRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ProcessPickUpTagRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ProcessPickUpTagRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
        if self.processShipmentResult is not None:
            namespaceprefix_ = self.processShipmentResult_nsprefix_ + ':' if (UseCapturedNS_ and self.processShipmentResult_nsprefix_) else ''
            self.processShipmentResult.export(outfile, level, namespaceprefix_, namespacedef_='', name_='processShipmentResult', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
        elif nodeName_ == 'processShipmentResult':
            obj_ = ProcessShipmentResult.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.processShipmentResult = obj_
            obj_.original_tagname_ = 'processShipmentResult'
# end class ProcessPickUpTagRs


class SearchPickupByPickupDateRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, from_pickup_date=None, password=None, shipper_num=None, to_pickup_date=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if isinstance(from_pickup_date, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(from_pickup_date, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = from_pickup_date
        self.from_pickup_date = initvalue_
        self.from_pickup_date_nsprefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        if shipper_num is None:
            self.shipper_num = []
        else:
            self.shipper_num = shipper_num
        self.shipper_num_nsprefix_ = None
        if isinstance(to_pickup_date, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(to_pickup_date, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = to_pickup_date
        self.to_pickup_date = initvalue_
        self.to_pickup_date_nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SearchPickupByPickupDateRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SearchPickupByPickupDateRq.subclass:
            return SearchPickupByPickupDateRq.subclass(*args_, **kwargs_)
        else:
            return SearchPickupByPickupDateRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_from_pickup_date(self):
        return self.from_pickup_date
    def set_from_pickup_date(self, from_pickup_date):
        self.from_pickup_date = from_pickup_date
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_shipper_num(self):
        return self.shipper_num
    def set_shipper_num(self, shipper_num):
        self.shipper_num = shipper_num
    def add_shipper_num(self, value):
        self.shipper_num.append(value)
    def insert_shipper_num_at(self, index, value):
        self.shipper_num.insert(index, value)
    def replace_shipper_num_at(self, index, value):
        self.shipper_num[index] = value
    def get_to_pickup_date(self):
        return self.to_pickup_date
    def set_to_pickup_date(self, to_pickup_date):
        self.to_pickup_date = to_pickup_date
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.from_pickup_date is not None or
            self.password is not None or
            self.shipper_num or
            self.to_pickup_date is not None or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchPickupByPickupDateRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SearchPickupByPickupDateRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SearchPickupByPickupDateRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SearchPickupByPickupDateRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SearchPickupByPickupDateRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SearchPickupByPickupDateRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchPickupByPickupDateRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.from_pickup_date is not None:
            namespaceprefix_ = self.from_pickup_date_nsprefix_ + ':' if (UseCapturedNS_ and self.from_pickup_date_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfrom_pickup_date>%s</%sfrom_pickup_date>%s' % (namespaceprefix_ , self.gds_format_datetime(self.from_pickup_date, input_name='from_pickup_date'), namespaceprefix_ , eol_))
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        for shipper_num_ in self.shipper_num:
            namespaceprefix_ = self.shipper_num_nsprefix_ + ':' if (UseCapturedNS_ and self.shipper_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sshipper_num>%s</%sshipper_num>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(shipper_num_), input_name='shipper_num')), namespaceprefix_ , eol_))
        if self.to_pickup_date is not None:
            namespaceprefix_ = self.to_pickup_date_nsprefix_ + ':' if (UseCapturedNS_ and self.to_pickup_date_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sto_pickup_date>%s</%sto_pickup_date>%s' % (namespaceprefix_ , self.gds_format_datetime(self.to_pickup_date, input_name='to_pickup_date'), namespaceprefix_ , eol_))
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'from_pickup_date':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.from_pickup_date = dval_
            self.from_pickup_date_nsprefix_ = child_.prefix
        elif nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'shipper_num':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'shipper_num')
            value_ = self.gds_validate_string(value_, node, 'shipper_num')
            self.shipper_num.append(value_)
            self.shipper_num_nsprefix_ = child_.prefix
        elif nodeName_ == 'to_pickup_date':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.to_pickup_date = dval_
            self.to_pickup_date_nsprefix_ = child_.prefix
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class SearchPickupByPickupDateRq


class SearchPickupByPickupDateRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, pickup=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
        if pickup is None:
            self.pickup = []
        else:
            self.pickup = pickup
        self.pickup_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SearchPickupByPickupDateRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SearchPickupByPickupDateRs.subclass:
            return SearchPickupByPickupDateRs.subclass(*args_, **kwargs_)
        else:
            return SearchPickupByPickupDateRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def get_pickup(self):
        return self.pickup
    def set_pickup(self, pickup):
        self.pickup = pickup
    def add_pickup(self, value):
        self.pickup.append(value)
    def insert_pickup_at(self, index, value):
        self.pickup.insert(index, value)
    def replace_pickup_at(self, index, value):
        self.pickup[index] = value
    def hasContent_(self):
        if (
            self.error is not None or
            self.pickup
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchPickupByPickupDateRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SearchPickupByPickupDateRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SearchPickupByPickupDateRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SearchPickupByPickupDateRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SearchPickupByPickupDateRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SearchPickupByPickupDateRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchPickupByPickupDateRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
        for pickup_ in self.pickup:
            namespaceprefix_ = self.pickup_nsprefix_ + ':' if (UseCapturedNS_ and self.pickup_nsprefix_) else ''
            pickup_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='pickup', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
        elif nodeName_ == 'pickup':
            obj_ = Pickup.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.pickup.append(obj_)
            obj_.original_tagname_ = 'pickup'
# end class SearchPickupByPickupDateRs


class SearchPickupByPickupDateV2Rq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, from_pickup_date=None, password=None, shipper_num=None, to_pickup_date=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if isinstance(from_pickup_date, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(from_pickup_date, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = from_pickup_date
        self.from_pickup_date = initvalue_
        self.from_pickup_date_nsprefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        if shipper_num is None:
            self.shipper_num = []
        else:
            self.shipper_num = shipper_num
        self.shipper_num_nsprefix_ = None
        if isinstance(to_pickup_date, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(to_pickup_date, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = to_pickup_date
        self.to_pickup_date = initvalue_
        self.to_pickup_date_nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SearchPickupByPickupDateV2Rq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SearchPickupByPickupDateV2Rq.subclass:
            return SearchPickupByPickupDateV2Rq.subclass(*args_, **kwargs_)
        else:
            return SearchPickupByPickupDateV2Rq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_from_pickup_date(self):
        return self.from_pickup_date
    def set_from_pickup_date(self, from_pickup_date):
        self.from_pickup_date = from_pickup_date
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_shipper_num(self):
        return self.shipper_num
    def set_shipper_num(self, shipper_num):
        self.shipper_num = shipper_num
    def add_shipper_num(self, value):
        self.shipper_num.append(value)
    def insert_shipper_num_at(self, index, value):
        self.shipper_num.insert(index, value)
    def replace_shipper_num_at(self, index, value):
        self.shipper_num[index] = value
    def get_to_pickup_date(self):
        return self.to_pickup_date
    def set_to_pickup_date(self, to_pickup_date):
        self.to_pickup_date = to_pickup_date
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.from_pickup_date is not None or
            self.password is not None or
            self.shipper_num or
            self.to_pickup_date is not None or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchPickupByPickupDateV2Rq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SearchPickupByPickupDateV2Rq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SearchPickupByPickupDateV2Rq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SearchPickupByPickupDateV2Rq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SearchPickupByPickupDateV2Rq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SearchPickupByPickupDateV2Rq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchPickupByPickupDateV2Rq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.from_pickup_date is not None:
            namespaceprefix_ = self.from_pickup_date_nsprefix_ + ':' if (UseCapturedNS_ and self.from_pickup_date_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfrom_pickup_date>%s</%sfrom_pickup_date>%s' % (namespaceprefix_ , self.gds_format_datetime(self.from_pickup_date, input_name='from_pickup_date'), namespaceprefix_ , eol_))
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        for shipper_num_ in self.shipper_num:
            namespaceprefix_ = self.shipper_num_nsprefix_ + ':' if (UseCapturedNS_ and self.shipper_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sshipper_num>%s</%sshipper_num>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(shipper_num_), input_name='shipper_num')), namespaceprefix_ , eol_))
        if self.to_pickup_date is not None:
            namespaceprefix_ = self.to_pickup_date_nsprefix_ + ':' if (UseCapturedNS_ and self.to_pickup_date_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sto_pickup_date>%s</%sto_pickup_date>%s' % (namespaceprefix_ , self.gds_format_datetime(self.to_pickup_date, input_name='to_pickup_date'), namespaceprefix_ , eol_))
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'from_pickup_date':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.from_pickup_date = dval_
            self.from_pickup_date_nsprefix_ = child_.prefix
        elif nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'shipper_num':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'shipper_num')
            value_ = self.gds_validate_string(value_, node, 'shipper_num')
            self.shipper_num.append(value_)
            self.shipper_num_nsprefix_ = child_.prefix
        elif nodeName_ == 'to_pickup_date':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.to_pickup_date = dval_
            self.to_pickup_date_nsprefix_ = child_.prefix
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class SearchPickupByPickupDateV2Rq


class SearchPickupByPickupDateV2Rs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, pickup=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
        if pickup is None:
            self.pickup = []
        else:
            self.pickup = pickup
        self.pickup_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SearchPickupByPickupDateV2Rs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SearchPickupByPickupDateV2Rs.subclass:
            return SearchPickupByPickupDateV2Rs.subclass(*args_, **kwargs_)
        else:
            return SearchPickupByPickupDateV2Rs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def get_pickup(self):
        return self.pickup
    def set_pickup(self, pickup):
        self.pickup = pickup
    def add_pickup(self, value):
        self.pickup.append(value)
    def insert_pickup_at(self, index, value):
        self.pickup.insert(index, value)
    def replace_pickup_at(self, index, value):
        self.pickup[index] = value
    def hasContent_(self):
        if (
            self.error is not None or
            self.pickup
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchPickupByPickupDateV2Rs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SearchPickupByPickupDateV2Rs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SearchPickupByPickupDateV2Rs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SearchPickupByPickupDateV2Rs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SearchPickupByPickupDateV2Rs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SearchPickupByPickupDateV2Rs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchPickupByPickupDateV2Rs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
        for pickup_ in self.pickup:
            namespaceprefix_ = self.pickup_nsprefix_ + ':' if (UseCapturedNS_ and self.pickup_nsprefix_) else ''
            pickup_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='pickup', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
        elif nodeName_ == 'pickup':
            obj_ = PickupV2.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.pickup.append(obj_)
            obj_.original_tagname_ = 'pickup'
# end class SearchPickupByPickupDateV2Rs


class ExportAddressBookFromCanshipWebRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, password=None, shipper_num=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        self.shipper_num = shipper_num
        self.shipper_num_nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ExportAddressBookFromCanshipWebRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ExportAddressBookFromCanshipWebRq.subclass:
            return ExportAddressBookFromCanshipWebRq.subclass(*args_, **kwargs_)
        else:
            return ExportAddressBookFromCanshipWebRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_shipper_num(self):
        return self.shipper_num
    def set_shipper_num(self, shipper_num):
        self.shipper_num = shipper_num
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.password is not None or
            self.shipper_num is not None or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ExportAddressBookFromCanshipWebRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ExportAddressBookFromCanshipWebRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ExportAddressBookFromCanshipWebRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ExportAddressBookFromCanshipWebRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ExportAddressBookFromCanshipWebRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ExportAddressBookFromCanshipWebRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ExportAddressBookFromCanshipWebRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        if self.shipper_num is not None:
            namespaceprefix_ = self.shipper_num_nsprefix_ + ':' if (UseCapturedNS_ and self.shipper_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sshipper_num>%s</%sshipper_num>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.shipper_num), input_name='shipper_num')), namespaceprefix_ , eol_))
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'shipper_num':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'shipper_num')
            value_ = self.gds_validate_string(value_, node, 'shipper_num')
            self.shipper_num = value_
            self.shipper_num_nsprefix_ = child_.prefix
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class ExportAddressBookFromCanshipWebRq


class ExportAddressBookFromCanshipWebRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, file=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
        self.file = file
        self.file_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ExportAddressBookFromCanshipWebRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ExportAddressBookFromCanshipWebRs.subclass:
            return ExportAddressBookFromCanshipWebRs.subclass(*args_, **kwargs_)
        else:
            return ExportAddressBookFromCanshipWebRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def get_file(self):
        return self.file
    def set_file(self, file):
        self.file = file
    def hasContent_(self):
        if (
            self.error is not None or
            self.file is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ExportAddressBookFromCanshipWebRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ExportAddressBookFromCanshipWebRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ExportAddressBookFromCanshipWebRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ExportAddressBookFromCanshipWebRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ExportAddressBookFromCanshipWebRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ExportAddressBookFromCanshipWebRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ExportAddressBookFromCanshipWebRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
        if self.file is not None:
            namespaceprefix_ = self.file_nsprefix_ + ':' if (UseCapturedNS_ and self.file_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfile>%s</%sfile>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.file), input_name='file')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
        elif nodeName_ == 'file':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'file')
            value_ = self.gds_validate_string(value_, node, 'file')
            self.file = value_
            self.file_nsprefix_ = child_.prefix
# end class ExportAddressBookFromCanshipWebRs


class TrackByReferenceLoomisRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, days=None, filter=None, reference=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.days = days
        self.days_nsprefix_ = None
        self.filter = filter
        self.filter_nsprefix_ = None
        self.reference = reference
        self.reference_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TrackByReferenceLoomisRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TrackByReferenceLoomisRq.subclass:
            return TrackByReferenceLoomisRq.subclass(*args_, **kwargs_)
        else:
            return TrackByReferenceLoomisRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_days(self):
        return self.days
    def set_days(self, days):
        self.days = days
    def get_filter(self):
        return self.filter
    def set_filter(self, filter):
        self.filter = filter
    def get_reference(self):
        return self.reference
    def set_reference(self, reference):
        self.reference = reference
    def hasContent_(self):
        if (
            self.days is not None or
            self.filter is not None or
            self.reference is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TrackByReferenceLoomisRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TrackByReferenceLoomisRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TrackByReferenceLoomisRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TrackByReferenceLoomisRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TrackByReferenceLoomisRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TrackByReferenceLoomisRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TrackByReferenceLoomisRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.days is not None:
            namespaceprefix_ = self.days_nsprefix_ + ':' if (UseCapturedNS_ and self.days_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdays>%s</%sdays>%s' % (namespaceprefix_ , self.gds_format_integer(self.days, input_name='days'), namespaceprefix_ , eol_))
        if self.filter is not None:
            namespaceprefix_ = self.filter_nsprefix_ + ':' if (UseCapturedNS_ and self.filter_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfilter>%s</%sfilter>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.filter), input_name='filter')), namespaceprefix_ , eol_))
        if self.reference is not None:
            namespaceprefix_ = self.reference_nsprefix_ + ':' if (UseCapturedNS_ and self.reference_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sreference>%s</%sreference>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.reference), input_name='reference')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'days' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'days')
            ival_ = self.gds_validate_integer(ival_, node, 'days')
            self.days = ival_
            self.days_nsprefix_ = child_.prefix
        elif nodeName_ == 'filter':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'filter')
            value_ = self.gds_validate_string(value_, node, 'filter')
            self.filter = value_
            self.filter_nsprefix_ = child_.prefix
        elif nodeName_ == 'reference':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'reference')
            value_ = self.gds_validate_string(value_, node, 'reference')
            self.reference = value_
            self.reference_nsprefix_ = child_.prefix
# end class TrackByReferenceLoomisRq


class SearchPickUpTagByShippingDateRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, from_date=None, page_num=None, password=None, shipper_num=None, to_date=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if isinstance(from_date, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(from_date, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = from_date
        self.from_date = initvalue_
        self.from_date_nsprefix_ = None
        self.page_num = page_num
        self.page_num_nsprefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        self.shipper_num = shipper_num
        self.shipper_num_nsprefix_ = None
        if isinstance(to_date, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(to_date, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = to_date
        self.to_date = initvalue_
        self.to_date_nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SearchPickUpTagByShippingDateRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SearchPickUpTagByShippingDateRq.subclass:
            return SearchPickUpTagByShippingDateRq.subclass(*args_, **kwargs_)
        else:
            return SearchPickUpTagByShippingDateRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_from_date(self):
        return self.from_date
    def set_from_date(self, from_date):
        self.from_date = from_date
    def get_page_num(self):
        return self.page_num
    def set_page_num(self, page_num):
        self.page_num = page_num
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_shipper_num(self):
        return self.shipper_num
    def set_shipper_num(self, shipper_num):
        self.shipper_num = shipper_num
    def get_to_date(self):
        return self.to_date
    def set_to_date(self, to_date):
        self.to_date = to_date
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.from_date is not None or
            self.page_num is not None or
            self.password is not None or
            self.shipper_num is not None or
            self.to_date is not None or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchPickUpTagByShippingDateRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SearchPickUpTagByShippingDateRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SearchPickUpTagByShippingDateRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SearchPickUpTagByShippingDateRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SearchPickUpTagByShippingDateRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SearchPickUpTagByShippingDateRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchPickUpTagByShippingDateRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.from_date is not None:
            namespaceprefix_ = self.from_date_nsprefix_ + ':' if (UseCapturedNS_ and self.from_date_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfrom_date>%s</%sfrom_date>%s' % (namespaceprefix_ , self.gds_format_datetime(self.from_date, input_name='from_date'), namespaceprefix_ , eol_))
        if self.page_num is not None:
            namespaceprefix_ = self.page_num_nsprefix_ + ':' if (UseCapturedNS_ and self.page_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spage_num>%s</%spage_num>%s' % (namespaceprefix_ , self.gds_format_integer(self.page_num, input_name='page_num'), namespaceprefix_ , eol_))
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        if self.shipper_num is not None:
            namespaceprefix_ = self.shipper_num_nsprefix_ + ':' if (UseCapturedNS_ and self.shipper_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sshipper_num>%s</%sshipper_num>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.shipper_num), input_name='shipper_num')), namespaceprefix_ , eol_))
        if self.to_date is not None:
            namespaceprefix_ = self.to_date_nsprefix_ + ':' if (UseCapturedNS_ and self.to_date_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sto_date>%s</%sto_date>%s' % (namespaceprefix_ , self.gds_format_datetime(self.to_date, input_name='to_date'), namespaceprefix_ , eol_))
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'from_date':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.from_date = dval_
            self.from_date_nsprefix_ = child_.prefix
        elif nodeName_ == 'page_num' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'page_num')
            ival_ = self.gds_validate_integer(ival_, node, 'page_num')
            self.page_num = ival_
            self.page_num_nsprefix_ = child_.prefix
        elif nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'shipper_num':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'shipper_num')
            value_ = self.gds_validate_string(value_, node, 'shipper_num')
            self.shipper_num = value_
            self.shipper_num_nsprefix_ = child_.prefix
        elif nodeName_ == 'to_date':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.to_date = dval_
            self.to_date_nsprefix_ = child_.prefix
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class SearchPickUpTagByShippingDateRq


class SearchPickUpTagByShippingDateRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, pickup_tag=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
        if pickup_tag is None:
            self.pickup_tag = []
        else:
            self.pickup_tag = pickup_tag
        self.pickup_tag_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SearchPickUpTagByShippingDateRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SearchPickUpTagByShippingDateRs.subclass:
            return SearchPickUpTagByShippingDateRs.subclass(*args_, **kwargs_)
        else:
            return SearchPickUpTagByShippingDateRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def get_pickup_tag(self):
        return self.pickup_tag
    def set_pickup_tag(self, pickup_tag):
        self.pickup_tag = pickup_tag
    def add_pickup_tag(self, value):
        self.pickup_tag.append(value)
    def insert_pickup_tag_at(self, index, value):
        self.pickup_tag.insert(index, value)
    def replace_pickup_tag_at(self, index, value):
        self.pickup_tag[index] = value
    def hasContent_(self):
        if (
            self.error is not None or
            self.pickup_tag
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchPickUpTagByShippingDateRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SearchPickUpTagByShippingDateRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SearchPickUpTagByShippingDateRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SearchPickUpTagByShippingDateRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SearchPickUpTagByShippingDateRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SearchPickUpTagByShippingDateRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchPickUpTagByShippingDateRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
        for pickup_tag_ in self.pickup_tag:
            namespaceprefix_ = self.pickup_tag_nsprefix_ + ':' if (UseCapturedNS_ and self.pickup_tag_nsprefix_) else ''
            pickup_tag_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='pickup_tag', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
        elif nodeName_ == 'pickup_tag':
            obj_ = Shipment.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.pickup_tag.append(obj_)
            obj_.original_tagname_ = 'pickup_tag'
# end class SearchPickUpTagByShippingDateRs


class CheckOfflineRatesPackageRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, password=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CheckOfflineRatesPackageRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CheckOfflineRatesPackageRq.subclass:
            return CheckOfflineRatesPackageRq.subclass(*args_, **kwargs_)
        else:
            return CheckOfflineRatesPackageRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.password is not None or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CheckOfflineRatesPackageRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CheckOfflineRatesPackageRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CheckOfflineRatesPackageRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CheckOfflineRatesPackageRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CheckOfflineRatesPackageRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CheckOfflineRatesPackageRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CheckOfflineRatesPackageRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class CheckOfflineRatesPackageRq


class CheckOfflineRatesPackageRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, offline_rates_package=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
        self.offline_rates_package = offline_rates_package
        self.offline_rates_package_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CheckOfflineRatesPackageRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CheckOfflineRatesPackageRs.subclass:
            return CheckOfflineRatesPackageRs.subclass(*args_, **kwargs_)
        else:
            return CheckOfflineRatesPackageRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def get_offline_rates_package(self):
        return self.offline_rates_package
    def set_offline_rates_package(self, offline_rates_package):
        self.offline_rates_package = offline_rates_package
    def hasContent_(self):
        if (
            self.error is not None or
            self.offline_rates_package is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CheckOfflineRatesPackageRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CheckOfflineRatesPackageRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CheckOfflineRatesPackageRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CheckOfflineRatesPackageRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CheckOfflineRatesPackageRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CheckOfflineRatesPackageRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CheckOfflineRatesPackageRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
        if self.offline_rates_package is not None:
            namespaceprefix_ = self.offline_rates_package_nsprefix_ + ':' if (UseCapturedNS_ and self.offline_rates_package_nsprefix_) else ''
            self.offline_rates_package.export(outfile, level, namespaceprefix_, namespacedef_='', name_='offline_rates_package', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
        elif nodeName_ == 'offline_rates_package':
            obj_ = OfflineRatesPackage.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.offline_rates_package = obj_
            obj_.original_tagname_ = 'offline_rates_package'
# end class CheckOfflineRatesPackageRs


class InsertLiteShipmentRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, password=None, shipment=None, token=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        if shipment is None:
            self.shipment = []
        else:
            self.shipment = shipment
        self.shipment_nsprefix_ = None
        self.token = token
        self.token_nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, InsertLiteShipmentRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if InsertLiteShipmentRq.subclass:
            return InsertLiteShipmentRq.subclass(*args_, **kwargs_)
        else:
            return InsertLiteShipmentRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_shipment(self):
        return self.shipment
    def set_shipment(self, shipment):
        self.shipment = shipment
    def add_shipment(self, value):
        self.shipment.append(value)
    def insert_shipment_at(self, index, value):
        self.shipment.insert(index, value)
    def replace_shipment_at(self, index, value):
        self.shipment[index] = value
    def get_token(self):
        return self.token
    def set_token(self, token):
        self.token = token
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.password is not None or
            self.shipment or
            self.token is not None or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='InsertLiteShipmentRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('InsertLiteShipmentRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'InsertLiteShipmentRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='InsertLiteShipmentRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='InsertLiteShipmentRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='InsertLiteShipmentRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='InsertLiteShipmentRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        for shipment_ in self.shipment:
            namespaceprefix_ = self.shipment_nsprefix_ + ':' if (UseCapturedNS_ and self.shipment_nsprefix_) else ''
            shipment_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='shipment', pretty_print=pretty_print)
        if self.token is not None:
            namespaceprefix_ = self.token_nsprefix_ + ':' if (UseCapturedNS_ and self.token_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stoken>%s</%stoken>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.token), input_name='token')), namespaceprefix_ , eol_))
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'shipment':
            obj_ = Shipment.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.shipment.append(obj_)
            obj_.original_tagname_ = 'shipment'
        elif nodeName_ == 'token':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'token')
            value_ = self.gds_validate_string(value_, node, 'token')
            self.token = value_
            self.token_nsprefix_ = child_.prefix
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class InsertLiteShipmentRq


class InsertLiteShipmentRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, shipment=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
        if shipment is None:
            self.shipment = []
        else:
            self.shipment = shipment
        self.shipment_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, InsertLiteShipmentRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if InsertLiteShipmentRs.subclass:
            return InsertLiteShipmentRs.subclass(*args_, **kwargs_)
        else:
            return InsertLiteShipmentRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def get_shipment(self):
        return self.shipment
    def set_shipment(self, shipment):
        self.shipment = shipment
    def add_shipment(self, value):
        self.shipment.append(value)
    def insert_shipment_at(self, index, value):
        self.shipment.insert(index, value)
    def replace_shipment_at(self, index, value):
        self.shipment[index] = value
    def hasContent_(self):
        if (
            self.error is not None or
            self.shipment
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='InsertLiteShipmentRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('InsertLiteShipmentRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'InsertLiteShipmentRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='InsertLiteShipmentRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='InsertLiteShipmentRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='InsertLiteShipmentRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='InsertLiteShipmentRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
        for shipment_ in self.shipment:
            namespaceprefix_ = self.shipment_nsprefix_ + ':' if (UseCapturedNS_ and self.shipment_nsprefix_) else ''
            shipment_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='shipment', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
        elif nodeName_ == 'shipment':
            obj_ = InsertLiteShipmentResult.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.shipment.append(obj_)
            obj_.original_tagname_ = 'shipment'
# end class InsertLiteShipmentRs


class SearchDropOffLocationByCityRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, from_postal_code=None, to_city=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.from_postal_code = from_postal_code
        self.from_postal_code_nsprefix_ = None
        self.to_city = to_city
        self.to_city_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SearchDropOffLocationByCityRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SearchDropOffLocationByCityRq.subclass:
            return SearchDropOffLocationByCityRq.subclass(*args_, **kwargs_)
        else:
            return SearchDropOffLocationByCityRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_from_postal_code(self):
        return self.from_postal_code
    def set_from_postal_code(self, from_postal_code):
        self.from_postal_code = from_postal_code
    def get_to_city(self):
        return self.to_city
    def set_to_city(self, to_city):
        self.to_city = to_city
    def hasContent_(self):
        if (
            self.from_postal_code is not None or
            self.to_city is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchDropOffLocationByCityRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SearchDropOffLocationByCityRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SearchDropOffLocationByCityRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SearchDropOffLocationByCityRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SearchDropOffLocationByCityRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SearchDropOffLocationByCityRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchDropOffLocationByCityRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.from_postal_code is not None:
            namespaceprefix_ = self.from_postal_code_nsprefix_ + ':' if (UseCapturedNS_ and self.from_postal_code_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfrom_postal_code>%s</%sfrom_postal_code>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.from_postal_code), input_name='from_postal_code')), namespaceprefix_ , eol_))
        if self.to_city is not None:
            namespaceprefix_ = self.to_city_nsprefix_ + ':' if (UseCapturedNS_ and self.to_city_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sto_city>%s</%sto_city>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.to_city), input_name='to_city')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'from_postal_code':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'from_postal_code')
            value_ = self.gds_validate_string(value_, node, 'from_postal_code')
            self.from_postal_code = value_
            self.from_postal_code_nsprefix_ = child_.prefix
        elif nodeName_ == 'to_city':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'to_city')
            value_ = self.gds_validate_string(value_, node, 'to_city')
            self.to_city = value_
            self.to_city_nsprefix_ = child_.prefix
# end class SearchDropOffLocationByCityRq


class SearchDropOffLocationByCityRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, result=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
        if result is None:
            self.result = []
        else:
            self.result = result
        self.result_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SearchDropOffLocationByCityRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SearchDropOffLocationByCityRs.subclass:
            return SearchDropOffLocationByCityRs.subclass(*args_, **kwargs_)
        else:
            return SearchDropOffLocationByCityRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def get_result(self):
        return self.result
    def set_result(self, result):
        self.result = result
    def add_result(self, value):
        self.result.append(value)
    def insert_result_at(self, index, value):
        self.result.insert(index, value)
    def replace_result_at(self, index, value):
        self.result[index] = value
    def hasContent_(self):
        if (
            self.error is not None or
            self.result
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchDropOffLocationByCityRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SearchDropOffLocationByCityRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SearchDropOffLocationByCityRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SearchDropOffLocationByCityRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SearchDropOffLocationByCityRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SearchDropOffLocationByCityRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchDropOffLocationByCityRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
        for result_ in self.result:
            namespaceprefix_ = self.result_nsprefix_ + ':' if (UseCapturedNS_ and self.result_nsprefix_) else ''
            result_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='result', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
        elif nodeName_ == 'result':
            obj_ = Address.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.result.append(obj_)
            obj_.original_tagname_ = 'result'
# end class SearchDropOffLocationByCityRs


class SearchPickupByIdV2Rq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, id=None, password=None, shipper_num=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = id
        self.id_nsprefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        self.shipper_num = shipper_num
        self.shipper_num_nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SearchPickupByIdV2Rq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SearchPickupByIdV2Rq.subclass:
            return SearchPickupByIdV2Rq.subclass(*args_, **kwargs_)
        else:
            return SearchPickupByIdV2Rq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_shipper_num(self):
        return self.shipper_num
    def set_shipper_num(self, shipper_num):
        self.shipper_num = shipper_num
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.id is not None or
            self.password is not None or
            self.shipper_num is not None or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchPickupByIdV2Rq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SearchPickupByIdV2Rq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SearchPickupByIdV2Rq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SearchPickupByIdV2Rq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SearchPickupByIdV2Rq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SearchPickupByIdV2Rq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchPickupByIdV2Rq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.id is not None:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sid>%s</%sid>%s' % (namespaceprefix_ , self.gds_format_integer(self.id, input_name='id'), namespaceprefix_ , eol_))
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        if self.shipper_num is not None:
            namespaceprefix_ = self.shipper_num_nsprefix_ + ':' if (UseCapturedNS_ and self.shipper_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sshipper_num>%s</%sshipper_num>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.shipper_num), input_name='shipper_num')), namespaceprefix_ , eol_))
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'id' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'id')
            ival_ = self.gds_validate_integer(ival_, node, 'id')
            self.id = ival_
            self.id_nsprefix_ = child_.prefix
        elif nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'shipper_num':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'shipper_num')
            value_ = self.gds_validate_string(value_, node, 'shipper_num')
            self.shipper_num = value_
            self.shipper_num_nsprefix_ = child_.prefix
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class SearchPickupByIdV2Rq


class SearchPickupByIdV2Rs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, pickup=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
        if pickup is None:
            self.pickup = []
        else:
            self.pickup = pickup
        self.pickup_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SearchPickupByIdV2Rs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SearchPickupByIdV2Rs.subclass:
            return SearchPickupByIdV2Rs.subclass(*args_, **kwargs_)
        else:
            return SearchPickupByIdV2Rs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def get_pickup(self):
        return self.pickup
    def set_pickup(self, pickup):
        self.pickup = pickup
    def add_pickup(self, value):
        self.pickup.append(value)
    def insert_pickup_at(self, index, value):
        self.pickup.insert(index, value)
    def replace_pickup_at(self, index, value):
        self.pickup[index] = value
    def hasContent_(self):
        if (
            self.error is not None or
            self.pickup
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchPickupByIdV2Rs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SearchPickupByIdV2Rs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SearchPickupByIdV2Rs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SearchPickupByIdV2Rs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SearchPickupByIdV2Rs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SearchPickupByIdV2Rs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchPickupByIdV2Rs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
        for pickup_ in self.pickup:
            namespaceprefix_ = self.pickup_nsprefix_ + ':' if (UseCapturedNS_ and self.pickup_nsprefix_) else ''
            pickup_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='pickup', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
        elif nodeName_ == 'pickup':
            obj_ = PickupV2.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.pickup.append(obj_)
            obj_.original_tagname_ = 'pickup'
# end class SearchPickupByIdV2Rs


class RequestOfflineRatesPackageRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, password=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, RequestOfflineRatesPackageRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if RequestOfflineRatesPackageRq.subclass:
            return RequestOfflineRatesPackageRq.subclass(*args_, **kwargs_)
        else:
            return RequestOfflineRatesPackageRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.password is not None or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='RequestOfflineRatesPackageRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('RequestOfflineRatesPackageRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'RequestOfflineRatesPackageRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='RequestOfflineRatesPackageRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='RequestOfflineRatesPackageRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='RequestOfflineRatesPackageRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='RequestOfflineRatesPackageRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class RequestOfflineRatesPackageRq


class RequestOfflineRatesPackageRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, RequestOfflineRatesPackageRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if RequestOfflineRatesPackageRs.subclass:
            return RequestOfflineRatesPackageRs.subclass(*args_, **kwargs_)
        else:
            return RequestOfflineRatesPackageRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def hasContent_(self):
        if (
            self.error is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='RequestOfflineRatesPackageRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('RequestOfflineRatesPackageRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'RequestOfflineRatesPackageRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='RequestOfflineRatesPackageRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='RequestOfflineRatesPackageRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='RequestOfflineRatesPackageRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='RequestOfflineRatesPackageRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
# end class RequestOfflineRatesPackageRs


class GetFuelSurchargeRateRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, password=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetFuelSurchargeRateRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetFuelSurchargeRateRq.subclass:
            return GetFuelSurchargeRateRq.subclass(*args_, **kwargs_)
        else:
            return GetFuelSurchargeRateRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.password is not None or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetFuelSurchargeRateRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GetFuelSurchargeRateRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GetFuelSurchargeRateRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GetFuelSurchargeRateRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GetFuelSurchargeRateRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GetFuelSurchargeRateRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetFuelSurchargeRateRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class GetFuelSurchargeRateRq


class GetFuelSurchargeRateRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, result=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
        if result is None:
            self.result = []
        else:
            self.result = result
        self.result_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetFuelSurchargeRateRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetFuelSurchargeRateRs.subclass:
            return GetFuelSurchargeRateRs.subclass(*args_, **kwargs_)
        else:
            return GetFuelSurchargeRateRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def get_result(self):
        return self.result
    def set_result(self, result):
        self.result = result
    def add_result(self, value):
        self.result.append(value)
    def insert_result_at(self, index, value):
        self.result.insert(index, value)
    def replace_result_at(self, index, value):
        self.result[index] = value
    def hasContent_(self):
        if (
            self.error is not None or
            self.result
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetFuelSurchargeRateRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GetFuelSurchargeRateRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GetFuelSurchargeRateRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GetFuelSurchargeRateRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GetFuelSurchargeRateRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GetFuelSurchargeRateRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetFuelSurchargeRateRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
        for result_ in self.result:
            namespaceprefix_ = self.result_nsprefix_ + ':' if (UseCapturedNS_ and self.result_nsprefix_) else ''
            result_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='result', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
        elif nodeName_ == 'result':
            obj_ = Fuel.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.result.append(obj_)
            obj_.original_tagname_ = 'result'
# end class GetFuelSurchargeRateRs


class TerminalLocation(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, address=None, coordinates=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.address = address
        self.address_nsprefix_ = None
        self.coordinates = coordinates
        self.coordinates_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TerminalLocation)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TerminalLocation.subclass:
            return TerminalLocation.subclass(*args_, **kwargs_)
        else:
            return TerminalLocation(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_address(self):
        return self.address
    def set_address(self, address):
        self.address = address
    def get_coordinates(self):
        return self.coordinates
    def set_coordinates(self, coordinates):
        self.coordinates = coordinates
    def hasContent_(self):
        if (
            self.address is not None or
            self.coordinates is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TerminalLocation', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TerminalLocation')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TerminalLocation':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TerminalLocation')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TerminalLocation', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TerminalLocation'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TerminalLocation', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.address is not None:
            namespaceprefix_ = self.address_nsprefix_ + ':' if (UseCapturedNS_ and self.address_nsprefix_) else ''
            self.address.export(outfile, level, namespaceprefix_, namespacedef_='', name_='address', pretty_print=pretty_print)
        if self.coordinates is not None:
            namespaceprefix_ = self.coordinates_nsprefix_ + ':' if (UseCapturedNS_ and self.coordinates_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scoordinates>%s</%scoordinates>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.coordinates), input_name='coordinates')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'address':
            obj_ = Address.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.address = obj_
            obj_.original_tagname_ = 'address'
        elif nodeName_ == 'coordinates':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'coordinates')
            value_ = self.gds_validate_string(value_, node, 'coordinates')
            self.coordinates = value_
            self.coordinates_nsprefix_ = child_.prefix
# end class TerminalLocation


class Address(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, address_id=None, address_line_1=None, address_line_2=None, address_line_3=None, attention=None, city=None, country=None, email=None, extension=None, id=None, inserted_on=None, name=None, phone=None, postal_code=None, province=None, residential=None, updated_on=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.address_id = address_id
        self.address_id_nsprefix_ = None
        self.address_line_1 = address_line_1
        self.address_line_1_nsprefix_ = None
        self.address_line_2 = address_line_2
        self.address_line_2_nsprefix_ = None
        self.address_line_3 = address_line_3
        self.address_line_3_nsprefix_ = None
        self.attention = attention
        self.attention_nsprefix_ = None
        self.city = city
        self.city_nsprefix_ = None
        self.country = country
        self.country_nsprefix_ = None
        self.email = email
        self.email_nsprefix_ = None
        self.extension = extension
        self.extension_nsprefix_ = None
        self.id = id
        self.id_nsprefix_ = None
        if isinstance(inserted_on, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(inserted_on, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = inserted_on
        self.inserted_on = initvalue_
        self.inserted_on_nsprefix_ = None
        self.name = name
        self.name_nsprefix_ = None
        self.phone = phone
        self.phone_nsprefix_ = None
        self.postal_code = postal_code
        self.postal_code_nsprefix_ = None
        self.province = province
        self.province_nsprefix_ = None
        self.residential = residential
        self.residential_nsprefix_ = None
        if isinstance(updated_on, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(updated_on, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = updated_on
        self.updated_on = initvalue_
        self.updated_on_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Address)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Address.subclass:
            return Address.subclass(*args_, **kwargs_)
        else:
            return Address(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_address_id(self):
        return self.address_id
    def set_address_id(self, address_id):
        self.address_id = address_id
    def get_address_line_1(self):
        return self.address_line_1
    def set_address_line_1(self, address_line_1):
        self.address_line_1 = address_line_1
    def get_address_line_2(self):
        return self.address_line_2
    def set_address_line_2(self, address_line_2):
        self.address_line_2 = address_line_2
    def get_address_line_3(self):
        return self.address_line_3
    def set_address_line_3(self, address_line_3):
        self.address_line_3 = address_line_3
    def get_attention(self):
        return self.attention
    def set_attention(self, attention):
        self.attention = attention
    def get_city(self):
        return self.city
    def set_city(self, city):
        self.city = city
    def get_country(self):
        return self.country
    def set_country(self, country):
        self.country = country
    def get_email(self):
        return self.email
    def set_email(self, email):
        self.email = email
    def get_extension(self):
        return self.extension
    def set_extension(self, extension):
        self.extension = extension
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_inserted_on(self):
        return self.inserted_on
    def set_inserted_on(self, inserted_on):
        self.inserted_on = inserted_on
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_phone(self):
        return self.phone
    def set_phone(self, phone):
        self.phone = phone
    def get_postal_code(self):
        return self.postal_code
    def set_postal_code(self, postal_code):
        self.postal_code = postal_code
    def get_province(self):
        return self.province
    def set_province(self, province):
        self.province = province
    def get_residential(self):
        return self.residential
    def set_residential(self, residential):
        self.residential = residential
    def get_updated_on(self):
        return self.updated_on
    def set_updated_on(self, updated_on):
        self.updated_on = updated_on
    def hasContent_(self):
        if (
            self.address_id is not None or
            self.address_line_1 is not None or
            self.address_line_2 is not None or
            self.address_line_3 is not None or
            self.attention is not None or
            self.city is not None or
            self.country is not None or
            self.email is not None or
            self.extension is not None or
            self.id is not None or
            self.inserted_on is not None or
            self.name is not None or
            self.phone is not None or
            self.postal_code is not None or
            self.province is not None or
            self.residential is not None or
            self.updated_on is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Address', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Address')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Address':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Address')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Address', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Address'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Address', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.address_id is not None:
            namespaceprefix_ = self.address_id_nsprefix_ + ':' if (UseCapturedNS_ and self.address_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saddress_id>%s</%saddress_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.address_id), input_name='address_id')), namespaceprefix_ , eol_))
        if self.address_line_1 is not None:
            namespaceprefix_ = self.address_line_1_nsprefix_ + ':' if (UseCapturedNS_ and self.address_line_1_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saddress_line_1>%s</%saddress_line_1>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.address_line_1), input_name='address_line_1')), namespaceprefix_ , eol_))
        if self.address_line_2 is not None:
            namespaceprefix_ = self.address_line_2_nsprefix_ + ':' if (UseCapturedNS_ and self.address_line_2_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saddress_line_2>%s</%saddress_line_2>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.address_line_2), input_name='address_line_2')), namespaceprefix_ , eol_))
        if self.address_line_3 is not None:
            namespaceprefix_ = self.address_line_3_nsprefix_ + ':' if (UseCapturedNS_ and self.address_line_3_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saddress_line_3>%s</%saddress_line_3>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.address_line_3), input_name='address_line_3')), namespaceprefix_ , eol_))
        if self.attention is not None:
            namespaceprefix_ = self.attention_nsprefix_ + ':' if (UseCapturedNS_ and self.attention_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sattention>%s</%sattention>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.attention), input_name='attention')), namespaceprefix_ , eol_))
        if self.city is not None:
            namespaceprefix_ = self.city_nsprefix_ + ':' if (UseCapturedNS_ and self.city_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scity>%s</%scity>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.city), input_name='city')), namespaceprefix_ , eol_))
        if self.country is not None:
            namespaceprefix_ = self.country_nsprefix_ + ':' if (UseCapturedNS_ and self.country_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scountry>%s</%scountry>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.country), input_name='country')), namespaceprefix_ , eol_))
        if self.email is not None:
            namespaceprefix_ = self.email_nsprefix_ + ':' if (UseCapturedNS_ and self.email_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%semail>%s</%semail>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.email), input_name='email')), namespaceprefix_ , eol_))
        if self.extension is not None:
            namespaceprefix_ = self.extension_nsprefix_ + ':' if (UseCapturedNS_ and self.extension_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sextension>%s</%sextension>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.extension), input_name='extension')), namespaceprefix_ , eol_))
        if self.id is not None:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sid>%s</%sid>%s' % (namespaceprefix_ , self.gds_format_integer(self.id, input_name='id'), namespaceprefix_ , eol_))
        if self.inserted_on is not None:
            namespaceprefix_ = self.inserted_on_nsprefix_ + ':' if (UseCapturedNS_ and self.inserted_on_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sinserted_on>%s</%sinserted_on>%s' % (namespaceprefix_ , self.gds_format_datetime(self.inserted_on, input_name='inserted_on'), namespaceprefix_ , eol_))
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespaceprefix_ , eol_))
        if self.phone is not None:
            namespaceprefix_ = self.phone_nsprefix_ + ':' if (UseCapturedNS_ and self.phone_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sphone>%s</%sphone>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.phone), input_name='phone')), namespaceprefix_ , eol_))
        if self.postal_code is not None:
            namespaceprefix_ = self.postal_code_nsprefix_ + ':' if (UseCapturedNS_ and self.postal_code_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spostal_code>%s</%spostal_code>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.postal_code), input_name='postal_code')), namespaceprefix_ , eol_))
        if self.province is not None:
            namespaceprefix_ = self.province_nsprefix_ + ':' if (UseCapturedNS_ and self.province_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sprovince>%s</%sprovince>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.province), input_name='province')), namespaceprefix_ , eol_))
        if self.residential is not None:
            namespaceprefix_ = self.residential_nsprefix_ + ':' if (UseCapturedNS_ and self.residential_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sresidential>%s</%sresidential>%s' % (namespaceprefix_ , self.gds_format_boolean(self.residential, input_name='residential'), namespaceprefix_ , eol_))
        if self.updated_on is not None:
            namespaceprefix_ = self.updated_on_nsprefix_ + ':' if (UseCapturedNS_ and self.updated_on_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%supdated_on>%s</%supdated_on>%s' % (namespaceprefix_ , self.gds_format_datetime(self.updated_on, input_name='updated_on'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'address_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'address_id')
            value_ = self.gds_validate_string(value_, node, 'address_id')
            self.address_id = value_
            self.address_id_nsprefix_ = child_.prefix
        elif nodeName_ == 'address_line_1':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'address_line_1')
            value_ = self.gds_validate_string(value_, node, 'address_line_1')
            self.address_line_1 = value_
            self.address_line_1_nsprefix_ = child_.prefix
        elif nodeName_ == 'address_line_2':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'address_line_2')
            value_ = self.gds_validate_string(value_, node, 'address_line_2')
            self.address_line_2 = value_
            self.address_line_2_nsprefix_ = child_.prefix
        elif nodeName_ == 'address_line_3':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'address_line_3')
            value_ = self.gds_validate_string(value_, node, 'address_line_3')
            self.address_line_3 = value_
            self.address_line_3_nsprefix_ = child_.prefix
        elif nodeName_ == 'attention':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'attention')
            value_ = self.gds_validate_string(value_, node, 'attention')
            self.attention = value_
            self.attention_nsprefix_ = child_.prefix
        elif nodeName_ == 'city':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'city')
            value_ = self.gds_validate_string(value_, node, 'city')
            self.city = value_
            self.city_nsprefix_ = child_.prefix
        elif nodeName_ == 'country':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'country')
            value_ = self.gds_validate_string(value_, node, 'country')
            self.country = value_
            self.country_nsprefix_ = child_.prefix
        elif nodeName_ == 'email':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'email')
            value_ = self.gds_validate_string(value_, node, 'email')
            self.email = value_
            self.email_nsprefix_ = child_.prefix
        elif nodeName_ == 'extension':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'extension')
            value_ = self.gds_validate_string(value_, node, 'extension')
            self.extension = value_
            self.extension_nsprefix_ = child_.prefix
        elif nodeName_ == 'id' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'id')
            ival_ = self.gds_validate_integer(ival_, node, 'id')
            self.id = ival_
            self.id_nsprefix_ = child_.prefix
        elif nodeName_ == 'inserted_on':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.inserted_on = dval_
            self.inserted_on_nsprefix_ = child_.prefix
        elif nodeName_ == 'name':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'name')
            value_ = self.gds_validate_string(value_, node, 'name')
            self.name = value_
            self.name_nsprefix_ = child_.prefix
        elif nodeName_ == 'phone':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'phone')
            value_ = self.gds_validate_string(value_, node, 'phone')
            self.phone = value_
            self.phone_nsprefix_ = child_.prefix
        elif nodeName_ == 'postal_code':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'postal_code')
            value_ = self.gds_validate_string(value_, node, 'postal_code')
            self.postal_code = value_
            self.postal_code_nsprefix_ = child_.prefix
        elif nodeName_ == 'province':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'province')
            value_ = self.gds_validate_string(value_, node, 'province')
            self.province = value_
            self.province_nsprefix_ = child_.prefix
        elif nodeName_ == 'residential':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'residential')
            ival_ = self.gds_validate_boolean(ival_, node, 'residential')
            self.residential = ival_
            self.residential_nsprefix_ = child_.prefix
        elif nodeName_ == 'updated_on':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.updated_on = dval_
            self.updated_on_nsprefix_ = child_.prefix
# end class Address


class Shipment(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, airport_code=None, billed_weight=None, billed_weight_unit=None, cod_charge=None, cod_type=None, collect=None, collect_charge=None, collect_shipper_num=None, consolidation_type=None, cos=None, cos_charge=None, delivery_address=None, description=None, dg=None, dg_charge=None, dimention_unit=None, dv_charge=None, ea_charge=None, ea_zone=None, estimated_delivery_date=None, freight_charge=None, fuel_surcharge=None, handling=None, handling_type=None, id=None, inserted_on=None, instruction=None, lg_charge=None, manifest_num=None, nsr=None, order_id=None, over_size_charge=None, over_weight_charge=None, packages=None, pickup_address=None, premium=None, premium_charge=None, proforma=None, ra_charge=None, reported_weight_unit=None, rural_charge=None, send_email_to_delivery=None, send_email_to_pickup=None, service_type=None, shipment_status=None, shipper_num=None, shipping_date=None, subtotal=None, subtotal_with_handling=None, tax_charge_1=None, tax_charge_2=None, tax_code_1=None, tax_code_2=None, total=None, total_with_handling=None, transit_time=None, transit_time_guaranteed=None, updated_on=None, user_id=None, voided=None, xc_charge=None, zone=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.airport_code = airport_code
        self.airport_code_nsprefix_ = None
        self.billed_weight = billed_weight
        self.billed_weight_nsprefix_ = None
        self.billed_weight_unit = billed_weight_unit
        self.billed_weight_unit_nsprefix_ = None
        self.cod_charge = cod_charge
        self.cod_charge_nsprefix_ = None
        self.cod_type = cod_type
        self.cod_type_nsprefix_ = None
        self.collect = collect
        self.collect_nsprefix_ = None
        self.collect_charge = collect_charge
        self.collect_charge_nsprefix_ = None
        self.collect_shipper_num = collect_shipper_num
        self.collect_shipper_num_nsprefix_ = None
        self.consolidation_type = consolidation_type
        self.consolidation_type_nsprefix_ = None
        self.cos = cos
        self.cos_nsprefix_ = None
        self.cos_charge = cos_charge
        self.cos_charge_nsprefix_ = None
        self.delivery_address = delivery_address
        self.delivery_address_nsprefix_ = None
        self.description = description
        self.description_nsprefix_ = None
        self.dg = dg
        self.dg_nsprefix_ = None
        self.dg_charge = dg_charge
        self.dg_charge_nsprefix_ = None
        self.dimention_unit = dimention_unit
        self.dimention_unit_nsprefix_ = None
        self.dv_charge = dv_charge
        self.dv_charge_nsprefix_ = None
        self.ea_charge = ea_charge
        self.ea_charge_nsprefix_ = None
        self.ea_zone = ea_zone
        self.ea_zone_nsprefix_ = None
        if isinstance(estimated_delivery_date, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(estimated_delivery_date, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = estimated_delivery_date
        self.estimated_delivery_date = initvalue_
        self.estimated_delivery_date_nsprefix_ = None
        self.freight_charge = freight_charge
        self.freight_charge_nsprefix_ = None
        self.fuel_surcharge = fuel_surcharge
        self.fuel_surcharge_nsprefix_ = None
        self.handling = handling
        self.handling_nsprefix_ = None
        self.handling_type = handling_type
        self.handling_type_nsprefix_ = None
        self.id = id
        self.id_nsprefix_ = None
        if isinstance(inserted_on, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(inserted_on, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = inserted_on
        self.inserted_on = initvalue_
        self.inserted_on_nsprefix_ = None
        self.instruction = instruction
        self.instruction_nsprefix_ = None
        self.lg_charge = lg_charge
        self.lg_charge_nsprefix_ = None
        self.manifest_num = manifest_num
        self.manifest_num_nsprefix_ = None
        self.nsr = nsr
        self.nsr_nsprefix_ = None
        self.order_id = order_id
        self.order_id_nsprefix_ = None
        self.over_size_charge = over_size_charge
        self.over_size_charge_nsprefix_ = None
        self.over_weight_charge = over_weight_charge
        self.over_weight_charge_nsprefix_ = None
        if packages is None:
            self.packages = []
        else:
            self.packages = packages
        self.packages_nsprefix_ = None
        self.pickup_address = pickup_address
        self.pickup_address_nsprefix_ = None
        self.premium = premium
        self.premium_nsprefix_ = None
        self.premium_charge = premium_charge
        self.premium_charge_nsprefix_ = None
        self.proforma = proforma
        self.proforma_nsprefix_ = None
        self.ra_charge = ra_charge
        self.ra_charge_nsprefix_ = None
        self.reported_weight_unit = reported_weight_unit
        self.reported_weight_unit_nsprefix_ = None
        self.rural_charge = rural_charge
        self.rural_charge_nsprefix_ = None
        self.send_email_to_delivery = send_email_to_delivery
        self.send_email_to_delivery_nsprefix_ = None
        self.send_email_to_pickup = send_email_to_pickup
        self.send_email_to_pickup_nsprefix_ = None
        self.service_type = service_type
        self.service_type_nsprefix_ = None
        self.shipment_status = shipment_status
        self.shipment_status_nsprefix_ = None
        self.shipper_num = shipper_num
        self.shipper_num_nsprefix_ = None
        if isinstance(shipping_date, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(shipping_date, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = shipping_date
        self.shipping_date = initvalue_
        self.shipping_date_nsprefix_ = None
        self.subtotal = subtotal
        self.subtotal_nsprefix_ = None
        self.subtotal_with_handling = subtotal_with_handling
        self.subtotal_with_handling_nsprefix_ = None
        self.tax_charge_1 = tax_charge_1
        self.tax_charge_1_nsprefix_ = None
        self.tax_charge_2 = tax_charge_2
        self.tax_charge_2_nsprefix_ = None
        self.tax_code_1 = tax_code_1
        self.tax_code_1_nsprefix_ = None
        self.tax_code_2 = tax_code_2
        self.tax_code_2_nsprefix_ = None
        self.total = total
        self.total_nsprefix_ = None
        self.total_with_handling = total_with_handling
        self.total_with_handling_nsprefix_ = None
        self.transit_time = transit_time
        self.transit_time_nsprefix_ = None
        self.transit_time_guaranteed = transit_time_guaranteed
        self.transit_time_guaranteed_nsprefix_ = None
        if isinstance(updated_on, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(updated_on, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = updated_on
        self.updated_on = initvalue_
        self.updated_on_nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
        self.voided = voided
        self.voided_nsprefix_ = None
        self.xc_charge = xc_charge
        self.xc_charge_nsprefix_ = None
        self.zone = zone
        self.zone_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Shipment)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Shipment.subclass:
            return Shipment.subclass(*args_, **kwargs_)
        else:
            return Shipment(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_airport_code(self):
        return self.airport_code
    def set_airport_code(self, airport_code):
        self.airport_code = airport_code
    def get_billed_weight(self):
        return self.billed_weight
    def set_billed_weight(self, billed_weight):
        self.billed_weight = billed_weight
    def get_billed_weight_unit(self):
        return self.billed_weight_unit
    def set_billed_weight_unit(self, billed_weight_unit):
        self.billed_weight_unit = billed_weight_unit
    def get_cod_charge(self):
        return self.cod_charge
    def set_cod_charge(self, cod_charge):
        self.cod_charge = cod_charge
    def get_cod_type(self):
        return self.cod_type
    def set_cod_type(self, cod_type):
        self.cod_type = cod_type
    def get_collect(self):
        return self.collect
    def set_collect(self, collect):
        self.collect = collect
    def get_collect_charge(self):
        return self.collect_charge
    def set_collect_charge(self, collect_charge):
        self.collect_charge = collect_charge
    def get_collect_shipper_num(self):
        return self.collect_shipper_num
    def set_collect_shipper_num(self, collect_shipper_num):
        self.collect_shipper_num = collect_shipper_num
    def get_consolidation_type(self):
        return self.consolidation_type
    def set_consolidation_type(self, consolidation_type):
        self.consolidation_type = consolidation_type
    def get_cos(self):
        return self.cos
    def set_cos(self, cos):
        self.cos = cos
    def get_cos_charge(self):
        return self.cos_charge
    def set_cos_charge(self, cos_charge):
        self.cos_charge = cos_charge
    def get_delivery_address(self):
        return self.delivery_address
    def set_delivery_address(self, delivery_address):
        self.delivery_address = delivery_address
    def get_description(self):
        return self.description
    def set_description(self, description):
        self.description = description
    def get_dg(self):
        return self.dg
    def set_dg(self, dg):
        self.dg = dg
    def get_dg_charge(self):
        return self.dg_charge
    def set_dg_charge(self, dg_charge):
        self.dg_charge = dg_charge
    def get_dimention_unit(self):
        return self.dimention_unit
    def set_dimention_unit(self, dimention_unit):
        self.dimention_unit = dimention_unit
    def get_dv_charge(self):
        return self.dv_charge
    def set_dv_charge(self, dv_charge):
        self.dv_charge = dv_charge
    def get_ea_charge(self):
        return self.ea_charge
    def set_ea_charge(self, ea_charge):
        self.ea_charge = ea_charge
    def get_ea_zone(self):
        return self.ea_zone
    def set_ea_zone(self, ea_zone):
        self.ea_zone = ea_zone
    def get_estimated_delivery_date(self):
        return self.estimated_delivery_date
    def set_estimated_delivery_date(self, estimated_delivery_date):
        self.estimated_delivery_date = estimated_delivery_date
    def get_freight_charge(self):
        return self.freight_charge
    def set_freight_charge(self, freight_charge):
        self.freight_charge = freight_charge
    def get_fuel_surcharge(self):
        return self.fuel_surcharge
    def set_fuel_surcharge(self, fuel_surcharge):
        self.fuel_surcharge = fuel_surcharge
    def get_handling(self):
        return self.handling
    def set_handling(self, handling):
        self.handling = handling
    def get_handling_type(self):
        return self.handling_type
    def set_handling_type(self, handling_type):
        self.handling_type = handling_type
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_inserted_on(self):
        return self.inserted_on
    def set_inserted_on(self, inserted_on):
        self.inserted_on = inserted_on
    def get_instruction(self):
        return self.instruction
    def set_instruction(self, instruction):
        self.instruction = instruction
    def get_lg_charge(self):
        return self.lg_charge
    def set_lg_charge(self, lg_charge):
        self.lg_charge = lg_charge
    def get_manifest_num(self):
        return self.manifest_num
    def set_manifest_num(self, manifest_num):
        self.manifest_num = manifest_num
    def get_nsr(self):
        return self.nsr
    def set_nsr(self, nsr):
        self.nsr = nsr
    def get_order_id(self):
        return self.order_id
    def set_order_id(self, order_id):
        self.order_id = order_id
    def get_over_size_charge(self):
        return self.over_size_charge
    def set_over_size_charge(self, over_size_charge):
        self.over_size_charge = over_size_charge
    def get_over_weight_charge(self):
        return self.over_weight_charge
    def set_over_weight_charge(self, over_weight_charge):
        self.over_weight_charge = over_weight_charge
    def get_packages(self):
        return self.packages
    def set_packages(self, packages):
        self.packages = packages
    def add_packages(self, value):
        self.packages.append(value)
    def insert_packages_at(self, index, value):
        self.packages.insert(index, value)
    def replace_packages_at(self, index, value):
        self.packages[index] = value
    def get_pickup_address(self):
        return self.pickup_address
    def set_pickup_address(self, pickup_address):
        self.pickup_address = pickup_address
    def get_premium(self):
        return self.premium
    def set_premium(self, premium):
        self.premium = premium
    def get_premium_charge(self):
        return self.premium_charge
    def set_premium_charge(self, premium_charge):
        self.premium_charge = premium_charge
    def get_proforma(self):
        return self.proforma
    def set_proforma(self, proforma):
        self.proforma = proforma
    def get_ra_charge(self):
        return self.ra_charge
    def set_ra_charge(self, ra_charge):
        self.ra_charge = ra_charge
    def get_reported_weight_unit(self):
        return self.reported_weight_unit
    def set_reported_weight_unit(self, reported_weight_unit):
        self.reported_weight_unit = reported_weight_unit
    def get_rural_charge(self):
        return self.rural_charge
    def set_rural_charge(self, rural_charge):
        self.rural_charge = rural_charge
    def get_send_email_to_delivery(self):
        return self.send_email_to_delivery
    def set_send_email_to_delivery(self, send_email_to_delivery):
        self.send_email_to_delivery = send_email_to_delivery
    def get_send_email_to_pickup(self):
        return self.send_email_to_pickup
    def set_send_email_to_pickup(self, send_email_to_pickup):
        self.send_email_to_pickup = send_email_to_pickup
    def get_service_type(self):
        return self.service_type
    def set_service_type(self, service_type):
        self.service_type = service_type
    def get_shipment_status(self):
        return self.shipment_status
    def set_shipment_status(self, shipment_status):
        self.shipment_status = shipment_status
    def get_shipper_num(self):
        return self.shipper_num
    def set_shipper_num(self, shipper_num):
        self.shipper_num = shipper_num
    def get_shipping_date(self):
        return self.shipping_date
    def set_shipping_date(self, shipping_date):
        self.shipping_date = shipping_date
    def get_subtotal(self):
        return self.subtotal
    def set_subtotal(self, subtotal):
        self.subtotal = subtotal
    def get_subtotal_with_handling(self):
        return self.subtotal_with_handling
    def set_subtotal_with_handling(self, subtotal_with_handling):
        self.subtotal_with_handling = subtotal_with_handling
    def get_tax_charge_1(self):
        return self.tax_charge_1
    def set_tax_charge_1(self, tax_charge_1):
        self.tax_charge_1 = tax_charge_1
    def get_tax_charge_2(self):
        return self.tax_charge_2
    def set_tax_charge_2(self, tax_charge_2):
        self.tax_charge_2 = tax_charge_2
    def get_tax_code_1(self):
        return self.tax_code_1
    def set_tax_code_1(self, tax_code_1):
        self.tax_code_1 = tax_code_1
    def get_tax_code_2(self):
        return self.tax_code_2
    def set_tax_code_2(self, tax_code_2):
        self.tax_code_2 = tax_code_2
    def get_total(self):
        return self.total
    def set_total(self, total):
        self.total = total
    def get_total_with_handling(self):
        return self.total_with_handling
    def set_total_with_handling(self, total_with_handling):
        self.total_with_handling = total_with_handling
    def get_transit_time(self):
        return self.transit_time
    def set_transit_time(self, transit_time):
        self.transit_time = transit_time
    def get_transit_time_guaranteed(self):
        return self.transit_time_guaranteed
    def set_transit_time_guaranteed(self, transit_time_guaranteed):
        self.transit_time_guaranteed = transit_time_guaranteed
    def get_updated_on(self):
        return self.updated_on
    def set_updated_on(self, updated_on):
        self.updated_on = updated_on
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def get_voided(self):
        return self.voided
    def set_voided(self, voided):
        self.voided = voided
    def get_xc_charge(self):
        return self.xc_charge
    def set_xc_charge(self, xc_charge):
        self.xc_charge = xc_charge
    def get_zone(self):
        return self.zone
    def set_zone(self, zone):
        self.zone = zone
    def hasContent_(self):
        if (
            self.airport_code is not None or
            self.billed_weight is not None or
            self.billed_weight_unit is not None or
            self.cod_charge is not None or
            self.cod_type is not None or
            self.collect is not None or
            self.collect_charge is not None or
            self.collect_shipper_num is not None or
            self.consolidation_type is not None or
            self.cos is not None or
            self.cos_charge is not None or
            self.delivery_address is not None or
            self.description is not None or
            self.dg is not None or
            self.dg_charge is not None or
            self.dimention_unit is not None or
            self.dv_charge is not None or
            self.ea_charge is not None or
            self.ea_zone is not None or
            self.estimated_delivery_date is not None or
            self.freight_charge is not None or
            self.fuel_surcharge is not None or
            self.handling is not None or
            self.handling_type is not None or
            self.id is not None or
            self.inserted_on is not None or
            self.instruction is not None or
            self.lg_charge is not None or
            self.manifest_num is not None or
            self.nsr is not None or
            self.order_id is not None or
            self.over_size_charge is not None or
            self.over_weight_charge is not None or
            self.packages or
            self.pickup_address is not None or
            self.premium is not None or
            self.premium_charge is not None or
            self.proforma is not None or
            self.ra_charge is not None or
            self.reported_weight_unit is not None or
            self.rural_charge is not None or
            self.send_email_to_delivery is not None or
            self.send_email_to_pickup is not None or
            self.service_type is not None or
            self.shipment_status is not None or
            self.shipper_num is not None or
            self.shipping_date is not None or
            self.subtotal is not None or
            self.subtotal_with_handling is not None or
            self.tax_charge_1 is not None or
            self.tax_charge_2 is not None or
            self.tax_code_1 is not None or
            self.tax_code_2 is not None or
            self.total is not None or
            self.total_with_handling is not None or
            self.transit_time is not None or
            self.transit_time_guaranteed is not None or
            self.updated_on is not None or
            self.user_id is not None or
            self.voided is not None or
            self.xc_charge is not None or
            self.zone is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Shipment', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Shipment')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Shipment':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Shipment')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Shipment', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Shipment'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Shipment', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.airport_code is not None:
            namespaceprefix_ = self.airport_code_nsprefix_ + ':' if (UseCapturedNS_ and self.airport_code_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sairport_code>%s</%sairport_code>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.airport_code), input_name='airport_code')), namespaceprefix_ , eol_))
        if self.billed_weight is not None:
            namespaceprefix_ = self.billed_weight_nsprefix_ + ':' if (UseCapturedNS_ and self.billed_weight_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbilled_weight>%s</%sbilled_weight>%s' % (namespaceprefix_ , self.gds_format_float(self.billed_weight, input_name='billed_weight'), namespaceprefix_ , eol_))
        if self.billed_weight_unit is not None:
            namespaceprefix_ = self.billed_weight_unit_nsprefix_ + ':' if (UseCapturedNS_ and self.billed_weight_unit_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbilled_weight_unit>%s</%sbilled_weight_unit>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.billed_weight_unit), input_name='billed_weight_unit')), namespaceprefix_ , eol_))
        if self.cod_charge is not None:
            namespaceprefix_ = self.cod_charge_nsprefix_ + ':' if (UseCapturedNS_ and self.cod_charge_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scod_charge>%s</%scod_charge>%s' % (namespaceprefix_ , self.gds_format_float(self.cod_charge, input_name='cod_charge'), namespaceprefix_ , eol_))
        if self.cod_type is not None:
            namespaceprefix_ = self.cod_type_nsprefix_ + ':' if (UseCapturedNS_ and self.cod_type_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scod_type>%s</%scod_type>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cod_type), input_name='cod_type')), namespaceprefix_ , eol_))
        if self.collect is not None:
            namespaceprefix_ = self.collect_nsprefix_ + ':' if (UseCapturedNS_ and self.collect_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scollect>%s</%scollect>%s' % (namespaceprefix_ , self.gds_format_boolean(self.collect, input_name='collect'), namespaceprefix_ , eol_))
        if self.collect_charge is not None:
            namespaceprefix_ = self.collect_charge_nsprefix_ + ':' if (UseCapturedNS_ and self.collect_charge_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scollect_charge>%s</%scollect_charge>%s' % (namespaceprefix_ , self.gds_format_float(self.collect_charge, input_name='collect_charge'), namespaceprefix_ , eol_))
        if self.collect_shipper_num is not None:
            namespaceprefix_ = self.collect_shipper_num_nsprefix_ + ':' if (UseCapturedNS_ and self.collect_shipper_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scollect_shipper_num>%s</%scollect_shipper_num>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.collect_shipper_num), input_name='collect_shipper_num')), namespaceprefix_ , eol_))
        if self.consolidation_type is not None:
            namespaceprefix_ = self.consolidation_type_nsprefix_ + ':' if (UseCapturedNS_ and self.consolidation_type_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sconsolidation_type>%s</%sconsolidation_type>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.consolidation_type), input_name='consolidation_type')), namespaceprefix_ , eol_))
        if self.cos is not None:
            namespaceprefix_ = self.cos_nsprefix_ + ':' if (UseCapturedNS_ and self.cos_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scos>%s</%scos>%s' % (namespaceprefix_ , self.gds_format_boolean(self.cos, input_name='cos'), namespaceprefix_ , eol_))
        if self.cos_charge is not None:
            namespaceprefix_ = self.cos_charge_nsprefix_ + ':' if (UseCapturedNS_ and self.cos_charge_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scos_charge>%s</%scos_charge>%s' % (namespaceprefix_ , self.gds_format_float(self.cos_charge, input_name='cos_charge'), namespaceprefix_ , eol_))
        if self.delivery_address is not None:
            namespaceprefix_ = self.delivery_address_nsprefix_ + ':' if (UseCapturedNS_ and self.delivery_address_nsprefix_) else ''
            self.delivery_address.export(outfile, level, namespaceprefix_, namespacedef_='', name_='delivery_address', pretty_print=pretty_print)
        if self.description is not None:
            namespaceprefix_ = self.description_nsprefix_ + ':' if (UseCapturedNS_ and self.description_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.description), input_name='description')), namespaceprefix_ , eol_))
        if self.dg is not None:
            namespaceprefix_ = self.dg_nsprefix_ + ':' if (UseCapturedNS_ and self.dg_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdg>%s</%sdg>%s' % (namespaceprefix_ , self.gds_format_boolean(self.dg, input_name='dg'), namespaceprefix_ , eol_))
        if self.dg_charge is not None:
            namespaceprefix_ = self.dg_charge_nsprefix_ + ':' if (UseCapturedNS_ and self.dg_charge_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdg_charge>%s</%sdg_charge>%s' % (namespaceprefix_ , self.gds_format_float(self.dg_charge, input_name='dg_charge'), namespaceprefix_ , eol_))
        if self.dimention_unit is not None:
            namespaceprefix_ = self.dimention_unit_nsprefix_ + ':' if (UseCapturedNS_ and self.dimention_unit_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdimention_unit>%s</%sdimention_unit>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.dimention_unit), input_name='dimention_unit')), namespaceprefix_ , eol_))
        if self.dv_charge is not None:
            namespaceprefix_ = self.dv_charge_nsprefix_ + ':' if (UseCapturedNS_ and self.dv_charge_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdv_charge>%s</%sdv_charge>%s' % (namespaceprefix_ , self.gds_format_float(self.dv_charge, input_name='dv_charge'), namespaceprefix_ , eol_))
        if self.ea_charge is not None:
            namespaceprefix_ = self.ea_charge_nsprefix_ + ':' if (UseCapturedNS_ and self.ea_charge_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sea_charge>%s</%sea_charge>%s' % (namespaceprefix_ , self.gds_format_float(self.ea_charge, input_name='ea_charge'), namespaceprefix_ , eol_))
        if self.ea_zone is not None:
            namespaceprefix_ = self.ea_zone_nsprefix_ + ':' if (UseCapturedNS_ and self.ea_zone_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sea_zone>%s</%sea_zone>%s' % (namespaceprefix_ , self.gds_format_integer(self.ea_zone, input_name='ea_zone'), namespaceprefix_ , eol_))
        if self.estimated_delivery_date is not None:
            namespaceprefix_ = self.estimated_delivery_date_nsprefix_ + ':' if (UseCapturedNS_ and self.estimated_delivery_date_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sestimated_delivery_date>%s</%sestimated_delivery_date>%s' % (namespaceprefix_ , self.gds_format_datetime(self.estimated_delivery_date, input_name='estimated_delivery_date'), namespaceprefix_ , eol_))
        if self.freight_charge is not None:
            namespaceprefix_ = self.freight_charge_nsprefix_ + ':' if (UseCapturedNS_ and self.freight_charge_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfreight_charge>%s</%sfreight_charge>%s' % (namespaceprefix_ , self.gds_format_float(self.freight_charge, input_name='freight_charge'), namespaceprefix_ , eol_))
        if self.fuel_surcharge is not None:
            namespaceprefix_ = self.fuel_surcharge_nsprefix_ + ':' if (UseCapturedNS_ and self.fuel_surcharge_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfuel_surcharge>%s</%sfuel_surcharge>%s' % (namespaceprefix_ , self.gds_format_float(self.fuel_surcharge, input_name='fuel_surcharge'), namespaceprefix_ , eol_))
        if self.handling is not None:
            namespaceprefix_ = self.handling_nsprefix_ + ':' if (UseCapturedNS_ and self.handling_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%shandling>%s</%shandling>%s' % (namespaceprefix_ , self.gds_format_float(self.handling, input_name='handling'), namespaceprefix_ , eol_))
        if self.handling_type is not None:
            namespaceprefix_ = self.handling_type_nsprefix_ + ':' if (UseCapturedNS_ and self.handling_type_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%shandling_type>%s</%shandling_type>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.handling_type), input_name='handling_type')), namespaceprefix_ , eol_))
        if self.id is not None:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sid>%s</%sid>%s' % (namespaceprefix_ , self.gds_format_integer(self.id, input_name='id'), namespaceprefix_ , eol_))
        if self.inserted_on is not None:
            namespaceprefix_ = self.inserted_on_nsprefix_ + ':' if (UseCapturedNS_ and self.inserted_on_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sinserted_on>%s</%sinserted_on>%s' % (namespaceprefix_ , self.gds_format_datetime(self.inserted_on, input_name='inserted_on'), namespaceprefix_ , eol_))
        if self.instruction is not None:
            namespaceprefix_ = self.instruction_nsprefix_ + ':' if (UseCapturedNS_ and self.instruction_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sinstruction>%s</%sinstruction>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.instruction), input_name='instruction')), namespaceprefix_ , eol_))
        if self.lg_charge is not None:
            namespaceprefix_ = self.lg_charge_nsprefix_ + ':' if (UseCapturedNS_ and self.lg_charge_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slg_charge>%s</%slg_charge>%s' % (namespaceprefix_ , self.gds_format_float(self.lg_charge, input_name='lg_charge'), namespaceprefix_ , eol_))
        if self.manifest_num is not None:
            namespaceprefix_ = self.manifest_num_nsprefix_ + ':' if (UseCapturedNS_ and self.manifest_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smanifest_num>%s</%smanifest_num>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.manifest_num), input_name='manifest_num')), namespaceprefix_ , eol_))
        if self.nsr is not None:
            namespaceprefix_ = self.nsr_nsprefix_ + ':' if (UseCapturedNS_ and self.nsr_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snsr>%s</%snsr>%s' % (namespaceprefix_ , self.gds_format_boolean(self.nsr, input_name='nsr'), namespaceprefix_ , eol_))
        if self.order_id is not None:
            namespaceprefix_ = self.order_id_nsprefix_ + ':' if (UseCapturedNS_ and self.order_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorder_id>%s</%sorder_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.order_id), input_name='order_id')), namespaceprefix_ , eol_))
        if self.over_size_charge is not None:
            namespaceprefix_ = self.over_size_charge_nsprefix_ + ':' if (UseCapturedNS_ and self.over_size_charge_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sover_size_charge>%s</%sover_size_charge>%s' % (namespaceprefix_ , self.gds_format_float(self.over_size_charge, input_name='over_size_charge'), namespaceprefix_ , eol_))
        if self.over_weight_charge is not None:
            namespaceprefix_ = self.over_weight_charge_nsprefix_ + ':' if (UseCapturedNS_ and self.over_weight_charge_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sover_weight_charge>%s</%sover_weight_charge>%s' % (namespaceprefix_ , self.gds_format_float(self.over_weight_charge, input_name='over_weight_charge'), namespaceprefix_ , eol_))
        for packages_ in self.packages:
            namespaceprefix_ = self.packages_nsprefix_ + ':' if (UseCapturedNS_ and self.packages_nsprefix_) else ''
            packages_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='packages', pretty_print=pretty_print)
        if self.pickup_address is not None:
            namespaceprefix_ = self.pickup_address_nsprefix_ + ':' if (UseCapturedNS_ and self.pickup_address_nsprefix_) else ''
            self.pickup_address.export(outfile, level, namespaceprefix_, namespacedef_='', name_='pickup_address', pretty_print=pretty_print)
        if self.premium is not None:
            namespaceprefix_ = self.premium_nsprefix_ + ':' if (UseCapturedNS_ and self.premium_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spremium>%s</%spremium>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.premium), input_name='premium')), namespaceprefix_ , eol_))
        if self.premium_charge is not None:
            namespaceprefix_ = self.premium_charge_nsprefix_ + ':' if (UseCapturedNS_ and self.premium_charge_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spremium_charge>%s</%spremium_charge>%s' % (namespaceprefix_ , self.gds_format_float(self.premium_charge, input_name='premium_charge'), namespaceprefix_ , eol_))
        if self.proforma is not None:
            namespaceprefix_ = self.proforma_nsprefix_ + ':' if (UseCapturedNS_ and self.proforma_nsprefix_) else ''
            self.proforma.export(outfile, level, namespaceprefix_, namespacedef_='', name_='proforma', pretty_print=pretty_print)
        if self.ra_charge is not None:
            namespaceprefix_ = self.ra_charge_nsprefix_ + ':' if (UseCapturedNS_ and self.ra_charge_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sra_charge>%s</%sra_charge>%s' % (namespaceprefix_ , self.gds_format_float(self.ra_charge, input_name='ra_charge'), namespaceprefix_ , eol_))
        if self.reported_weight_unit is not None:
            namespaceprefix_ = self.reported_weight_unit_nsprefix_ + ':' if (UseCapturedNS_ and self.reported_weight_unit_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sreported_weight_unit>%s</%sreported_weight_unit>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.reported_weight_unit), input_name='reported_weight_unit')), namespaceprefix_ , eol_))
        if self.rural_charge is not None:
            namespaceprefix_ = self.rural_charge_nsprefix_ + ':' if (UseCapturedNS_ and self.rural_charge_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srural_charge>%s</%srural_charge>%s' % (namespaceprefix_ , self.gds_format_float(self.rural_charge, input_name='rural_charge'), namespaceprefix_ , eol_))
        if self.send_email_to_delivery is not None:
            namespaceprefix_ = self.send_email_to_delivery_nsprefix_ + ':' if (UseCapturedNS_ and self.send_email_to_delivery_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssend_email_to_delivery>%s</%ssend_email_to_delivery>%s' % (namespaceprefix_ , self.gds_format_boolean(self.send_email_to_delivery, input_name='send_email_to_delivery'), namespaceprefix_ , eol_))
        if self.send_email_to_pickup is not None:
            namespaceprefix_ = self.send_email_to_pickup_nsprefix_ + ':' if (UseCapturedNS_ and self.send_email_to_pickup_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssend_email_to_pickup>%s</%ssend_email_to_pickup>%s' % (namespaceprefix_ , self.gds_format_boolean(self.send_email_to_pickup, input_name='send_email_to_pickup'), namespaceprefix_ , eol_))
        if self.service_type is not None:
            namespaceprefix_ = self.service_type_nsprefix_ + ':' if (UseCapturedNS_ and self.service_type_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sservice_type>%s</%sservice_type>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.service_type), input_name='service_type')), namespaceprefix_ , eol_))
        if self.shipment_status is not None:
            namespaceprefix_ = self.shipment_status_nsprefix_ + ':' if (UseCapturedNS_ and self.shipment_status_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sshipment_status>%s</%sshipment_status>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.shipment_status), input_name='shipment_status')), namespaceprefix_ , eol_))
        if self.shipper_num is not None:
            namespaceprefix_ = self.shipper_num_nsprefix_ + ':' if (UseCapturedNS_ and self.shipper_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sshipper_num>%s</%sshipper_num>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.shipper_num), input_name='shipper_num')), namespaceprefix_ , eol_))
        if self.shipping_date is not None:
            namespaceprefix_ = self.shipping_date_nsprefix_ + ':' if (UseCapturedNS_ and self.shipping_date_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sshipping_date>%s</%sshipping_date>%s' % (namespaceprefix_ , self.gds_format_datetime(self.shipping_date, input_name='shipping_date'), namespaceprefix_ , eol_))
        if self.subtotal is not None:
            namespaceprefix_ = self.subtotal_nsprefix_ + ':' if (UseCapturedNS_ and self.subtotal_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssubtotal>%s</%ssubtotal>%s' % (namespaceprefix_ , self.gds_format_float(self.subtotal, input_name='subtotal'), namespaceprefix_ , eol_))
        if self.subtotal_with_handling is not None:
            namespaceprefix_ = self.subtotal_with_handling_nsprefix_ + ':' if (UseCapturedNS_ and self.subtotal_with_handling_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssubtotal_with_handling>%s</%ssubtotal_with_handling>%s' % (namespaceprefix_ , self.gds_format_float(self.subtotal_with_handling, input_name='subtotal_with_handling'), namespaceprefix_ , eol_))
        if self.tax_charge_1 is not None:
            namespaceprefix_ = self.tax_charge_1_nsprefix_ + ':' if (UseCapturedNS_ and self.tax_charge_1_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stax_charge_1>%s</%stax_charge_1>%s' % (namespaceprefix_ , self.gds_format_float(self.tax_charge_1, input_name='tax_charge_1'), namespaceprefix_ , eol_))
        if self.tax_charge_2 is not None:
            namespaceprefix_ = self.tax_charge_2_nsprefix_ + ':' if (UseCapturedNS_ and self.tax_charge_2_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stax_charge_2>%s</%stax_charge_2>%s' % (namespaceprefix_ , self.gds_format_float(self.tax_charge_2, input_name='tax_charge_2'), namespaceprefix_ , eol_))
        if self.tax_code_1 is not None:
            namespaceprefix_ = self.tax_code_1_nsprefix_ + ':' if (UseCapturedNS_ and self.tax_code_1_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stax_code_1>%s</%stax_code_1>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.tax_code_1), input_name='tax_code_1')), namespaceprefix_ , eol_))
        if self.tax_code_2 is not None:
            namespaceprefix_ = self.tax_code_2_nsprefix_ + ':' if (UseCapturedNS_ and self.tax_code_2_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stax_code_2>%s</%stax_code_2>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.tax_code_2), input_name='tax_code_2')), namespaceprefix_ , eol_))
        if self.total is not None:
            namespaceprefix_ = self.total_nsprefix_ + ':' if (UseCapturedNS_ and self.total_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stotal>%s</%stotal>%s' % (namespaceprefix_ , self.gds_format_float(self.total, input_name='total'), namespaceprefix_ , eol_))
        if self.total_with_handling is not None:
            namespaceprefix_ = self.total_with_handling_nsprefix_ + ':' if (UseCapturedNS_ and self.total_with_handling_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stotal_with_handling>%s</%stotal_with_handling>%s' % (namespaceprefix_ , self.gds_format_float(self.total_with_handling, input_name='total_with_handling'), namespaceprefix_ , eol_))
        if self.transit_time is not None:
            namespaceprefix_ = self.transit_time_nsprefix_ + ':' if (UseCapturedNS_ and self.transit_time_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stransit_time>%s</%stransit_time>%s' % (namespaceprefix_ , self.gds_format_integer(self.transit_time, input_name='transit_time'), namespaceprefix_ , eol_))
        if self.transit_time_guaranteed is not None:
            namespaceprefix_ = self.transit_time_guaranteed_nsprefix_ + ':' if (UseCapturedNS_ and self.transit_time_guaranteed_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stransit_time_guaranteed>%s</%stransit_time_guaranteed>%s' % (namespaceprefix_ , self.gds_format_boolean(self.transit_time_guaranteed, input_name='transit_time_guaranteed'), namespaceprefix_ , eol_))
        if self.updated_on is not None:
            namespaceprefix_ = self.updated_on_nsprefix_ + ':' if (UseCapturedNS_ and self.updated_on_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%supdated_on>%s</%supdated_on>%s' % (namespaceprefix_ , self.gds_format_datetime(self.updated_on, input_name='updated_on'), namespaceprefix_ , eol_))
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
        if self.voided is not None:
            namespaceprefix_ = self.voided_nsprefix_ + ':' if (UseCapturedNS_ and self.voided_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svoided>%s</%svoided>%s' % (namespaceprefix_ , self.gds_format_boolean(self.voided, input_name='voided'), namespaceprefix_ , eol_))
        if self.xc_charge is not None:
            namespaceprefix_ = self.xc_charge_nsprefix_ + ':' if (UseCapturedNS_ and self.xc_charge_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxc_charge>%s</%sxc_charge>%s' % (namespaceprefix_ , self.gds_format_float(self.xc_charge, input_name='xc_charge'), namespaceprefix_ , eol_))
        if self.zone is not None:
            namespaceprefix_ = self.zone_nsprefix_ + ':' if (UseCapturedNS_ and self.zone_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%szone>%s</%szone>%s' % (namespaceprefix_ , self.gds_format_integer(self.zone, input_name='zone'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'airport_code':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'airport_code')
            value_ = self.gds_validate_string(value_, node, 'airport_code')
            self.airport_code = value_
            self.airport_code_nsprefix_ = child_.prefix
        elif nodeName_ == 'billed_weight' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'billed_weight')
            fval_ = self.gds_validate_float(fval_, node, 'billed_weight')
            self.billed_weight = fval_
            self.billed_weight_nsprefix_ = child_.prefix
        elif nodeName_ == 'billed_weight_unit':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'billed_weight_unit')
            value_ = self.gds_validate_string(value_, node, 'billed_weight_unit')
            self.billed_weight_unit = value_
            self.billed_weight_unit_nsprefix_ = child_.prefix
        elif nodeName_ == 'cod_charge' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'cod_charge')
            fval_ = self.gds_validate_float(fval_, node, 'cod_charge')
            self.cod_charge = fval_
            self.cod_charge_nsprefix_ = child_.prefix
        elif nodeName_ == 'cod_type':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cod_type')
            value_ = self.gds_validate_string(value_, node, 'cod_type')
            self.cod_type = value_
            self.cod_type_nsprefix_ = child_.prefix
        elif nodeName_ == 'collect':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'collect')
            ival_ = self.gds_validate_boolean(ival_, node, 'collect')
            self.collect = ival_
            self.collect_nsprefix_ = child_.prefix
        elif nodeName_ == 'collect_charge' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'collect_charge')
            fval_ = self.gds_validate_float(fval_, node, 'collect_charge')
            self.collect_charge = fval_
            self.collect_charge_nsprefix_ = child_.prefix
        elif nodeName_ == 'collect_shipper_num':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'collect_shipper_num')
            value_ = self.gds_validate_string(value_, node, 'collect_shipper_num')
            self.collect_shipper_num = value_
            self.collect_shipper_num_nsprefix_ = child_.prefix
        elif nodeName_ == 'consolidation_type':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'consolidation_type')
            value_ = self.gds_validate_string(value_, node, 'consolidation_type')
            self.consolidation_type = value_
            self.consolidation_type_nsprefix_ = child_.prefix
        elif nodeName_ == 'cos':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'cos')
            ival_ = self.gds_validate_boolean(ival_, node, 'cos')
            self.cos = ival_
            self.cos_nsprefix_ = child_.prefix
        elif nodeName_ == 'cos_charge' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'cos_charge')
            fval_ = self.gds_validate_float(fval_, node, 'cos_charge')
            self.cos_charge = fval_
            self.cos_charge_nsprefix_ = child_.prefix
        elif nodeName_ == 'delivery_address':
            obj_ = Address.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.delivery_address = obj_
            obj_.original_tagname_ = 'delivery_address'
        elif nodeName_ == 'description':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'description')
            value_ = self.gds_validate_string(value_, node, 'description')
            self.description = value_
            self.description_nsprefix_ = child_.prefix
        elif nodeName_ == 'dg':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'dg')
            ival_ = self.gds_validate_boolean(ival_, node, 'dg')
            self.dg = ival_
            self.dg_nsprefix_ = child_.prefix
        elif nodeName_ == 'dg_charge' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'dg_charge')
            fval_ = self.gds_validate_float(fval_, node, 'dg_charge')
            self.dg_charge = fval_
            self.dg_charge_nsprefix_ = child_.prefix
        elif nodeName_ == 'dimention_unit':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'dimention_unit')
            value_ = self.gds_validate_string(value_, node, 'dimention_unit')
            self.dimention_unit = value_
            self.dimention_unit_nsprefix_ = child_.prefix
        elif nodeName_ == 'dv_charge' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'dv_charge')
            fval_ = self.gds_validate_float(fval_, node, 'dv_charge')
            self.dv_charge = fval_
            self.dv_charge_nsprefix_ = child_.prefix
        elif nodeName_ == 'ea_charge' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'ea_charge')
            fval_ = self.gds_validate_float(fval_, node, 'ea_charge')
            self.ea_charge = fval_
            self.ea_charge_nsprefix_ = child_.prefix
        elif nodeName_ == 'ea_zone' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'ea_zone')
            ival_ = self.gds_validate_integer(ival_, node, 'ea_zone')
            self.ea_zone = ival_
            self.ea_zone_nsprefix_ = child_.prefix
        elif nodeName_ == 'estimated_delivery_date':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.estimated_delivery_date = dval_
            self.estimated_delivery_date_nsprefix_ = child_.prefix
        elif nodeName_ == 'freight_charge' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'freight_charge')
            fval_ = self.gds_validate_float(fval_, node, 'freight_charge')
            self.freight_charge = fval_
            self.freight_charge_nsprefix_ = child_.prefix
        elif nodeName_ == 'fuel_surcharge' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'fuel_surcharge')
            fval_ = self.gds_validate_float(fval_, node, 'fuel_surcharge')
            self.fuel_surcharge = fval_
            self.fuel_surcharge_nsprefix_ = child_.prefix
        elif nodeName_ == 'handling' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'handling')
            fval_ = self.gds_validate_float(fval_, node, 'handling')
            self.handling = fval_
            self.handling_nsprefix_ = child_.prefix
        elif nodeName_ == 'handling_type':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'handling_type')
            value_ = self.gds_validate_string(value_, node, 'handling_type')
            self.handling_type = value_
            self.handling_type_nsprefix_ = child_.prefix
        elif nodeName_ == 'id' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'id')
            ival_ = self.gds_validate_integer(ival_, node, 'id')
            self.id = ival_
            self.id_nsprefix_ = child_.prefix
        elif nodeName_ == 'inserted_on':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.inserted_on = dval_
            self.inserted_on_nsprefix_ = child_.prefix
        elif nodeName_ == 'instruction':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'instruction')
            value_ = self.gds_validate_string(value_, node, 'instruction')
            self.instruction = value_
            self.instruction_nsprefix_ = child_.prefix
        elif nodeName_ == 'lg_charge' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'lg_charge')
            fval_ = self.gds_validate_float(fval_, node, 'lg_charge')
            self.lg_charge = fval_
            self.lg_charge_nsprefix_ = child_.prefix
        elif nodeName_ == 'manifest_num':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'manifest_num')
            value_ = self.gds_validate_string(value_, node, 'manifest_num')
            self.manifest_num = value_
            self.manifest_num_nsprefix_ = child_.prefix
        elif nodeName_ == 'nsr':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'nsr')
            ival_ = self.gds_validate_boolean(ival_, node, 'nsr')
            self.nsr = ival_
            self.nsr_nsprefix_ = child_.prefix
        elif nodeName_ == 'order_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'order_id')
            value_ = self.gds_validate_string(value_, node, 'order_id')
            self.order_id = value_
            self.order_id_nsprefix_ = child_.prefix
        elif nodeName_ == 'over_size_charge' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'over_size_charge')
            fval_ = self.gds_validate_float(fval_, node, 'over_size_charge')
            self.over_size_charge = fval_
            self.over_size_charge_nsprefix_ = child_.prefix
        elif nodeName_ == 'over_weight_charge' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'over_weight_charge')
            fval_ = self.gds_validate_float(fval_, node, 'over_weight_charge')
            self.over_weight_charge = fval_
            self.over_weight_charge_nsprefix_ = child_.prefix
        elif nodeName_ == 'packages':
            obj_ = Package.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.packages.append(obj_)
            obj_.original_tagname_ = 'packages'
        elif nodeName_ == 'pickup_address':
            obj_ = Address.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.pickup_address = obj_
            obj_.original_tagname_ = 'pickup_address'
        elif nodeName_ == 'premium':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'premium')
            value_ = self.gds_validate_string(value_, node, 'premium')
            self.premium = value_
            self.premium_nsprefix_ = child_.prefix
        elif nodeName_ == 'premium_charge' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'premium_charge')
            fval_ = self.gds_validate_float(fval_, node, 'premium_charge')
            self.premium_charge = fval_
            self.premium_charge_nsprefix_ = child_.prefix
        elif nodeName_ == 'proforma':
            obj_ = Proforma.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.proforma = obj_
            obj_.original_tagname_ = 'proforma'
        elif nodeName_ == 'ra_charge' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'ra_charge')
            fval_ = self.gds_validate_float(fval_, node, 'ra_charge')
            self.ra_charge = fval_
            self.ra_charge_nsprefix_ = child_.prefix
        elif nodeName_ == 'reported_weight_unit':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'reported_weight_unit')
            value_ = self.gds_validate_string(value_, node, 'reported_weight_unit')
            self.reported_weight_unit = value_
            self.reported_weight_unit_nsprefix_ = child_.prefix
        elif nodeName_ == 'rural_charge' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'rural_charge')
            fval_ = self.gds_validate_float(fval_, node, 'rural_charge')
            self.rural_charge = fval_
            self.rural_charge_nsprefix_ = child_.prefix
        elif nodeName_ == 'send_email_to_delivery':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'send_email_to_delivery')
            ival_ = self.gds_validate_boolean(ival_, node, 'send_email_to_delivery')
            self.send_email_to_delivery = ival_
            self.send_email_to_delivery_nsprefix_ = child_.prefix
        elif nodeName_ == 'send_email_to_pickup':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'send_email_to_pickup')
            ival_ = self.gds_validate_boolean(ival_, node, 'send_email_to_pickup')
            self.send_email_to_pickup = ival_
            self.send_email_to_pickup_nsprefix_ = child_.prefix
        elif nodeName_ == 'service_type':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'service_type')
            value_ = self.gds_validate_string(value_, node, 'service_type')
            self.service_type = value_
            self.service_type_nsprefix_ = child_.prefix
        elif nodeName_ == 'shipment_status':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'shipment_status')
            value_ = self.gds_validate_string(value_, node, 'shipment_status')
            self.shipment_status = value_
            self.shipment_status_nsprefix_ = child_.prefix
        elif nodeName_ == 'shipper_num':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'shipper_num')
            value_ = self.gds_validate_string(value_, node, 'shipper_num')
            self.shipper_num = value_
            self.shipper_num_nsprefix_ = child_.prefix
        elif nodeName_ == 'shipping_date':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.shipping_date = dval_
            self.shipping_date_nsprefix_ = child_.prefix
        elif nodeName_ == 'subtotal' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'subtotal')
            fval_ = self.gds_validate_float(fval_, node, 'subtotal')
            self.subtotal = fval_
            self.subtotal_nsprefix_ = child_.prefix
        elif nodeName_ == 'subtotal_with_handling' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'subtotal_with_handling')
            fval_ = self.gds_validate_float(fval_, node, 'subtotal_with_handling')
            self.subtotal_with_handling = fval_
            self.subtotal_with_handling_nsprefix_ = child_.prefix
        elif nodeName_ == 'tax_charge_1' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'tax_charge_1')
            fval_ = self.gds_validate_float(fval_, node, 'tax_charge_1')
            self.tax_charge_1 = fval_
            self.tax_charge_1_nsprefix_ = child_.prefix
        elif nodeName_ == 'tax_charge_2' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'tax_charge_2')
            fval_ = self.gds_validate_float(fval_, node, 'tax_charge_2')
            self.tax_charge_2 = fval_
            self.tax_charge_2_nsprefix_ = child_.prefix
        elif nodeName_ == 'tax_code_1':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'tax_code_1')
            value_ = self.gds_validate_string(value_, node, 'tax_code_1')
            self.tax_code_1 = value_
            self.tax_code_1_nsprefix_ = child_.prefix
        elif nodeName_ == 'tax_code_2':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'tax_code_2')
            value_ = self.gds_validate_string(value_, node, 'tax_code_2')
            self.tax_code_2 = value_
            self.tax_code_2_nsprefix_ = child_.prefix
        elif nodeName_ == 'total' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'total')
            fval_ = self.gds_validate_float(fval_, node, 'total')
            self.total = fval_
            self.total_nsprefix_ = child_.prefix
        elif nodeName_ == 'total_with_handling' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'total_with_handling')
            fval_ = self.gds_validate_float(fval_, node, 'total_with_handling')
            self.total_with_handling = fval_
            self.total_with_handling_nsprefix_ = child_.prefix
        elif nodeName_ == 'transit_time' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'transit_time')
            ival_ = self.gds_validate_integer(ival_, node, 'transit_time')
            self.transit_time = ival_
            self.transit_time_nsprefix_ = child_.prefix
        elif nodeName_ == 'transit_time_guaranteed':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'transit_time_guaranteed')
            ival_ = self.gds_validate_boolean(ival_, node, 'transit_time_guaranteed')
            self.transit_time_guaranteed = ival_
            self.transit_time_guaranteed_nsprefix_ = child_.prefix
        elif nodeName_ == 'updated_on':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.updated_on = dval_
            self.updated_on_nsprefix_ = child_.prefix
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
        elif nodeName_ == 'voided':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'voided')
            ival_ = self.gds_validate_boolean(ival_, node, 'voided')
            self.voided = ival_
            self.voided_nsprefix_ = child_.prefix
        elif nodeName_ == 'xc_charge' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'xc_charge')
            fval_ = self.gds_validate_float(fval_, node, 'xc_charge')
            self.xc_charge = fval_
            self.xc_charge_nsprefix_ = child_.prefix
        elif nodeName_ == 'zone' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'zone')
            ival_ = self.gds_validate_integer(ival_, node, 'zone')
            self.zone = ival_
            self.zone_nsprefix_ = child_.prefix
# end class Shipment


class Package(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, alternative_reference=None, barcode=None, billed_weight=None, cod=None, cost_centre=None, declared_value=None, dim_weight=None, dim_weight_flag=None, height=None, id=None, inserted_on=None, length=None, lg=None, min_weight_flag=None, over_size=None, over_weight=None, package_num=None, package_reference=None, reference=None, reported_weight=None, store_num=None, updated_on=None, width=None, xc=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.alternative_reference = alternative_reference
        self.alternative_reference_nsprefix_ = None
        self.barcode = barcode
        self.barcode_nsprefix_ = None
        self.billed_weight = billed_weight
        self.billed_weight_nsprefix_ = None
        self.cod = cod
        self.cod_nsprefix_ = None
        self.cost_centre = cost_centre
        self.cost_centre_nsprefix_ = None
        self.declared_value = declared_value
        self.declared_value_nsprefix_ = None
        self.dim_weight = dim_weight
        self.dim_weight_nsprefix_ = None
        self.dim_weight_flag = dim_weight_flag
        self.dim_weight_flag_nsprefix_ = None
        self.height = height
        self.height_nsprefix_ = None
        self.id = id
        self.id_nsprefix_ = None
        if isinstance(inserted_on, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(inserted_on, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = inserted_on
        self.inserted_on = initvalue_
        self.inserted_on_nsprefix_ = None
        self.length = length
        self.length_nsprefix_ = None
        self.lg = lg
        self.lg_nsprefix_ = None
        self.min_weight_flag = min_weight_flag
        self.min_weight_flag_nsprefix_ = None
        self.over_size = over_size
        self.over_size_nsprefix_ = None
        self.over_weight = over_weight
        self.over_weight_nsprefix_ = None
        self.package_num = package_num
        self.package_num_nsprefix_ = None
        self.package_reference = package_reference
        self.package_reference_nsprefix_ = None
        self.reference = reference
        self.reference_nsprefix_ = None
        self.reported_weight = reported_weight
        self.reported_weight_nsprefix_ = None
        self.store_num = store_num
        self.store_num_nsprefix_ = None
        if isinstance(updated_on, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(updated_on, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = updated_on
        self.updated_on = initvalue_
        self.updated_on_nsprefix_ = None
        self.width = width
        self.width_nsprefix_ = None
        self.xc = xc
        self.xc_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Package)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Package.subclass:
            return Package.subclass(*args_, **kwargs_)
        else:
            return Package(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_alternative_reference(self):
        return self.alternative_reference
    def set_alternative_reference(self, alternative_reference):
        self.alternative_reference = alternative_reference
    def get_barcode(self):
        return self.barcode
    def set_barcode(self, barcode):
        self.barcode = barcode
    def get_billed_weight(self):
        return self.billed_weight
    def set_billed_weight(self, billed_weight):
        self.billed_weight = billed_weight
    def get_cod(self):
        return self.cod
    def set_cod(self, cod):
        self.cod = cod
    def get_cost_centre(self):
        return self.cost_centre
    def set_cost_centre(self, cost_centre):
        self.cost_centre = cost_centre
    def get_declared_value(self):
        return self.declared_value
    def set_declared_value(self, declared_value):
        self.declared_value = declared_value
    def get_dim_weight(self):
        return self.dim_weight
    def set_dim_weight(self, dim_weight):
        self.dim_weight = dim_weight
    def get_dim_weight_flag(self):
        return self.dim_weight_flag
    def set_dim_weight_flag(self, dim_weight_flag):
        self.dim_weight_flag = dim_weight_flag
    def get_height(self):
        return self.height
    def set_height(self, height):
        self.height = height
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_inserted_on(self):
        return self.inserted_on
    def set_inserted_on(self, inserted_on):
        self.inserted_on = inserted_on
    def get_length(self):
        return self.length
    def set_length(self, length):
        self.length = length
    def get_lg(self):
        return self.lg
    def set_lg(self, lg):
        self.lg = lg
    def get_min_weight_flag(self):
        return self.min_weight_flag
    def set_min_weight_flag(self, min_weight_flag):
        self.min_weight_flag = min_weight_flag
    def get_over_size(self):
        return self.over_size
    def set_over_size(self, over_size):
        self.over_size = over_size
    def get_over_weight(self):
        return self.over_weight
    def set_over_weight(self, over_weight):
        self.over_weight = over_weight
    def get_package_num(self):
        return self.package_num
    def set_package_num(self, package_num):
        self.package_num = package_num
    def get_package_reference(self):
        return self.package_reference
    def set_package_reference(self, package_reference):
        self.package_reference = package_reference
    def get_reference(self):
        return self.reference
    def set_reference(self, reference):
        self.reference = reference
    def get_reported_weight(self):
        return self.reported_weight
    def set_reported_weight(self, reported_weight):
        self.reported_weight = reported_weight
    def get_store_num(self):
        return self.store_num
    def set_store_num(self, store_num):
        self.store_num = store_num
    def get_updated_on(self):
        return self.updated_on
    def set_updated_on(self, updated_on):
        self.updated_on = updated_on
    def get_width(self):
        return self.width
    def set_width(self, width):
        self.width = width
    def get_xc(self):
        return self.xc
    def set_xc(self, xc):
        self.xc = xc
    def hasContent_(self):
        if (
            self.alternative_reference is not None or
            self.barcode is not None or
            self.billed_weight is not None or
            self.cod is not None or
            self.cost_centre is not None or
            self.declared_value is not None or
            self.dim_weight is not None or
            self.dim_weight_flag is not None or
            self.height is not None or
            self.id is not None or
            self.inserted_on is not None or
            self.length is not None or
            self.lg is not None or
            self.min_weight_flag is not None or
            self.over_size is not None or
            self.over_weight is not None or
            self.package_num is not None or
            self.package_reference is not None or
            self.reference is not None or
            self.reported_weight is not None or
            self.store_num is not None or
            self.updated_on is not None or
            self.width is not None or
            self.xc is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Package', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Package')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Package':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Package')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Package', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Package'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Package', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.alternative_reference is not None:
            namespaceprefix_ = self.alternative_reference_nsprefix_ + ':' if (UseCapturedNS_ and self.alternative_reference_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%salternative_reference>%s</%salternative_reference>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.alternative_reference), input_name='alternative_reference')), namespaceprefix_ , eol_))
        if self.barcode is not None:
            namespaceprefix_ = self.barcode_nsprefix_ + ':' if (UseCapturedNS_ and self.barcode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbarcode>%s</%sbarcode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.barcode), input_name='barcode')), namespaceprefix_ , eol_))
        if self.billed_weight is not None:
            namespaceprefix_ = self.billed_weight_nsprefix_ + ':' if (UseCapturedNS_ and self.billed_weight_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbilled_weight>%s</%sbilled_weight>%s' % (namespaceprefix_ , self.gds_format_float(self.billed_weight, input_name='billed_weight'), namespaceprefix_ , eol_))
        if self.cod is not None:
            namespaceprefix_ = self.cod_nsprefix_ + ':' if (UseCapturedNS_ and self.cod_nsprefix_) else ''
            self.cod.export(outfile, level, namespaceprefix_, namespacedef_='', name_='cod', pretty_print=pretty_print)
        if self.cost_centre is not None:
            namespaceprefix_ = self.cost_centre_nsprefix_ + ':' if (UseCapturedNS_ and self.cost_centre_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scost_centre>%s</%scost_centre>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cost_centre), input_name='cost_centre')), namespaceprefix_ , eol_))
        if self.declared_value is not None:
            namespaceprefix_ = self.declared_value_nsprefix_ + ':' if (UseCapturedNS_ and self.declared_value_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdeclared_value>%s</%sdeclared_value>%s' % (namespaceprefix_ , self.gds_format_float(self.declared_value, input_name='declared_value'), namespaceprefix_ , eol_))
        if self.dim_weight is not None:
            namespaceprefix_ = self.dim_weight_nsprefix_ + ':' if (UseCapturedNS_ and self.dim_weight_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdim_weight>%s</%sdim_weight>%s' % (namespaceprefix_ , self.gds_format_float(self.dim_weight, input_name='dim_weight'), namespaceprefix_ , eol_))
        if self.dim_weight_flag is not None:
            namespaceprefix_ = self.dim_weight_flag_nsprefix_ + ':' if (UseCapturedNS_ and self.dim_weight_flag_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdim_weight_flag>%s</%sdim_weight_flag>%s' % (namespaceprefix_ , self.gds_format_boolean(self.dim_weight_flag, input_name='dim_weight_flag'), namespaceprefix_ , eol_))
        if self.height is not None:
            namespaceprefix_ = self.height_nsprefix_ + ':' if (UseCapturedNS_ and self.height_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sheight>%s</%sheight>%s' % (namespaceprefix_ , self.gds_format_float(self.height, input_name='height'), namespaceprefix_ , eol_))
        if self.id is not None:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sid>%s</%sid>%s' % (namespaceprefix_ , self.gds_format_integer(self.id, input_name='id'), namespaceprefix_ , eol_))
        if self.inserted_on is not None:
            namespaceprefix_ = self.inserted_on_nsprefix_ + ':' if (UseCapturedNS_ and self.inserted_on_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sinserted_on>%s</%sinserted_on>%s' % (namespaceprefix_ , self.gds_format_datetime(self.inserted_on, input_name='inserted_on'), namespaceprefix_ , eol_))
        if self.length is not None:
            namespaceprefix_ = self.length_nsprefix_ + ':' if (UseCapturedNS_ and self.length_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slength>%s</%slength>%s' % (namespaceprefix_ , self.gds_format_float(self.length, input_name='length'), namespaceprefix_ , eol_))
        if self.lg is not None:
            namespaceprefix_ = self.lg_nsprefix_ + ':' if (UseCapturedNS_ and self.lg_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slg>%s</%slg>%s' % (namespaceprefix_ , self.gds_format_boolean(self.lg, input_name='lg'), namespaceprefix_ , eol_))
        if self.min_weight_flag is not None:
            namespaceprefix_ = self.min_weight_flag_nsprefix_ + ':' if (UseCapturedNS_ and self.min_weight_flag_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smin_weight_flag>%s</%smin_weight_flag>%s' % (namespaceprefix_ , self.gds_format_boolean(self.min_weight_flag, input_name='min_weight_flag'), namespaceprefix_ , eol_))
        if self.over_size is not None:
            namespaceprefix_ = self.over_size_nsprefix_ + ':' if (UseCapturedNS_ and self.over_size_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sover_size>%s</%sover_size>%s' % (namespaceprefix_ , self.gds_format_boolean(self.over_size, input_name='over_size'), namespaceprefix_ , eol_))
        if self.over_weight is not None:
            namespaceprefix_ = self.over_weight_nsprefix_ + ':' if (UseCapturedNS_ and self.over_weight_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sover_weight>%s</%sover_weight>%s' % (namespaceprefix_ , self.gds_format_boolean(self.over_weight, input_name='over_weight'), namespaceprefix_ , eol_))
        if self.package_num is not None:
            namespaceprefix_ = self.package_num_nsprefix_ + ':' if (UseCapturedNS_ and self.package_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spackage_num>%s</%spackage_num>%s' % (namespaceprefix_ , self.gds_format_integer(self.package_num, input_name='package_num'), namespaceprefix_ , eol_))
        if self.package_reference is not None:
            namespaceprefix_ = self.package_reference_nsprefix_ + ':' if (UseCapturedNS_ and self.package_reference_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spackage_reference>%s</%spackage_reference>%s' % (namespaceprefix_ , self.gds_format_integer(self.package_reference, input_name='package_reference'), namespaceprefix_ , eol_))
        if self.reference is not None:
            namespaceprefix_ = self.reference_nsprefix_ + ':' if (UseCapturedNS_ and self.reference_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sreference>%s</%sreference>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.reference), input_name='reference')), namespaceprefix_ , eol_))
        if self.reported_weight is not None:
            namespaceprefix_ = self.reported_weight_nsprefix_ + ':' if (UseCapturedNS_ and self.reported_weight_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sreported_weight>%s</%sreported_weight>%s' % (namespaceprefix_ , self.gds_format_float(self.reported_weight, input_name='reported_weight'), namespaceprefix_ , eol_))
        if self.store_num is not None:
            namespaceprefix_ = self.store_num_nsprefix_ + ':' if (UseCapturedNS_ and self.store_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstore_num>%s</%sstore_num>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.store_num), input_name='store_num')), namespaceprefix_ , eol_))
        if self.updated_on is not None:
            namespaceprefix_ = self.updated_on_nsprefix_ + ':' if (UseCapturedNS_ and self.updated_on_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%supdated_on>%s</%supdated_on>%s' % (namespaceprefix_ , self.gds_format_datetime(self.updated_on, input_name='updated_on'), namespaceprefix_ , eol_))
        if self.width is not None:
            namespaceprefix_ = self.width_nsprefix_ + ':' if (UseCapturedNS_ and self.width_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%swidth>%s</%swidth>%s' % (namespaceprefix_ , self.gds_format_float(self.width, input_name='width'), namespaceprefix_ , eol_))
        if self.xc is not None:
            namespaceprefix_ = self.xc_nsprefix_ + ':' if (UseCapturedNS_ and self.xc_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxc>%s</%sxc>%s' % (namespaceprefix_ , self.gds_format_boolean(self.xc, input_name='xc'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'alternative_reference':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'alternative_reference')
            value_ = self.gds_validate_string(value_, node, 'alternative_reference')
            self.alternative_reference = value_
            self.alternative_reference_nsprefix_ = child_.prefix
        elif nodeName_ == 'barcode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'barcode')
            value_ = self.gds_validate_string(value_, node, 'barcode')
            self.barcode = value_
            self.barcode_nsprefix_ = child_.prefix
        elif nodeName_ == 'billed_weight' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'billed_weight')
            fval_ = self.gds_validate_float(fval_, node, 'billed_weight')
            self.billed_weight = fval_
            self.billed_weight_nsprefix_ = child_.prefix
        elif nodeName_ == 'cod':
            obj_ = COD.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.cod = obj_
            obj_.original_tagname_ = 'cod'
        elif nodeName_ == 'cost_centre':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cost_centre')
            value_ = self.gds_validate_string(value_, node, 'cost_centre')
            self.cost_centre = value_
            self.cost_centre_nsprefix_ = child_.prefix
        elif nodeName_ == 'declared_value' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'declared_value')
            fval_ = self.gds_validate_float(fval_, node, 'declared_value')
            self.declared_value = fval_
            self.declared_value_nsprefix_ = child_.prefix
        elif nodeName_ == 'dim_weight' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'dim_weight')
            fval_ = self.gds_validate_float(fval_, node, 'dim_weight')
            self.dim_weight = fval_
            self.dim_weight_nsprefix_ = child_.prefix
        elif nodeName_ == 'dim_weight_flag':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'dim_weight_flag')
            ival_ = self.gds_validate_boolean(ival_, node, 'dim_weight_flag')
            self.dim_weight_flag = ival_
            self.dim_weight_flag_nsprefix_ = child_.prefix
        elif nodeName_ == 'height' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'height')
            fval_ = self.gds_validate_float(fval_, node, 'height')
            self.height = fval_
            self.height_nsprefix_ = child_.prefix
        elif nodeName_ == 'id' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'id')
            ival_ = self.gds_validate_integer(ival_, node, 'id')
            self.id = ival_
            self.id_nsprefix_ = child_.prefix
        elif nodeName_ == 'inserted_on':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.inserted_on = dval_
            self.inserted_on_nsprefix_ = child_.prefix
        elif nodeName_ == 'length' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'length')
            fval_ = self.gds_validate_float(fval_, node, 'length')
            self.length = fval_
            self.length_nsprefix_ = child_.prefix
        elif nodeName_ == 'lg':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'lg')
            ival_ = self.gds_validate_boolean(ival_, node, 'lg')
            self.lg = ival_
            self.lg_nsprefix_ = child_.prefix
        elif nodeName_ == 'min_weight_flag':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'min_weight_flag')
            ival_ = self.gds_validate_boolean(ival_, node, 'min_weight_flag')
            self.min_weight_flag = ival_
            self.min_weight_flag_nsprefix_ = child_.prefix
        elif nodeName_ == 'over_size':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'over_size')
            ival_ = self.gds_validate_boolean(ival_, node, 'over_size')
            self.over_size = ival_
            self.over_size_nsprefix_ = child_.prefix
        elif nodeName_ == 'over_weight':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'over_weight')
            ival_ = self.gds_validate_boolean(ival_, node, 'over_weight')
            self.over_weight = ival_
            self.over_weight_nsprefix_ = child_.prefix
        elif nodeName_ == 'package_num' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'package_num')
            ival_ = self.gds_validate_integer(ival_, node, 'package_num')
            self.package_num = ival_
            self.package_num_nsprefix_ = child_.prefix
        elif nodeName_ == 'package_reference' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'package_reference')
            ival_ = self.gds_validate_integer(ival_, node, 'package_reference')
            self.package_reference = ival_
            self.package_reference_nsprefix_ = child_.prefix
        elif nodeName_ == 'reference':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'reference')
            value_ = self.gds_validate_string(value_, node, 'reference')
            self.reference = value_
            self.reference_nsprefix_ = child_.prefix
        elif nodeName_ == 'reported_weight' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'reported_weight')
            fval_ = self.gds_validate_float(fval_, node, 'reported_weight')
            self.reported_weight = fval_
            self.reported_weight_nsprefix_ = child_.prefix
        elif nodeName_ == 'store_num':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'store_num')
            value_ = self.gds_validate_string(value_, node, 'store_num')
            self.store_num = value_
            self.store_num_nsprefix_ = child_.prefix
        elif nodeName_ == 'updated_on':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.updated_on = dval_
            self.updated_on_nsprefix_ = child_.prefix
        elif nodeName_ == 'width' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'width')
            fval_ = self.gds_validate_float(fval_, node, 'width')
            self.width = fval_
            self.width_nsprefix_ = child_.prefix
        elif nodeName_ == 'xc':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'xc')
            ival_ = self.gds_validate_boolean(ival_, node, 'xc')
            self.xc = ival_
            self.xc_nsprefix_ = child_.prefix
# end class Package


class COD(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, amount_1=None, amount_2=None, amount_3=None, id=None, inserted_on=None, post_dated_cheque_1=None, post_dated_cheque_2=None, post_dated_cheque_3=None, updated_on=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.amount_1 = amount_1
        self.amount_1_nsprefix_ = None
        self.amount_2 = amount_2
        self.amount_2_nsprefix_ = None
        self.amount_3 = amount_3
        self.amount_3_nsprefix_ = None
        self.id = id
        self.id_nsprefix_ = None
        if isinstance(inserted_on, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(inserted_on, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = inserted_on
        self.inserted_on = initvalue_
        self.inserted_on_nsprefix_ = None
        if isinstance(post_dated_cheque_1, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(post_dated_cheque_1, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = post_dated_cheque_1
        self.post_dated_cheque_1 = initvalue_
        self.post_dated_cheque_1_nsprefix_ = None
        if isinstance(post_dated_cheque_2, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(post_dated_cheque_2, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = post_dated_cheque_2
        self.post_dated_cheque_2 = initvalue_
        self.post_dated_cheque_2_nsprefix_ = None
        if isinstance(post_dated_cheque_3, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(post_dated_cheque_3, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = post_dated_cheque_3
        self.post_dated_cheque_3 = initvalue_
        self.post_dated_cheque_3_nsprefix_ = None
        if isinstance(updated_on, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(updated_on, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = updated_on
        self.updated_on = initvalue_
        self.updated_on_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, COD)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if COD.subclass:
            return COD.subclass(*args_, **kwargs_)
        else:
            return COD(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_amount_1(self):
        return self.amount_1
    def set_amount_1(self, amount_1):
        self.amount_1 = amount_1
    def get_amount_2(self):
        return self.amount_2
    def set_amount_2(self, amount_2):
        self.amount_2 = amount_2
    def get_amount_3(self):
        return self.amount_3
    def set_amount_3(self, amount_3):
        self.amount_3 = amount_3
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_inserted_on(self):
        return self.inserted_on
    def set_inserted_on(self, inserted_on):
        self.inserted_on = inserted_on
    def get_post_dated_cheque_1(self):
        return self.post_dated_cheque_1
    def set_post_dated_cheque_1(self, post_dated_cheque_1):
        self.post_dated_cheque_1 = post_dated_cheque_1
    def get_post_dated_cheque_2(self):
        return self.post_dated_cheque_2
    def set_post_dated_cheque_2(self, post_dated_cheque_2):
        self.post_dated_cheque_2 = post_dated_cheque_2
    def get_post_dated_cheque_3(self):
        return self.post_dated_cheque_3
    def set_post_dated_cheque_3(self, post_dated_cheque_3):
        self.post_dated_cheque_3 = post_dated_cheque_3
    def get_updated_on(self):
        return self.updated_on
    def set_updated_on(self, updated_on):
        self.updated_on = updated_on
    def hasContent_(self):
        if (
            self.amount_1 is not None or
            self.amount_2 is not None or
            self.amount_3 is not None or
            self.id is not None or
            self.inserted_on is not None or
            self.post_dated_cheque_1 is not None or
            self.post_dated_cheque_2 is not None or
            self.post_dated_cheque_3 is not None or
            self.updated_on is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='COD', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('COD')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'COD':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='COD')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='COD', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='COD'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='COD', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.amount_1 is not None:
            namespaceprefix_ = self.amount_1_nsprefix_ + ':' if (UseCapturedNS_ and self.amount_1_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%samount_1>%s</%samount_1>%s' % (namespaceprefix_ , self.gds_format_float(self.amount_1, input_name='amount_1'), namespaceprefix_ , eol_))
        if self.amount_2 is not None:
            namespaceprefix_ = self.amount_2_nsprefix_ + ':' if (UseCapturedNS_ and self.amount_2_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%samount_2>%s</%samount_2>%s' % (namespaceprefix_ , self.gds_format_float(self.amount_2, input_name='amount_2'), namespaceprefix_ , eol_))
        if self.amount_3 is not None:
            namespaceprefix_ = self.amount_3_nsprefix_ + ':' if (UseCapturedNS_ and self.amount_3_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%samount_3>%s</%samount_3>%s' % (namespaceprefix_ , self.gds_format_float(self.amount_3, input_name='amount_3'), namespaceprefix_ , eol_))
        if self.id is not None:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sid>%s</%sid>%s' % (namespaceprefix_ , self.gds_format_integer(self.id, input_name='id'), namespaceprefix_ , eol_))
        if self.inserted_on is not None:
            namespaceprefix_ = self.inserted_on_nsprefix_ + ':' if (UseCapturedNS_ and self.inserted_on_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sinserted_on>%s</%sinserted_on>%s' % (namespaceprefix_ , self.gds_format_datetime(self.inserted_on, input_name='inserted_on'), namespaceprefix_ , eol_))
        if self.post_dated_cheque_1 is not None:
            namespaceprefix_ = self.post_dated_cheque_1_nsprefix_ + ':' if (UseCapturedNS_ and self.post_dated_cheque_1_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spost_dated_cheque_1>%s</%spost_dated_cheque_1>%s' % (namespaceprefix_ , self.gds_format_datetime(self.post_dated_cheque_1, input_name='post_dated_cheque_1'), namespaceprefix_ , eol_))
        if self.post_dated_cheque_2 is not None:
            namespaceprefix_ = self.post_dated_cheque_2_nsprefix_ + ':' if (UseCapturedNS_ and self.post_dated_cheque_2_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spost_dated_cheque_2>%s</%spost_dated_cheque_2>%s' % (namespaceprefix_ , self.gds_format_datetime(self.post_dated_cheque_2, input_name='post_dated_cheque_2'), namespaceprefix_ , eol_))
        if self.post_dated_cheque_3 is not None:
            namespaceprefix_ = self.post_dated_cheque_3_nsprefix_ + ':' if (UseCapturedNS_ and self.post_dated_cheque_3_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spost_dated_cheque_3>%s</%spost_dated_cheque_3>%s' % (namespaceprefix_ , self.gds_format_datetime(self.post_dated_cheque_3, input_name='post_dated_cheque_3'), namespaceprefix_ , eol_))
        if self.updated_on is not None:
            namespaceprefix_ = self.updated_on_nsprefix_ + ':' if (UseCapturedNS_ and self.updated_on_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%supdated_on>%s</%supdated_on>%s' % (namespaceprefix_ , self.gds_format_datetime(self.updated_on, input_name='updated_on'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'amount_1' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'amount_1')
            fval_ = self.gds_validate_float(fval_, node, 'amount_1')
            self.amount_1 = fval_
            self.amount_1_nsprefix_ = child_.prefix
        elif nodeName_ == 'amount_2' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'amount_2')
            fval_ = self.gds_validate_float(fval_, node, 'amount_2')
            self.amount_2 = fval_
            self.amount_2_nsprefix_ = child_.prefix
        elif nodeName_ == 'amount_3' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'amount_3')
            fval_ = self.gds_validate_float(fval_, node, 'amount_3')
            self.amount_3 = fval_
            self.amount_3_nsprefix_ = child_.prefix
        elif nodeName_ == 'id' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'id')
            ival_ = self.gds_validate_integer(ival_, node, 'id')
            self.id = ival_
            self.id_nsprefix_ = child_.prefix
        elif nodeName_ == 'inserted_on':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.inserted_on = dval_
            self.inserted_on_nsprefix_ = child_.prefix
        elif nodeName_ == 'post_dated_cheque_1':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.post_dated_cheque_1 = dval_
            self.post_dated_cheque_1_nsprefix_ = child_.prefix
        elif nodeName_ == 'post_dated_cheque_2':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.post_dated_cheque_2 = dval_
            self.post_dated_cheque_2_nsprefix_ = child_.prefix
        elif nodeName_ == 'post_dated_cheque_3':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.post_dated_cheque_3 = dval_
            self.post_dated_cheque_3_nsprefix_ = child_.prefix
        elif nodeName_ == 'updated_on':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.updated_on = dval_
            self.updated_on_nsprefix_ = child_.prefix
# end class COD


class Proforma(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, broker_address=None, business_num=None, currency_of_declared_value=None, extension=None, id=None, inserted_on=None, name=None, permit_num=None, phone=None, proforma_items=None, reason_for_export=None, reference=None, status=None, updated_on=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.broker_address = broker_address
        self.broker_address_nsprefix_ = None
        self.business_num = business_num
        self.business_num_nsprefix_ = None
        self.currency_of_declared_value = currency_of_declared_value
        self.currency_of_declared_value_nsprefix_ = None
        self.extension = extension
        self.extension_nsprefix_ = None
        self.id = id
        self.id_nsprefix_ = None
        if isinstance(inserted_on, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(inserted_on, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = inserted_on
        self.inserted_on = initvalue_
        self.inserted_on_nsprefix_ = None
        self.name = name
        self.name_nsprefix_ = None
        self.permit_num = permit_num
        self.permit_num_nsprefix_ = None
        self.phone = phone
        self.phone_nsprefix_ = None
        if proforma_items is None:
            self.proforma_items = []
        else:
            self.proforma_items = proforma_items
        self.proforma_items_nsprefix_ = None
        self.reason_for_export = reason_for_export
        self.reason_for_export_nsprefix_ = None
        self.reference = reference
        self.reference_nsprefix_ = None
        self.status = status
        self.status_nsprefix_ = None
        if isinstance(updated_on, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(updated_on, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = updated_on
        self.updated_on = initvalue_
        self.updated_on_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Proforma)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Proforma.subclass:
            return Proforma.subclass(*args_, **kwargs_)
        else:
            return Proforma(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_broker_address(self):
        return self.broker_address
    def set_broker_address(self, broker_address):
        self.broker_address = broker_address
    def get_business_num(self):
        return self.business_num
    def set_business_num(self, business_num):
        self.business_num = business_num
    def get_currency_of_declared_value(self):
        return self.currency_of_declared_value
    def set_currency_of_declared_value(self, currency_of_declared_value):
        self.currency_of_declared_value = currency_of_declared_value
    def get_extension(self):
        return self.extension
    def set_extension(self, extension):
        self.extension = extension
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_inserted_on(self):
        return self.inserted_on
    def set_inserted_on(self, inserted_on):
        self.inserted_on = inserted_on
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_permit_num(self):
        return self.permit_num
    def set_permit_num(self, permit_num):
        self.permit_num = permit_num
    def get_phone(self):
        return self.phone
    def set_phone(self, phone):
        self.phone = phone
    def get_proforma_items(self):
        return self.proforma_items
    def set_proforma_items(self, proforma_items):
        self.proforma_items = proforma_items
    def add_proforma_items(self, value):
        self.proforma_items.append(value)
    def insert_proforma_items_at(self, index, value):
        self.proforma_items.insert(index, value)
    def replace_proforma_items_at(self, index, value):
        self.proforma_items[index] = value
    def get_reason_for_export(self):
        return self.reason_for_export
    def set_reason_for_export(self, reason_for_export):
        self.reason_for_export = reason_for_export
    def get_reference(self):
        return self.reference
    def set_reference(self, reference):
        self.reference = reference
    def get_status(self):
        return self.status
    def set_status(self, status):
        self.status = status
    def get_updated_on(self):
        return self.updated_on
    def set_updated_on(self, updated_on):
        self.updated_on = updated_on
    def hasContent_(self):
        if (
            self.broker_address is not None or
            self.business_num is not None or
            self.currency_of_declared_value is not None or
            self.extension is not None or
            self.id is not None or
            self.inserted_on is not None or
            self.name is not None or
            self.permit_num is not None or
            self.phone is not None or
            self.proforma_items or
            self.reason_for_export is not None or
            self.reference is not None or
            self.status is not None or
            self.updated_on is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Proforma', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Proforma')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Proforma':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Proforma')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Proforma', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Proforma'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Proforma', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.broker_address is not None:
            namespaceprefix_ = self.broker_address_nsprefix_ + ':' if (UseCapturedNS_ and self.broker_address_nsprefix_) else ''
            self.broker_address.export(outfile, level, namespaceprefix_, namespacedef_='', name_='broker_address', pretty_print=pretty_print)
        if self.business_num is not None:
            namespaceprefix_ = self.business_num_nsprefix_ + ':' if (UseCapturedNS_ and self.business_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbusiness_num>%s</%sbusiness_num>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.business_num), input_name='business_num')), namespaceprefix_ , eol_))
        if self.currency_of_declared_value is not None:
            namespaceprefix_ = self.currency_of_declared_value_nsprefix_ + ':' if (UseCapturedNS_ and self.currency_of_declared_value_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scurrency_of_declared_value>%s</%scurrency_of_declared_value>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.currency_of_declared_value), input_name='currency_of_declared_value')), namespaceprefix_ , eol_))
        if self.extension is not None:
            namespaceprefix_ = self.extension_nsprefix_ + ':' if (UseCapturedNS_ and self.extension_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sextension>%s</%sextension>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.extension), input_name='extension')), namespaceprefix_ , eol_))
        if self.id is not None:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sid>%s</%sid>%s' % (namespaceprefix_ , self.gds_format_integer(self.id, input_name='id'), namespaceprefix_ , eol_))
        if self.inserted_on is not None:
            namespaceprefix_ = self.inserted_on_nsprefix_ + ':' if (UseCapturedNS_ and self.inserted_on_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sinserted_on>%s</%sinserted_on>%s' % (namespaceprefix_ , self.gds_format_datetime(self.inserted_on, input_name='inserted_on'), namespaceprefix_ , eol_))
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespaceprefix_ , eol_))
        if self.permit_num is not None:
            namespaceprefix_ = self.permit_num_nsprefix_ + ':' if (UseCapturedNS_ and self.permit_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spermit_num>%s</%spermit_num>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.permit_num), input_name='permit_num')), namespaceprefix_ , eol_))
        if self.phone is not None:
            namespaceprefix_ = self.phone_nsprefix_ + ':' if (UseCapturedNS_ and self.phone_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sphone>%s</%sphone>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.phone), input_name='phone')), namespaceprefix_ , eol_))
        for proforma_items_ in self.proforma_items:
            namespaceprefix_ = self.proforma_items_nsprefix_ + ':' if (UseCapturedNS_ and self.proforma_items_nsprefix_) else ''
            proforma_items_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='proforma_items', pretty_print=pretty_print)
        if self.reason_for_export is not None:
            namespaceprefix_ = self.reason_for_export_nsprefix_ + ':' if (UseCapturedNS_ and self.reason_for_export_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sreason_for_export>%s</%sreason_for_export>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.reason_for_export), input_name='reason_for_export')), namespaceprefix_ , eol_))
        if self.reference is not None:
            namespaceprefix_ = self.reference_nsprefix_ + ':' if (UseCapturedNS_ and self.reference_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sreference>%s</%sreference>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.reference), input_name='reference')), namespaceprefix_ , eol_))
        if self.status is not None:
            namespaceprefix_ = self.status_nsprefix_ + ':' if (UseCapturedNS_ and self.status_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstatus>%s</%sstatus>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.status), input_name='status')), namespaceprefix_ , eol_))
        if self.updated_on is not None:
            namespaceprefix_ = self.updated_on_nsprefix_ + ':' if (UseCapturedNS_ and self.updated_on_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%supdated_on>%s</%supdated_on>%s' % (namespaceprefix_ , self.gds_format_datetime(self.updated_on, input_name='updated_on'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'broker_address':
            obj_ = Address.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.broker_address = obj_
            obj_.original_tagname_ = 'broker_address'
        elif nodeName_ == 'business_num':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'business_num')
            value_ = self.gds_validate_string(value_, node, 'business_num')
            self.business_num = value_
            self.business_num_nsprefix_ = child_.prefix
        elif nodeName_ == 'currency_of_declared_value':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'currency_of_declared_value')
            value_ = self.gds_validate_string(value_, node, 'currency_of_declared_value')
            self.currency_of_declared_value = value_
            self.currency_of_declared_value_nsprefix_ = child_.prefix
        elif nodeName_ == 'extension':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'extension')
            value_ = self.gds_validate_string(value_, node, 'extension')
            self.extension = value_
            self.extension_nsprefix_ = child_.prefix
        elif nodeName_ == 'id' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'id')
            ival_ = self.gds_validate_integer(ival_, node, 'id')
            self.id = ival_
            self.id_nsprefix_ = child_.prefix
        elif nodeName_ == 'inserted_on':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.inserted_on = dval_
            self.inserted_on_nsprefix_ = child_.prefix
        elif nodeName_ == 'name':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'name')
            value_ = self.gds_validate_string(value_, node, 'name')
            self.name = value_
            self.name_nsprefix_ = child_.prefix
        elif nodeName_ == 'permit_num':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'permit_num')
            value_ = self.gds_validate_string(value_, node, 'permit_num')
            self.permit_num = value_
            self.permit_num_nsprefix_ = child_.prefix
        elif nodeName_ == 'phone':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'phone')
            value_ = self.gds_validate_string(value_, node, 'phone')
            self.phone = value_
            self.phone_nsprefix_ = child_.prefix
        elif nodeName_ == 'proforma_items':
            obj_ = ProformaItem.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.proforma_items.append(obj_)
            obj_.original_tagname_ = 'proforma_items'
        elif nodeName_ == 'reason_for_export':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'reason_for_export')
            value_ = self.gds_validate_string(value_, node, 'reason_for_export')
            self.reason_for_export = value_
            self.reason_for_export_nsprefix_ = child_.prefix
        elif nodeName_ == 'reference':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'reference')
            value_ = self.gds_validate_string(value_, node, 'reference')
            self.reference = value_
            self.reference_nsprefix_ = child_.prefix
        elif nodeName_ == 'status':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'status')
            value_ = self.gds_validate_string(value_, node, 'status')
            self.status = value_
            self.status_nsprefix_ = child_.prefix
        elif nodeName_ == 'updated_on':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.updated_on = dval_
            self.updated_on_nsprefix_ = child_.prefix
# end class Proforma


class ProformaItem(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, commodity_info=None, id=None, inserted_on=None, quantity=None, updated_on=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.commodity_info = commodity_info
        self.commodity_info_nsprefix_ = None
        self.id = id
        self.id_nsprefix_ = None
        if isinstance(inserted_on, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(inserted_on, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = inserted_on
        self.inserted_on = initvalue_
        self.inserted_on_nsprefix_ = None
        self.quantity = quantity
        self.quantity_nsprefix_ = None
        if isinstance(updated_on, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(updated_on, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = updated_on
        self.updated_on = initvalue_
        self.updated_on_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ProformaItem)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ProformaItem.subclass:
            return ProformaItem.subclass(*args_, **kwargs_)
        else:
            return ProformaItem(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_commodity_info(self):
        return self.commodity_info
    def set_commodity_info(self, commodity_info):
        self.commodity_info = commodity_info
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_inserted_on(self):
        return self.inserted_on
    def set_inserted_on(self, inserted_on):
        self.inserted_on = inserted_on
    def get_quantity(self):
        return self.quantity
    def set_quantity(self, quantity):
        self.quantity = quantity
    def get_updated_on(self):
        return self.updated_on
    def set_updated_on(self, updated_on):
        self.updated_on = updated_on
    def hasContent_(self):
        if (
            self.commodity_info is not None or
            self.id is not None or
            self.inserted_on is not None or
            self.quantity is not None or
            self.updated_on is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ProformaItem', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ProformaItem')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ProformaItem':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ProformaItem')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ProformaItem', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ProformaItem'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ProformaItem', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.commodity_info is not None:
            namespaceprefix_ = self.commodity_info_nsprefix_ + ':' if (UseCapturedNS_ and self.commodity_info_nsprefix_) else ''
            self.commodity_info.export(outfile, level, namespaceprefix_, namespacedef_='', name_='commodity_info', pretty_print=pretty_print)
        if self.id is not None:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sid>%s</%sid>%s' % (namespaceprefix_ , self.gds_format_integer(self.id, input_name='id'), namespaceprefix_ , eol_))
        if self.inserted_on is not None:
            namespaceprefix_ = self.inserted_on_nsprefix_ + ':' if (UseCapturedNS_ and self.inserted_on_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sinserted_on>%s</%sinserted_on>%s' % (namespaceprefix_ , self.gds_format_datetime(self.inserted_on, input_name='inserted_on'), namespaceprefix_ , eol_))
        if self.quantity is not None:
            namespaceprefix_ = self.quantity_nsprefix_ + ':' if (UseCapturedNS_ and self.quantity_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%squantity>%s</%squantity>%s' % (namespaceprefix_ , self.gds_format_integer(self.quantity, input_name='quantity'), namespaceprefix_ , eol_))
        if self.updated_on is not None:
            namespaceprefix_ = self.updated_on_nsprefix_ + ':' if (UseCapturedNS_ and self.updated_on_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%supdated_on>%s</%supdated_on>%s' % (namespaceprefix_ , self.gds_format_datetime(self.updated_on, input_name='updated_on'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'commodity_info':
            obj_ = CommodityInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.commodity_info = obj_
            obj_.original_tagname_ = 'commodity_info'
        elif nodeName_ == 'id' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'id')
            ival_ = self.gds_validate_integer(ival_, node, 'id')
            self.id = ival_
            self.id_nsprefix_ = child_.prefix
        elif nodeName_ == 'inserted_on':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.inserted_on = dval_
            self.inserted_on_nsprefix_ = child_.prefix
        elif nodeName_ == 'quantity' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'quantity')
            ival_ = self.gds_validate_integer(ival_, node, 'quantity')
            self.quantity = ival_
            self.quantity_nsprefix_ = child_.prefix
        elif nodeName_ == 'updated_on':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.updated_on = dval_
            self.updated_on_nsprefix_ = child_.prefix
# end class ProformaItem


class CommodityInfo(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, country_of_origin=None, description=None, hs_code=None, id=None, inserted_on=None, province_of_origin=None, updated_on=None, value=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.country_of_origin = country_of_origin
        self.country_of_origin_nsprefix_ = None
        self.description = description
        self.description_nsprefix_ = None
        self.hs_code = hs_code
        self.hs_code_nsprefix_ = None
        self.id = id
        self.id_nsprefix_ = None
        if isinstance(inserted_on, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(inserted_on, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = inserted_on
        self.inserted_on = initvalue_
        self.inserted_on_nsprefix_ = None
        self.province_of_origin = province_of_origin
        self.province_of_origin_nsprefix_ = None
        if isinstance(updated_on, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(updated_on, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = updated_on
        self.updated_on = initvalue_
        self.updated_on_nsprefix_ = None
        self.value = value
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CommodityInfo)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CommodityInfo.subclass:
            return CommodityInfo.subclass(*args_, **kwargs_)
        else:
            return CommodityInfo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_country_of_origin(self):
        return self.country_of_origin
    def set_country_of_origin(self, country_of_origin):
        self.country_of_origin = country_of_origin
    def get_description(self):
        return self.description
    def set_description(self, description):
        self.description = description
    def get_hs_code(self):
        return self.hs_code
    def set_hs_code(self, hs_code):
        self.hs_code = hs_code
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_inserted_on(self):
        return self.inserted_on
    def set_inserted_on(self, inserted_on):
        self.inserted_on = inserted_on
    def get_province_of_origin(self):
        return self.province_of_origin
    def set_province_of_origin(self, province_of_origin):
        self.province_of_origin = province_of_origin
    def get_updated_on(self):
        return self.updated_on
    def set_updated_on(self, updated_on):
        self.updated_on = updated_on
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def hasContent_(self):
        if (
            self.country_of_origin is not None or
            self.description is not None or
            self.hs_code is not None or
            self.id is not None or
            self.inserted_on is not None or
            self.province_of_origin is not None or
            self.updated_on is not None or
            self.value is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CommodityInfo', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CommodityInfo')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CommodityInfo':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CommodityInfo')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CommodityInfo', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CommodityInfo'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CommodityInfo', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.country_of_origin is not None:
            namespaceprefix_ = self.country_of_origin_nsprefix_ + ':' if (UseCapturedNS_ and self.country_of_origin_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scountry_of_origin>%s</%scountry_of_origin>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.country_of_origin), input_name='country_of_origin')), namespaceprefix_ , eol_))
        if self.description is not None:
            namespaceprefix_ = self.description_nsprefix_ + ':' if (UseCapturedNS_ and self.description_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.description), input_name='description')), namespaceprefix_ , eol_))
        if self.hs_code is not None:
            namespaceprefix_ = self.hs_code_nsprefix_ + ':' if (UseCapturedNS_ and self.hs_code_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%shs_code>%s</%shs_code>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.hs_code), input_name='hs_code')), namespaceprefix_ , eol_))
        if self.id is not None:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sid>%s</%sid>%s' % (namespaceprefix_ , self.gds_format_integer(self.id, input_name='id'), namespaceprefix_ , eol_))
        if self.inserted_on is not None:
            namespaceprefix_ = self.inserted_on_nsprefix_ + ':' if (UseCapturedNS_ and self.inserted_on_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sinserted_on>%s</%sinserted_on>%s' % (namespaceprefix_ , self.gds_format_datetime(self.inserted_on, input_name='inserted_on'), namespaceprefix_ , eol_))
        if self.province_of_origin is not None:
            namespaceprefix_ = self.province_of_origin_nsprefix_ + ':' if (UseCapturedNS_ and self.province_of_origin_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sprovince_of_origin>%s</%sprovince_of_origin>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.province_of_origin), input_name='province_of_origin')), namespaceprefix_ , eol_))
        if self.updated_on is not None:
            namespaceprefix_ = self.updated_on_nsprefix_ + ':' if (UseCapturedNS_ and self.updated_on_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%supdated_on>%s</%supdated_on>%s' % (namespaceprefix_ , self.gds_format_datetime(self.updated_on, input_name='updated_on'), namespaceprefix_ , eol_))
        if self.value is not None:
            namespaceprefix_ = self.value_nsprefix_ + ':' if (UseCapturedNS_ and self.value_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svalue>%s</%svalue>%s' % (namespaceprefix_ , self.gds_format_float(self.value, input_name='value'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'country_of_origin':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'country_of_origin')
            value_ = self.gds_validate_string(value_, node, 'country_of_origin')
            self.country_of_origin = value_
            self.country_of_origin_nsprefix_ = child_.prefix
        elif nodeName_ == 'description':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'description')
            value_ = self.gds_validate_string(value_, node, 'description')
            self.description = value_
            self.description_nsprefix_ = child_.prefix
        elif nodeName_ == 'hs_code':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'hs_code')
            value_ = self.gds_validate_string(value_, node, 'hs_code')
            self.hs_code = value_
            self.hs_code_nsprefix_ = child_.prefix
        elif nodeName_ == 'id' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'id')
            ival_ = self.gds_validate_integer(ival_, node, 'id')
            self.id = ival_
            self.id_nsprefix_ = child_.prefix
        elif nodeName_ == 'inserted_on':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.inserted_on = dval_
            self.inserted_on_nsprefix_ = child_.prefix
        elif nodeName_ == 'province_of_origin':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'province_of_origin')
            value_ = self.gds_validate_string(value_, node, 'province_of_origin')
            self.province_of_origin = value_
            self.province_of_origin_nsprefix_ = child_.prefix
        elif nodeName_ == 'updated_on':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.updated_on = dval_
            self.updated_on_nsprefix_ = child_.prefix
        elif nodeName_ == 'value' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'value')
            fval_ = self.gds_validate_float(fval_, node, 'value')
            self.value = fval_
            self.value_nsprefix_ = child_.prefix
# end class CommodityInfo


class Pickup(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, canceled_by=None, canceled_on=None, collect=None, comments=None, created_by=None, created_on=None, id=None, picked_up_on=None, pickup_address=None, pickup_date=None, pickup_location=None, pickup_phone=None, shipper_num=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.canceled_by = canceled_by
        self.canceled_by_nsprefix_ = None
        if isinstance(canceled_on, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(canceled_on, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = canceled_on
        self.canceled_on = initvalue_
        self.canceled_on_nsprefix_ = None
        self.collect = collect
        self.collect_nsprefix_ = None
        self.comments = comments
        self.comments_nsprefix_ = None
        self.created_by = created_by
        self.created_by_nsprefix_ = None
        if isinstance(created_on, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(created_on, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = created_on
        self.created_on = initvalue_
        self.created_on_nsprefix_ = None
        self.id = id
        self.id_nsprefix_ = None
        if isinstance(picked_up_on, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(picked_up_on, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = picked_up_on
        self.picked_up_on = initvalue_
        self.picked_up_on_nsprefix_ = None
        self.pickup_address = pickup_address
        self.pickup_address_nsprefix_ = None
        if isinstance(pickup_date, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(pickup_date, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = pickup_date
        self.pickup_date = initvalue_
        self.pickup_date_nsprefix_ = None
        self.pickup_location = pickup_location
        self.pickup_location_nsprefix_ = None
        self.pickup_phone = pickup_phone
        self.pickup_phone_nsprefix_ = None
        self.shipper_num = shipper_num
        self.shipper_num_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Pickup)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Pickup.subclass:
            return Pickup.subclass(*args_, **kwargs_)
        else:
            return Pickup(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_canceled_by(self):
        return self.canceled_by
    def set_canceled_by(self, canceled_by):
        self.canceled_by = canceled_by
    def get_canceled_on(self):
        return self.canceled_on
    def set_canceled_on(self, canceled_on):
        self.canceled_on = canceled_on
    def get_collect(self):
        return self.collect
    def set_collect(self, collect):
        self.collect = collect
    def get_comments(self):
        return self.comments
    def set_comments(self, comments):
        self.comments = comments
    def get_created_by(self):
        return self.created_by
    def set_created_by(self, created_by):
        self.created_by = created_by
    def get_created_on(self):
        return self.created_on
    def set_created_on(self, created_on):
        self.created_on = created_on
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_picked_up_on(self):
        return self.picked_up_on
    def set_picked_up_on(self, picked_up_on):
        self.picked_up_on = picked_up_on
    def get_pickup_address(self):
        return self.pickup_address
    def set_pickup_address(self, pickup_address):
        self.pickup_address = pickup_address
    def get_pickup_date(self):
        return self.pickup_date
    def set_pickup_date(self, pickup_date):
        self.pickup_date = pickup_date
    def get_pickup_location(self):
        return self.pickup_location
    def set_pickup_location(self, pickup_location):
        self.pickup_location = pickup_location
    def get_pickup_phone(self):
        return self.pickup_phone
    def set_pickup_phone(self, pickup_phone):
        self.pickup_phone = pickup_phone
    def get_shipper_num(self):
        return self.shipper_num
    def set_shipper_num(self, shipper_num):
        self.shipper_num = shipper_num
    def hasContent_(self):
        if (
            self.canceled_by is not None or
            self.canceled_on is not None or
            self.collect is not None or
            self.comments is not None or
            self.created_by is not None or
            self.created_on is not None or
            self.id is not None or
            self.picked_up_on is not None or
            self.pickup_address is not None or
            self.pickup_date is not None or
            self.pickup_location is not None or
            self.pickup_phone is not None or
            self.shipper_num is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Pickup', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Pickup')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Pickup':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Pickup')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Pickup', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Pickup'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Pickup', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.canceled_by is not None:
            namespaceprefix_ = self.canceled_by_nsprefix_ + ':' if (UseCapturedNS_ and self.canceled_by_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scanceled_by>%s</%scanceled_by>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.canceled_by), input_name='canceled_by')), namespaceprefix_ , eol_))
        if self.canceled_on is not None:
            namespaceprefix_ = self.canceled_on_nsprefix_ + ':' if (UseCapturedNS_ and self.canceled_on_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scanceled_on>%s</%scanceled_on>%s' % (namespaceprefix_ , self.gds_format_datetime(self.canceled_on, input_name='canceled_on'), namespaceprefix_ , eol_))
        if self.collect is not None:
            namespaceprefix_ = self.collect_nsprefix_ + ':' if (UseCapturedNS_ and self.collect_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scollect>%s</%scollect>%s' % (namespaceprefix_ , self.gds_format_boolean(self.collect, input_name='collect'), namespaceprefix_ , eol_))
        if self.comments is not None:
            namespaceprefix_ = self.comments_nsprefix_ + ':' if (UseCapturedNS_ and self.comments_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scomments>%s</%scomments>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.comments), input_name='comments')), namespaceprefix_ , eol_))
        if self.created_by is not None:
            namespaceprefix_ = self.created_by_nsprefix_ + ':' if (UseCapturedNS_ and self.created_by_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%screated_by>%s</%screated_by>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.created_by), input_name='created_by')), namespaceprefix_ , eol_))
        if self.created_on is not None:
            namespaceprefix_ = self.created_on_nsprefix_ + ':' if (UseCapturedNS_ and self.created_on_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%screated_on>%s</%screated_on>%s' % (namespaceprefix_ , self.gds_format_datetime(self.created_on, input_name='created_on'), namespaceprefix_ , eol_))
        if self.id is not None:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sid>%s</%sid>%s' % (namespaceprefix_ , self.gds_format_integer(self.id, input_name='id'), namespaceprefix_ , eol_))
        if self.picked_up_on is not None:
            namespaceprefix_ = self.picked_up_on_nsprefix_ + ':' if (UseCapturedNS_ and self.picked_up_on_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spicked_up_on>%s</%spicked_up_on>%s' % (namespaceprefix_ , self.gds_format_datetime(self.picked_up_on, input_name='picked_up_on'), namespaceprefix_ , eol_))
        if self.pickup_address is not None:
            namespaceprefix_ = self.pickup_address_nsprefix_ + ':' if (UseCapturedNS_ and self.pickup_address_nsprefix_) else ''
            self.pickup_address.export(outfile, level, namespaceprefix_, namespacedef_='', name_='pickup_address', pretty_print=pretty_print)
        if self.pickup_date is not None:
            namespaceprefix_ = self.pickup_date_nsprefix_ + ':' if (UseCapturedNS_ and self.pickup_date_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spickup_date>%s</%spickup_date>%s' % (namespaceprefix_ , self.gds_format_datetime(self.pickup_date, input_name='pickup_date'), namespaceprefix_ , eol_))
        if self.pickup_location is not None:
            namespaceprefix_ = self.pickup_location_nsprefix_ + ':' if (UseCapturedNS_ and self.pickup_location_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spickup_location>%s</%spickup_location>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pickup_location), input_name='pickup_location')), namespaceprefix_ , eol_))
        if self.pickup_phone is not None:
            namespaceprefix_ = self.pickup_phone_nsprefix_ + ':' if (UseCapturedNS_ and self.pickup_phone_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spickup_phone>%s</%spickup_phone>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pickup_phone), input_name='pickup_phone')), namespaceprefix_ , eol_))
        if self.shipper_num is not None:
            namespaceprefix_ = self.shipper_num_nsprefix_ + ':' if (UseCapturedNS_ and self.shipper_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sshipper_num>%s</%sshipper_num>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.shipper_num), input_name='shipper_num')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'canceled_by':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'canceled_by')
            value_ = self.gds_validate_string(value_, node, 'canceled_by')
            self.canceled_by = value_
            self.canceled_by_nsprefix_ = child_.prefix
        elif nodeName_ == 'canceled_on':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.canceled_on = dval_
            self.canceled_on_nsprefix_ = child_.prefix
        elif nodeName_ == 'collect':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'collect')
            ival_ = self.gds_validate_boolean(ival_, node, 'collect')
            self.collect = ival_
            self.collect_nsprefix_ = child_.prefix
        elif nodeName_ == 'comments':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'comments')
            value_ = self.gds_validate_string(value_, node, 'comments')
            self.comments = value_
            self.comments_nsprefix_ = child_.prefix
        elif nodeName_ == 'created_by':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'created_by')
            value_ = self.gds_validate_string(value_, node, 'created_by')
            self.created_by = value_
            self.created_by_nsprefix_ = child_.prefix
        elif nodeName_ == 'created_on':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.created_on = dval_
            self.created_on_nsprefix_ = child_.prefix
        elif nodeName_ == 'id' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'id')
            ival_ = self.gds_validate_integer(ival_, node, 'id')
            self.id = ival_
            self.id_nsprefix_ = child_.prefix
        elif nodeName_ == 'picked_up_on':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.picked_up_on = dval_
            self.picked_up_on_nsprefix_ = child_.prefix
        elif nodeName_ == 'pickup_address':
            obj_ = Address.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.pickup_address = obj_
            obj_.original_tagname_ = 'pickup_address'
        elif nodeName_ == 'pickup_date':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.pickup_date = dval_
            self.pickup_date_nsprefix_ = child_.prefix
        elif nodeName_ == 'pickup_location':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pickup_location')
            value_ = self.gds_validate_string(value_, node, 'pickup_location')
            self.pickup_location = value_
            self.pickup_location_nsprefix_ = child_.prefix
        elif nodeName_ == 'pickup_phone':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pickup_phone')
            value_ = self.gds_validate_string(value_, node, 'pickup_phone')
            self.pickup_phone = value_
            self.pickup_phone_nsprefix_ = child_.prefix
        elif nodeName_ == 'shipper_num':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'shipper_num')
            value_ = self.gds_validate_string(value_, node, 'shipper_num')
            self.shipper_num = value_
            self.shipper_num_nsprefix_ = child_.prefix
# end class Pickup


class TrackingResultV2(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, barcode=None, consignee_address=None, delivered=None, estimated_delivery_date=None, events=None, reference_num=None, service_description_en=None, service_description_fr=None, shipping_date=None, signature=None, signed_by=None, tracking_url_en=None, tracking_url_fr=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.barcode = barcode
        self.barcode_nsprefix_ = None
        self.consignee_address = consignee_address
        self.consignee_address_nsprefix_ = None
        self.delivered = delivered
        self.delivered_nsprefix_ = None
        self.estimated_delivery_date = estimated_delivery_date
        self.estimated_delivery_date_nsprefix_ = None
        if events is None:
            self.events = []
        else:
            self.events = events
        self.events_nsprefix_ = None
        self.reference_num = reference_num
        self.reference_num_nsprefix_ = None
        self.service_description_en = service_description_en
        self.service_description_en_nsprefix_ = None
        self.service_description_fr = service_description_fr
        self.service_description_fr_nsprefix_ = None
        self.shipping_date = shipping_date
        self.shipping_date_nsprefix_ = None
        self.signature = signature
        self.signature_nsprefix_ = None
        self.signed_by = signed_by
        self.signed_by_nsprefix_ = None
        self.tracking_url_en = tracking_url_en
        self.tracking_url_en_nsprefix_ = None
        self.tracking_url_fr = tracking_url_fr
        self.tracking_url_fr_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TrackingResultV2)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TrackingResultV2.subclass:
            return TrackingResultV2.subclass(*args_, **kwargs_)
        else:
            return TrackingResultV2(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_barcode(self):
        return self.barcode
    def set_barcode(self, barcode):
        self.barcode = barcode
    def get_consignee_address(self):
        return self.consignee_address
    def set_consignee_address(self, consignee_address):
        self.consignee_address = consignee_address
    def get_delivered(self):
        return self.delivered
    def set_delivered(self, delivered):
        self.delivered = delivered
    def get_estimated_delivery_date(self):
        return self.estimated_delivery_date
    def set_estimated_delivery_date(self, estimated_delivery_date):
        self.estimated_delivery_date = estimated_delivery_date
    def get_events(self):
        return self.events
    def set_events(self, events):
        self.events = events
    def add_events(self, value):
        self.events.append(value)
    def insert_events_at(self, index, value):
        self.events.insert(index, value)
    def replace_events_at(self, index, value):
        self.events[index] = value
    def get_reference_num(self):
        return self.reference_num
    def set_reference_num(self, reference_num):
        self.reference_num = reference_num
    def get_service_description_en(self):
        return self.service_description_en
    def set_service_description_en(self, service_description_en):
        self.service_description_en = service_description_en
    def get_service_description_fr(self):
        return self.service_description_fr
    def set_service_description_fr(self, service_description_fr):
        self.service_description_fr = service_description_fr
    def get_shipping_date(self):
        return self.shipping_date
    def set_shipping_date(self, shipping_date):
        self.shipping_date = shipping_date
    def get_signature(self):
        return self.signature
    def set_signature(self, signature):
        self.signature = signature
    def get_signed_by(self):
        return self.signed_by
    def set_signed_by(self, signed_by):
        self.signed_by = signed_by
    def get_tracking_url_en(self):
        return self.tracking_url_en
    def set_tracking_url_en(self, tracking_url_en):
        self.tracking_url_en = tracking_url_en
    def get_tracking_url_fr(self):
        return self.tracking_url_fr
    def set_tracking_url_fr(self, tracking_url_fr):
        self.tracking_url_fr = tracking_url_fr
    def hasContent_(self):
        if (
            self.barcode is not None or
            self.consignee_address is not None or
            self.delivered is not None or
            self.estimated_delivery_date is not None or
            self.events or
            self.reference_num is not None or
            self.service_description_en is not None or
            self.service_description_fr is not None or
            self.shipping_date is not None or
            self.signature is not None or
            self.signed_by is not None or
            self.tracking_url_en is not None or
            self.tracking_url_fr is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TrackingResultV2', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TrackingResultV2')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TrackingResultV2':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TrackingResultV2')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TrackingResultV2', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TrackingResultV2'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TrackingResultV2', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.barcode is not None:
            namespaceprefix_ = self.barcode_nsprefix_ + ':' if (UseCapturedNS_ and self.barcode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbarcode>%s</%sbarcode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.barcode), input_name='barcode')), namespaceprefix_ , eol_))
        if self.consignee_address is not None:
            namespaceprefix_ = self.consignee_address_nsprefix_ + ':' if (UseCapturedNS_ and self.consignee_address_nsprefix_) else ''
            self.consignee_address.export(outfile, level, namespaceprefix_, namespacedef_='', name_='consignee_address', pretty_print=pretty_print)
        if self.delivered is not None:
            namespaceprefix_ = self.delivered_nsprefix_ + ':' if (UseCapturedNS_ and self.delivered_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdelivered>%s</%sdelivered>%s' % (namespaceprefix_ , self.gds_format_boolean(self.delivered, input_name='delivered'), namespaceprefix_ , eol_))
        if self.estimated_delivery_date is not None:
            namespaceprefix_ = self.estimated_delivery_date_nsprefix_ + ':' if (UseCapturedNS_ and self.estimated_delivery_date_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sestimated_delivery_date>%s</%sestimated_delivery_date>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.estimated_delivery_date), input_name='estimated_delivery_date')), namespaceprefix_ , eol_))
        for events_ in self.events:
            namespaceprefix_ = self.events_nsprefix_ + ':' if (UseCapturedNS_ and self.events_nsprefix_) else ''
            events_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='events', pretty_print=pretty_print)
        if self.reference_num is not None:
            namespaceprefix_ = self.reference_num_nsprefix_ + ':' if (UseCapturedNS_ and self.reference_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sreference_num>%s</%sreference_num>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.reference_num), input_name='reference_num')), namespaceprefix_ , eol_))
        if self.service_description_en is not None:
            namespaceprefix_ = self.service_description_en_nsprefix_ + ':' if (UseCapturedNS_ and self.service_description_en_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sservice_description_en>%s</%sservice_description_en>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.service_description_en), input_name='service_description_en')), namespaceprefix_ , eol_))
        if self.service_description_fr is not None:
            namespaceprefix_ = self.service_description_fr_nsprefix_ + ':' if (UseCapturedNS_ and self.service_description_fr_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sservice_description_fr>%s</%sservice_description_fr>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.service_description_fr), input_name='service_description_fr')), namespaceprefix_ , eol_))
        if self.shipping_date is not None:
            namespaceprefix_ = self.shipping_date_nsprefix_ + ':' if (UseCapturedNS_ and self.shipping_date_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sshipping_date>%s</%sshipping_date>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.shipping_date), input_name='shipping_date')), namespaceprefix_ , eol_))
        if self.signature is not None:
            namespaceprefix_ = self.signature_nsprefix_ + ':' if (UseCapturedNS_ and self.signature_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssignature>%s</%ssignature>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.signature), input_name='signature')), namespaceprefix_ , eol_))
        if self.signed_by is not None:
            namespaceprefix_ = self.signed_by_nsprefix_ + ':' if (UseCapturedNS_ and self.signed_by_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssigned_by>%s</%ssigned_by>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.signed_by), input_name='signed_by')), namespaceprefix_ , eol_))
        if self.tracking_url_en is not None:
            namespaceprefix_ = self.tracking_url_en_nsprefix_ + ':' if (UseCapturedNS_ and self.tracking_url_en_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stracking_url_en>%s</%stracking_url_en>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.tracking_url_en), input_name='tracking_url_en')), namespaceprefix_ , eol_))
        if self.tracking_url_fr is not None:
            namespaceprefix_ = self.tracking_url_fr_nsprefix_ + ':' if (UseCapturedNS_ and self.tracking_url_fr_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stracking_url_fr>%s</%stracking_url_fr>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.tracking_url_fr), input_name='tracking_url_fr')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'barcode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'barcode')
            value_ = self.gds_validate_string(value_, node, 'barcode')
            self.barcode = value_
            self.barcode_nsprefix_ = child_.prefix
        elif nodeName_ == 'consignee_address':
            obj_ = Address.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.consignee_address = obj_
            obj_.original_tagname_ = 'consignee_address'
        elif nodeName_ == 'delivered':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'delivered')
            ival_ = self.gds_validate_boolean(ival_, node, 'delivered')
            self.delivered = ival_
            self.delivered_nsprefix_ = child_.prefix
        elif nodeName_ == 'estimated_delivery_date':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'estimated_delivery_date')
            value_ = self.gds_validate_string(value_, node, 'estimated_delivery_date')
            self.estimated_delivery_date = value_
            self.estimated_delivery_date_nsprefix_ = child_.prefix
        elif nodeName_ == 'events':
            obj_ = TrackingEventV2.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.events.append(obj_)
            obj_.original_tagname_ = 'events'
        elif nodeName_ == 'reference_num':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'reference_num')
            value_ = self.gds_validate_string(value_, node, 'reference_num')
            self.reference_num = value_
            self.reference_num_nsprefix_ = child_.prefix
        elif nodeName_ == 'service_description_en':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'service_description_en')
            value_ = self.gds_validate_string(value_, node, 'service_description_en')
            self.service_description_en = value_
            self.service_description_en_nsprefix_ = child_.prefix
        elif nodeName_ == 'service_description_fr':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'service_description_fr')
            value_ = self.gds_validate_string(value_, node, 'service_description_fr')
            self.service_description_fr = value_
            self.service_description_fr_nsprefix_ = child_.prefix
        elif nodeName_ == 'shipping_date':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'shipping_date')
            value_ = self.gds_validate_string(value_, node, 'shipping_date')
            self.shipping_date = value_
            self.shipping_date_nsprefix_ = child_.prefix
        elif nodeName_ == 'signature':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'signature')
            value_ = self.gds_validate_string(value_, node, 'signature')
            self.signature = value_
            self.signature_nsprefix_ = child_.prefix
        elif nodeName_ == 'signed_by':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'signed_by')
            value_ = self.gds_validate_string(value_, node, 'signed_by')
            self.signed_by = value_
            self.signed_by_nsprefix_ = child_.prefix
        elif nodeName_ == 'tracking_url_en':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'tracking_url_en')
            value_ = self.gds_validate_string(value_, node, 'tracking_url_en')
            self.tracking_url_en = value_
            self.tracking_url_en_nsprefix_ = child_.prefix
        elif nodeName_ == 'tracking_url_fr':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'tracking_url_fr')
            value_ = self.gds_validate_string(value_, node, 'tracking_url_fr')
            self.tracking_url_fr = value_
            self.tracking_url_fr_nsprefix_ = child_.prefix
# end class TrackingResultV2


class TrackingEventV2(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, address=None, code=None, code_description_en=None, code_description_fr=None, comment=None, employee_num=None, local_date_time=None, route_num=None, time_shift=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.address = address
        self.address_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.code_description_en = code_description_en
        self.code_description_en_nsprefix_ = None
        self.code_description_fr = code_description_fr
        self.code_description_fr_nsprefix_ = None
        self.comment = comment
        self.comment_nsprefix_ = None
        self.employee_num = employee_num
        self.employee_num_nsprefix_ = None
        self.local_date_time = local_date_time
        self.local_date_time_nsprefix_ = None
        self.route_num = route_num
        self.route_num_nsprefix_ = None
        self.time_shift = time_shift
        self.time_shift_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TrackingEventV2)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TrackingEventV2.subclass:
            return TrackingEventV2.subclass(*args_, **kwargs_)
        else:
            return TrackingEventV2(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_address(self):
        return self.address
    def set_address(self, address):
        self.address = address
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_code_description_en(self):
        return self.code_description_en
    def set_code_description_en(self, code_description_en):
        self.code_description_en = code_description_en
    def get_code_description_fr(self):
        return self.code_description_fr
    def set_code_description_fr(self, code_description_fr):
        self.code_description_fr = code_description_fr
    def get_comment(self):
        return self.comment
    def set_comment(self, comment):
        self.comment = comment
    def get_employee_num(self):
        return self.employee_num
    def set_employee_num(self, employee_num):
        self.employee_num = employee_num
    def get_local_date_time(self):
        return self.local_date_time
    def set_local_date_time(self, local_date_time):
        self.local_date_time = local_date_time
    def get_route_num(self):
        return self.route_num
    def set_route_num(self, route_num):
        self.route_num = route_num
    def get_time_shift(self):
        return self.time_shift
    def set_time_shift(self, time_shift):
        self.time_shift = time_shift
    def hasContent_(self):
        if (
            self.address is not None or
            self.code is not None or
            self.code_description_en is not None or
            self.code_description_fr is not None or
            self.comment is not None or
            self.employee_num is not None or
            self.local_date_time is not None or
            self.route_num is not None or
            self.time_shift is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TrackingEventV2', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TrackingEventV2')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TrackingEventV2':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TrackingEventV2')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TrackingEventV2', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TrackingEventV2'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TrackingEventV2', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.address is not None:
            namespaceprefix_ = self.address_nsprefix_ + ':' if (UseCapturedNS_ and self.address_nsprefix_) else ''
            self.address.export(outfile, level, namespaceprefix_, namespacedef_='', name_='address', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scode>%s</%scode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.code), input_name='code')), namespaceprefix_ , eol_))
        if self.code_description_en is not None:
            namespaceprefix_ = self.code_description_en_nsprefix_ + ':' if (UseCapturedNS_ and self.code_description_en_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scode_description_en>%s</%scode_description_en>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.code_description_en), input_name='code_description_en')), namespaceprefix_ , eol_))
        if self.code_description_fr is not None:
            namespaceprefix_ = self.code_description_fr_nsprefix_ + ':' if (UseCapturedNS_ and self.code_description_fr_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scode_description_fr>%s</%scode_description_fr>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.code_description_fr), input_name='code_description_fr')), namespaceprefix_ , eol_))
        if self.comment is not None:
            namespaceprefix_ = self.comment_nsprefix_ + ':' if (UseCapturedNS_ and self.comment_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scomment>%s</%scomment>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.comment), input_name='comment')), namespaceprefix_ , eol_))
        if self.employee_num is not None:
            namespaceprefix_ = self.employee_num_nsprefix_ + ':' if (UseCapturedNS_ and self.employee_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%semployee_num>%s</%semployee_num>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.employee_num), input_name='employee_num')), namespaceprefix_ , eol_))
        if self.local_date_time is not None:
            namespaceprefix_ = self.local_date_time_nsprefix_ + ':' if (UseCapturedNS_ and self.local_date_time_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slocal_date_time>%s</%slocal_date_time>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.local_date_time), input_name='local_date_time')), namespaceprefix_ , eol_))
        if self.route_num is not None:
            namespaceprefix_ = self.route_num_nsprefix_ + ':' if (UseCapturedNS_ and self.route_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sroute_num>%s</%sroute_num>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.route_num), input_name='route_num')), namespaceprefix_ , eol_))
        if self.time_shift is not None:
            namespaceprefix_ = self.time_shift_nsprefix_ + ':' if (UseCapturedNS_ and self.time_shift_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stime_shift>%s</%stime_shift>%s' % (namespaceprefix_ , self.gds_format_integer(self.time_shift, input_name='time_shift'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'address':
            obj_ = Address.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.address = obj_
            obj_.original_tagname_ = 'address'
        elif nodeName_ == 'code':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'code')
            value_ = self.gds_validate_string(value_, node, 'code')
            self.code = value_
            self.code_nsprefix_ = child_.prefix
        elif nodeName_ == 'code_description_en':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'code_description_en')
            value_ = self.gds_validate_string(value_, node, 'code_description_en')
            self.code_description_en = value_
            self.code_description_en_nsprefix_ = child_.prefix
        elif nodeName_ == 'code_description_fr':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'code_description_fr')
            value_ = self.gds_validate_string(value_, node, 'code_description_fr')
            self.code_description_fr = value_
            self.code_description_fr_nsprefix_ = child_.prefix
        elif nodeName_ == 'comment':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'comment')
            value_ = self.gds_validate_string(value_, node, 'comment')
            self.comment = value_
            self.comment_nsprefix_ = child_.prefix
        elif nodeName_ == 'employee_num':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'employee_num')
            value_ = self.gds_validate_string(value_, node, 'employee_num')
            self.employee_num = value_
            self.employee_num_nsprefix_ = child_.prefix
        elif nodeName_ == 'local_date_time':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'local_date_time')
            value_ = self.gds_validate_string(value_, node, 'local_date_time')
            self.local_date_time = value_
            self.local_date_time_nsprefix_ = child_.prefix
        elif nodeName_ == 'route_num':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'route_num')
            value_ = self.gds_validate_string(value_, node, 'route_num')
            self.route_num = value_
            self.route_num_nsprefix_ = child_.prefix
        elif nodeName_ == 'time_shift' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'time_shift')
            ival_ = self.gds_validate_integer(ival_, node, 'time_shift')
            self.time_shift = ival_
            self.time_shift_nsprefix_ = child_.prefix
# end class TrackingEventV2


class TrackingResultLite(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, barcode=None, events=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.barcode = barcode
        self.barcode_nsprefix_ = None
        if events is None:
            self.events = []
        else:
            self.events = events
        self.events_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TrackingResultLite)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TrackingResultLite.subclass:
            return TrackingResultLite.subclass(*args_, **kwargs_)
        else:
            return TrackingResultLite(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_barcode(self):
        return self.barcode
    def set_barcode(self, barcode):
        self.barcode = barcode
    def get_events(self):
        return self.events
    def set_events(self, events):
        self.events = events
    def add_events(self, value):
        self.events.append(value)
    def insert_events_at(self, index, value):
        self.events.insert(index, value)
    def replace_events_at(self, index, value):
        self.events[index] = value
    def hasContent_(self):
        if (
            self.barcode is not None or
            self.events
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TrackingResultLite', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TrackingResultLite')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TrackingResultLite':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TrackingResultLite')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TrackingResultLite', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TrackingResultLite'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TrackingResultLite', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.barcode is not None:
            namespaceprefix_ = self.barcode_nsprefix_ + ':' if (UseCapturedNS_ and self.barcode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbarcode>%s</%sbarcode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.barcode), input_name='barcode')), namespaceprefix_ , eol_))
        for events_ in self.events:
            namespaceprefix_ = self.events_nsprefix_ + ':' if (UseCapturedNS_ and self.events_nsprefix_) else ''
            events_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='events', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'barcode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'barcode')
            value_ = self.gds_validate_string(value_, node, 'barcode')
            self.barcode = value_
            self.barcode_nsprefix_ = child_.prefix
        elif nodeName_ == 'events':
            obj_ = TrackingEventLite.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.events.append(obj_)
            obj_.original_tagname_ = 'events'
# end class TrackingResultLite


class TrackingEventLite(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, city=None, code=None, comment=None, country=None, local_date_time=None, postal_code=None, province=None, time_shift=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.city = city
        self.city_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.comment = comment
        self.comment_nsprefix_ = None
        self.country = country
        self.country_nsprefix_ = None
        self.local_date_time = local_date_time
        self.local_date_time_nsprefix_ = None
        self.postal_code = postal_code
        self.postal_code_nsprefix_ = None
        self.province = province
        self.province_nsprefix_ = None
        self.time_shift = time_shift
        self.time_shift_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TrackingEventLite)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TrackingEventLite.subclass:
            return TrackingEventLite.subclass(*args_, **kwargs_)
        else:
            return TrackingEventLite(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_city(self):
        return self.city
    def set_city(self, city):
        self.city = city
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_comment(self):
        return self.comment
    def set_comment(self, comment):
        self.comment = comment
    def get_country(self):
        return self.country
    def set_country(self, country):
        self.country = country
    def get_local_date_time(self):
        return self.local_date_time
    def set_local_date_time(self, local_date_time):
        self.local_date_time = local_date_time
    def get_postal_code(self):
        return self.postal_code
    def set_postal_code(self, postal_code):
        self.postal_code = postal_code
    def get_province(self):
        return self.province
    def set_province(self, province):
        self.province = province
    def get_time_shift(self):
        return self.time_shift
    def set_time_shift(self, time_shift):
        self.time_shift = time_shift
    def hasContent_(self):
        if (
            self.city is not None or
            self.code is not None or
            self.comment is not None or
            self.country is not None or
            self.local_date_time is not None or
            self.postal_code is not None or
            self.province is not None or
            self.time_shift is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TrackingEventLite', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TrackingEventLite')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TrackingEventLite':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TrackingEventLite')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TrackingEventLite', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TrackingEventLite'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TrackingEventLite', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.city is not None:
            namespaceprefix_ = self.city_nsprefix_ + ':' if (UseCapturedNS_ and self.city_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scity>%s</%scity>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.city), input_name='city')), namespaceprefix_ , eol_))
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scode>%s</%scode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.code), input_name='code')), namespaceprefix_ , eol_))
        if self.comment is not None:
            namespaceprefix_ = self.comment_nsprefix_ + ':' if (UseCapturedNS_ and self.comment_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scomment>%s</%scomment>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.comment), input_name='comment')), namespaceprefix_ , eol_))
        if self.country is not None:
            namespaceprefix_ = self.country_nsprefix_ + ':' if (UseCapturedNS_ and self.country_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scountry>%s</%scountry>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.country), input_name='country')), namespaceprefix_ , eol_))
        if self.local_date_time is not None:
            namespaceprefix_ = self.local_date_time_nsprefix_ + ':' if (UseCapturedNS_ and self.local_date_time_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slocal_date_time>%s</%slocal_date_time>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.local_date_time), input_name='local_date_time')), namespaceprefix_ , eol_))
        if self.postal_code is not None:
            namespaceprefix_ = self.postal_code_nsprefix_ + ':' if (UseCapturedNS_ and self.postal_code_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spostal_code>%s</%spostal_code>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.postal_code), input_name='postal_code')), namespaceprefix_ , eol_))
        if self.province is not None:
            namespaceprefix_ = self.province_nsprefix_ + ':' if (UseCapturedNS_ and self.province_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sprovince>%s</%sprovince>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.province), input_name='province')), namespaceprefix_ , eol_))
        if self.time_shift is not None:
            namespaceprefix_ = self.time_shift_nsprefix_ + ':' if (UseCapturedNS_ and self.time_shift_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stime_shift>%s</%stime_shift>%s' % (namespaceprefix_ , self.gds_format_integer(self.time_shift, input_name='time_shift'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'city':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'city')
            value_ = self.gds_validate_string(value_, node, 'city')
            self.city = value_
            self.city_nsprefix_ = child_.prefix
        elif nodeName_ == 'code':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'code')
            value_ = self.gds_validate_string(value_, node, 'code')
            self.code = value_
            self.code_nsprefix_ = child_.prefix
        elif nodeName_ == 'comment':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'comment')
            value_ = self.gds_validate_string(value_, node, 'comment')
            self.comment = value_
            self.comment_nsprefix_ = child_.prefix
        elif nodeName_ == 'country':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'country')
            value_ = self.gds_validate_string(value_, node, 'country')
            self.country = value_
            self.country_nsprefix_ = child_.prefix
        elif nodeName_ == 'local_date_time':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'local_date_time')
            value_ = self.gds_validate_string(value_, node, 'local_date_time')
            self.local_date_time = value_
            self.local_date_time_nsprefix_ = child_.prefix
        elif nodeName_ == 'postal_code':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'postal_code')
            value_ = self.gds_validate_string(value_, node, 'postal_code')
            self.postal_code = value_
            self.postal_code_nsprefix_ = child_.prefix
        elif nodeName_ == 'province':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'province')
            value_ = self.gds_validate_string(value_, node, 'province')
            self.province = value_
            self.province_nsprefix_ = child_.prefix
        elif nodeName_ == 'time_shift' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'time_shift')
            ival_ = self.gds_validate_integer(ival_, node, 'time_shift')
            self.time_shift = ival_
            self.time_shift_nsprefix_ = child_.prefix
# end class TrackingEventLite


class PickupV2(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, canceled_by=None, canceled_on=None, closing_time=None, collect=None, comments=None, created_by=None, created_on=None, id=None, number_of_packages=None, picked_up_on=None, pickup_address=None, pickup_date=None, pickup_location=None, pickup_phone=None, ready_time=None, shipper_num=None, unit_of_measure=None, weight=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.canceled_by = canceled_by
        self.canceled_by_nsprefix_ = None
        if isinstance(canceled_on, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(canceled_on, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = canceled_on
        self.canceled_on = initvalue_
        self.canceled_on_nsprefix_ = None
        self.closing_time = closing_time
        self.closing_time_nsprefix_ = None
        self.collect = collect
        self.collect_nsprefix_ = None
        self.comments = comments
        self.comments_nsprefix_ = None
        self.created_by = created_by
        self.created_by_nsprefix_ = None
        if isinstance(created_on, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(created_on, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = created_on
        self.created_on = initvalue_
        self.created_on_nsprefix_ = None
        self.id = id
        self.id_nsprefix_ = None
        self.number_of_packages = number_of_packages
        self.number_of_packages_nsprefix_ = None
        if isinstance(picked_up_on, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(picked_up_on, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = picked_up_on
        self.picked_up_on = initvalue_
        self.picked_up_on_nsprefix_ = None
        self.pickup_address = pickup_address
        self.pickup_address_nsprefix_ = None
        if isinstance(pickup_date, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(pickup_date, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = pickup_date
        self.pickup_date = initvalue_
        self.pickup_date_nsprefix_ = None
        self.pickup_location = pickup_location
        self.pickup_location_nsprefix_ = None
        self.pickup_phone = pickup_phone
        self.pickup_phone_nsprefix_ = None
        self.ready_time = ready_time
        self.ready_time_nsprefix_ = None
        self.shipper_num = shipper_num
        self.shipper_num_nsprefix_ = None
        self.unit_of_measure = unit_of_measure
        self.unit_of_measure_nsprefix_ = None
        self.weight = weight
        self.weight_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PickupV2)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PickupV2.subclass:
            return PickupV2.subclass(*args_, **kwargs_)
        else:
            return PickupV2(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_canceled_by(self):
        return self.canceled_by
    def set_canceled_by(self, canceled_by):
        self.canceled_by = canceled_by
    def get_canceled_on(self):
        return self.canceled_on
    def set_canceled_on(self, canceled_on):
        self.canceled_on = canceled_on
    def get_closing_time(self):
        return self.closing_time
    def set_closing_time(self, closing_time):
        self.closing_time = closing_time
    def get_collect(self):
        return self.collect
    def set_collect(self, collect):
        self.collect = collect
    def get_comments(self):
        return self.comments
    def set_comments(self, comments):
        self.comments = comments
    def get_created_by(self):
        return self.created_by
    def set_created_by(self, created_by):
        self.created_by = created_by
    def get_created_on(self):
        return self.created_on
    def set_created_on(self, created_on):
        self.created_on = created_on
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_number_of_packages(self):
        return self.number_of_packages
    def set_number_of_packages(self, number_of_packages):
        self.number_of_packages = number_of_packages
    def get_picked_up_on(self):
        return self.picked_up_on
    def set_picked_up_on(self, picked_up_on):
        self.picked_up_on = picked_up_on
    def get_pickup_address(self):
        return self.pickup_address
    def set_pickup_address(self, pickup_address):
        self.pickup_address = pickup_address
    def get_pickup_date(self):
        return self.pickup_date
    def set_pickup_date(self, pickup_date):
        self.pickup_date = pickup_date
    def get_pickup_location(self):
        return self.pickup_location
    def set_pickup_location(self, pickup_location):
        self.pickup_location = pickup_location
    def get_pickup_phone(self):
        return self.pickup_phone
    def set_pickup_phone(self, pickup_phone):
        self.pickup_phone = pickup_phone
    def get_ready_time(self):
        return self.ready_time
    def set_ready_time(self, ready_time):
        self.ready_time = ready_time
    def get_shipper_num(self):
        return self.shipper_num
    def set_shipper_num(self, shipper_num):
        self.shipper_num = shipper_num
    def get_unit_of_measure(self):
        return self.unit_of_measure
    def set_unit_of_measure(self, unit_of_measure):
        self.unit_of_measure = unit_of_measure
    def get_weight(self):
        return self.weight
    def set_weight(self, weight):
        self.weight = weight
    def hasContent_(self):
        if (
            self.canceled_by is not None or
            self.canceled_on is not None or
            self.closing_time is not None or
            self.collect is not None or
            self.comments is not None or
            self.created_by is not None or
            self.created_on is not None or
            self.id is not None or
            self.number_of_packages is not None or
            self.picked_up_on is not None or
            self.pickup_address is not None or
            self.pickup_date is not None or
            self.pickup_location is not None or
            self.pickup_phone is not None or
            self.ready_time is not None or
            self.shipper_num is not None or
            self.unit_of_measure is not None or
            self.weight is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='PickupV2', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PickupV2')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'PickupV2':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='PickupV2')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='PickupV2', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='PickupV2'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='PickupV2', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.canceled_by is not None:
            namespaceprefix_ = self.canceled_by_nsprefix_ + ':' if (UseCapturedNS_ and self.canceled_by_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scanceled_by>%s</%scanceled_by>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.canceled_by), input_name='canceled_by')), namespaceprefix_ , eol_))
        if self.canceled_on is not None:
            namespaceprefix_ = self.canceled_on_nsprefix_ + ':' if (UseCapturedNS_ and self.canceled_on_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scanceled_on>%s</%scanceled_on>%s' % (namespaceprefix_ , self.gds_format_datetime(self.canceled_on, input_name='canceled_on'), namespaceprefix_ , eol_))
        if self.closing_time is not None:
            namespaceprefix_ = self.closing_time_nsprefix_ + ':' if (UseCapturedNS_ and self.closing_time_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sclosing_time>%s</%sclosing_time>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.closing_time), input_name='closing_time')), namespaceprefix_ , eol_))
        if self.collect is not None:
            namespaceprefix_ = self.collect_nsprefix_ + ':' if (UseCapturedNS_ and self.collect_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scollect>%s</%scollect>%s' % (namespaceprefix_ , self.gds_format_boolean(self.collect, input_name='collect'), namespaceprefix_ , eol_))
        if self.comments is not None:
            namespaceprefix_ = self.comments_nsprefix_ + ':' if (UseCapturedNS_ and self.comments_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scomments>%s</%scomments>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.comments), input_name='comments')), namespaceprefix_ , eol_))
        if self.created_by is not None:
            namespaceprefix_ = self.created_by_nsprefix_ + ':' if (UseCapturedNS_ and self.created_by_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%screated_by>%s</%screated_by>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.created_by), input_name='created_by')), namespaceprefix_ , eol_))
        if self.created_on is not None:
            namespaceprefix_ = self.created_on_nsprefix_ + ':' if (UseCapturedNS_ and self.created_on_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%screated_on>%s</%screated_on>%s' % (namespaceprefix_ , self.gds_format_datetime(self.created_on, input_name='created_on'), namespaceprefix_ , eol_))
        if self.id is not None:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sid>%s</%sid>%s' % (namespaceprefix_ , self.gds_format_integer(self.id, input_name='id'), namespaceprefix_ , eol_))
        if self.number_of_packages is not None:
            namespaceprefix_ = self.number_of_packages_nsprefix_ + ':' if (UseCapturedNS_ and self.number_of_packages_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snumber_of_packages>%s</%snumber_of_packages>%s' % (namespaceprefix_ , self.gds_format_integer(self.number_of_packages, input_name='number_of_packages'), namespaceprefix_ , eol_))
        if self.picked_up_on is not None:
            namespaceprefix_ = self.picked_up_on_nsprefix_ + ':' if (UseCapturedNS_ and self.picked_up_on_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spicked_up_on>%s</%spicked_up_on>%s' % (namespaceprefix_ , self.gds_format_datetime(self.picked_up_on, input_name='picked_up_on'), namespaceprefix_ , eol_))
        if self.pickup_address is not None:
            namespaceprefix_ = self.pickup_address_nsprefix_ + ':' if (UseCapturedNS_ and self.pickup_address_nsprefix_) else ''
            self.pickup_address.export(outfile, level, namespaceprefix_, namespacedef_='', name_='pickup_address', pretty_print=pretty_print)
        if self.pickup_date is not None:
            namespaceprefix_ = self.pickup_date_nsprefix_ + ':' if (UseCapturedNS_ and self.pickup_date_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spickup_date>%s</%spickup_date>%s' % (namespaceprefix_ , self.gds_format_datetime(self.pickup_date, input_name='pickup_date'), namespaceprefix_ , eol_))
        if self.pickup_location is not None:
            namespaceprefix_ = self.pickup_location_nsprefix_ + ':' if (UseCapturedNS_ and self.pickup_location_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spickup_location>%s</%spickup_location>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pickup_location), input_name='pickup_location')), namespaceprefix_ , eol_))
        if self.pickup_phone is not None:
            namespaceprefix_ = self.pickup_phone_nsprefix_ + ':' if (UseCapturedNS_ and self.pickup_phone_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spickup_phone>%s</%spickup_phone>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pickup_phone), input_name='pickup_phone')), namespaceprefix_ , eol_))
        if self.ready_time is not None:
            namespaceprefix_ = self.ready_time_nsprefix_ + ':' if (UseCapturedNS_ and self.ready_time_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sready_time>%s</%sready_time>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ready_time), input_name='ready_time')), namespaceprefix_ , eol_))
        if self.shipper_num is not None:
            namespaceprefix_ = self.shipper_num_nsprefix_ + ':' if (UseCapturedNS_ and self.shipper_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sshipper_num>%s</%sshipper_num>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.shipper_num), input_name='shipper_num')), namespaceprefix_ , eol_))
        if self.unit_of_measure is not None:
            namespaceprefix_ = self.unit_of_measure_nsprefix_ + ':' if (UseCapturedNS_ and self.unit_of_measure_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sunit_of_measure>%s</%sunit_of_measure>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.unit_of_measure), input_name='unit_of_measure')), namespaceprefix_ , eol_))
        if self.weight is not None:
            namespaceprefix_ = self.weight_nsprefix_ + ':' if (UseCapturedNS_ and self.weight_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sweight>%s</%sweight>%s' % (namespaceprefix_ , self.gds_format_float(self.weight, input_name='weight'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'canceled_by':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'canceled_by')
            value_ = self.gds_validate_string(value_, node, 'canceled_by')
            self.canceled_by = value_
            self.canceled_by_nsprefix_ = child_.prefix
        elif nodeName_ == 'canceled_on':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.canceled_on = dval_
            self.canceled_on_nsprefix_ = child_.prefix
        elif nodeName_ == 'closing_time':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'closing_time')
            value_ = self.gds_validate_string(value_, node, 'closing_time')
            self.closing_time = value_
            self.closing_time_nsprefix_ = child_.prefix
        elif nodeName_ == 'collect':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'collect')
            ival_ = self.gds_validate_boolean(ival_, node, 'collect')
            self.collect = ival_
            self.collect_nsprefix_ = child_.prefix
        elif nodeName_ == 'comments':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'comments')
            value_ = self.gds_validate_string(value_, node, 'comments')
            self.comments = value_
            self.comments_nsprefix_ = child_.prefix
        elif nodeName_ == 'created_by':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'created_by')
            value_ = self.gds_validate_string(value_, node, 'created_by')
            self.created_by = value_
            self.created_by_nsprefix_ = child_.prefix
        elif nodeName_ == 'created_on':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.created_on = dval_
            self.created_on_nsprefix_ = child_.prefix
        elif nodeName_ == 'id' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'id')
            ival_ = self.gds_validate_integer(ival_, node, 'id')
            self.id = ival_
            self.id_nsprefix_ = child_.prefix
        elif nodeName_ == 'number_of_packages' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'number_of_packages')
            ival_ = self.gds_validate_integer(ival_, node, 'number_of_packages')
            self.number_of_packages = ival_
            self.number_of_packages_nsprefix_ = child_.prefix
        elif nodeName_ == 'picked_up_on':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.picked_up_on = dval_
            self.picked_up_on_nsprefix_ = child_.prefix
        elif nodeName_ == 'pickup_address':
            obj_ = Address.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.pickup_address = obj_
            obj_.original_tagname_ = 'pickup_address'
        elif nodeName_ == 'pickup_date':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.pickup_date = dval_
            self.pickup_date_nsprefix_ = child_.prefix
        elif nodeName_ == 'pickup_location':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pickup_location')
            value_ = self.gds_validate_string(value_, node, 'pickup_location')
            self.pickup_location = value_
            self.pickup_location_nsprefix_ = child_.prefix
        elif nodeName_ == 'pickup_phone':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pickup_phone')
            value_ = self.gds_validate_string(value_, node, 'pickup_phone')
            self.pickup_phone = value_
            self.pickup_phone_nsprefix_ = child_.prefix
        elif nodeName_ == 'ready_time':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ready_time')
            value_ = self.gds_validate_string(value_, node, 'ready_time')
            self.ready_time = value_
            self.ready_time_nsprefix_ = child_.prefix
        elif nodeName_ == 'shipper_num':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'shipper_num')
            value_ = self.gds_validate_string(value_, node, 'shipper_num')
            self.shipper_num = value_
            self.shipper_num_nsprefix_ = child_.prefix
        elif nodeName_ == 'unit_of_measure':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'unit_of_measure')
            value_ = self.gds_validate_string(value_, node, 'unit_of_measure')
            self.unit_of_measure = value_
            self.unit_of_measure_nsprefix_ = child_.prefix
        elif nodeName_ == 'weight' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'weight')
            fval_ = self.gds_validate_float(fval_, node, 'weight')
            self.weight = fval_
            self.weight_nsprefix_ = child_.prefix
# end class PickupV2


class TrackingResult(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, barcode=None, consignee_address=None, delivered=None, estimated_delivery_date=None, events=None, reference_num=None, service_description_en=None, service_description_fr=None, shipping_date=None, signature=None, signed_by=None, tracking_url_en=None, tracking_url_fr=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.barcode = barcode
        self.barcode_nsprefix_ = None
        self.consignee_address = consignee_address
        self.consignee_address_nsprefix_ = None
        self.delivered = delivered
        self.delivered_nsprefix_ = None
        self.estimated_delivery_date = estimated_delivery_date
        self.estimated_delivery_date_nsprefix_ = None
        if events is None:
            self.events = []
        else:
            self.events = events
        self.events_nsprefix_ = None
        self.reference_num = reference_num
        self.reference_num_nsprefix_ = None
        self.service_description_en = service_description_en
        self.service_description_en_nsprefix_ = None
        self.service_description_fr = service_description_fr
        self.service_description_fr_nsprefix_ = None
        self.shipping_date = shipping_date
        self.shipping_date_nsprefix_ = None
        self.signature = signature
        self.signature_nsprefix_ = None
        self.signed_by = signed_by
        self.signed_by_nsprefix_ = None
        self.tracking_url_en = tracking_url_en
        self.tracking_url_en_nsprefix_ = None
        self.tracking_url_fr = tracking_url_fr
        self.tracking_url_fr_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TrackingResult)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TrackingResult.subclass:
            return TrackingResult.subclass(*args_, **kwargs_)
        else:
            return TrackingResult(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_barcode(self):
        return self.barcode
    def set_barcode(self, barcode):
        self.barcode = barcode
    def get_consignee_address(self):
        return self.consignee_address
    def set_consignee_address(self, consignee_address):
        self.consignee_address = consignee_address
    def get_delivered(self):
        return self.delivered
    def set_delivered(self, delivered):
        self.delivered = delivered
    def get_estimated_delivery_date(self):
        return self.estimated_delivery_date
    def set_estimated_delivery_date(self, estimated_delivery_date):
        self.estimated_delivery_date = estimated_delivery_date
    def get_events(self):
        return self.events
    def set_events(self, events):
        self.events = events
    def add_events(self, value):
        self.events.append(value)
    def insert_events_at(self, index, value):
        self.events.insert(index, value)
    def replace_events_at(self, index, value):
        self.events[index] = value
    def get_reference_num(self):
        return self.reference_num
    def set_reference_num(self, reference_num):
        self.reference_num = reference_num
    def get_service_description_en(self):
        return self.service_description_en
    def set_service_description_en(self, service_description_en):
        self.service_description_en = service_description_en
    def get_service_description_fr(self):
        return self.service_description_fr
    def set_service_description_fr(self, service_description_fr):
        self.service_description_fr = service_description_fr
    def get_shipping_date(self):
        return self.shipping_date
    def set_shipping_date(self, shipping_date):
        self.shipping_date = shipping_date
    def get_signature(self):
        return self.signature
    def set_signature(self, signature):
        self.signature = signature
    def get_signed_by(self):
        return self.signed_by
    def set_signed_by(self, signed_by):
        self.signed_by = signed_by
    def get_tracking_url_en(self):
        return self.tracking_url_en
    def set_tracking_url_en(self, tracking_url_en):
        self.tracking_url_en = tracking_url_en
    def get_tracking_url_fr(self):
        return self.tracking_url_fr
    def set_tracking_url_fr(self, tracking_url_fr):
        self.tracking_url_fr = tracking_url_fr
    def hasContent_(self):
        if (
            self.barcode is not None or
            self.consignee_address is not None or
            self.delivered is not None or
            self.estimated_delivery_date is not None or
            self.events or
            self.reference_num is not None or
            self.service_description_en is not None or
            self.service_description_fr is not None or
            self.shipping_date is not None or
            self.signature is not None or
            self.signed_by is not None or
            self.tracking_url_en is not None or
            self.tracking_url_fr is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TrackingResult', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TrackingResult')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TrackingResult':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TrackingResult')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TrackingResult', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TrackingResult'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TrackingResult', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.barcode is not None:
            namespaceprefix_ = self.barcode_nsprefix_ + ':' if (UseCapturedNS_ and self.barcode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbarcode>%s</%sbarcode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.barcode), input_name='barcode')), namespaceprefix_ , eol_))
        if self.consignee_address is not None:
            namespaceprefix_ = self.consignee_address_nsprefix_ + ':' if (UseCapturedNS_ and self.consignee_address_nsprefix_) else ''
            self.consignee_address.export(outfile, level, namespaceprefix_, namespacedef_='', name_='consignee_address', pretty_print=pretty_print)
        if self.delivered is not None:
            namespaceprefix_ = self.delivered_nsprefix_ + ':' if (UseCapturedNS_ and self.delivered_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdelivered>%s</%sdelivered>%s' % (namespaceprefix_ , self.gds_format_boolean(self.delivered, input_name='delivered'), namespaceprefix_ , eol_))
        if self.estimated_delivery_date is not None:
            namespaceprefix_ = self.estimated_delivery_date_nsprefix_ + ':' if (UseCapturedNS_ and self.estimated_delivery_date_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sestimated_delivery_date>%s</%sestimated_delivery_date>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.estimated_delivery_date), input_name='estimated_delivery_date')), namespaceprefix_ , eol_))
        for events_ in self.events:
            namespaceprefix_ = self.events_nsprefix_ + ':' if (UseCapturedNS_ and self.events_nsprefix_) else ''
            events_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='events', pretty_print=pretty_print)
        if self.reference_num is not None:
            namespaceprefix_ = self.reference_num_nsprefix_ + ':' if (UseCapturedNS_ and self.reference_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sreference_num>%s</%sreference_num>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.reference_num), input_name='reference_num')), namespaceprefix_ , eol_))
        if self.service_description_en is not None:
            namespaceprefix_ = self.service_description_en_nsprefix_ + ':' if (UseCapturedNS_ and self.service_description_en_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sservice_description_en>%s</%sservice_description_en>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.service_description_en), input_name='service_description_en')), namespaceprefix_ , eol_))
        if self.service_description_fr is not None:
            namespaceprefix_ = self.service_description_fr_nsprefix_ + ':' if (UseCapturedNS_ and self.service_description_fr_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sservice_description_fr>%s</%sservice_description_fr>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.service_description_fr), input_name='service_description_fr')), namespaceprefix_ , eol_))
        if self.shipping_date is not None:
            namespaceprefix_ = self.shipping_date_nsprefix_ + ':' if (UseCapturedNS_ and self.shipping_date_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sshipping_date>%s</%sshipping_date>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.shipping_date), input_name='shipping_date')), namespaceprefix_ , eol_))
        if self.signature is not None:
            namespaceprefix_ = self.signature_nsprefix_ + ':' if (UseCapturedNS_ and self.signature_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssignature>%s</%ssignature>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.signature), input_name='signature')), namespaceprefix_ , eol_))
        if self.signed_by is not None:
            namespaceprefix_ = self.signed_by_nsprefix_ + ':' if (UseCapturedNS_ and self.signed_by_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssigned_by>%s</%ssigned_by>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.signed_by), input_name='signed_by')), namespaceprefix_ , eol_))
        if self.tracking_url_en is not None:
            namespaceprefix_ = self.tracking_url_en_nsprefix_ + ':' if (UseCapturedNS_ and self.tracking_url_en_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stracking_url_en>%s</%stracking_url_en>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.tracking_url_en), input_name='tracking_url_en')), namespaceprefix_ , eol_))
        if self.tracking_url_fr is not None:
            namespaceprefix_ = self.tracking_url_fr_nsprefix_ + ':' if (UseCapturedNS_ and self.tracking_url_fr_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stracking_url_fr>%s</%stracking_url_fr>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.tracking_url_fr), input_name='tracking_url_fr')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'barcode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'barcode')
            value_ = self.gds_validate_string(value_, node, 'barcode')
            self.barcode = value_
            self.barcode_nsprefix_ = child_.prefix
        elif nodeName_ == 'consignee_address':
            obj_ = Address.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.consignee_address = obj_
            obj_.original_tagname_ = 'consignee_address'
        elif nodeName_ == 'delivered':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'delivered')
            ival_ = self.gds_validate_boolean(ival_, node, 'delivered')
            self.delivered = ival_
            self.delivered_nsprefix_ = child_.prefix
        elif nodeName_ == 'estimated_delivery_date':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'estimated_delivery_date')
            value_ = self.gds_validate_string(value_, node, 'estimated_delivery_date')
            self.estimated_delivery_date = value_
            self.estimated_delivery_date_nsprefix_ = child_.prefix
        elif nodeName_ == 'events':
            obj_ = TrackingEvent.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.events.append(obj_)
            obj_.original_tagname_ = 'events'
        elif nodeName_ == 'reference_num':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'reference_num')
            value_ = self.gds_validate_string(value_, node, 'reference_num')
            self.reference_num = value_
            self.reference_num_nsprefix_ = child_.prefix
        elif nodeName_ == 'service_description_en':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'service_description_en')
            value_ = self.gds_validate_string(value_, node, 'service_description_en')
            self.service_description_en = value_
            self.service_description_en_nsprefix_ = child_.prefix
        elif nodeName_ == 'service_description_fr':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'service_description_fr')
            value_ = self.gds_validate_string(value_, node, 'service_description_fr')
            self.service_description_fr = value_
            self.service_description_fr_nsprefix_ = child_.prefix
        elif nodeName_ == 'shipping_date':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'shipping_date')
            value_ = self.gds_validate_string(value_, node, 'shipping_date')
            self.shipping_date = value_
            self.shipping_date_nsprefix_ = child_.prefix
        elif nodeName_ == 'signature':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'signature')
            value_ = self.gds_validate_string(value_, node, 'signature')
            self.signature = value_
            self.signature_nsprefix_ = child_.prefix
        elif nodeName_ == 'signed_by':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'signed_by')
            value_ = self.gds_validate_string(value_, node, 'signed_by')
            self.signed_by = value_
            self.signed_by_nsprefix_ = child_.prefix
        elif nodeName_ == 'tracking_url_en':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'tracking_url_en')
            value_ = self.gds_validate_string(value_, node, 'tracking_url_en')
            self.tracking_url_en = value_
            self.tracking_url_en_nsprefix_ = child_.prefix
        elif nodeName_ == 'tracking_url_fr':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'tracking_url_fr')
            value_ = self.gds_validate_string(value_, node, 'tracking_url_fr')
            self.tracking_url_fr = value_
            self.tracking_url_fr_nsprefix_ = child_.prefix
# end class TrackingResult


class TrackingEvent(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, address=None, code=None, code_description_en=None, code_description_fr=None, comment=None, local_date_time=None, time_shift=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.address = address
        self.address_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.code_description_en = code_description_en
        self.code_description_en_nsprefix_ = None
        self.code_description_fr = code_description_fr
        self.code_description_fr_nsprefix_ = None
        self.comment = comment
        self.comment_nsprefix_ = None
        self.local_date_time = local_date_time
        self.local_date_time_nsprefix_ = None
        self.time_shift = time_shift
        self.time_shift_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TrackingEvent)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TrackingEvent.subclass:
            return TrackingEvent.subclass(*args_, **kwargs_)
        else:
            return TrackingEvent(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_address(self):
        return self.address
    def set_address(self, address):
        self.address = address
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_code_description_en(self):
        return self.code_description_en
    def set_code_description_en(self, code_description_en):
        self.code_description_en = code_description_en
    def get_code_description_fr(self):
        return self.code_description_fr
    def set_code_description_fr(self, code_description_fr):
        self.code_description_fr = code_description_fr
    def get_comment(self):
        return self.comment
    def set_comment(self, comment):
        self.comment = comment
    def get_local_date_time(self):
        return self.local_date_time
    def set_local_date_time(self, local_date_time):
        self.local_date_time = local_date_time
    def get_time_shift(self):
        return self.time_shift
    def set_time_shift(self, time_shift):
        self.time_shift = time_shift
    def hasContent_(self):
        if (
            self.address is not None or
            self.code is not None or
            self.code_description_en is not None or
            self.code_description_fr is not None or
            self.comment is not None or
            self.local_date_time is not None or
            self.time_shift is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TrackingEvent', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TrackingEvent')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TrackingEvent':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TrackingEvent')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TrackingEvent', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TrackingEvent'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TrackingEvent', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.address is not None:
            namespaceprefix_ = self.address_nsprefix_ + ':' if (UseCapturedNS_ and self.address_nsprefix_) else ''
            self.address.export(outfile, level, namespaceprefix_, namespacedef_='', name_='address', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scode>%s</%scode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.code), input_name='code')), namespaceprefix_ , eol_))
        if self.code_description_en is not None:
            namespaceprefix_ = self.code_description_en_nsprefix_ + ':' if (UseCapturedNS_ and self.code_description_en_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scode_description_en>%s</%scode_description_en>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.code_description_en), input_name='code_description_en')), namespaceprefix_ , eol_))
        if self.code_description_fr is not None:
            namespaceprefix_ = self.code_description_fr_nsprefix_ + ':' if (UseCapturedNS_ and self.code_description_fr_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scode_description_fr>%s</%scode_description_fr>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.code_description_fr), input_name='code_description_fr')), namespaceprefix_ , eol_))
        if self.comment is not None:
            namespaceprefix_ = self.comment_nsprefix_ + ':' if (UseCapturedNS_ and self.comment_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scomment>%s</%scomment>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.comment), input_name='comment')), namespaceprefix_ , eol_))
        if self.local_date_time is not None:
            namespaceprefix_ = self.local_date_time_nsprefix_ + ':' if (UseCapturedNS_ and self.local_date_time_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slocal_date_time>%s</%slocal_date_time>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.local_date_time), input_name='local_date_time')), namespaceprefix_ , eol_))
        if self.time_shift is not None:
            namespaceprefix_ = self.time_shift_nsprefix_ + ':' if (UseCapturedNS_ and self.time_shift_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stime_shift>%s</%stime_shift>%s' % (namespaceprefix_ , self.gds_format_integer(self.time_shift, input_name='time_shift'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'address':
            obj_ = Address.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.address = obj_
            obj_.original_tagname_ = 'address'
        elif nodeName_ == 'code':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'code')
            value_ = self.gds_validate_string(value_, node, 'code')
            self.code = value_
            self.code_nsprefix_ = child_.prefix
        elif nodeName_ == 'code_description_en':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'code_description_en')
            value_ = self.gds_validate_string(value_, node, 'code_description_en')
            self.code_description_en = value_
            self.code_description_en_nsprefix_ = child_.prefix
        elif nodeName_ == 'code_description_fr':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'code_description_fr')
            value_ = self.gds_validate_string(value_, node, 'code_description_fr')
            self.code_description_fr = value_
            self.code_description_fr_nsprefix_ = child_.prefix
        elif nodeName_ == 'comment':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'comment')
            value_ = self.gds_validate_string(value_, node, 'comment')
            self.comment = value_
            self.comment_nsprefix_ = child_.prefix
        elif nodeName_ == 'local_date_time':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'local_date_time')
            value_ = self.gds_validate_string(value_, node, 'local_date_time')
            self.local_date_time = value_
            self.local_date_time_nsprefix_ = child_.prefix
        elif nodeName_ == 'time_shift' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'time_shift')
            ival_ = self.gds_validate_integer(ival_, node, 'time_shift')
            self.time_shift = ival_
            self.time_shift_nsprefix_ = child_.prefix
# end class TrackingEvent


class PickupInfo(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, close_time=None, ready_time=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.close_time = close_time
        self.close_time_nsprefix_ = None
        self.ready_time = ready_time
        self.ready_time_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PickupInfo)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PickupInfo.subclass:
            return PickupInfo.subclass(*args_, **kwargs_)
        else:
            return PickupInfo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_close_time(self):
        return self.close_time
    def set_close_time(self, close_time):
        self.close_time = close_time
    def get_ready_time(self):
        return self.ready_time
    def set_ready_time(self, ready_time):
        self.ready_time = ready_time
    def hasContent_(self):
        if (
            self.close_time is not None or
            self.ready_time is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='PickupInfo', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PickupInfo')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'PickupInfo':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='PickupInfo')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='PickupInfo', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='PickupInfo'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='PickupInfo', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.close_time is not None:
            namespaceprefix_ = self.close_time_nsprefix_ + ':' if (UseCapturedNS_ and self.close_time_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sclose_time>%s</%sclose_time>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.close_time), input_name='close_time')), namespaceprefix_ , eol_))
        if self.ready_time is not None:
            namespaceprefix_ = self.ready_time_nsprefix_ + ':' if (UseCapturedNS_ and self.ready_time_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sready_time>%s</%sready_time>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ready_time), input_name='ready_time')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'close_time':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'close_time')
            value_ = self.gds_validate_string(value_, node, 'close_time')
            self.close_time = value_
            self.close_time_nsprefix_ = child_.prefix
        elif nodeName_ == 'ready_time':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ready_time')
            value_ = self.gds_validate_string(value_, node, 'ready_time')
            self.ready_time = value_
            self.ready_time_nsprefix_ = child_.prefix
# end class PickupInfo


class ReturnTag(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, address=None, barcode=None, return_tag_barcode=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.address = address
        self.address_nsprefix_ = None
        self.barcode = barcode
        self.barcode_nsprefix_ = None
        self.return_tag_barcode = return_tag_barcode
        self.return_tag_barcode_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ReturnTag)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ReturnTag.subclass:
            return ReturnTag.subclass(*args_, **kwargs_)
        else:
            return ReturnTag(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_address(self):
        return self.address
    def set_address(self, address):
        self.address = address
    def get_barcode(self):
        return self.barcode
    def set_barcode(self, barcode):
        self.barcode = barcode
    def get_return_tag_barcode(self):
        return self.return_tag_barcode
    def set_return_tag_barcode(self, return_tag_barcode):
        self.return_tag_barcode = return_tag_barcode
    def hasContent_(self):
        if (
            self.address is not None or
            self.barcode is not None or
            self.return_tag_barcode is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ReturnTag', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ReturnTag')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ReturnTag':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ReturnTag')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ReturnTag', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ReturnTag'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ReturnTag', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.address is not None:
            namespaceprefix_ = self.address_nsprefix_ + ':' if (UseCapturedNS_ and self.address_nsprefix_) else ''
            self.address.export(outfile, level, namespaceprefix_, namespacedef_='', name_='address', pretty_print=pretty_print)
        if self.barcode is not None:
            namespaceprefix_ = self.barcode_nsprefix_ + ':' if (UseCapturedNS_ and self.barcode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbarcode>%s</%sbarcode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.barcode), input_name='barcode')), namespaceprefix_ , eol_))
        if self.return_tag_barcode is not None:
            namespaceprefix_ = self.return_tag_barcode_nsprefix_ + ':' if (UseCapturedNS_ and self.return_tag_barcode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sreturn_tag_barcode>%s</%sreturn_tag_barcode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.return_tag_barcode), input_name='return_tag_barcode')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'address':
            obj_ = Address.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.address = obj_
            obj_.original_tagname_ = 'address'
        elif nodeName_ == 'barcode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'barcode')
            value_ = self.gds_validate_string(value_, node, 'barcode')
            self.barcode = value_
            self.barcode_nsprefix_ = child_.prefix
        elif nodeName_ == 'return_tag_barcode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'return_tag_barcode')
            value_ = self.gds_validate_string(value_, node, 'return_tag_barcode')
            self.return_tag_barcode = value_
            self.return_tag_barcode_nsprefix_ = child_.prefix
# end class ReturnTag


class Transmission(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, receiver=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.receiver = receiver
        self.receiver_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Transmission)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Transmission.subclass:
            return Transmission.subclass(*args_, **kwargs_)
        else:
            return Transmission(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_receiver(self):
        return self.receiver
    def set_receiver(self, receiver):
        self.receiver = receiver
    def hasContent_(self):
        if (
            self.receiver is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Transmission', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Transmission')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Transmission':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Transmission')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Transmission', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Transmission'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Transmission', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.receiver is not None:
            namespaceprefix_ = self.receiver_nsprefix_ + ':' if (UseCapturedNS_ and self.receiver_nsprefix_) else ''
            self.receiver.export(outfile, level, namespaceprefix_, namespacedef_='', name_='receiver', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'receiver':
            obj_ = Receiver.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.receiver = obj_
            obj_.original_tagname_ = 'receiver'
# end class Transmission


class Receiver(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, activityEvent=None, deliveryEvent=None, prepared_utc=None, spec_version=None, transforce_company=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if activityEvent is None:
            self.activityEvent = []
        else:
            self.activityEvent = activityEvent
        self.activityEvent_nsprefix_ = None
        if deliveryEvent is None:
            self.deliveryEvent = []
        else:
            self.deliveryEvent = deliveryEvent
        self.deliveryEvent_nsprefix_ = None
        self.prepared_utc = prepared_utc
        self.prepared_utc_nsprefix_ = None
        self.spec_version = spec_version
        self.spec_version_nsprefix_ = None
        self.transforce_company = transforce_company
        self.transforce_company_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Receiver)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Receiver.subclass:
            return Receiver.subclass(*args_, **kwargs_)
        else:
            return Receiver(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_activityEvent(self):
        return self.activityEvent
    def set_activityEvent(self, activityEvent):
        self.activityEvent = activityEvent
    def add_activityEvent(self, value):
        self.activityEvent.append(value)
    def insert_activityEvent_at(self, index, value):
        self.activityEvent.insert(index, value)
    def replace_activityEvent_at(self, index, value):
        self.activityEvent[index] = value
    def get_deliveryEvent(self):
        return self.deliveryEvent
    def set_deliveryEvent(self, deliveryEvent):
        self.deliveryEvent = deliveryEvent
    def add_deliveryEvent(self, value):
        self.deliveryEvent.append(value)
    def insert_deliveryEvent_at(self, index, value):
        self.deliveryEvent.insert(index, value)
    def replace_deliveryEvent_at(self, index, value):
        self.deliveryEvent[index] = value
    def get_prepared_utc(self):
        return self.prepared_utc
    def set_prepared_utc(self, prepared_utc):
        self.prepared_utc = prepared_utc
    def get_spec_version(self):
        return self.spec_version
    def set_spec_version(self, spec_version):
        self.spec_version = spec_version
    def get_transforce_company(self):
        return self.transforce_company
    def set_transforce_company(self, transforce_company):
        self.transforce_company = transforce_company
    def hasContent_(self):
        if (
            self.activityEvent or
            self.deliveryEvent or
            self.prepared_utc is not None or
            self.spec_version is not None or
            self.transforce_company is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Receiver', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Receiver')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Receiver':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Receiver')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Receiver', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Receiver'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Receiver', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for activityEvent_ in self.activityEvent:
            namespaceprefix_ = self.activityEvent_nsprefix_ + ':' if (UseCapturedNS_ and self.activityEvent_nsprefix_) else ''
            activityEvent_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='activityEvent', pretty_print=pretty_print)
        for deliveryEvent_ in self.deliveryEvent:
            namespaceprefix_ = self.deliveryEvent_nsprefix_ + ':' if (UseCapturedNS_ and self.deliveryEvent_nsprefix_) else ''
            deliveryEvent_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='deliveryEvent', pretty_print=pretty_print)
        if self.prepared_utc is not None:
            namespaceprefix_ = self.prepared_utc_nsprefix_ + ':' if (UseCapturedNS_ and self.prepared_utc_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sprepared_utc>%s</%sprepared_utc>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.prepared_utc), input_name='prepared_utc')), namespaceprefix_ , eol_))
        if self.spec_version is not None:
            namespaceprefix_ = self.spec_version_nsprefix_ + ':' if (UseCapturedNS_ and self.spec_version_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sspec_version>%s</%sspec_version>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.spec_version), input_name='spec_version')), namespaceprefix_ , eol_))
        if self.transforce_company is not None:
            namespaceprefix_ = self.transforce_company_nsprefix_ + ':' if (UseCapturedNS_ and self.transforce_company_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stransforce_company>%s</%stransforce_company>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.transforce_company), input_name='transforce_company')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'activityEvent':
            obj_ = ActivityEvent.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.activityEvent.append(obj_)
            obj_.original_tagname_ = 'activityEvent'
        elif nodeName_ == 'deliveryEvent':
            obj_ = DeliveryEvent.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.deliveryEvent.append(obj_)
            obj_.original_tagname_ = 'deliveryEvent'
        elif nodeName_ == 'prepared_utc':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node