#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Thu Oct  8 19:02:33 2020 by generateDS.py version 2.35.15.
# Python 3.8.1 (v3.8.1:1b293b6006, Dec 18 2019, 14:08:53)  [Clang 6.0 (clang-600.0.57)]
#
# Command line options:
#   ('--no-namespace-defs', '')
#   ('-o', './pycanpar/CanshipBusinessService.py')
#
# Command line arguments:
#   ./schemas/CanshipBusinessService.xsd
#
# Command line:
#   /Users/danielkobina/Workspace/project/purplship-carriers/.venv/purplship-carriers/bin/generateDS --no-namespace-defs -o "./pycanpar/CanshipBusinessService.py" ./schemas/CanshipBusinessService.xsd
#
# Current working directory (os.getcwd()):
#   py-canpar
#

from six.moves import zip_longest
import os
import sys
import re as re_
import base64
import datetime as datetime_
import decimal as decimal_
try:
    from lxml import etree as etree_
except ImportError:
    from xml.etree import ElementTree as etree_


Validate_simpletypes_ = True
SaveElementTreeNode = True
if sys.version_info.major == 2:
    BaseStrType_ = basestring
else:
    BaseStrType_ = str


def parsexml_(infile, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    try:
        if isinstance(infile, os.PathLike):
            infile = os.path.join(infile)
    except AttributeError:
        pass
    doc = etree_.parse(infile, parser=parser, **kwargs)
    return doc

def parsexmlstring_(instring, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    element = etree_.fromstring(instring, parser=parser, **kwargs)
    return element

#
# Namespace prefix definition table (and other attributes, too)
#
# The module generatedsnamespaces, if it is importable, must contain
# a dictionary named GeneratedsNamespaceDefs.  This Python dictionary
# should map element type names (strings) to XML schema namespace prefix
# definitions.  The export method for any class for which there is
# a namespace prefix definition, will export that definition in the
# XML representation of that element.  See the export method of
# any generated element type class for an example of the use of this
# table.
# A sample table is:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceDefs = {
#         "ElementtypeA": "http://www.xxx.com/namespaceA",
#         "ElementtypeB": "http://www.xxx.com/namespaceB",
#     }
#
# Additionally, the generatedsnamespaces module can contain a python
# dictionary named GenerateDSNamespaceTypePrefixes that associates element
# types with the namespace prefixes that are to be added to the
# "xsi:type" attribute value.  See the exportAttributes method of
# any generated element type and the generation of "xsi:type" for an
# example of the use of this table.
# An example table:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceTypePrefixes = {
#         "ElementtypeC": "aaa:",
#         "ElementtypeD": "bbb:",
#     }
#

try:
    from generatedsnamespaces import GenerateDSNamespaceDefs as GenerateDSNamespaceDefs_
except ImportError:
    GenerateDSNamespaceDefs_ = {}
try:
    from generatedsnamespaces import GenerateDSNamespaceTypePrefixes as GenerateDSNamespaceTypePrefixes_
except ImportError:
    GenerateDSNamespaceTypePrefixes_ = {}

#
# You can replace the following class definition by defining an
# importable module named "generatedscollector" containing a class
# named "GdsCollector".  See the default class definition below for
# clues about the possible content of that class.
#
try:
    from generatedscollector import GdsCollector as GdsCollector_
except ImportError:

    class GdsCollector_(object):

        def __init__(self, messages=None):
            if messages is None:
                self.messages = []
            else:
                self.messages = messages

        def add_message(self, msg):
            self.messages.append(msg)

        def get_messages(self):
            return self.messages

        def clear_messages(self):
            self.messages = []

        def print_messages(self):
            for msg in self.messages:
                print("Warning: {}".format(msg))

        def write_messages(self, outstream):
            for msg in self.messages:
                outstream.write("Warning: {}\n".format(msg))


#
# The super-class for enum types
#

try:
    from enum import Enum
except ImportError:
    Enum = object

#
# The root super-class for element type classes
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError as exp:
    
    class GeneratedsSuper(object):
        __hash__ = object.__hash__
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_parse_string(self, input_data, node=None, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node=None, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_parse_integer(self, input_data, node=None, input_name=''):
            try:
                ival = int(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires integer value: %s' % exp)
            return ival
        def gds_validate_integer(self, input_data, node=None, input_name=''):
            try:
                value = int(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires integer value')
            return value
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_integer_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    int(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integer valuess')
            return values
        def gds_format_float(self, input_data, input_name=''):
            return ('%.15f' % input_data).rstrip('0')
        def gds_parse_float(self, input_data, node=None, input_name=''):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires float or double value: %s' % exp)
            return fval_
        def gds_validate_float(self, input_data, node=None, input_name=''):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires float value')
            return value
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_float_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of float values')
            return values
        def gds_format_decimal(self, input_data, input_name=''):
            return ('%s' % input_data).rstrip('0')
        def gds_parse_decimal(self, input_data, node=None, input_name=''):
            try:
                decimal_value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires decimal value')
            return decimal_value
        def gds_validate_decimal(self, input_data, node=None, input_name=''):
            try:
                value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires decimal value')
            return value
        def gds_format_decimal_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_decimal_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    decimal_.Decimal(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of decimal values')
            return values
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_parse_double(self, input_data, node=None, input_name=''):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires double or float value: %s' % exp)
            return fval_
        def gds_validate_double(self, input_data, node=None, input_name=''):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires double or float value')
            return value
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_double_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(
                        node, 'Requires sequence of double or float values')
            return values
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_parse_boolean(self, input_data, node=None, input_name=''):
            if input_data in ('true', '1'):
                bval = True
            elif input_data in ('false', '0'):
                bval = False
            else:
                raise_parse_error(node, 'Requires boolean value')
            return bval
        def gds_validate_boolean(self, input_data, node=None, input_name=''):
            if input_data not in (True, 1, False, 0, ):
                raise_parse_error(
                    node,
                    'Requires boolean value '
                    '(one of True, 1, False, 0)')
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_boolean_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in (True, 1, False, 0, ):
                    raise_parse_error(
                        node,
                        'Requires sequence of boolean values '
                        '(one of True, 1, False, 0)')
            return values
        def gds_validate_datetime(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split('.')
            if len(time_parts) > 1:
                micro_seconds = int(float('0.' + time_parts[1]) * 1000000)
                input_data = '%s.%s' % (
                    time_parts[0], "{}".format(micro_seconds).rjust(6, "0"), )
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(
                                hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_validate_simple_patterns(self, patterns, target):
            # pat is a list of lists of strings/patterns.
            # The target value must match at least one of the patterns
            # in order for the test to succeed.
            found1 = True
            for patterns1 in patterns:
                found2 = False
                for patterns2 in patterns1:
                    mo = re_.search(patterns2, target)
                    if mo is not None and len(mo.group(0)) == len(target):
                        found2 = True
                        break
                if not found2:
                    found1 = False
                    break
            return found1
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_check_cardinality_(
                self, value, input_name,
                min_occurs=0, max_occurs=1, required=None):
            if value is None:
                length = 0
            elif isinstance(value, list):
                length = len(value)
            else:
                length = 1
            if required is not None :
                if required and length < 1:
                    self.gds_collector_.add_message(
                        "Required value {}{} is missing".format(
                            input_name, self.gds_get_node_lineno_()))
            if length < min_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is below "
                    "the minimum allowed, "
                    "expected at least {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(),
                        min_occurs, length))
            elif length > max_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is above "
                    "the maximum allowed, "
                    "expected at most {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(),
                        max_occurs, length))
        def gds_validate_builtin_ST_(
                self, validator, value, input_name,
                min_occurs=None, max_occurs=None, required=None):
            if value is not None:
                try:
                    validator(value, input_name=input_name)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))
        def gds_validate_defined_ST_(
                self, validator, value, input_name,
                min_occurs=None, max_occurs=None, required=None):
            if value is not None:
                try:
                    validator(value)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            # provide default value in case option --disable-xml is used.
            content = ""
            content = etree_.tostring(node, encoding="unicode")
            return content
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.items()))
        @staticmethod
        def gds_encode(instring):
            if sys.version_info.major == 2:
                if ExternalEncoding:
                    encoding = ExternalEncoding
                else:
                    encoding = 'utf-8'
                return instring.encode(encoding)
            else:
                return instring
        @staticmethod
        def convert_unicode(instring):
            if isinstance(instring, str):
                result = quote_xml(instring)
            elif sys.version_info.major == 2 and isinstance(instring, unicode):
                result = quote_xml(instring).encode('utf8')
            else:
                result = GeneratedsSuper.gds_encode(str(instring))
            return result
        def __eq__(self, other):
            def excl_select_objs_(obj):
                return (obj[0] != 'parent_object_' and
                        obj[0] != 'gds_collector_')
            if type(self) != type(other):
                return False
            return all(x == y for x, y in zip_longest(
                filter(excl_select_objs_, self.__dict__.items()),
                filter(excl_select_objs_, other.__dict__.items())))
        def __ne__(self, other):
            return not self.__eq__(other)
        # Django ETL transform hooks.
        def gds_djo_etl_transform(self):
            pass
        def gds_djo_etl_transform_db_obj(self, dbobj):
            pass
        # SQLAlchemy ETL transform hooks.
        def gds_sqa_etl_transform(self):
            return 0, None
        def gds_sqa_etl_transform_db_obj(self, dbobj):
            pass
        def gds_get_node_lineno_(self):
            if (hasattr(self, "gds_elementtree_node_") and
                    self.gds_elementtree_node_ is not None):
                return ' near line {}'.format(
                    self.gds_elementtree_node_.sourceline)
            else:
                return ""
    
    
    def getSubclassFromModule_(module, class_):
        '''Get the subclass of a class from a specific module.'''
        name = class_.__name__ + 'Sub'
        if hasattr(module, name):
            return getattr(module, name)
        else:
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = ''
# Set this to false in order to deactivate during export, the use of
# name space prefixes captured from the input document.
UseCapturedNS_ = True
CapturedNsmap_ = {}
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')
CDATA_pattern_ = re_.compile(r"<!\[CDATA\[.*?\]\]>", re_.DOTALL)

# Change this to redirect the generated superclass module to use a
# specific subclass module.
CurrentSubclassModule_ = None

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    "Escape markup chars, but do not modify CDATA sections."
    if not inStr:
        return ''
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s2 = ''
    pos = 0
    matchobjects = CDATA_pattern_.finditer(s1)
    for mo in matchobjects:
        s3 = s1[pos:mo.start()]
        s2 += quote_xml_aux(s3)
        s2 += s1[mo.start():mo.end()]
        pos = mo.end()
    s3 = s1[pos:]
    s2 += quote_xml_aux(s3)
    return s2


def quote_xml_aux(inStr):
    s1 = inStr.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


def encode_str_2_3(instr):
    return instr


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    if node is not None:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace,
               pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(
                outfile, level, namespace, name_=name,
                pretty_print=pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name,
                base64.b64encode(self.value),
                self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(
                element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0,
            optional=0, child_attrs=None, choice=None):
        self.name = name
        self.data_type = data_type
        self.container = container
        self.child_attrs = child_attrs
        self.choice = choice
        self.optional = optional
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container
    def set_child_attrs(self, child_attrs): self.child_attrs = child_attrs
    def get_child_attrs(self): return self.child_attrs
    def set_choice(self, choice): self.choice = choice
    def get_choice(self): return self.choice
    def set_optional(self, optional): self.optional = optional
    def get_optional(self): return self.optional


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class getManifest(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getManifest)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getManifest.subclass:
            return getManifest.subclass(*args_, **kwargs_)
        else:
            return getManifest(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getManifest', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getManifest')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getManifest':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getManifest')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getManifest', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getManifest'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getManifest', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = GetManifestRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class getManifest


class getManifestResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getManifestResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getManifestResponse.subclass:
            return getManifestResponse.subclass(*args_, **kwargs_)
        else:
            return getManifestResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getManifestResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getManifestResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getManifestResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getManifestResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getManifestResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getManifestResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getManifestResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = GetManifestRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class getManifestResponse


class getVersionResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getVersionResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getVersionResponse.subclass:
            return getVersionResponse.subclass(*args_, **kwargs_)
        else:
            return getVersionResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getVersionResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getVersionResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getVersionResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getVersionResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getVersionResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getVersionResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getVersionResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = GetVersionRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class getVersionResponse


class getLabels(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getLabels)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getLabels.subclass:
            return getLabels.subclass(*args_, **kwargs_)
        else:
            return getLabels(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getLabels', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getLabels')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getLabels':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getLabels')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getLabels', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getLabels'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getLabels', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = GetLabelsRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class getLabels


class getLabelsResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getLabelsResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getLabelsResponse.subclass:
            return getLabelsResponse.subclass(*args_, **kwargs_)
        else:
            return getLabelsResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getLabelsResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getLabelsResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getLabelsResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getLabelsResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getLabelsResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getLabelsResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getLabelsResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = GetLabelsRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class getLabelsResponse


class getUsers(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getUsers)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getUsers.subclass:
            return getUsers.subclass(*args_, **kwargs_)
        else:
            return getUsers(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getUsers', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getUsers')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getUsers':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getUsers')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getUsers', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getUsers'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getUsers', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = GetUsersRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class getUsers


class getUsersResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getUsersResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getUsersResponse.subclass:
            return getUsersResponse.subclass(*args_, **kwargs_)
        else:
            return getUsersResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getUsersResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getUsersResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getUsersResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getUsersResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getUsersResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getUsersResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getUsersResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = GetUsersRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class getUsersResponse


class searchShipmentsByDeliveryPostalCode(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchShipmentsByDeliveryPostalCode)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchShipmentsByDeliveryPostalCode.subclass:
            return searchShipmentsByDeliveryPostalCode.subclass(*args_, **kwargs_)
        else:
            return searchShipmentsByDeliveryPostalCode(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByDeliveryPostalCode', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchShipmentsByDeliveryPostalCode')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchShipmentsByDeliveryPostalCode':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchShipmentsByDeliveryPostalCode')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchShipmentsByDeliveryPostalCode', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchShipmentsByDeliveryPostalCode'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByDeliveryPostalCode', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SearchShipmentsByDeliveryPostalCodeRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class searchShipmentsByDeliveryPostalCode


class searchShipmentsByDeliveryPostalCodeResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchShipmentsByDeliveryPostalCodeResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchShipmentsByDeliveryPostalCodeResponse.subclass:
            return searchShipmentsByDeliveryPostalCodeResponse.subclass(*args_, **kwargs_)
        else:
            return searchShipmentsByDeliveryPostalCodeResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByDeliveryPostalCodeResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchShipmentsByDeliveryPostalCodeResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchShipmentsByDeliveryPostalCodeResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchShipmentsByDeliveryPostalCodeResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchShipmentsByDeliveryPostalCodeResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchShipmentsByDeliveryPostalCodeResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByDeliveryPostalCodeResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SearchShipmentsByDeliveryPostalCodeRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class searchShipmentsByDeliveryPostalCodeResponse


class searchShipmentsByDeliveryProvince(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchShipmentsByDeliveryProvince)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchShipmentsByDeliveryProvince.subclass:
            return searchShipmentsByDeliveryProvince.subclass(*args_, **kwargs_)
        else:
            return searchShipmentsByDeliveryProvince(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByDeliveryProvince', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchShipmentsByDeliveryProvince')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchShipmentsByDeliveryProvince':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchShipmentsByDeliveryProvince')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchShipmentsByDeliveryProvince', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchShipmentsByDeliveryProvince'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByDeliveryProvince', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SearchShipmentsByDeliveryProvinceRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class searchShipmentsByDeliveryProvince


class searchShipmentsByDeliveryProvinceResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchShipmentsByDeliveryProvinceResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchShipmentsByDeliveryProvinceResponse.subclass:
            return searchShipmentsByDeliveryProvinceResponse.subclass(*args_, **kwargs_)
        else:
            return searchShipmentsByDeliveryProvinceResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByDeliveryProvinceResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchShipmentsByDeliveryProvinceResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchShipmentsByDeliveryProvinceResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchShipmentsByDeliveryProvinceResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchShipmentsByDeliveryProvinceResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchShipmentsByDeliveryProvinceResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByDeliveryProvinceResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SearchShipmentsByDeliveryProvinceRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class searchShipmentsByDeliveryProvinceResponse


class searchShipmentsByDeliveryAddressId(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchShipmentsByDeliveryAddressId)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchShipmentsByDeliveryAddressId.subclass:
            return searchShipmentsByDeliveryAddressId.subclass(*args_, **kwargs_)
        else:
            return searchShipmentsByDeliveryAddressId(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByDeliveryAddressId', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchShipmentsByDeliveryAddressId')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchShipmentsByDeliveryAddressId':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchShipmentsByDeliveryAddressId')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchShipmentsByDeliveryAddressId', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchShipmentsByDeliveryAddressId'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByDeliveryAddressId', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SearchShipmentsByDeliveryAddressIdRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class searchShipmentsByDeliveryAddressId


class searchShipmentsByDeliveryAddressIdResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchShipmentsByDeliveryAddressIdResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchShipmentsByDeliveryAddressIdResponse.subclass:
            return searchShipmentsByDeliveryAddressIdResponse.subclass(*args_, **kwargs_)
        else:
            return searchShipmentsByDeliveryAddressIdResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByDeliveryAddressIdResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchShipmentsByDeliveryAddressIdResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchShipmentsByDeliveryAddressIdResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchShipmentsByDeliveryAddressIdResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchShipmentsByDeliveryAddressIdResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchShipmentsByDeliveryAddressIdResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByDeliveryAddressIdResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SearchShipmentsByDeliveryAddressIdRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class searchShipmentsByDeliveryAddressIdResponse


class searchShipmentsByAlternativeReference(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchShipmentsByAlternativeReference)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchShipmentsByAlternativeReference.subclass:
            return searchShipmentsByAlternativeReference.subclass(*args_, **kwargs_)
        else:
            return searchShipmentsByAlternativeReference(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByAlternativeReference', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchShipmentsByAlternativeReference')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchShipmentsByAlternativeReference':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchShipmentsByAlternativeReference')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchShipmentsByAlternativeReference', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchShipmentsByAlternativeReference'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByAlternativeReference', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SearchShipmentsByAlternativeReferenceRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class searchShipmentsByAlternativeReference


class searchShipmentsByAlternativeReferenceResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchShipmentsByAlternativeReferenceResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchShipmentsByAlternativeReferenceResponse.subclass:
            return searchShipmentsByAlternativeReferenceResponse.subclass(*args_, **kwargs_)
        else:
            return searchShipmentsByAlternativeReferenceResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByAlternativeReferenceResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchShipmentsByAlternativeReferenceResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchShipmentsByAlternativeReferenceResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchShipmentsByAlternativeReferenceResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchShipmentsByAlternativeReferenceResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchShipmentsByAlternativeReferenceResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByAlternativeReferenceResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SearchShipmentsByAlternativeReferenceRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class searchShipmentsByAlternativeReferenceResponse


class getLabelsAdvanced(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getLabelsAdvanced)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getLabelsAdvanced.subclass:
            return getLabelsAdvanced.subclass(*args_, **kwargs_)
        else:
            return getLabelsAdvanced(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getLabelsAdvanced', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getLabelsAdvanced')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getLabelsAdvanced':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getLabelsAdvanced')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getLabelsAdvanced', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getLabelsAdvanced'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getLabelsAdvanced', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = GetLabelsAdvancedRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class getLabelsAdvanced


class getLabelsAdvancedResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getLabelsAdvancedResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getLabelsAdvancedResponse.subclass:
            return getLabelsAdvancedResponse.subclass(*args_, **kwargs_)
        else:
            return getLabelsAdvancedResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getLabelsAdvancedResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getLabelsAdvancedResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getLabelsAdvancedResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getLabelsAdvancedResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getLabelsAdvancedResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getLabelsAdvancedResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getLabelsAdvancedResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = GetLabelsAdvancedRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class getLabelsAdvancedResponse


class voidShipment(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, voidShipment)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if voidShipment.subclass:
            return voidShipment.subclass(*args_, **kwargs_)
        else:
            return voidShipment(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='voidShipment', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('voidShipment')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'voidShipment':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='voidShipment')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='voidShipment', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='voidShipment'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='voidShipment', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = VoidShipmentRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class voidShipment


class voidShipmentResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, voidShipmentResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if voidShipmentResponse.subclass:
            return voidShipmentResponse.subclass(*args_, **kwargs_)
        else:
            return voidShipmentResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='voidShipmentResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('voidShipmentResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'voidShipmentResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='voidShipmentResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='voidShipmentResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='voidShipmentResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='voidShipmentResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = VoidShipmentRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class voidShipmentResponse


class endOfDay(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, endOfDay)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if endOfDay.subclass:
            return endOfDay.subclass(*args_, **kwargs_)
        else:
            return endOfDay(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='endOfDay', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('endOfDay')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'endOfDay':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='endOfDay')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='endOfDay', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='endOfDay'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='endOfDay', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = EndOfDayRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class endOfDay


class endOfDayResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, endOfDayResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if endOfDayResponse.subclass:
            return endOfDayResponse.subclass(*args_, **kwargs_)
        else:
            return endOfDayResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='endOfDayResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('endOfDayResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'endOfDayResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='endOfDayResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='endOfDayResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='endOfDayResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='endOfDayResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = EndOfDayRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class endOfDayResponse


class deleteBox(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, deleteBox)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if deleteBox.subclass:
            return deleteBox.subclass(*args_, **kwargs_)
        else:
            return deleteBox(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='deleteBox', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('deleteBox')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'deleteBox':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='deleteBox')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='deleteBox', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='deleteBox'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='deleteBox', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = DeleteBoxRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class deleteBox


class deleteBoxResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, deleteBoxResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if deleteBoxResponse.subclass:
            return deleteBoxResponse.subclass(*args_, **kwargs_)
        else:
            return deleteBoxResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='deleteBoxResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('deleteBoxResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'deleteBoxResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='deleteBoxResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='deleteBoxResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='deleteBoxResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='deleteBoxResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = DeleteBoxRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class deleteBoxResponse


class saveBox(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, saveBox)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if saveBox.subclass:
            return saveBox.subclass(*args_, **kwargs_)
        else:
            return saveBox(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='saveBox', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('saveBox')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'saveBox':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='saveBox')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='saveBox', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='saveBox'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='saveBox', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SaveBoxRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class saveBox


class saveBoxResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, saveBoxResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if saveBoxResponse.subclass:
            return saveBoxResponse.subclass(*args_, **kwargs_)
        else:
            return saveBoxResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='saveBoxResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('saveBoxResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'saveBoxResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='saveBoxResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='saveBoxResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='saveBoxResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='saveBoxResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SaveBoxRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class saveBoxResponse


class getPreferences(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getPreferences)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getPreferences.subclass:
            return getPreferences.subclass(*args_, **kwargs_)
        else:
            return getPreferences(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getPreferences', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getPreferences')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getPreferences':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getPreferences')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getPreferences', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getPreferences'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getPreferences', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = GetPreferencesRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class getPreferences


class getPreferencesResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getPreferencesResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getPreferencesResponse.subclass:
            return getPreferencesResponse.subclass(*args_, **kwargs_)
        else:
            return getPreferencesResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getPreferencesResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getPreferencesResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getPreferencesResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getPreferencesResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getPreferencesResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getPreferencesResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getPreferencesResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = GetPreferencesRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class getPreferencesResponse


class processShipment(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, processShipment)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if processShipment.subclass:
            return processShipment.subclass(*args_, **kwargs_)
        else:
            return processShipment(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='processShipment', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('processShipment')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'processShipment':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='processShipment')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='processShipment', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='processShipment'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='processShipment', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = ProcessShipmentRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class processShipment


class processShipmentResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, processShipmentResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if processShipmentResponse.subclass:
            return processShipmentResponse.subclass(*args_, **kwargs_)
        else:
            return processShipmentResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='processShipmentResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('processShipmentResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'processShipmentResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='processShipmentResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='processShipmentResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='processShipmentResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='processShipmentResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = ProcessShipmentRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class processShipmentResponse


class savePreference(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, savePreference)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if savePreference.subclass:
            return savePreference.subclass(*args_, **kwargs_)
        else:
            return savePreference(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='savePreference', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('savePreference')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'savePreference':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='savePreference')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='savePreference', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='savePreference'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='savePreference', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SavePreferenceRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class savePreference


class savePreferenceResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, savePreferenceResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if savePreferenceResponse.subclass:
            return savePreferenceResponse.subclass(*args_, **kwargs_)
        else:
            return savePreferenceResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='savePreferenceResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('savePreferenceResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'savePreferenceResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='savePreferenceResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='savePreferenceResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='savePreferenceResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='savePreferenceResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SavePreferenceRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class savePreferenceResponse


class deletePreference(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, deletePreference)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if deletePreference.subclass:
            return deletePreference.subclass(*args_, **kwargs_)
        else:
            return deletePreference(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='deletePreference', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('deletePreference')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'deletePreference':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='deletePreference')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='deletePreference', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='deletePreference'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='deletePreference', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = DeletePreferenceRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class deletePreference


class deletePreferenceResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, deletePreferenceResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if deletePreferenceResponse.subclass:
            return deletePreferenceResponse.subclass(*args_, **kwargs_)
        else:
            return deletePreferenceResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='deletePreferenceResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('deletePreferenceResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'deletePreferenceResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='deletePreferenceResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='deletePreferenceResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='deletePreferenceResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='deletePreferenceResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = DeletePreferenceRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class deletePreferenceResponse


class getBoxes(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getBoxes)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getBoxes.subclass:
            return getBoxes.subclass(*args_, **kwargs_)
        else:
            return getBoxes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getBoxes', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getBoxes')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getBoxes':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getBoxes')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getBoxes', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getBoxes'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getBoxes', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = GetBoxesRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class getBoxes


class getBoxesResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getBoxesResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getBoxesResponse.subclass:
            return getBoxesResponse.subclass(*args_, **kwargs_)
        else:
            return getBoxesResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getBoxesResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getBoxesResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getBoxesResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getBoxesResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getBoxesResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getBoxesResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getBoxesResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = GetBoxesRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class getBoxesResponse


class getProforma(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getProforma)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getProforma.subclass:
            return getProforma.subclass(*args_, **kwargs_)
        else:
            return getProforma(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getProforma', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getProforma')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getProforma':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getProforma')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getProforma', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getProforma'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getProforma', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = GetProformaRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class getProforma


class getProformaResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getProformaResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getProformaResponse.subclass:
            return getProformaResponse.subclass(*args_, **kwargs_)
        else:
            return getProformaResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getProformaResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getProformaResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getProformaResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getProformaResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getProformaResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getProformaResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getProformaResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = GetProformaRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class getProformaResponse


class getSTOs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getSTOs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getSTOs.subclass:
            return getSTOs.subclass(*args_, **kwargs_)
        else:
            return getSTOs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getSTOs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getSTOs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getSTOs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getSTOs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getSTOs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getSTOs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getSTOs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = GetSTOsRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class getSTOs


class getSTOsResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getSTOsResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getSTOsResponse.subclass:
            return getSTOsResponse.subclass(*args_, **kwargs_)
        else:
            return getSTOsResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getSTOsResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getSTOsResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getSTOsResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getSTOsResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getSTOsResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getSTOsResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getSTOsResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = GetSTOsRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class getSTOsResponse


class deleteSTO(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, deleteSTO)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if deleteSTO.subclass:
            return deleteSTO.subclass(*args_, **kwargs_)
        else:
            return deleteSTO(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='deleteSTO', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('deleteSTO')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'deleteSTO':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='deleteSTO')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='deleteSTO', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='deleteSTO'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='deleteSTO', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = DeleteSTORq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class deleteSTO


class deleteSTOResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, deleteSTOResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if deleteSTOResponse.subclass:
            return deleteSTOResponse.subclass(*args_, **kwargs_)
        else:
            return deleteSTOResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='deleteSTOResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('deleteSTOResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'deleteSTOResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='deleteSTOResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='deleteSTOResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='deleteSTOResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='deleteSTOResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = DeleteSTORs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class deleteSTOResponse


class saveProforma(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, saveProforma)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if saveProforma.subclass:
            return saveProforma.subclass(*args_, **kwargs_)
        else:
            return saveProforma(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='saveProforma', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('saveProforma')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'saveProforma':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='saveProforma')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='saveProforma', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='saveProforma'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='saveProforma', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SaveProformaRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class saveProforma


class saveProformaResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, saveProformaResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if saveProformaResponse.subclass:
            return saveProformaResponse.subclass(*args_, **kwargs_)
        else:
            return saveProformaResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='saveProformaResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('saveProformaResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'saveProformaResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='saveProformaResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='saveProformaResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='saveProformaResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='saveProformaResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SaveProformaRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class saveProformaResponse


class deleteCommodity(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, deleteCommodity)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if deleteCommodity.subclass:
            return deleteCommodity.subclass(*args_, **kwargs_)
        else:
            return deleteCommodity(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='deleteCommodity', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('deleteCommodity')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'deleteCommodity':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='deleteCommodity')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='deleteCommodity', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='deleteCommodity'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='deleteCommodity', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = DeleteCommodityRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class deleteCommodity


class deleteCommodityResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, deleteCommodityResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if deleteCommodityResponse.subclass:
            return deleteCommodityResponse.subclass(*args_, **kwargs_)
        else:
            return deleteCommodityResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='deleteCommodityResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('deleteCommodityResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'deleteCommodityResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='deleteCommodityResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='deleteCommodityResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='deleteCommodityResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='deleteCommodityResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = DeleteCommodityRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class deleteCommodityResponse


class deleteUser(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, deleteUser)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if deleteUser.subclass:
            return deleteUser.subclass(*args_, **kwargs_)
        else:
            return deleteUser(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='deleteUser', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('deleteUser')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'deleteUser':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='deleteUser')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='deleteUser', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='deleteUser'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='deleteUser', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = DeleteUserRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class deleteUser


class deleteUserResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, deleteUserResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if deleteUserResponse.subclass:
            return deleteUserResponse.subclass(*args_, **kwargs_)
        else:
            return deleteUserResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='deleteUserResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('deleteUserResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'deleteUserResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='deleteUserResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='deleteUserResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='deleteUserResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='deleteUserResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = DeleteUserRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class deleteUserResponse


class holdShipment(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, holdShipment)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if holdShipment.subclass:
            return holdShipment.subclass(*args_, **kwargs_)
        else:
            return holdShipment(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='holdShipment', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('holdShipment')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'holdShipment':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='holdShipment')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='holdShipment', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='holdShipment'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='holdShipment', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = HoldShipmentRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class holdShipment


class holdShipmentResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, holdShipmentResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if holdShipmentResponse.subclass:
            return holdShipmentResponse.subclass(*args_, **kwargs_)
        else:
            return holdShipmentResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='holdShipmentResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('holdShipmentResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'holdShipmentResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='holdShipmentResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='holdShipmentResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='holdShipmentResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='holdShipmentResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = HoldShipmentRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class holdShipmentResponse


class saveCostCentre(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, saveCostCentre)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if saveCostCentre.subclass:
            return saveCostCentre.subclass(*args_, **kwargs_)
        else:
            return saveCostCentre(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='saveCostCentre', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('saveCostCentre')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'saveCostCentre':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='saveCostCentre')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='saveCostCentre', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='saveCostCentre'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='saveCostCentre', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SaveCostCentreRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class saveCostCentre


class saveCostCentreResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, saveCostCentreResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if saveCostCentreResponse.subclass:
            return saveCostCentreResponse.subclass(*args_, **kwargs_)
        else:
            return saveCostCentreResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='saveCostCentreResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('saveCostCentreResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'saveCostCentreResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='saveCostCentreResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='saveCostCentreResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='saveCostCentreResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='saveCostCentreResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SaveCostCentreRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class saveCostCentreResponse


class saveUser(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, saveUser)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if saveUser.subclass:
            return saveUser.subclass(*args_, **kwargs_)
        else:
            return saveUser(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='saveUser', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('saveUser')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'saveUser':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='saveUser')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='saveUser', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='saveUser'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='saveUser', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SaveUserRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class saveUser


class saveUserResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, saveUserResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if saveUserResponse.subclass:
            return saveUserResponse.subclass(*args_, **kwargs_)
        else:
            return saveUserResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='saveUserResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('saveUserResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'saveUserResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='saveUserResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='saveUserResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='saveUserResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='saveUserResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SaveUserRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class saveUserResponse


class saveSTO(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, saveSTO)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if saveSTO.subclass:
            return saveSTO.subclass(*args_, **kwargs_)
        else:
            return saveSTO(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='saveSTO', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('saveSTO')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'saveSTO':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='saveSTO')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='saveSTO', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='saveSTO'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='saveSTO', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SaveSTORq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class saveSTO


class saveSTOResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, saveSTOResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if saveSTOResponse.subclass:
            return saveSTOResponse.subclass(*args_, **kwargs_)
        else:
            return saveSTOResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='saveSTOResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('saveSTOResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'saveSTOResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='saveSTOResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='saveSTOResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='saveSTOResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='saveSTOResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SaveSTORs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class saveSTOResponse


class saveCommodity(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, saveCommodity)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if saveCommodity.subclass:
            return saveCommodity.subclass(*args_, **kwargs_)
        else:
            return saveCommodity(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='saveCommodity', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('saveCommodity')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'saveCommodity':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='saveCommodity')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='saveCommodity', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='saveCommodity'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='saveCommodity', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SaveCommodityRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class saveCommodity


class saveCommodityResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, saveCommodityResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if saveCommodityResponse.subclass:
            return saveCommodityResponse.subclass(*args_, **kwargs_)
        else:
            return saveCommodityResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='saveCommodityResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('saveCommodityResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'saveCommodityResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='saveCommodityResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='saveCommodityResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='saveCommodityResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='saveCommodityResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SaveCommodityRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class saveCommodityResponse


class saveFuel(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, saveFuel)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if saveFuel.subclass:
            return saveFuel.subclass(*args_, **kwargs_)
        else:
            return saveFuel(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='saveFuel', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('saveFuel')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'saveFuel':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='saveFuel')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='saveFuel', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='saveFuel'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='saveFuel', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SaveFuelRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class saveFuel


class saveFuelResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, saveFuelResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if saveFuelResponse.subclass:
            return saveFuelResponse.subclass(*args_, **kwargs_)
        else:
            return saveFuelResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='saveFuelResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('saveFuelResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'saveFuelResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='saveFuelResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='saveFuelResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='saveFuelResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='saveFuelResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SaveFuelRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class saveFuelResponse


class getFuels(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getFuels)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getFuels.subclass:
            return getFuels.subclass(*args_, **kwargs_)
        else:
            return getFuels(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getFuels', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getFuels')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getFuels':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getFuels')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getFuels', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getFuels'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getFuels', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = GetFuelsRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class getFuels


class getFuelsResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getFuelsResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getFuelsResponse.subclass:
            return getFuelsResponse.subclass(*args_, **kwargs_)
        else:
            return getFuelsResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getFuelsResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getFuelsResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getFuelsResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getFuelsResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getFuelsResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getFuelsResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getFuelsResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = GetFuelsRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class getFuelsResponse


class changePassword(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, changePassword)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if changePassword.subclass:
            return changePassword.subclass(*args_, **kwargs_)
        else:
            return changePassword(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='changePassword', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('changePassword')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'changePassword':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='changePassword')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='changePassword', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='changePassword'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='changePassword', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = ChangePasswordRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class changePassword


class changePasswordResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, changePasswordResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if changePasswordResponse.subclass:
            return changePasswordResponse.subclass(*args_, **kwargs_)
        else:
            return changePasswordResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='changePasswordResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('changePasswordResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'changePasswordResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='changePasswordResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='changePasswordResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='changePasswordResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='changePasswordResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = ChangePasswordRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class changePasswordResponse


class getCostCentres(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getCostCentres)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getCostCentres.subclass:
            return getCostCentres.subclass(*args_, **kwargs_)
        else:
            return getCostCentres(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getCostCentres', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getCostCentres')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getCostCentres':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getCostCentres')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getCostCentres', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getCostCentres'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getCostCentres', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = GetCostCentresRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class getCostCentres


class getCostCentresResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getCostCentresResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getCostCentresResponse.subclass:
            return getCostCentresResponse.subclass(*args_, **kwargs_)
        else:
            return getCostCentresResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getCostCentresResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getCostCentresResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getCostCentresResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getCostCentresResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getCostCentresResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getCostCentresResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getCostCentresResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = GetCostCentresRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class getCostCentresResponse


class getCommodities(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getCommodities)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getCommodities.subclass:
            return getCommodities.subclass(*args_, **kwargs_)
        else:
            return getCommodities(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getCommodities', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getCommodities')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getCommodities':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getCommodities')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getCommodities', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getCommodities'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getCommodities', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = GetCommoditiesRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class getCommodities


class getCommoditiesResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getCommoditiesResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getCommoditiesResponse.subclass:
            return getCommoditiesResponse.subclass(*args_, **kwargs_)
        else:
            return getCommoditiesResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getCommoditiesResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getCommoditiesResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getCommoditiesResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getCommoditiesResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getCommoditiesResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getCommoditiesResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getCommoditiesResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = GetCommoditiesRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class getCommoditiesResponse


class saveAddressBook(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, saveAddressBook)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if saveAddressBook.subclass:
            return saveAddressBook.subclass(*args_, **kwargs_)
        else:
            return saveAddressBook(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='saveAddressBook', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('saveAddressBook')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'saveAddressBook':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='saveAddressBook')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='saveAddressBook', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='saveAddressBook'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='saveAddressBook', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SaveAddressBookRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class saveAddressBook


class saveAddressBookResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, saveAddressBookResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if saveAddressBookResponse.subclass:
            return saveAddressBookResponse.subclass(*args_, **kwargs_)
        else:
            return saveAddressBookResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='saveAddressBookResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('saveAddressBookResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'saveAddressBookResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='saveAddressBookResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='saveAddressBookResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='saveAddressBookResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='saveAddressBookResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SaveAddressBookRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class saveAddressBookResponse


class getUser(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getUser)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getUser.subclass:
            return getUser.subclass(*args_, **kwargs_)
        else:
            return getUser(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getUser', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getUser')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getUser':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getUser')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getUser', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getUser'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getUser', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = GetUserRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class getUser


class getUserResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getUserResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getUserResponse.subclass:
            return getUserResponse.subclass(*args_, **kwargs_)
        else:
            return getUserResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getUserResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getUserResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getUserResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getUserResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getUserResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getUserResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getUserResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = GetUserRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class getUserResponse


class deleteProforma(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, deleteProforma)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if deleteProforma.subclass:
            return deleteProforma.subclass(*args_, **kwargs_)
        else:
            return deleteProforma(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='deleteProforma', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('deleteProforma')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'deleteProforma':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='deleteProforma')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='deleteProforma', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='deleteProforma'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='deleteProforma', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = DeleteProformaRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class deleteProforma


class deleteProformaResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, deleteProformaResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if deleteProformaResponse.subclass:
            return deleteProformaResponse.subclass(*args_, **kwargs_)
        else:
            return deleteProformaResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='deleteProformaResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('deleteProformaResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'deleteProformaResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='deleteProformaResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='deleteProformaResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='deleteProformaResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='deleteProformaResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = DeleteProformaRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class deleteProformaResponse


class autorating(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, autorating)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if autorating.subclass:
            return autorating.subclass(*args_, **kwargs_)
        else:
            return autorating(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='autorating', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('autorating')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'autorating':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='autorating')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='autorating', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='autorating'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='autorating', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = AutoratingRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class autorating


class autoratingResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, autoratingResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if autoratingResponse.subclass:
            return autoratingResponse.subclass(*args_, **kwargs_)
        else:
            return autoratingResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='autoratingResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('autoratingResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'autoratingResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='autoratingResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='autoratingResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='autoratingResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='autoratingResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = AutoratingRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class autoratingResponse


class deleteCostCentre(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, deleteCostCentre)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if deleteCostCentre.subclass:
            return deleteCostCentre.subclass(*args_, **kwargs_)
        else:
            return deleteCostCentre(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='deleteCostCentre', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('deleteCostCentre')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'deleteCostCentre':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='deleteCostCentre')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='deleteCostCentre', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='deleteCostCentre'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='deleteCostCentre', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = DeleteCostCentreRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class deleteCostCentre


class deleteCostCentreResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, deleteCostCentreResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if deleteCostCentreResponse.subclass:
            return deleteCostCentreResponse.subclass(*args_, **kwargs_)
        else:
            return deleteCostCentreResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='deleteCostCentreResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('deleteCostCentreResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'deleteCostCentreResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='deleteCostCentreResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='deleteCostCentreResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='deleteCostCentreResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='deleteCostCentreResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = DeleteCostCentreRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class deleteCostCentreResponse


class exportBoxes(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, exportBoxes)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if exportBoxes.subclass:
            return exportBoxes.subclass(*args_, **kwargs_)
        else:
            return exportBoxes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='exportBoxes', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('exportBoxes')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'exportBoxes':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='exportBoxes')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='exportBoxes', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='exportBoxes'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='exportBoxes', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = ExportBoxesRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class exportBoxes


class exportBoxesResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, exportBoxesResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if exportBoxesResponse.subclass:
            return exportBoxesResponse.subclass(*args_, **kwargs_)
        else:
            return exportBoxesResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='exportBoxesResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('exportBoxesResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'exportBoxesResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='exportBoxesResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='exportBoxesResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='exportBoxesResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='exportBoxesResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = ExportBoxesRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class exportBoxesResponse


class importBoxes(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, importBoxes)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if importBoxes.subclass:
            return importBoxes.subclass(*args_, **kwargs_)
        else:
            return importBoxes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='importBoxes', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('importBoxes')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'importBoxes':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='importBoxes')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='importBoxes', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='importBoxes'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='importBoxes', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = ImportBoxesRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class importBoxes


class importBoxesResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, importBoxesResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if importBoxesResponse.subclass:
            return importBoxesResponse.subclass(*args_, **kwargs_)
        else:
            return importBoxesResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='importBoxesResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('importBoxesResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'importBoxesResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='importBoxesResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='importBoxesResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='importBoxesResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='importBoxesResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = ImportBoxesRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class importBoxesResponse


class searchAddressBookByName(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchAddressBookByName)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchAddressBookByName.subclass:
            return searchAddressBookByName.subclass(*args_, **kwargs_)
        else:
            return searchAddressBookByName(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchAddressBookByName', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchAddressBookByName')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchAddressBookByName':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchAddressBookByName')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchAddressBookByName', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchAddressBookByName'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchAddressBookByName', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SearchAddressBookByNameRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class searchAddressBookByName


class searchAddressBookByNameResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchAddressBookByNameResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchAddressBookByNameResponse.subclass:
            return searchAddressBookByNameResponse.subclass(*args_, **kwargs_)
        else:
            return searchAddressBookByNameResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchAddressBookByNameResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchAddressBookByNameResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchAddressBookByNameResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchAddressBookByNameResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchAddressBookByNameResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchAddressBookByNameResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchAddressBookByNameResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SearchAddressBookByNameRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class searchAddressBookByNameResponse


class importAddressBook(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, importAddressBook)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if importAddressBook.subclass:
            return importAddressBook.subclass(*args_, **kwargs_)
        else:
            return importAddressBook(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='importAddressBook', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('importAddressBook')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'importAddressBook':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='importAddressBook')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='importAddressBook', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='importAddressBook'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='importAddressBook', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = ImportAddressBookRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class importAddressBook


class importAddressBookResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, importAddressBookResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if importAddressBookResponse.subclass:
            return importAddressBookResponse.subclass(*args_, **kwargs_)
        else:
            return importAddressBookResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='importAddressBookResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('importAddressBookResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'importAddressBookResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='importAddressBookResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='importAddressBookResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='importAddressBookResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='importAddressBookResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = ImportAddressBookRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class importAddressBookResponse


class saveGlobalPreference(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, saveGlobalPreference)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if saveGlobalPreference.subclass:
            return saveGlobalPreference.subclass(*args_, **kwargs_)
        else:
            return saveGlobalPreference(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='saveGlobalPreference', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('saveGlobalPreference')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'saveGlobalPreference':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='saveGlobalPreference')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='saveGlobalPreference', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='saveGlobalPreference'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='saveGlobalPreference', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SaveGlobalPreferenceRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class saveGlobalPreference


class saveGlobalPreferenceResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, saveGlobalPreferenceResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if saveGlobalPreferenceResponse.subclass:
            return saveGlobalPreferenceResponse.subclass(*args_, **kwargs_)
        else:
            return saveGlobalPreferenceResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='saveGlobalPreferenceResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('saveGlobalPreferenceResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'saveGlobalPreferenceResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='saveGlobalPreferenceResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='saveGlobalPreferenceResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='saveGlobalPreferenceResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='saveGlobalPreferenceResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SaveGlobalPreferenceRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class saveGlobalPreferenceResponse


class getShipmentsAfterDay(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getShipmentsAfterDay)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getShipmentsAfterDay.subclass:
            return getShipmentsAfterDay.subclass(*args_, **kwargs_)
        else:
            return getShipmentsAfterDay(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getShipmentsAfterDay', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getShipmentsAfterDay')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getShipmentsAfterDay':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getShipmentsAfterDay')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getShipmentsAfterDay', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getShipmentsAfterDay'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getShipmentsAfterDay', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = GetShipmentsAfterDayRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class getShipmentsAfterDay


class getShipmentsAfterDayResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getShipmentsAfterDayResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getShipmentsAfterDayResponse.subclass:
            return getShipmentsAfterDayResponse.subclass(*args_, **kwargs_)
        else:
            return getShipmentsAfterDayResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getShipmentsAfterDayResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getShipmentsAfterDayResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getShipmentsAfterDayResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getShipmentsAfterDayResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getShipmentsAfterDayResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getShipmentsAfterDayResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getShipmentsAfterDayResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = GetShipmentsAfterDayRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class getShipmentsAfterDayResponse


class getGlobalPreference(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getGlobalPreference)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getGlobalPreference.subclass:
            return getGlobalPreference.subclass(*args_, **kwargs_)
        else:
            return getGlobalPreference(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getGlobalPreference', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getGlobalPreference')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getGlobalPreference':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getGlobalPreference')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getGlobalPreference', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getGlobalPreference'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getGlobalPreference', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = GetGlobalPreferenceRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class getGlobalPreference


class getGlobalPreferenceResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getGlobalPreferenceResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getGlobalPreferenceResponse.subclass:
            return getGlobalPreferenceResponse.subclass(*args_, **kwargs_)
        else:
            return getGlobalPreferenceResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getGlobalPreferenceResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getGlobalPreferenceResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getGlobalPreferenceResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getGlobalPreferenceResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getGlobalPreferenceResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getGlobalPreferenceResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getGlobalPreferenceResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = GetGlobalPreferenceRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class getGlobalPreferenceResponse


class deleteAddressBook(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, deleteAddressBook)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if deleteAddressBook.subclass:
            return deleteAddressBook.subclass(*args_, **kwargs_)
        else:
            return deleteAddressBook(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='deleteAddressBook', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('deleteAddressBook')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'deleteAddressBook':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='deleteAddressBook')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='deleteAddressBook', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='deleteAddressBook'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='deleteAddressBook', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = DeleteAddressBookRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class deleteAddressBook


class deleteAddressBookResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, deleteAddressBookResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if deleteAddressBookResponse.subclass:
            return deleteAddressBookResponse.subclass(*args_, **kwargs_)
        else:
            return deleteAddressBookResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='deleteAddressBookResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('deleteAddressBookResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'deleteAddressBookResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='deleteAddressBookResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='deleteAddressBookResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='deleteAddressBookResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='deleteAddressBookResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = DeleteAddressBookRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class deleteAddressBookResponse


class searchAddressBookByAddressId(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchAddressBookByAddressId)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchAddressBookByAddressId.subclass:
            return searchAddressBookByAddressId.subclass(*args_, **kwargs_)
        else:
            return searchAddressBookByAddressId(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchAddressBookByAddressId', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchAddressBookByAddressId')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchAddressBookByAddressId':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchAddressBookByAddressId')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchAddressBookByAddressId', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchAddressBookByAddressId'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchAddressBookByAddressId', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SearchAddressBookByAddressIdRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class searchAddressBookByAddressId


class searchAddressBookByAddressIdResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchAddressBookByAddressIdResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchAddressBookByAddressIdResponse.subclass:
            return searchAddressBookByAddressIdResponse.subclass(*args_, **kwargs_)
        else:
            return searchAddressBookByAddressIdResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchAddressBookByAddressIdResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchAddressBookByAddressIdResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchAddressBookByAddressIdResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchAddressBookByAddressIdResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchAddressBookByAddressIdResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchAddressBookByAddressIdResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchAddressBookByAddressIdResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SearchAddressBookByAddressIdRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class searchAddressBookByAddressIdResponse


class getLastManifestNumber(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getLastManifestNumber)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getLastManifestNumber.subclass:
            return getLastManifestNumber.subclass(*args_, **kwargs_)
        else:
            return getLastManifestNumber(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getLastManifestNumber', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getLastManifestNumber')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getLastManifestNumber':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getLastManifestNumber')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getLastManifestNumber', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getLastManifestNumber'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getLastManifestNumber', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = GetLastManifestNumberRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class getLastManifestNumber


class getLastManifestNumberResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getLastManifestNumberResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getLastManifestNumberResponse.subclass:
            return getLastManifestNumberResponse.subclass(*args_, **kwargs_)
        else:
            return getLastManifestNumberResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getLastManifestNumberResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getLastManifestNumberResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getLastManifestNumberResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getLastManifestNumberResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getLastManifestNumberResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getLastManifestNumberResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getLastManifestNumberResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = GetLastManifestNumberRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class getLastManifestNumberResponse


class searchAddressBookByPostalCode(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchAddressBookByPostalCode)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchAddressBookByPostalCode.subclass:
            return searchAddressBookByPostalCode.subclass(*args_, **kwargs_)
        else:
            return searchAddressBookByPostalCode(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchAddressBookByPostalCode', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchAddressBookByPostalCode')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchAddressBookByPostalCode':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchAddressBookByPostalCode')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchAddressBookByPostalCode', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchAddressBookByPostalCode'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchAddressBookByPostalCode', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SearchAddressBookByPostalCodeRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class searchAddressBookByPostalCode


class searchAddressBookByPostalCodeResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchAddressBookByPostalCodeResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchAddressBookByPostalCodeResponse.subclass:
            return searchAddressBookByPostalCodeResponse.subclass(*args_, **kwargs_)
        else:
            return searchAddressBookByPostalCodeResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchAddressBookByPostalCodeResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchAddressBookByPostalCodeResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchAddressBookByPostalCodeResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchAddressBookByPostalCodeResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchAddressBookByPostalCodeResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchAddressBookByPostalCodeResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchAddressBookByPostalCodeResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SearchAddressBookByPostalCodeRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class searchAddressBookByPostalCodeResponse


class deleteGlobalPreference(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, deleteGlobalPreference)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if deleteGlobalPreference.subclass:
            return deleteGlobalPreference.subclass(*args_, **kwargs_)
        else:
            return deleteGlobalPreference(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='deleteGlobalPreference', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('deleteGlobalPreference')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'deleteGlobalPreference':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='deleteGlobalPreference')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='deleteGlobalPreference', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='deleteGlobalPreference'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='deleteGlobalPreference', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = DeleteGlobalPreferenceRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class deleteGlobalPreference


class deleteGlobalPreferenceResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, deleteGlobalPreferenceResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if deleteGlobalPreferenceResponse.subclass:
            return deleteGlobalPreferenceResponse.subclass(*args_, **kwargs_)
        else:
            return deleteGlobalPreferenceResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='deleteGlobalPreferenceResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('deleteGlobalPreferenceResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'deleteGlobalPreferenceResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='deleteGlobalPreferenceResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='deleteGlobalPreferenceResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='deleteGlobalPreferenceResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='deleteGlobalPreferenceResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = DeleteGlobalPreferenceRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class deleteGlobalPreferenceResponse


class searchAddressBookByProvince(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchAddressBookByProvince)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchAddressBookByProvince.subclass:
            return searchAddressBookByProvince.subclass(*args_, **kwargs_)
        else:
            return searchAddressBookByProvince(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchAddressBookByProvince', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchAddressBookByProvince')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchAddressBookByProvince':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchAddressBookByProvince')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchAddressBookByProvince', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchAddressBookByProvince'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchAddressBookByProvince', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SearchAddressBookByProvinceRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class searchAddressBookByProvince


class searchAddressBookByProvinceResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchAddressBookByProvinceResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchAddressBookByProvinceResponse.subclass:
            return searchAddressBookByProvinceResponse.subclass(*args_, **kwargs_)
        else:
            return searchAddressBookByProvinceResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchAddressBookByProvinceResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchAddressBookByProvinceResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchAddressBookByProvinceResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchAddressBookByProvinceResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchAddressBookByProvinceResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchAddressBookByProvinceResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchAddressBookByProvinceResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SearchAddressBookByProvinceRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class searchAddressBookByProvinceResponse


class searchAddressBookByCity(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchAddressBookByCity)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchAddressBookByCity.subclass:
            return searchAddressBookByCity.subclass(*args_, **kwargs_)
        else:
            return searchAddressBookByCity(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchAddressBookByCity', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchAddressBookByCity')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchAddressBookByCity':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchAddressBookByCity')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchAddressBookByCity', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchAddressBookByCity'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchAddressBookByCity', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SearchAddressBookByCityRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class searchAddressBookByCity


class searchAddressBookByCityResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchAddressBookByCityResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchAddressBookByCityResponse.subclass:
            return searchAddressBookByCityResponse.subclass(*args_, **kwargs_)
        else:
            return searchAddressBookByCityResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchAddressBookByCityResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchAddressBookByCityResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchAddressBookByCityResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchAddressBookByCityResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchAddressBookByCityResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchAddressBookByCityResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchAddressBookByCityResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SearchAddressBookByCityRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class searchAddressBookByCityResponse


class getLabelsAdvancedV2(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getLabelsAdvancedV2)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getLabelsAdvancedV2.subclass:
            return getLabelsAdvancedV2.subclass(*args_, **kwargs_)
        else:
            return getLabelsAdvancedV2(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getLabelsAdvancedV2', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getLabelsAdvancedV2')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getLabelsAdvancedV2':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getLabelsAdvancedV2')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getLabelsAdvancedV2', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getLabelsAdvancedV2'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getLabelsAdvancedV2', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = GetLabelsAdvancedV2Rq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class getLabelsAdvancedV2


class getLabelsAdvancedV2Response(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getLabelsAdvancedV2Response)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getLabelsAdvancedV2Response.subclass:
            return getLabelsAdvancedV2Response.subclass(*args_, **kwargs_)
        else:
            return getLabelsAdvancedV2Response(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getLabelsAdvancedV2Response', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getLabelsAdvancedV2Response')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getLabelsAdvancedV2Response':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getLabelsAdvancedV2Response')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getLabelsAdvancedV2Response', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getLabelsAdvancedV2Response'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getLabelsAdvancedV2Response', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = GetLabelsAdvancedV2Rs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class getLabelsAdvancedV2Response


class searchAddressBookByPhone(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchAddressBookByPhone)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchAddressBookByPhone.subclass:
            return searchAddressBookByPhone.subclass(*args_, **kwargs_)
        else:
            return searchAddressBookByPhone(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchAddressBookByPhone', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchAddressBookByPhone')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchAddressBookByPhone':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchAddressBookByPhone')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchAddressBookByPhone', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchAddressBookByPhone'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchAddressBookByPhone', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SearchAddressBookByPhoneRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class searchAddressBookByPhone


class searchAddressBookByPhoneResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchAddressBookByPhoneResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchAddressBookByPhoneResponse.subclass:
            return searchAddressBookByPhoneResponse.subclass(*args_, **kwargs_)
        else:
            return searchAddressBookByPhoneResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchAddressBookByPhoneResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchAddressBookByPhoneResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchAddressBookByPhoneResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchAddressBookByPhoneResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchAddressBookByPhoneResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchAddressBookByPhoneResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchAddressBookByPhoneResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SearchAddressBookByPhoneRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class searchAddressBookByPhoneResponse


class getShipmentsBeforeDay(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getShipmentsBeforeDay)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getShipmentsBeforeDay.subclass:
            return getShipmentsBeforeDay.subclass(*args_, **kwargs_)
        else:
            return getShipmentsBeforeDay(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getShipmentsBeforeDay', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getShipmentsBeforeDay')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getShipmentsBeforeDay':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getShipmentsBeforeDay')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getShipmentsBeforeDay', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getShipmentsBeforeDay'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getShipmentsBeforeDay', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = GetShipmentsBeforeDayRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class getShipmentsBeforeDay


class getShipmentsBeforeDayResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getShipmentsBeforeDayResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getShipmentsBeforeDayResponse.subclass:
            return getShipmentsBeforeDayResponse.subclass(*args_, **kwargs_)
        else:
            return getShipmentsBeforeDayResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getShipmentsBeforeDayResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getShipmentsBeforeDayResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getShipmentsBeforeDayResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getShipmentsBeforeDayResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getShipmentsBeforeDayResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getShipmentsBeforeDayResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getShipmentsBeforeDayResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = GetShipmentsBeforeDayRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class getShipmentsBeforeDayResponse


class searchAddressBookByReference(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchAddressBookByReference)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchAddressBookByReference.subclass:
            return searchAddressBookByReference.subclass(*args_, **kwargs_)
        else:
            return searchAddressBookByReference(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchAddressBookByReference', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchAddressBookByReference')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchAddressBookByReference':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchAddressBookByReference')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchAddressBookByReference', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchAddressBookByReference'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchAddressBookByReference', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SearchAddressBookByReferenceRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class searchAddressBookByReference


class searchAddressBookByReferenceResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchAddressBookByReferenceResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchAddressBookByReferenceResponse.subclass:
            return searchAddressBookByReferenceResponse.subclass(*args_, **kwargs_)
        else:
            return searchAddressBookByReferenceResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchAddressBookByReferenceResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchAddressBookByReferenceResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchAddressBookByReferenceResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchAddressBookByReferenceResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchAddressBookByReferenceResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchAddressBookByReferenceResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchAddressBookByReferenceResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SearchAddressBookByReferenceRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class searchAddressBookByReferenceResponse


class exportAddressBook(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, exportAddressBook)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if exportAddressBook.subclass:
            return exportAddressBook.subclass(*args_, **kwargs_)
        else:
            return exportAddressBook(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='exportAddressBook', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('exportAddressBook')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'exportAddressBook':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='exportAddressBook')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='exportAddressBook', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='exportAddressBook'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='exportAddressBook', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = ExportAddressBookRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class exportAddressBook


class exportAddressBookResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, exportAddressBookResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if exportAddressBookResponse.subclass:
            return exportAddressBookResponse.subclass(*args_, **kwargs_)
        else:
            return exportAddressBookResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='exportAddressBookResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('exportAddressBookResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'exportAddressBookResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='exportAddressBookResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='exportAddressBookResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='exportAddressBookResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='exportAddressBookResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = ExportAddressBookRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class exportAddressBookResponse


class searchAddressBookByCostCentre(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchAddressBookByCostCentre)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchAddressBookByCostCentre.subclass:
            return searchAddressBookByCostCentre.subclass(*args_, **kwargs_)
        else:
            return searchAddressBookByCostCentre(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchAddressBookByCostCentre', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchAddressBookByCostCentre')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchAddressBookByCostCentre':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchAddressBookByCostCentre')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchAddressBookByCostCentre', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchAddressBookByCostCentre'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchAddressBookByCostCentre', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SearchAddressBookByCostCentreRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class searchAddressBookByCostCentre


class searchAddressBookByCostCentreResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchAddressBookByCostCentreResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchAddressBookByCostCentreResponse.subclass:
            return searchAddressBookByCostCentreResponse.subclass(*args_, **kwargs_)
        else:
            return searchAddressBookByCostCentreResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchAddressBookByCostCentreResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchAddressBookByCostCentreResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchAddressBookByCostCentreResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchAddressBookByCostCentreResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchAddressBookByCostCentreResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchAddressBookByCostCentreResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchAddressBookByCostCentreResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SearchAddressBookByCostCentreRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class searchAddressBookByCostCentreResponse


class searchShipmentsByBarcode(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchShipmentsByBarcode)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchShipmentsByBarcode.subclass:
            return searchShipmentsByBarcode.subclass(*args_, **kwargs_)
        else:
            return searchShipmentsByBarcode(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByBarcode', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchShipmentsByBarcode')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchShipmentsByBarcode':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchShipmentsByBarcode')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchShipmentsByBarcode', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchShipmentsByBarcode'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByBarcode', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SearchShipmentsByBarcodeRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class searchShipmentsByBarcode


class searchShipmentsByBarcodeResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchShipmentsByBarcodeResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchShipmentsByBarcodeResponse.subclass:
            return searchShipmentsByBarcodeResponse.subclass(*args_, **kwargs_)
        else:
            return searchShipmentsByBarcodeResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByBarcodeResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchShipmentsByBarcodeResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchShipmentsByBarcodeResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchShipmentsByBarcodeResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchShipmentsByBarcodeResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchShipmentsByBarcodeResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByBarcodeResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SearchShipmentsByBarcodeRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class searchShipmentsByBarcodeResponse


class saveGlobalPreferenceAllUsers(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, saveGlobalPreferenceAllUsers)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if saveGlobalPreferenceAllUsers.subclass:
            return saveGlobalPreferenceAllUsers.subclass(*args_, **kwargs_)
        else:
            return saveGlobalPreferenceAllUsers(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='saveGlobalPreferenceAllUsers', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('saveGlobalPreferenceAllUsers')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'saveGlobalPreferenceAllUsers':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='saveGlobalPreferenceAllUsers')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='saveGlobalPreferenceAllUsers', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='saveGlobalPreferenceAllUsers'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='saveGlobalPreferenceAllUsers', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SaveGlobalPreferenceAllUsersRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class saveGlobalPreferenceAllUsers


class saveGlobalPreferenceAllUsersResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, saveGlobalPreferenceAllUsersResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if saveGlobalPreferenceAllUsersResponse.subclass:
            return saveGlobalPreferenceAllUsersResponse.subclass(*args_, **kwargs_)
        else:
            return saveGlobalPreferenceAllUsersResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='saveGlobalPreferenceAllUsersResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('saveGlobalPreferenceAllUsersResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'saveGlobalPreferenceAllUsersResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='saveGlobalPreferenceAllUsersResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='saveGlobalPreferenceAllUsersResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='saveGlobalPreferenceAllUsersResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='saveGlobalPreferenceAllUsersResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SaveGlobalPreferenceAllUsersRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class saveGlobalPreferenceAllUsersResponse


class searchShipmentsByDeliveryAddress(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchShipmentsByDeliveryAddress)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchShipmentsByDeliveryAddress.subclass:
            return searchShipmentsByDeliveryAddress.subclass(*args_, **kwargs_)
        else:
            return searchShipmentsByDeliveryAddress(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByDeliveryAddress', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchShipmentsByDeliveryAddress')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchShipmentsByDeliveryAddress':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchShipmentsByDeliveryAddress')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchShipmentsByDeliveryAddress', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchShipmentsByDeliveryAddress'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByDeliveryAddress', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SearchShipmentsByDeliveryAddressRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class searchShipmentsByDeliveryAddress


class searchShipmentsByDeliveryAddressResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchShipmentsByDeliveryAddressResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchShipmentsByDeliveryAddressResponse.subclass:
            return searchShipmentsByDeliveryAddressResponse.subclass(*args_, **kwargs_)
        else:
            return searchShipmentsByDeliveryAddressResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByDeliveryAddressResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchShipmentsByDeliveryAddressResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchShipmentsByDeliveryAddressResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchShipmentsByDeliveryAddressResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchShipmentsByDeliveryAddressResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchShipmentsByDeliveryAddressResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByDeliveryAddressResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SearchShipmentsByDeliveryAddressRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class searchShipmentsByDeliveryAddressResponse


class savePreferenceAllShippers(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, savePreferenceAllShippers)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if savePreferenceAllShippers.subclass:
            return savePreferenceAllShippers.subclass(*args_, **kwargs_)
        else:
            return savePreferenceAllShippers(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='savePreferenceAllShippers', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('savePreferenceAllShippers')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'savePreferenceAllShippers':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='savePreferenceAllShippers')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='savePreferenceAllShippers', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='savePreferenceAllShippers'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='savePreferenceAllShippers', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SavePreferenceAllShippersRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class savePreferenceAllShippers


class savePreferenceAllShippersResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, savePreferenceAllShippersResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if savePreferenceAllShippersResponse.subclass:
            return savePreferenceAllShippersResponse.subclass(*args_, **kwargs_)
        else:
            return savePreferenceAllShippersResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='savePreferenceAllShippersResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('savePreferenceAllShippersResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'savePreferenceAllShippersResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='savePreferenceAllShippersResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='savePreferenceAllShippersResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='savePreferenceAllShippersResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='savePreferenceAllShippersResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SavePreferenceAllShippersRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class savePreferenceAllShippersResponse


class searchShipmentsByManifestNum(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchShipmentsByManifestNum)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchShipmentsByManifestNum.subclass:
            return searchShipmentsByManifestNum.subclass(*args_, **kwargs_)
        else:
            return searchShipmentsByManifestNum(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByManifestNum', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchShipmentsByManifestNum')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchShipmentsByManifestNum':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchShipmentsByManifestNum')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchShipmentsByManifestNum', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchShipmentsByManifestNum'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByManifestNum', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SearchShipmentsByManifestNumRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class searchShipmentsByManifestNum


class searchShipmentsByManifestNumResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchShipmentsByManifestNumResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchShipmentsByManifestNumResponse.subclass:
            return searchShipmentsByManifestNumResponse.subclass(*args_, **kwargs_)
        else:
            return searchShipmentsByManifestNumResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByManifestNumResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchShipmentsByManifestNumResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchShipmentsByManifestNumResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchShipmentsByManifestNumResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchShipmentsByManifestNumResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchShipmentsByManifestNumResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByManifestNumResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SearchShipmentsByManifestNumRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class searchShipmentsByManifestNumResponse


class searchShipmentsByReference(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchShipmentsByReference)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchShipmentsByReference.subclass:
            return searchShipmentsByReference.subclass(*args_, **kwargs_)
        else:
            return searchShipmentsByReference(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByReference', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchShipmentsByReference')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchShipmentsByReference':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchShipmentsByReference')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchShipmentsByReference', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchShipmentsByReference'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByReference', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SearchShipmentsByReferenceRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class searchShipmentsByReference


class searchShipmentsByReferenceResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchShipmentsByReferenceResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchShipmentsByReferenceResponse.subclass:
            return searchShipmentsByReferenceResponse.subclass(*args_, **kwargs_)
        else:
            return searchShipmentsByReferenceResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByReferenceResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchShipmentsByReferenceResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchShipmentsByReferenceResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchShipmentsByReferenceResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchShipmentsByReferenceResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchShipmentsByReferenceResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByReferenceResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SearchShipmentsByReferenceRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class searchShipmentsByReferenceResponse


class getConsolidatedProforma(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getConsolidatedProforma)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getConsolidatedProforma.subclass:
            return getConsolidatedProforma.subclass(*args_, **kwargs_)
        else:
            return getConsolidatedProforma(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getConsolidatedProforma', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getConsolidatedProforma')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getConsolidatedProforma':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getConsolidatedProforma')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getConsolidatedProforma', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getConsolidatedProforma'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getConsolidatedProforma', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = GetConsolidatedProformaRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class getConsolidatedProforma


class getConsolidatedProformaResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getConsolidatedProformaResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getConsolidatedProformaResponse.subclass:
            return getConsolidatedProformaResponse.subclass(*args_, **kwargs_)
        else:
            return getConsolidatedProformaResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getConsolidatedProformaResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getConsolidatedProformaResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getConsolidatedProformaResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getConsolidatedProformaResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getConsolidatedProformaResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getConsolidatedProformaResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getConsolidatedProformaResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = GetConsolidatedProformaRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class getConsolidatedProformaResponse


class exportCommodities(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, exportCommodities)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if exportCommodities.subclass:
            return exportCommodities.subclass(*args_, **kwargs_)
        else:
            return exportCommodities(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='exportCommodities', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('exportCommodities')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'exportCommodities':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='exportCommodities')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='exportCommodities', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='exportCommodities'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='exportCommodities', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = ExportCommoditiesRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class exportCommodities


class exportCommoditiesResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, exportCommoditiesResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if exportCommoditiesResponse.subclass:
            return exportCommoditiesResponse.subclass(*args_, **kwargs_)
        else:
            return exportCommoditiesResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='exportCommoditiesResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('exportCommoditiesResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'exportCommoditiesResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='exportCommoditiesResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='exportCommoditiesResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='exportCommoditiesResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='exportCommoditiesResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = ExportCommoditiesRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class exportCommoditiesResponse


class searchShipmentsByCostCentre(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchShipmentsByCostCentre)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchShipmentsByCostCentre.subclass:
            return searchShipmentsByCostCentre.subclass(*args_, **kwargs_)
        else:
            return searchShipmentsByCostCentre(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByCostCentre', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchShipmentsByCostCentre')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchShipmentsByCostCentre':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchShipmentsByCostCentre')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchShipmentsByCostCentre', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchShipmentsByCostCentre'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByCostCentre', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SearchShipmentsByCostCentreRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class searchShipmentsByCostCentre


class searchShipmentsByCostCentreResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchShipmentsByCostCentreResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchShipmentsByCostCentreResponse.subclass:
            return searchShipmentsByCostCentreResponse.subclass(*args_, **kwargs_)
        else:
            return searchShipmentsByCostCentreResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByCostCentreResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchShipmentsByCostCentreResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchShipmentsByCostCentreResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchShipmentsByCostCentreResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchShipmentsByCostCentreResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchShipmentsByCostCentreResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByCostCentreResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SearchShipmentsByCostCentreRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class searchShipmentsByCostCentreResponse


class savePreferenceAllUsers(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, savePreferenceAllUsers)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if savePreferenceAllUsers.subclass:
            return savePreferenceAllUsers.subclass(*args_, **kwargs_)
        else:
            return savePreferenceAllUsers(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='savePreferenceAllUsers', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('savePreferenceAllUsers')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'savePreferenceAllUsers':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='savePreferenceAllUsers')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='savePreferenceAllUsers', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='savePreferenceAllUsers'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='savePreferenceAllUsers', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SavePreferenceAllUsersRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class savePreferenceAllUsers


class savePreferenceAllUsersResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, savePreferenceAllUsersResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if savePreferenceAllUsersResponse.subclass:
            return savePreferenceAllUsersResponse.subclass(*args_, **kwargs_)
        else:
            return savePreferenceAllUsersResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='savePreferenceAllUsersResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('savePreferenceAllUsersResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'savePreferenceAllUsersResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='savePreferenceAllUsersResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='savePreferenceAllUsersResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='savePreferenceAllUsersResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='savePreferenceAllUsersResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SavePreferenceAllUsersRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class savePreferenceAllUsersResponse


class getAddressBookLimit(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getAddressBookLimit)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getAddressBookLimit.subclass:
            return getAddressBookLimit.subclass(*args_, **kwargs_)
        else:
            return getAddressBookLimit(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getAddressBookLimit', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getAddressBookLimit')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getAddressBookLimit':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getAddressBookLimit')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getAddressBookLimit', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getAddressBookLimit'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getAddressBookLimit', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = GetAddressBookLimitRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class getAddressBookLimit


class getAddressBookLimitResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getAddressBookLimitResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getAddressBookLimitResponse.subclass:
            return getAddressBookLimitResponse.subclass(*args_, **kwargs_)
        else:
            return getAddressBookLimitResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getAddressBookLimitResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('getAddressBookLimitResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'getAddressBookLimitResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='getAddressBookLimitResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='getAddressBookLimitResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='getAddressBookLimitResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='getAddressBookLimitResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = GetAddressBookLimitRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class getAddressBookLimitResponse


class searchShipmentsByDeliveryCity(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchShipmentsByDeliveryCity)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchShipmentsByDeliveryCity.subclass:
            return searchShipmentsByDeliveryCity.subclass(*args_, **kwargs_)
        else:
            return searchShipmentsByDeliveryCity(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByDeliveryCity', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchShipmentsByDeliveryCity')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchShipmentsByDeliveryCity':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchShipmentsByDeliveryCity')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchShipmentsByDeliveryCity', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchShipmentsByDeliveryCity'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByDeliveryCity', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SearchShipmentsByDeliveryCityRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class searchShipmentsByDeliveryCity


class searchShipmentsByDeliveryCityResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchShipmentsByDeliveryCityResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchShipmentsByDeliveryCityResponse.subclass:
            return searchShipmentsByDeliveryCityResponse.subclass(*args_, **kwargs_)
        else:
            return searchShipmentsByDeliveryCityResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByDeliveryCityResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchShipmentsByDeliveryCityResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchShipmentsByDeliveryCityResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchShipmentsByDeliveryCityResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchShipmentsByDeliveryCityResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchShipmentsByDeliveryCityResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByDeliveryCityResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SearchShipmentsByDeliveryCityRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class searchShipmentsByDeliveryCityResponse


class searchShipmentsByDeliveryName(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchShipmentsByDeliveryName)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchShipmentsByDeliveryName.subclass:
            return searchShipmentsByDeliveryName.subclass(*args_, **kwargs_)
        else:
            return searchShipmentsByDeliveryName(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByDeliveryName', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchShipmentsByDeliveryName')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchShipmentsByDeliveryName':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchShipmentsByDeliveryName')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchShipmentsByDeliveryName', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchShipmentsByDeliveryName'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByDeliveryName', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SearchShipmentsByDeliveryNameRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class searchShipmentsByDeliveryName


class searchShipmentsByDeliveryNameResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchShipmentsByDeliveryNameResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchShipmentsByDeliveryNameResponse.subclass:
            return searchShipmentsByDeliveryNameResponse.subclass(*args_, **kwargs_)
        else:
            return searchShipmentsByDeliveryNameResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByDeliveryNameResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchShipmentsByDeliveryNameResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchShipmentsByDeliveryNameResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchShipmentsByDeliveryNameResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchShipmentsByDeliveryNameResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchShipmentsByDeliveryNameResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByDeliveryNameResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SearchShipmentsByDeliveryNameRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class searchShipmentsByDeliveryNameResponse


class searchAddressByPhone(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchAddressByPhone)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchAddressByPhone.subclass:
            return searchAddressByPhone.subclass(*args_, **kwargs_)
        else:
            return searchAddressByPhone(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchAddressByPhone', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchAddressByPhone')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchAddressByPhone':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchAddressByPhone')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchAddressByPhone', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchAddressByPhone'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchAddressByPhone', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SearchAddressByPhoneRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class searchAddressByPhone


class searchAddressByPhoneResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchAddressByPhoneResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchAddressByPhoneResponse.subclass:
            return searchAddressByPhoneResponse.subclass(*args_, **kwargs_)
        else:
            return searchAddressByPhoneResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchAddressByPhoneResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchAddressByPhoneResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchAddressByPhoneResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchAddressByPhoneResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchAddressByPhoneResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchAddressByPhoneResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchAddressByPhoneResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SearchAddressByPhoneRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class searchAddressByPhoneResponse


class searchShipmentsByOrderId(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchShipmentsByOrderId)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchShipmentsByOrderId.subclass:
            return searchShipmentsByOrderId.subclass(*args_, **kwargs_)
        else:
            return searchShipmentsByOrderId(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByOrderId', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchShipmentsByOrderId')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchShipmentsByOrderId':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchShipmentsByOrderId')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchShipmentsByOrderId', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchShipmentsByOrderId'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByOrderId', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SearchShipmentsByOrderIdRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class searchShipmentsByOrderId


class searchShipmentsByOrderIdResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchShipmentsByOrderIdResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchShipmentsByOrderIdResponse.subclass:
            return searchShipmentsByOrderIdResponse.subclass(*args_, **kwargs_)
        else:
            return searchShipmentsByOrderIdResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByOrderIdResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchShipmentsByOrderIdResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchShipmentsByOrderIdResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchShipmentsByOrderIdResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchShipmentsByOrderIdResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchShipmentsByOrderIdResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByOrderIdResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SearchShipmentsByOrderIdRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class searchShipmentsByOrderIdResponse


class importCommodities(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, importCommodities)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if importCommodities.subclass:
            return importCommodities.subclass(*args_, **kwargs_)
        else:
            return importCommodities(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='importCommodities', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('importCommodities')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'importCommodities':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='importCommodities')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='importCommodities', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='importCommodities'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='importCommodities', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = ImportCommoditiesRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class importCommodities


class importCommoditiesResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, importCommoditiesResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if importCommoditiesResponse.subclass:
            return importCommoditiesResponse.subclass(*args_, **kwargs_)
        else:
            return importCommoditiesResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='importCommoditiesResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('importCommoditiesResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'importCommoditiesResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='importCommoditiesResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='importCommoditiesResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='importCommoditiesResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='importCommoditiesResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = ImportCommoditiesRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class importCommoditiesResponse


class searchShipmentsByShippingDate(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, request=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.request = request
        self.request_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchShipmentsByShippingDate)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchShipmentsByShippingDate.subclass:
            return searchShipmentsByShippingDate.subclass(*args_, **kwargs_)
        else:
            return searchShipmentsByShippingDate(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_request(self):
        return self.request
    def set_request(self, request):
        self.request = request
    def hasContent_(self):
        if (
            self.request is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByShippingDate', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchShipmentsByShippingDate')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchShipmentsByShippingDate':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchShipmentsByShippingDate')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchShipmentsByShippingDate', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchShipmentsByShippingDate'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByShippingDate', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.request is not None:
            namespaceprefix_ = self.request_nsprefix_ + ':' if (UseCapturedNS_ and self.request_nsprefix_) else ''
            self.request.export(outfile, level, namespaceprefix_, namespacedef_='', name_='request', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'request':
            obj_ = SearchShipmentsByShippingDateRq.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.request = obj_
            obj_.original_tagname_ = 'request'
# end class searchShipmentsByShippingDate


class searchShipmentsByShippingDateResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, return_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.return_ = return_
        self.return__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, searchShipmentsByShippingDateResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if searchShipmentsByShippingDateResponse.subclass:
            return searchShipmentsByShippingDateResponse.subclass(*args_, **kwargs_)
        else:
            return searchShipmentsByShippingDateResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_return(self):
        return self.return_
    def set_return(self, return_):
        self.return_ = return_
    def hasContent_(self):
        if (
            self.return_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByShippingDateResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('searchShipmentsByShippingDateResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'searchShipmentsByShippingDateResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='searchShipmentsByShippingDateResponse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='searchShipmentsByShippingDateResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='searchShipmentsByShippingDateResponse'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='searchShipmentsByShippingDateResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.return_ is not None:
            namespaceprefix_ = self.return__nsprefix_ + ':' if (UseCapturedNS_ and self.return__nsprefix_) else ''
            self.return_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='return', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'return':
            obj_ = SearchShipmentsByShippingDateRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.return_ = obj_
            obj_.original_tagname_ = 'return'
# end class searchShipmentsByShippingDateResponse


class GetManifestRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, manifest_num=None, password=None, shipper_num=None, type_=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.manifest_num = manifest_num
        self.manifest_num_nsprefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        self.shipper_num = shipper_num
        self.shipper_num_nsprefix_ = None
        self.type_ = type_
        self.type__nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetManifestRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetManifestRq.subclass:
            return GetManifestRq.subclass(*args_, **kwargs_)
        else:
            return GetManifestRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_manifest_num(self):
        return self.manifest_num
    def set_manifest_num(self, manifest_num):
        self.manifest_num = manifest_num
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_shipper_num(self):
        return self.shipper_num
    def set_shipper_num(self, shipper_num):
        self.shipper_num = shipper_num
    def get_type(self):
        return self.type_
    def set_type(self, type_):
        self.type_ = type_
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.manifest_num is not None or
            self.password is not None or
            self.shipper_num is not None or
            self.type_ is not None or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetManifestRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GetManifestRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GetManifestRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GetManifestRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GetManifestRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GetManifestRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetManifestRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.manifest_num is not None:
            namespaceprefix_ = self.manifest_num_nsprefix_ + ':' if (UseCapturedNS_ and self.manifest_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smanifest_num>%s</%smanifest_num>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.manifest_num), input_name='manifest_num')), namespaceprefix_ , eol_))
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        if self.shipper_num is not None:
            namespaceprefix_ = self.shipper_num_nsprefix_ + ':' if (UseCapturedNS_ and self.shipper_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sshipper_num>%s</%sshipper_num>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.shipper_num), input_name='shipper_num')), namespaceprefix_ , eol_))
        if self.type_ is not None:
            namespaceprefix_ = self.type__nsprefix_ + ':' if (UseCapturedNS_ and self.type__nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stype>%s</%stype>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.type_), input_name='type')), namespaceprefix_ , eol_))
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'manifest_num':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'manifest_num')
            value_ = self.gds_validate_string(value_, node, 'manifest_num')
            self.manifest_num = value_
            self.manifest_num_nsprefix_ = child_.prefix
        elif nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'shipper_num':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'shipper_num')
            value_ = self.gds_validate_string(value_, node, 'shipper_num')
            self.shipper_num = value_
            self.shipper_num_nsprefix_ = child_.prefix
        elif nodeName_ == 'type':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'type')
            value_ = self.gds_validate_string(value_, node, 'type')
            self.type_ = value_
            self.type_nsprefix_ = child_.prefix
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class GetManifestRq


class GetManifestRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, manifest=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
        self.manifest = manifest
        self.manifest_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetManifestRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetManifestRs.subclass:
            return GetManifestRs.subclass(*args_, **kwargs_)
        else:
            return GetManifestRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def get_manifest(self):
        return self.manifest
    def set_manifest(self, manifest):
        self.manifest = manifest
    def hasContent_(self):
        if (
            self.error is not None or
            self.manifest is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetManifestRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GetManifestRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GetManifestRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GetManifestRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GetManifestRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GetManifestRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetManifestRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
        if self.manifest is not None:
            namespaceprefix_ = self.manifest_nsprefix_ + ':' if (UseCapturedNS_ and self.manifest_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smanifest>%s</%smanifest>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.manifest), input_name='manifest')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
        elif nodeName_ == 'manifest':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'manifest')
            value_ = self.gds_validate_string(value_, node, 'manifest')
            self.manifest = value_
            self.manifest_nsprefix_ = child_.prefix
# end class GetManifestRs


class GetVersionRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, version=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
        self.version = version
        self.version_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetVersionRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetVersionRs.subclass:
            return GetVersionRs.subclass(*args_, **kwargs_)
        else:
            return GetVersionRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def get_version(self):
        return self.version
    def set_version(self, version):
        self.version = version
    def hasContent_(self):
        if (
            self.error is not None or
            self.version is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetVersionRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GetVersionRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GetVersionRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GetVersionRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GetVersionRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GetVersionRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetVersionRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
        if self.version is not None:
            namespaceprefix_ = self.version_nsprefix_ + ':' if (UseCapturedNS_ and self.version_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sversion>%s</%sversion>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.version), input_name='version')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
        elif nodeName_ == 'version':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'version')
            value_ = self.gds_validate_string(value_, node, 'version')
            self.version = value_
            self.version_nsprefix_ = child_.prefix
# end class GetVersionRs


class GetLabelsRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, id=None, password=None, thermal=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = id
        self.id_nsprefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        self.thermal = thermal
        self.thermal_nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetLabelsRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetLabelsRq.subclass:
            return GetLabelsRq.subclass(*args_, **kwargs_)
        else:
            return GetLabelsRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_thermal(self):
        return self.thermal
    def set_thermal(self, thermal):
        self.thermal = thermal
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.id is not None or
            self.password is not None or
            self.thermal is not None or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetLabelsRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GetLabelsRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GetLabelsRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GetLabelsRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GetLabelsRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GetLabelsRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetLabelsRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.id is not None:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sid>%s</%sid>%s' % (namespaceprefix_ , self.gds_format_integer(self.id, input_name='id'), namespaceprefix_ , eol_))
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        if self.thermal is not None:
            namespaceprefix_ = self.thermal_nsprefix_ + ':' if (UseCapturedNS_ and self.thermal_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sthermal>%s</%sthermal>%s' % (namespaceprefix_ , self.gds_format_boolean(self.thermal, input_name='thermal'), namespaceprefix_ , eol_))
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'id' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'id')
            ival_ = self.gds_validate_integer(ival_, node, 'id')
            self.id = ival_
            self.id_nsprefix_ = child_.prefix
        elif nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'thermal':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'thermal')
            ival_ = self.gds_validate_boolean(ival_, node, 'thermal')
            self.thermal = ival_
            self.thermal_nsprefix_ = child_.prefix
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class GetLabelsRq


class GetLabelsRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, labels=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
        if labels is None:
            self.labels = []
        else:
            self.labels = labels
        self.labels_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetLabelsRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetLabelsRs.subclass:
            return GetLabelsRs.subclass(*args_, **kwargs_)
        else:
            return GetLabelsRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def get_labels(self):
        return self.labels
    def set_labels(self, labels):
        self.labels = labels
    def add_labels(self, value):
        self.labels.append(value)
    def insert_labels_at(self, index, value):
        self.labels.insert(index, value)
    def replace_labels_at(self, index, value):
        self.labels[index] = value
    def hasContent_(self):
        if (
            self.error is not None or
            self.labels
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetLabelsRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GetLabelsRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GetLabelsRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GetLabelsRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GetLabelsRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GetLabelsRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetLabelsRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
        for labels_ in self.labels:
            namespaceprefix_ = self.labels_nsprefix_ + ':' if (UseCapturedNS_ and self.labels_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slabels>%s</%slabels>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(labels_), input_name='labels')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
        elif nodeName_ == 'labels':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'labels')
            value_ = self.gds_validate_string(value_, node, 'labels')
            self.labels.append(value_)
            self.labels_nsprefix_ = child_.prefix
# end class GetLabelsRs


class GetUsersRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, password=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetUsersRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetUsersRq.subclass:
            return GetUsersRq.subclass(*args_, **kwargs_)
        else:
            return GetUsersRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.password is not None or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetUsersRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GetUsersRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GetUsersRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GetUsersRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GetUsersRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GetUsersRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetUsersRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class GetUsersRq


class GetUsersRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, user=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
        if user is None:
            self.user = []
        else:
            self.user = user
        self.user_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetUsersRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetUsersRs.subclass:
            return GetUsersRs.subclass(*args_, **kwargs_)
        else:
            return GetUsersRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def get_user(self):
        return self.user
    def set_user(self, user):
        self.user = user
    def add_user(self, value):
        self.user.append(value)
    def insert_user_at(self, index, value):
        self.user.insert(index, value)
    def replace_user_at(self, index, value):
        self.user[index] = value
    def hasContent_(self):
        if (
            self.error is not None or
            self.user
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetUsersRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GetUsersRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GetUsersRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GetUsersRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GetUsersRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GetUsersRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetUsersRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
        for user_ in self.user:
            namespaceprefix_ = self.user_nsprefix_ + ':' if (UseCapturedNS_ and self.user_nsprefix_) else ''
            user_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='user', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
        elif nodeName_ == 'user':
            obj_ = CanshipUser.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.user.append(obj_)
            obj_.original_tagname_ = 'user'
# end class GetUsersRs


class SearchShipmentsByDeliveryPostalCodeRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, from_shipping_date=None, page_num=None, password=None, postal_code=None, shipper_num=None, to_shipping_date=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if isinstance(from_shipping_date, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(from_shipping_date, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = from_shipping_date
        self.from_shipping_date = initvalue_
        self.from_shipping_date_nsprefix_ = None
        self.page_num = page_num
        self.page_num_nsprefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        self.postal_code = postal_code
        self.postal_code_nsprefix_ = None
        self.shipper_num = shipper_num
        self.shipper_num_nsprefix_ = None
        if isinstance(to_shipping_date, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(to_shipping_date, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = to_shipping_date
        self.to_shipping_date = initvalue_
        self.to_shipping_date_nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SearchShipmentsByDeliveryPostalCodeRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SearchShipmentsByDeliveryPostalCodeRq.subclass:
            return SearchShipmentsByDeliveryPostalCodeRq.subclass(*args_, **kwargs_)
        else:
            return SearchShipmentsByDeliveryPostalCodeRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_from_shipping_date(self):
        return self.from_shipping_date
    def set_from_shipping_date(self, from_shipping_date):
        self.from_shipping_date = from_shipping_date
    def get_page_num(self):
        return self.page_num
    def set_page_num(self, page_num):
        self.page_num = page_num
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_postal_code(self):
        return self.postal_code
    def set_postal_code(self, postal_code):
        self.postal_code = postal_code
    def get_shipper_num(self):
        return self.shipper_num
    def set_shipper_num(self, shipper_num):
        self.shipper_num = shipper_num
    def get_to_shipping_date(self):
        return self.to_shipping_date
    def set_to_shipping_date(self, to_shipping_date):
        self.to_shipping_date = to_shipping_date
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.from_shipping_date is not None or
            self.page_num is not None or
            self.password is not None or
            self.postal_code is not None or
            self.shipper_num is not None or
            self.to_shipping_date is not None or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchShipmentsByDeliveryPostalCodeRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SearchShipmentsByDeliveryPostalCodeRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SearchShipmentsByDeliveryPostalCodeRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SearchShipmentsByDeliveryPostalCodeRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SearchShipmentsByDeliveryPostalCodeRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SearchShipmentsByDeliveryPostalCodeRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchShipmentsByDeliveryPostalCodeRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.from_shipping_date is not None:
            namespaceprefix_ = self.from_shipping_date_nsprefix_ + ':' if (UseCapturedNS_ and self.from_shipping_date_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfrom_shipping_date>%s</%sfrom_shipping_date>%s' % (namespaceprefix_ , self.gds_format_datetime(self.from_shipping_date, input_name='from_shipping_date'), namespaceprefix_ , eol_))
        if self.page_num is not None:
            namespaceprefix_ = self.page_num_nsprefix_ + ':' if (UseCapturedNS_ and self.page_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spage_num>%s</%spage_num>%s' % (namespaceprefix_ , self.gds_format_integer(self.page_num, input_name='page_num'), namespaceprefix_ , eol_))
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        if self.postal_code is not None:
            namespaceprefix_ = self.postal_code_nsprefix_ + ':' if (UseCapturedNS_ and self.postal_code_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spostal_code>%s</%spostal_code>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.postal_code), input_name='postal_code')), namespaceprefix_ , eol_))
        if self.shipper_num is not None:
            namespaceprefix_ = self.shipper_num_nsprefix_ + ':' if (UseCapturedNS_ and self.shipper_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sshipper_num>%s</%sshipper_num>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.shipper_num), input_name='shipper_num')), namespaceprefix_ , eol_))
        if self.to_shipping_date is not None:
            namespaceprefix_ = self.to_shipping_date_nsprefix_ + ':' if (UseCapturedNS_ and self.to_shipping_date_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sto_shipping_date>%s</%sto_shipping_date>%s' % (namespaceprefix_ , self.gds_format_datetime(self.to_shipping_date, input_name='to_shipping_date'), namespaceprefix_ , eol_))
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'from_shipping_date':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.from_shipping_date = dval_
            self.from_shipping_date_nsprefix_ = child_.prefix
        elif nodeName_ == 'page_num' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'page_num')
            ival_ = self.gds_validate_integer(ival_, node, 'page_num')
            self.page_num = ival_
            self.page_num_nsprefix_ = child_.prefix
        elif nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'postal_code':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'postal_code')
            value_ = self.gds_validate_string(value_, node, 'postal_code')
            self.postal_code = value_
            self.postal_code_nsprefix_ = child_.prefix
        elif nodeName_ == 'shipper_num':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'shipper_num')
            value_ = self.gds_validate_string(value_, node, 'shipper_num')
            self.shipper_num = value_
            self.shipper_num_nsprefix_ = child_.prefix
        elif nodeName_ == 'to_shipping_date':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.to_shipping_date = dval_
            self.to_shipping_date_nsprefix_ = child_.prefix
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class SearchShipmentsByDeliveryPostalCodeRq


class SearchShipmentsByDeliveryPostalCodeRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, shipment=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
        if shipment is None:
            self.shipment = []
        else:
            self.shipment = shipment
        self.shipment_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SearchShipmentsByDeliveryPostalCodeRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SearchShipmentsByDeliveryPostalCodeRs.subclass:
            return SearchShipmentsByDeliveryPostalCodeRs.subclass(*args_, **kwargs_)
        else:
            return SearchShipmentsByDeliveryPostalCodeRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def get_shipment(self):
        return self.shipment
    def set_shipment(self, shipment):
        self.shipment = shipment
    def add_shipment(self, value):
        self.shipment.append(value)
    def insert_shipment_at(self, index, value):
        self.shipment.insert(index, value)
    def replace_shipment_at(self, index, value):
        self.shipment[index] = value
    def hasContent_(self):
        if (
            self.error is not None or
            self.shipment
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchShipmentsByDeliveryPostalCodeRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SearchShipmentsByDeliveryPostalCodeRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SearchShipmentsByDeliveryPostalCodeRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SearchShipmentsByDeliveryPostalCodeRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SearchShipmentsByDeliveryPostalCodeRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SearchShipmentsByDeliveryPostalCodeRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchShipmentsByDeliveryPostalCodeRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
        for shipment_ in self.shipment:
            namespaceprefix_ = self.shipment_nsprefix_ + ':' if (UseCapturedNS_ and self.shipment_nsprefix_) else ''
            shipment_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='shipment', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
        elif nodeName_ == 'shipment':
            obj_ = Shipment.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.shipment.append(obj_)
            obj_.original_tagname_ = 'shipment'
# end class SearchShipmentsByDeliveryPostalCodeRs


class SearchShipmentsByDeliveryProvinceRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, from_shipping_date=None, page_num=None, password=None, province=None, shipper_num=None, to_shipping_date=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if isinstance(from_shipping_date, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(from_shipping_date, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = from_shipping_date
        self.from_shipping_date = initvalue_
        self.from_shipping_date_nsprefix_ = None
        self.page_num = page_num
        self.page_num_nsprefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        self.province = province
        self.province_nsprefix_ = None
        self.shipper_num = shipper_num
        self.shipper_num_nsprefix_ = None
        if isinstance(to_shipping_date, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(to_shipping_date, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = to_shipping_date
        self.to_shipping_date = initvalue_
        self.to_shipping_date_nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SearchShipmentsByDeliveryProvinceRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SearchShipmentsByDeliveryProvinceRq.subclass:
            return SearchShipmentsByDeliveryProvinceRq.subclass(*args_, **kwargs_)
        else:
            return SearchShipmentsByDeliveryProvinceRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_from_shipping_date(self):
        return self.from_shipping_date
    def set_from_shipping_date(self, from_shipping_date):
        self.from_shipping_date = from_shipping_date
    def get_page_num(self):
        return self.page_num
    def set_page_num(self, page_num):
        self.page_num = page_num
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_province(self):
        return self.province
    def set_province(self, province):
        self.province = province
    def get_shipper_num(self):
        return self.shipper_num
    def set_shipper_num(self, shipper_num):
        self.shipper_num = shipper_num
    def get_to_shipping_date(self):
        return self.to_shipping_date
    def set_to_shipping_date(self, to_shipping_date):
        self.to_shipping_date = to_shipping_date
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.from_shipping_date is not None or
            self.page_num is not None or
            self.password is not None or
            self.province is not None or
            self.shipper_num is not None or
            self.to_shipping_date is not None or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchShipmentsByDeliveryProvinceRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SearchShipmentsByDeliveryProvinceRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SearchShipmentsByDeliveryProvinceRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SearchShipmentsByDeliveryProvinceRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SearchShipmentsByDeliveryProvinceRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SearchShipmentsByDeliveryProvinceRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchShipmentsByDeliveryProvinceRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.from_shipping_date is not None:
            namespaceprefix_ = self.from_shipping_date_nsprefix_ + ':' if (UseCapturedNS_ and self.from_shipping_date_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfrom_shipping_date>%s</%sfrom_shipping_date>%s' % (namespaceprefix_ , self.gds_format_datetime(self.from_shipping_date, input_name='from_shipping_date'), namespaceprefix_ , eol_))
        if self.page_num is not None:
            namespaceprefix_ = self.page_num_nsprefix_ + ':' if (UseCapturedNS_ and self.page_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spage_num>%s</%spage_num>%s' % (namespaceprefix_ , self.gds_format_integer(self.page_num, input_name='page_num'), namespaceprefix_ , eol_))
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        if self.province is not None:
            namespaceprefix_ = self.province_nsprefix_ + ':' if (UseCapturedNS_ and self.province_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sprovince>%s</%sprovince>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.province), input_name='province')), namespaceprefix_ , eol_))
        if self.shipper_num is not None:
            namespaceprefix_ = self.shipper_num_nsprefix_ + ':' if (UseCapturedNS_ and self.shipper_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sshipper_num>%s</%sshipper_num>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.shipper_num), input_name='shipper_num')), namespaceprefix_ , eol_))
        if self.to_shipping_date is not None:
            namespaceprefix_ = self.to_shipping_date_nsprefix_ + ':' if (UseCapturedNS_ and self.to_shipping_date_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sto_shipping_date>%s</%sto_shipping_date>%s' % (namespaceprefix_ , self.gds_format_datetime(self.to_shipping_date, input_name='to_shipping_date'), namespaceprefix_ , eol_))
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'from_shipping_date':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.from_shipping_date = dval_
            self.from_shipping_date_nsprefix_ = child_.prefix
        elif nodeName_ == 'page_num' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'page_num')
            ival_ = self.gds_validate_integer(ival_, node, 'page_num')
            self.page_num = ival_
            self.page_num_nsprefix_ = child_.prefix
        elif nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'province':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'province')
            value_ = self.gds_validate_string(value_, node, 'province')
            self.province = value_
            self.province_nsprefix_ = child_.prefix
        elif nodeName_ == 'shipper_num':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'shipper_num')
            value_ = self.gds_validate_string(value_, node, 'shipper_num')
            self.shipper_num = value_
            self.shipper_num_nsprefix_ = child_.prefix
        elif nodeName_ == 'to_shipping_date':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.to_shipping_date = dval_
            self.to_shipping_date_nsprefix_ = child_.prefix
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class SearchShipmentsByDeliveryProvinceRq


class SearchShipmentsByDeliveryProvinceRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, shipment=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
        if shipment is None:
            self.shipment = []
        else:
            self.shipment = shipment
        self.shipment_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SearchShipmentsByDeliveryProvinceRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SearchShipmentsByDeliveryProvinceRs.subclass:
            return SearchShipmentsByDeliveryProvinceRs.subclass(*args_, **kwargs_)
        else:
            return SearchShipmentsByDeliveryProvinceRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def get_shipment(self):
        return self.shipment
    def set_shipment(self, shipment):
        self.shipment = shipment
    def add_shipment(self, value):
        self.shipment.append(value)
    def insert_shipment_at(self, index, value):
        self.shipment.insert(index, value)
    def replace_shipment_at(self, index, value):
        self.shipment[index] = value
    def hasContent_(self):
        if (
            self.error is not None or
            self.shipment
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchShipmentsByDeliveryProvinceRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SearchShipmentsByDeliveryProvinceRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SearchShipmentsByDeliveryProvinceRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SearchShipmentsByDeliveryProvinceRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SearchShipmentsByDeliveryProvinceRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SearchShipmentsByDeliveryProvinceRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchShipmentsByDeliveryProvinceRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
        for shipment_ in self.shipment:
            namespaceprefix_ = self.shipment_nsprefix_ + ':' if (UseCapturedNS_ and self.shipment_nsprefix_) else ''
            shipment_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='shipment', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
        elif nodeName_ == 'shipment':
            obj_ = Shipment.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.shipment.append(obj_)
            obj_.original_tagname_ = 'shipment'
# end class SearchShipmentsByDeliveryProvinceRs


class SearchShipmentsByDeliveryAddressIdRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, address_id=None, from_shipping_date=None, page_num=None, password=None, shipper_num=None, to_shipping_date=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.address_id = address_id
        self.address_id_nsprefix_ = None
        if isinstance(from_shipping_date, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(from_shipping_date, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = from_shipping_date
        self.from_shipping_date = initvalue_
        self.from_shipping_date_nsprefix_ = None
        self.page_num = page_num
        self.page_num_nsprefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        self.shipper_num = shipper_num
        self.shipper_num_nsprefix_ = None
        if isinstance(to_shipping_date, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(to_shipping_date, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = to_shipping_date
        self.to_shipping_date = initvalue_
        self.to_shipping_date_nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SearchShipmentsByDeliveryAddressIdRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SearchShipmentsByDeliveryAddressIdRq.subclass:
            return SearchShipmentsByDeliveryAddressIdRq.subclass(*args_, **kwargs_)
        else:
            return SearchShipmentsByDeliveryAddressIdRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_address_id(self):
        return self.address_id
    def set_address_id(self, address_id):
        self.address_id = address_id
    def get_from_shipping_date(self):
        return self.from_shipping_date
    def set_from_shipping_date(self, from_shipping_date):
        self.from_shipping_date = from_shipping_date
    def get_page_num(self):
        return self.page_num
    def set_page_num(self, page_num):
        self.page_num = page_num
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_shipper_num(self):
        return self.shipper_num
    def set_shipper_num(self, shipper_num):
        self.shipper_num = shipper_num
    def get_to_shipping_date(self):
        return self.to_shipping_date
    def set_to_shipping_date(self, to_shipping_date):
        self.to_shipping_date = to_shipping_date
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.address_id is not None or
            self.from_shipping_date is not None or
            self.page_num is not None or
            self.password is not None or
            self.shipper_num is not None or
            self.to_shipping_date is not None or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchShipmentsByDeliveryAddressIdRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SearchShipmentsByDeliveryAddressIdRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SearchShipmentsByDeliveryAddressIdRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SearchShipmentsByDeliveryAddressIdRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SearchShipmentsByDeliveryAddressIdRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SearchShipmentsByDeliveryAddressIdRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchShipmentsByDeliveryAddressIdRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.address_id is not None:
            namespaceprefix_ = self.address_id_nsprefix_ + ':' if (UseCapturedNS_ and self.address_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saddress_id>%s</%saddress_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.address_id), input_name='address_id')), namespaceprefix_ , eol_))
        if self.from_shipping_date is not None:
            namespaceprefix_ = self.from_shipping_date_nsprefix_ + ':' if (UseCapturedNS_ and self.from_shipping_date_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfrom_shipping_date>%s</%sfrom_shipping_date>%s' % (namespaceprefix_ , self.gds_format_datetime(self.from_shipping_date, input_name='from_shipping_date'), namespaceprefix_ , eol_))
        if self.page_num is not None:
            namespaceprefix_ = self.page_num_nsprefix_ + ':' if (UseCapturedNS_ and self.page_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spage_num>%s</%spage_num>%s' % (namespaceprefix_ , self.gds_format_integer(self.page_num, input_name='page_num'), namespaceprefix_ , eol_))
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        if self.shipper_num is not None:
            namespaceprefix_ = self.shipper_num_nsprefix_ + ':' if (UseCapturedNS_ and self.shipper_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sshipper_num>%s</%sshipper_num>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.shipper_num), input_name='shipper_num')), namespaceprefix_ , eol_))
        if self.to_shipping_date is not None:
            namespaceprefix_ = self.to_shipping_date_nsprefix_ + ':' if (UseCapturedNS_ and self.to_shipping_date_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sto_shipping_date>%s</%sto_shipping_date>%s' % (namespaceprefix_ , self.gds_format_datetime(self.to_shipping_date, input_name='to_shipping_date'), namespaceprefix_ , eol_))
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'address_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'address_id')
            value_ = self.gds_validate_string(value_, node, 'address_id')
            self.address_id = value_
            self.address_id_nsprefix_ = child_.prefix
        elif nodeName_ == 'from_shipping_date':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.from_shipping_date = dval_
            self.from_shipping_date_nsprefix_ = child_.prefix
        elif nodeName_ == 'page_num' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'page_num')
            ival_ = self.gds_validate_integer(ival_, node, 'page_num')
            self.page_num = ival_
            self.page_num_nsprefix_ = child_.prefix
        elif nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'shipper_num':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'shipper_num')
            value_ = self.gds_validate_string(value_, node, 'shipper_num')
            self.shipper_num = value_
            self.shipper_num_nsprefix_ = child_.prefix
        elif nodeName_ == 'to_shipping_date':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.to_shipping_date = dval_
            self.to_shipping_date_nsprefix_ = child_.prefix
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class SearchShipmentsByDeliveryAddressIdRq


class SearchShipmentsByDeliveryAddressIdRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, shipment=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
        if shipment is None:
            self.shipment = []
        else:
            self.shipment = shipment
        self.shipment_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SearchShipmentsByDeliveryAddressIdRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SearchShipmentsByDeliveryAddressIdRs.subclass:
            return SearchShipmentsByDeliveryAddressIdRs.subclass(*args_, **kwargs_)
        else:
            return SearchShipmentsByDeliveryAddressIdRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def get_shipment(self):
        return self.shipment
    def set_shipment(self, shipment):
        self.shipment = shipment
    def add_shipment(self, value):
        self.shipment.append(value)
    def insert_shipment_at(self, index, value):
        self.shipment.insert(index, value)
    def replace_shipment_at(self, index, value):
        self.shipment[index] = value
    def hasContent_(self):
        if (
            self.error is not None or
            self.shipment
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchShipmentsByDeliveryAddressIdRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SearchShipmentsByDeliveryAddressIdRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SearchShipmentsByDeliveryAddressIdRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SearchShipmentsByDeliveryAddressIdRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SearchShipmentsByDeliveryAddressIdRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SearchShipmentsByDeliveryAddressIdRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchShipmentsByDeliveryAddressIdRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
        for shipment_ in self.shipment:
            namespaceprefix_ = self.shipment_nsprefix_ + ':' if (UseCapturedNS_ and self.shipment_nsprefix_) else ''
            shipment_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='shipment', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
        elif nodeName_ == 'shipment':
            obj_ = Shipment.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.shipment.append(obj_)
            obj_.original_tagname_ = 'shipment'
# end class SearchShipmentsByDeliveryAddressIdRs


class SearchShipmentsByAlternativeReferenceRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, alternative_reference=None, from_shipping_date=None, page_num=None, password=None, shipper_num=None, to_shipping_date=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.alternative_reference = alternative_reference
        self.alternative_reference_nsprefix_ = None
        if isinstance(from_shipping_date, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(from_shipping_date, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = from_shipping_date
        self.from_shipping_date = initvalue_
        self.from_shipping_date_nsprefix_ = None
        self.page_num = page_num
        self.page_num_nsprefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        self.shipper_num = shipper_num
        self.shipper_num_nsprefix_ = None
        if isinstance(to_shipping_date, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(to_shipping_date, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = to_shipping_date
        self.to_shipping_date = initvalue_
        self.to_shipping_date_nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SearchShipmentsByAlternativeReferenceRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SearchShipmentsByAlternativeReferenceRq.subclass:
            return SearchShipmentsByAlternativeReferenceRq.subclass(*args_, **kwargs_)
        else:
            return SearchShipmentsByAlternativeReferenceRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_alternative_reference(self):
        return self.alternative_reference
    def set_alternative_reference(self, alternative_reference):
        self.alternative_reference = alternative_reference
    def get_from_shipping_date(self):
        return self.from_shipping_date
    def set_from_shipping_date(self, from_shipping_date):
        self.from_shipping_date = from_shipping_date
    def get_page_num(self):
        return self.page_num
    def set_page_num(self, page_num):
        self.page_num = page_num
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_shipper_num(self):
        return self.shipper_num
    def set_shipper_num(self, shipper_num):
        self.shipper_num = shipper_num
    def get_to_shipping_date(self):
        return self.to_shipping_date
    def set_to_shipping_date(self, to_shipping_date):
        self.to_shipping_date = to_shipping_date
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.alternative_reference is not None or
            self.from_shipping_date is not None or
            self.page_num is not None or
            self.password is not None or
            self.shipper_num is not None or
            self.to_shipping_date is not None or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchShipmentsByAlternativeReferenceRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SearchShipmentsByAlternativeReferenceRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SearchShipmentsByAlternativeReferenceRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SearchShipmentsByAlternativeReferenceRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SearchShipmentsByAlternativeReferenceRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SearchShipmentsByAlternativeReferenceRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchShipmentsByAlternativeReferenceRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.alternative_reference is not None:
            namespaceprefix_ = self.alternative_reference_nsprefix_ + ':' if (UseCapturedNS_ and self.alternative_reference_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%salternative_reference>%s</%salternative_reference>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.alternative_reference), input_name='alternative_reference')), namespaceprefix_ , eol_))
        if self.from_shipping_date is not None:
            namespaceprefix_ = self.from_shipping_date_nsprefix_ + ':' if (UseCapturedNS_ and self.from_shipping_date_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfrom_shipping_date>%s</%sfrom_shipping_date>%s' % (namespaceprefix_ , self.gds_format_datetime(self.from_shipping_date, input_name='from_shipping_date'), namespaceprefix_ , eol_))
        if self.page_num is not None:
            namespaceprefix_ = self.page_num_nsprefix_ + ':' if (UseCapturedNS_ and self.page_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spage_num>%s</%spage_num>%s' % (namespaceprefix_ , self.gds_format_integer(self.page_num, input_name='page_num'), namespaceprefix_ , eol_))
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        if self.shipper_num is not None:
            namespaceprefix_ = self.shipper_num_nsprefix_ + ':' if (UseCapturedNS_ and self.shipper_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sshipper_num>%s</%sshipper_num>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.shipper_num), input_name='shipper_num')), namespaceprefix_ , eol_))
        if self.to_shipping_date is not None:
            namespaceprefix_ = self.to_shipping_date_nsprefix_ + ':' if (UseCapturedNS_ and self.to_shipping_date_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sto_shipping_date>%s</%sto_shipping_date>%s' % (namespaceprefix_ , self.gds_format_datetime(self.to_shipping_date, input_name='to_shipping_date'), namespaceprefix_ , eol_))
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'alternative_reference':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'alternative_reference')
            value_ = self.gds_validate_string(value_, node, 'alternative_reference')
            self.alternative_reference = value_
            self.alternative_reference_nsprefix_ = child_.prefix
        elif nodeName_ == 'from_shipping_date':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.from_shipping_date = dval_
            self.from_shipping_date_nsprefix_ = child_.prefix
        elif nodeName_ == 'page_num' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'page_num')
            ival_ = self.gds_validate_integer(ival_, node, 'page_num')
            self.page_num = ival_
            self.page_num_nsprefix_ = child_.prefix
        elif nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'shipper_num':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'shipper_num')
            value_ = self.gds_validate_string(value_, node, 'shipper_num')
            self.shipper_num = value_
            self.shipper_num_nsprefix_ = child_.prefix
        elif nodeName_ == 'to_shipping_date':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.to_shipping_date = dval_
            self.to_shipping_date_nsprefix_ = child_.prefix
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class SearchShipmentsByAlternativeReferenceRq


class SearchShipmentsByAlternativeReferenceRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, shipment=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
        if shipment is None:
            self.shipment = []
        else:
            self.shipment = shipment
        self.shipment_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SearchShipmentsByAlternativeReferenceRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SearchShipmentsByAlternativeReferenceRs.subclass:
            return SearchShipmentsByAlternativeReferenceRs.subclass(*args_, **kwargs_)
        else:
            return SearchShipmentsByAlternativeReferenceRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def get_shipment(self):
        return self.shipment
    def set_shipment(self, shipment):
        self.shipment = shipment
    def add_shipment(self, value):
        self.shipment.append(value)
    def insert_shipment_at(self, index, value):
        self.shipment.insert(index, value)
    def replace_shipment_at(self, index, value):
        self.shipment[index] = value
    def hasContent_(self):
        if (
            self.error is not None or
            self.shipment
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchShipmentsByAlternativeReferenceRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SearchShipmentsByAlternativeReferenceRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SearchShipmentsByAlternativeReferenceRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SearchShipmentsByAlternativeReferenceRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SearchShipmentsByAlternativeReferenceRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SearchShipmentsByAlternativeReferenceRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchShipmentsByAlternativeReferenceRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
        for shipment_ in self.shipment:
            namespaceprefix_ = self.shipment_nsprefix_ + ':' if (UseCapturedNS_ and self.shipment_nsprefix_) else ''
            shipment_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='shipment', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
        elif nodeName_ == 'shipment':
            obj_ = Shipment.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.shipment.append(obj_)
            obj_.original_tagname_ = 'shipment'
# end class SearchShipmentsByAlternativeReferenceRs


class GetLabelsAdvancedRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, horizontal=None, id=None, password=None, thermal=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.horizontal = horizontal
        self.horizontal_nsprefix_ = None
        self.id = id
        self.id_nsprefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        self.thermal = thermal
        self.thermal_nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetLabelsAdvancedRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetLabelsAdvancedRq.subclass:
            return GetLabelsAdvancedRq.subclass(*args_, **kwargs_)
        else:
            return GetLabelsAdvancedRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_horizontal(self):
        return self.horizontal
    def set_horizontal(self, horizontal):
        self.horizontal = horizontal
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_thermal(self):
        return self.thermal
    def set_thermal(self, thermal):
        self.thermal = thermal
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.horizontal is not None or
            self.id is not None or
            self.password is not None or
            self.thermal is not None or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetLabelsAdvancedRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GetLabelsAdvancedRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GetLabelsAdvancedRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GetLabelsAdvancedRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GetLabelsAdvancedRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GetLabelsAdvancedRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetLabelsAdvancedRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.horizontal is not None:
            namespaceprefix_ = self.horizontal_nsprefix_ + ':' if (UseCapturedNS_ and self.horizontal_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%shorizontal>%s</%shorizontal>%s' % (namespaceprefix_ , self.gds_format_boolean(self.horizontal, input_name='horizontal'), namespaceprefix_ , eol_))
        if self.id is not None:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sid>%s</%sid>%s' % (namespaceprefix_ , self.gds_format_integer(self.id, input_name='id'), namespaceprefix_ , eol_))
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        if self.thermal is not None:
            namespaceprefix_ = self.thermal_nsprefix_ + ':' if (UseCapturedNS_ and self.thermal_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sthermal>%s</%sthermal>%s' % (namespaceprefix_ , self.gds_format_boolean(self.thermal, input_name='thermal'), namespaceprefix_ , eol_))
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'horizontal':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'horizontal')
            ival_ = self.gds_validate_boolean(ival_, node, 'horizontal')
            self.horizontal = ival_
            self.horizontal_nsprefix_ = child_.prefix
        elif nodeName_ == 'id' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'id')
            ival_ = self.gds_validate_integer(ival_, node, 'id')
            self.id = ival_
            self.id_nsprefix_ = child_.prefix
        elif nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'thermal':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'thermal')
            ival_ = self.gds_validate_boolean(ival_, node, 'thermal')
            self.thermal = ival_
            self.thermal_nsprefix_ = child_.prefix
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class GetLabelsAdvancedRq


class GetLabelsAdvancedRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, labels=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
        if labels is None:
            self.labels = []
        else:
            self.labels = labels
        self.labels_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetLabelsAdvancedRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetLabelsAdvancedRs.subclass:
            return GetLabelsAdvancedRs.subclass(*args_, **kwargs_)
        else:
            return GetLabelsAdvancedRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def get_labels(self):
        return self.labels
    def set_labels(self, labels):
        self.labels = labels
    def add_labels(self, value):
        self.labels.append(value)
    def insert_labels_at(self, index, value):
        self.labels.insert(index, value)
    def replace_labels_at(self, index, value):
        self.labels[index] = value
    def hasContent_(self):
        if (
            self.error is not None or
            self.labels
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetLabelsAdvancedRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GetLabelsAdvancedRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GetLabelsAdvancedRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GetLabelsAdvancedRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GetLabelsAdvancedRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GetLabelsAdvancedRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetLabelsAdvancedRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
        for labels_ in self.labels:
            namespaceprefix_ = self.labels_nsprefix_ + ':' if (UseCapturedNS_ and self.labels_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slabels>%s</%slabels>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(labels_), input_name='labels')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
        elif nodeName_ == 'labels':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'labels')
            value_ = self.gds_validate_string(value_, node, 'labels')
            self.labels.append(value_)
            self.labels_nsprefix_ = child_.prefix
# end class GetLabelsAdvancedRs


class VoidShipmentRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, id=None, password=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = id
        self.id_nsprefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, VoidShipmentRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if VoidShipmentRq.subclass:
            return VoidShipmentRq.subclass(*args_, **kwargs_)
        else:
            return VoidShipmentRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.id is not None or
            self.password is not None or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='VoidShipmentRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('VoidShipmentRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'VoidShipmentRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='VoidShipmentRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='VoidShipmentRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='VoidShipmentRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='VoidShipmentRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.id is not None:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sid>%s</%sid>%s' % (namespaceprefix_ , self.gds_format_integer(self.id, input_name='id'), namespaceprefix_ , eol_))
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'id' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'id')
            ival_ = self.gds_validate_integer(ival_, node, 'id')
            self.id = ival_
            self.id_nsprefix_ = child_.prefix
        elif nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class VoidShipmentRq


class VoidShipmentRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, VoidShipmentRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if VoidShipmentRs.subclass:
            return VoidShipmentRs.subclass(*args_, **kwargs_)
        else:
            return VoidShipmentRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def hasContent_(self):
        if (
            self.error is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='VoidShipmentRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('VoidShipmentRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'VoidShipmentRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='VoidShipmentRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='VoidShipmentRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='VoidShipmentRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='VoidShipmentRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
# end class VoidShipmentRs


class EndOfDayRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, date=None, password=None, payment_info=None, shipper_num=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if isinstance(date, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(date, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = date
        self.date = initvalue_
        self.date_nsprefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        self.payment_info = payment_info
        self.payment_info_nsprefix_ = None
        self.shipper_num = shipper_num
        self.shipper_num_nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, EndOfDayRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if EndOfDayRq.subclass:
            return EndOfDayRq.subclass(*args_, **kwargs_)
        else:
            return EndOfDayRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_date(self):
        return self.date
    def set_date(self, date):
        self.date = date
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_payment_info(self):
        return self.payment_info
    def set_payment_info(self, payment_info):
        self.payment_info = payment_info
    def get_shipper_num(self):
        return self.shipper_num
    def set_shipper_num(self, shipper_num):
        self.shipper_num = shipper_num
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.date is not None or
            self.password is not None or
            self.payment_info is not None or
            self.shipper_num is not None or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='EndOfDayRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('EndOfDayRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'EndOfDayRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='EndOfDayRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='EndOfDayRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='EndOfDayRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='EndOfDayRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.date is not None:
            namespaceprefix_ = self.date_nsprefix_ + ':' if (UseCapturedNS_ and self.date_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdate>%s</%sdate>%s' % (namespaceprefix_ , self.gds_format_datetime(self.date, input_name='date'), namespaceprefix_ , eol_))
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        if self.payment_info is not None:
            namespaceprefix_ = self.payment_info_nsprefix_ + ':' if (UseCapturedNS_ and self.payment_info_nsprefix_) else ''
            self.payment_info.export(outfile, level, namespaceprefix_, namespacedef_='', name_='payment_info', pretty_print=pretty_print)
        if self.shipper_num is not None:
            namespaceprefix_ = self.shipper_num_nsprefix_ + ':' if (UseCapturedNS_ and self.shipper_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sshipper_num>%s</%sshipper_num>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.shipper_num), input_name='shipper_num')), namespaceprefix_ , eol_))
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'date':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.date = dval_
            self.date_nsprefix_ = child_.prefix
        elif nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'payment_info':
            obj_ = PaymentInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.payment_info = obj_
            obj_.original_tagname_ = 'payment_info'
        elif nodeName_ == 'shipper_num':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'shipper_num')
            value_ = self.gds_validate_string(value_, node, 'shipper_num')
            self.shipper_num = value_
            self.shipper_num_nsprefix_ = child_.prefix
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class EndOfDayRq


class EndOfDayRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, manifest_num=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
        self.manifest_num = manifest_num
        self.manifest_num_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, EndOfDayRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if EndOfDayRs.subclass:
            return EndOfDayRs.subclass(*args_, **kwargs_)
        else:
            return EndOfDayRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def get_manifest_num(self):
        return self.manifest_num
    def set_manifest_num(self, manifest_num):
        self.manifest_num = manifest_num
    def hasContent_(self):
        if (
            self.error is not None or
            self.manifest_num is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='EndOfDayRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('EndOfDayRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'EndOfDayRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='EndOfDayRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='EndOfDayRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='EndOfDayRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='EndOfDayRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
        if self.manifest_num is not None:
            namespaceprefix_ = self.manifest_num_nsprefix_ + ':' if (UseCapturedNS_ and self.manifest_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smanifest_num>%s</%smanifest_num>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.manifest_num), input_name='manifest_num')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
        elif nodeName_ == 'manifest_num':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'manifest_num')
            value_ = self.gds_validate_string(value_, node, 'manifest_num')
            self.manifest_num = value_
            self.manifest_num_nsprefix_ = child_.prefix
# end class EndOfDayRs


class DeleteBoxRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, name=None, password=None, shipper_num=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.name = name
        self.name_nsprefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        self.shipper_num = shipper_num
        self.shipper_num_nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DeleteBoxRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DeleteBoxRq.subclass:
            return DeleteBoxRq.subclass(*args_, **kwargs_)
        else:
            return DeleteBoxRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_shipper_num(self):
        return self.shipper_num
    def set_shipper_num(self, shipper_num):
        self.shipper_num = shipper_num
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.name is not None or
            self.password is not None or
            self.shipper_num is not None or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DeleteBoxRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('DeleteBoxRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'DeleteBoxRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DeleteBoxRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='DeleteBoxRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='DeleteBoxRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DeleteBoxRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespaceprefix_ , eol_))
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        if self.shipper_num is not None:
            namespaceprefix_ = self.shipper_num_nsprefix_ + ':' if (UseCapturedNS_ and self.shipper_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sshipper_num>%s</%sshipper_num>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.shipper_num), input_name='shipper_num')), namespaceprefix_ , eol_))
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'name':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'name')
            value_ = self.gds_validate_string(value_, node, 'name')
            self.name = value_
            self.name_nsprefix_ = child_.prefix
        elif nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'shipper_num':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'shipper_num')
            value_ = self.gds_validate_string(value_, node, 'shipper_num')
            self.shipper_num = value_
            self.shipper_num_nsprefix_ = child_.prefix
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class DeleteBoxRq


class DeleteBoxRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DeleteBoxRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DeleteBoxRs.subclass:
            return DeleteBoxRs.subclass(*args_, **kwargs_)
        else:
            return DeleteBoxRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def hasContent_(self):
        if (
            self.error is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DeleteBoxRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('DeleteBoxRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'DeleteBoxRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DeleteBoxRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='DeleteBoxRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='DeleteBoxRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DeleteBoxRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
# end class DeleteBoxRs


class SaveBoxRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, box=None, password=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.box = box
        self.box_nsprefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SaveBoxRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SaveBoxRq.subclass:
            return SaveBoxRq.subclass(*args_, **kwargs_)
        else:
            return SaveBoxRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_box(self):
        return self.box
    def set_box(self, box):
        self.box = box
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.box is not None or
            self.password is not None or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SaveBoxRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SaveBoxRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SaveBoxRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SaveBoxRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SaveBoxRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SaveBoxRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SaveBoxRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.box is not None:
            namespaceprefix_ = self.box_nsprefix_ + ':' if (UseCapturedNS_ and self.box_nsprefix_) else ''
            self.box.export(outfile, level, namespaceprefix_, namespacedef_='', name_='box', pretty_print=pretty_print)
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'box':
            obj_ = Box.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.box = obj_
            obj_.original_tagname_ = 'box'
        elif nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class SaveBoxRq


class SaveBoxRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, box=None, error=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.box = box
        self.box_nsprefix_ = None
        self.error = error
        self.error_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SaveBoxRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SaveBoxRs.subclass:
            return SaveBoxRs.subclass(*args_, **kwargs_)
        else:
            return SaveBoxRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_box(self):
        return self.box
    def set_box(self, box):
        self.box = box
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def hasContent_(self):
        if (
            self.box is not None or
            self.error is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SaveBoxRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SaveBoxRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SaveBoxRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SaveBoxRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SaveBoxRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SaveBoxRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SaveBoxRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.box is not None:
            namespaceprefix_ = self.box_nsprefix_ + ':' if (UseCapturedNS_ and self.box_nsprefix_) else ''
            self.box.export(outfile, level, namespaceprefix_, namespacedef_='', name_='box', pretty_print=pretty_print)
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'box':
            obj_ = Box.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.box = obj_
            obj_.original_tagname_ = 'box'
        elif nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
# end class SaveBoxRs


class GetPreferencesRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, password=None, preference_user_id=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        self.preference_user_id = preference_user_id
        self.preference_user_id_nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetPreferencesRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetPreferencesRq.subclass:
            return GetPreferencesRq.subclass(*args_, **kwargs_)
        else:
            return GetPreferencesRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_preference_user_id(self):
        return self.preference_user_id
    def set_preference_user_id(self, preference_user_id):
        self.preference_user_id = preference_user_id
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.password is not None or
            self.preference_user_id is not None or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetPreferencesRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GetPreferencesRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GetPreferencesRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GetPreferencesRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GetPreferencesRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GetPreferencesRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetPreferencesRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        if self.preference_user_id is not None:
            namespaceprefix_ = self.preference_user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.preference_user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spreference_user_id>%s</%spreference_user_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.preference_user_id), input_name='preference_user_id')), namespaceprefix_ , eol_))
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'preference_user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'preference_user_id')
            value_ = self.gds_validate_string(value_, node, 'preference_user_id')
            self.preference_user_id = value_
            self.preference_user_id_nsprefix_ = child_.prefix
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class GetPreferencesRq


class GetPreferencesRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, preferences=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
        if preferences is None:
            self.preferences = []
        else:
            self.preferences = preferences
        self.preferences_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetPreferencesRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetPreferencesRs.subclass:
            return GetPreferencesRs.subclass(*args_, **kwargs_)
        else:
            return GetPreferencesRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def get_preferences(self):
        return self.preferences
    def set_preferences(self, preferences):
        self.preferences = preferences
    def add_preferences(self, value):
        self.preferences.append(value)
    def insert_preferences_at(self, index, value):
        self.preferences.insert(index, value)
    def replace_preferences_at(self, index, value):
        self.preferences[index] = value
    def hasContent_(self):
        if (
            self.error is not None or
            self.preferences
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetPreferencesRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GetPreferencesRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GetPreferencesRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GetPreferencesRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GetPreferencesRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GetPreferencesRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetPreferencesRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
        for preferences_ in self.preferences:
            namespaceprefix_ = self.preferences_nsprefix_ + ':' if (UseCapturedNS_ and self.preferences_nsprefix_) else ''
            preferences_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='preferences', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
        elif nodeName_ == 'preferences':
            obj_ = Preference.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.preferences.append(obj_)
            obj_.original_tagname_ = 'preferences'
# end class GetPreferencesRs


class ProcessShipmentRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, password=None, shipment=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        self.shipment = shipment
        self.shipment_nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ProcessShipmentRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ProcessShipmentRq.subclass:
            return ProcessShipmentRq.subclass(*args_, **kwargs_)
        else:
            return ProcessShipmentRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_shipment(self):
        return self.shipment
    def set_shipment(self, shipment):
        self.shipment = shipment
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.password is not None or
            self.shipment is not None or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ProcessShipmentRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ProcessShipmentRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ProcessShipmentRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ProcessShipmentRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ProcessShipmentRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ProcessShipmentRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ProcessShipmentRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        if self.shipment is not None:
            namespaceprefix_ = self.shipment_nsprefix_ + ':' if (UseCapturedNS_ and self.shipment_nsprefix_) else ''
            self.shipment.export(outfile, level, namespaceprefix_, namespacedef_='', name_='shipment', pretty_print=pretty_print)
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'shipment':
            obj_ = Shipment.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.shipment = obj_
            obj_.original_tagname_ = 'shipment'
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class ProcessShipmentRq


class ProcessShipmentRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, processShipmentResult=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
        self.processShipmentResult = processShipmentResult
        self.processShipmentResult_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ProcessShipmentRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ProcessShipmentRs.subclass:
            return ProcessShipmentRs.subclass(*args_, **kwargs_)
        else:
            return ProcessShipmentRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def get_processShipmentResult(self):
        return self.processShipmentResult
    def set_processShipmentResult(self, processShipmentResult):
        self.processShipmentResult = processShipmentResult
    def hasContent_(self):
        if (
            self.error is not None or
            self.processShipmentResult is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ProcessShipmentRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ProcessShipmentRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ProcessShipmentRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ProcessShipmentRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ProcessShipmentRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ProcessShipmentRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ProcessShipmentRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
        if self.processShipmentResult is not None:
            namespaceprefix_ = self.processShipmentResult_nsprefix_ + ':' if (UseCapturedNS_ and self.processShipmentResult_nsprefix_) else ''
            self.processShipmentResult.export(outfile, level, namespaceprefix_, namespacedef_='', name_='processShipmentResult', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
        elif nodeName_ == 'processShipmentResult':
            obj_ = ProcessShipmentResult.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.processShipmentResult = obj_
            obj_.original_tagname_ = 'processShipmentResult'
# end class ProcessShipmentRs


class SavePreferenceRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, password=None, preference=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        self.preference = preference
        self.preference_nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SavePreferenceRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SavePreferenceRq.subclass:
            return SavePreferenceRq.subclass(*args_, **kwargs_)
        else:
            return SavePreferenceRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_preference(self):
        return self.preference
    def set_preference(self, preference):
        self.preference = preference
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.password is not None or
            self.preference is not None or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SavePreferenceRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SavePreferenceRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SavePreferenceRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SavePreferenceRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SavePreferenceRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SavePreferenceRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SavePreferenceRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        if self.preference is not None:
            namespaceprefix_ = self.preference_nsprefix_ + ':' if (UseCapturedNS_ and self.preference_nsprefix_) else ''
            self.preference.export(outfile, level, namespaceprefix_, namespacedef_='', name_='preference', pretty_print=pretty_print)
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'preference':
            obj_ = Preference.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.preference = obj_
            obj_.original_tagname_ = 'preference'
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class SavePreferenceRq


class SavePreferenceRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, preference=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
        self.preference = preference
        self.preference_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SavePreferenceRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SavePreferenceRs.subclass:
            return SavePreferenceRs.subclass(*args_, **kwargs_)
        else:
            return SavePreferenceRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def get_preference(self):
        return self.preference
    def set_preference(self, preference):
        self.preference = preference
    def hasContent_(self):
        if (
            self.error is not None or
            self.preference is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SavePreferenceRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SavePreferenceRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SavePreferenceRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SavePreferenceRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SavePreferenceRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SavePreferenceRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SavePreferenceRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
        if self.preference is not None:
            namespaceprefix_ = self.preference_nsprefix_ + ':' if (UseCapturedNS_ and self.preference_nsprefix_) else ''
            self.preference.export(outfile, level, namespaceprefix_, namespacedef_='', name_='preference', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
        elif nodeName_ == 'preference':
            obj_ = Preference.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.preference = obj_
            obj_.original_tagname_ = 'preference'
# end class SavePreferenceRs


class DeletePreferenceRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, password=None, preference_shipper_num=None, preference_user_id=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        self.preference_shipper_num = preference_shipper_num
        self.preference_shipper_num_nsprefix_ = None
        self.preference_user_id = preference_user_id
        self.preference_user_id_nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DeletePreferenceRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DeletePreferenceRq.subclass:
            return DeletePreferenceRq.subclass(*args_, **kwargs_)
        else:
            return DeletePreferenceRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_preference_shipper_num(self):
        return self.preference_shipper_num
    def set_preference_shipper_num(self, preference_shipper_num):
        self.preference_shipper_num = preference_shipper_num
    def get_preference_user_id(self):
        return self.preference_user_id
    def set_preference_user_id(self, preference_user_id):
        self.preference_user_id = preference_user_id
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.password is not None or
            self.preference_shipper_num is not None or
            self.preference_user_id is not None or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DeletePreferenceRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('DeletePreferenceRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'DeletePreferenceRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DeletePreferenceRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='DeletePreferenceRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='DeletePreferenceRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DeletePreferenceRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        if self.preference_shipper_num is not None:
            namespaceprefix_ = self.preference_shipper_num_nsprefix_ + ':' if (UseCapturedNS_ and self.preference_shipper_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spreference_shipper_num>%s</%spreference_shipper_num>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.preference_shipper_num), input_name='preference_shipper_num')), namespaceprefix_ , eol_))
        if self.preference_user_id is not None:
            namespaceprefix_ = self.preference_user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.preference_user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spreference_user_id>%s</%spreference_user_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.preference_user_id), input_name='preference_user_id')), namespaceprefix_ , eol_))
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'preference_shipper_num':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'preference_shipper_num')
            value_ = self.gds_validate_string(value_, node, 'preference_shipper_num')
            self.preference_shipper_num = value_
            self.preference_shipper_num_nsprefix_ = child_.prefix
        elif nodeName_ == 'preference_user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'preference_user_id')
            value_ = self.gds_validate_string(value_, node, 'preference_user_id')
            self.preference_user_id = value_
            self.preference_user_id_nsprefix_ = child_.prefix
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class DeletePreferenceRq


class DeletePreferenceRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DeletePreferenceRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DeletePreferenceRs.subclass:
            return DeletePreferenceRs.subclass(*args_, **kwargs_)
        else:
            return DeletePreferenceRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def hasContent_(self):
        if (
            self.error is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DeletePreferenceRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('DeletePreferenceRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'DeletePreferenceRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DeletePreferenceRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='DeletePreferenceRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='DeletePreferenceRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DeletePreferenceRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
# end class DeletePreferenceRs


class GetBoxesRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, password=None, shipper_num=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        if shipper_num is None:
            self.shipper_num = []
        else:
            self.shipper_num = shipper_num
        self.shipper_num_nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetBoxesRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetBoxesRq.subclass:
            return GetBoxesRq.subclass(*args_, **kwargs_)
        else:
            return GetBoxesRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_shipper_num(self):
        return self.shipper_num
    def set_shipper_num(self, shipper_num):
        self.shipper_num = shipper_num
    def add_shipper_num(self, value):
        self.shipper_num.append(value)
    def insert_shipper_num_at(self, index, value):
        self.shipper_num.insert(index, value)
    def replace_shipper_num_at(self, index, value):
        self.shipper_num[index] = value
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.password is not None or
            self.shipper_num or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetBoxesRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GetBoxesRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GetBoxesRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GetBoxesRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GetBoxesRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GetBoxesRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetBoxesRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        for shipper_num_ in self.shipper_num:
            namespaceprefix_ = self.shipper_num_nsprefix_ + ':' if (UseCapturedNS_ and self.shipper_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sshipper_num>%s</%sshipper_num>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(shipper_num_), input_name='shipper_num')), namespaceprefix_ , eol_))
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'shipper_num':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'shipper_num')
            value_ = self.gds_validate_string(value_, node, 'shipper_num')
            self.shipper_num.append(value_)
            self.shipper_num_nsprefix_ = child_.prefix
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class GetBoxesRq


class GetBoxesRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, box=None, error=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if box is None:
            self.box = []
        else:
            self.box = box
        self.box_nsprefix_ = None
        self.error = error
        self.error_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetBoxesRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetBoxesRs.subclass:
            return GetBoxesRs.subclass(*args_, **kwargs_)
        else:
            return GetBoxesRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_box(self):
        return self.box
    def set_box(self, box):
        self.box = box
    def add_box(self, value):
        self.box.append(value)
    def insert_box_at(self, index, value):
        self.box.insert(index, value)
    def replace_box_at(self, index, value):
        self.box[index] = value
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def hasContent_(self):
        if (
            self.box or
            self.error is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetBoxesRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GetBoxesRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GetBoxesRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GetBoxesRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GetBoxesRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GetBoxesRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetBoxesRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for box_ in self.box:
            namespaceprefix_ = self.box_nsprefix_ + ':' if (UseCapturedNS_ and self.box_nsprefix_) else ''
            box_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='box', pretty_print=pretty_print)
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'box':
            obj_ = Box.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.box.append(obj_)
            obj_.original_tagname_ = 'box'
        elif nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
# end class GetBoxesRs


class GetProformaRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, id=None, password=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = id
        self.id_nsprefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetProformaRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetProformaRq.subclass:
            return GetProformaRq.subclass(*args_, **kwargs_)
        else:
            return GetProformaRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.id is not None or
            self.password is not None or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetProformaRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GetProformaRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GetProformaRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GetProformaRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GetProformaRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GetProformaRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetProformaRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.id is not None:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sid>%s</%sid>%s' % (namespaceprefix_ , self.gds_format_integer(self.id, input_name='id'), namespaceprefix_ , eol_))
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'id' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'id')
            ival_ = self.gds_validate_integer(ival_, node, 'id')
            self.id = ival_
            self.id_nsprefix_ = child_.prefix
        elif nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class GetProformaRq


class GetProformaRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, proforma=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
        self.proforma = proforma
        self.proforma_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetProformaRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetProformaRs.subclass:
            return GetProformaRs.subclass(*args_, **kwargs_)
        else:
            return GetProformaRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def get_proforma(self):
        return self.proforma
    def set_proforma(self, proforma):
        self.proforma = proforma
    def hasContent_(self):
        if (
            self.error is not None or
            self.proforma is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetProformaRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GetProformaRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GetProformaRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GetProformaRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GetProformaRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GetProformaRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetProformaRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
        if self.proforma is not None:
            namespaceprefix_ = self.proforma_nsprefix_ + ':' if (UseCapturedNS_ and self.proforma_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sproforma>%s</%sproforma>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.proforma), input_name='proforma')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
        elif nodeName_ == 'proforma':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'proforma')
            value_ = self.gds_validate_string(value_, node, 'proforma')
            self.proforma = value_
            self.proforma_nsprefix_ = child_.prefix
# end class GetProformaRs


class GetSTOsRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, password=None, shipper_num=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        if shipper_num is None:
            self.shipper_num = []
        else:
            self.shipper_num = shipper_num
        self.shipper_num_nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetSTOsRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetSTOsRq.subclass:
            return GetSTOsRq.subclass(*args_, **kwargs_)
        else:
            return GetSTOsRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_shipper_num(self):
        return self.shipper_num
    def set_shipper_num(self, shipper_num):
        self.shipper_num = shipper_num
    def add_shipper_num(self, value):
        self.shipper_num.append(value)
    def insert_shipper_num_at(self, index, value):
        self.shipper_num.insert(index, value)
    def replace_shipper_num_at(self, index, value):
        self.shipper_num[index] = value
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.password is not None or
            self.shipper_num or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetSTOsRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GetSTOsRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GetSTOsRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GetSTOsRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GetSTOsRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GetSTOsRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetSTOsRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        for shipper_num_ in self.shipper_num:
            namespaceprefix_ = self.shipper_num_nsprefix_ + ':' if (UseCapturedNS_ and self.shipper_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sshipper_num>%s</%sshipper_num>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(shipper_num_), input_name='shipper_num')), namespaceprefix_ , eol_))
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'shipper_num':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'shipper_num')
            value_ = self.gds_validate_string(value_, node, 'shipper_num')
            self.shipper_num.append(value_)
            self.shipper_num_nsprefix_ = child_.prefix
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class GetSTOsRq


class GetSTOsRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, sto=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
        if sto is None:
            self.sto = []
        else:
            self.sto = sto
        self.sto_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetSTOsRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetSTOsRs.subclass:
            return GetSTOsRs.subclass(*args_, **kwargs_)
        else:
            return GetSTOsRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def get_sto(self):
        return self.sto
    def set_sto(self, sto):
        self.sto = sto
    def add_sto(self, value):
        self.sto.append(value)
    def insert_sto_at(self, index, value):
        self.sto.insert(index, value)
    def replace_sto_at(self, index, value):
        self.sto[index] = value
    def hasContent_(self):
        if (
            self.error is not None or
            self.sto
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetSTOsRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GetSTOsRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GetSTOsRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GetSTOsRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GetSTOsRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GetSTOsRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetSTOsRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
        for sto_ in self.sto:
            namespaceprefix_ = self.sto_nsprefix_ + ':' if (UseCapturedNS_ and self.sto_nsprefix_) else ''
            sto_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sto', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
        elif nodeName_ == 'sto':
            obj_ = STO.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.sto.append(obj_)
            obj_.original_tagname_ = 'sto'
# end class GetSTOsRs


class DeleteSTORq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, name=None, password=None, shipper_num=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.name = name
        self.name_nsprefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        self.shipper_num = shipper_num
        self.shipper_num_nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DeleteSTORq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DeleteSTORq.subclass:
            return DeleteSTORq.subclass(*args_, **kwargs_)
        else:
            return DeleteSTORq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_shipper_num(self):
        return self.shipper_num
    def set_shipper_num(self, shipper_num):
        self.shipper_num = shipper_num
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.name is not None or
            self.password is not None or
            self.shipper_num is not None or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DeleteSTORq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('DeleteSTORq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'DeleteSTORq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DeleteSTORq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='DeleteSTORq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='DeleteSTORq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DeleteSTORq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespaceprefix_ , eol_))
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        if self.shipper_num is not None:
            namespaceprefix_ = self.shipper_num_nsprefix_ + ':' if (UseCapturedNS_ and self.shipper_num_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sshipper_num>%s</%sshipper_num>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.shipper_num), input_name='shipper_num')), namespaceprefix_ , eol_))
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'name':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'name')
            value_ = self.gds_validate_string(value_, node, 'name')
            self.name = value_
            self.name_nsprefix_ = child_.prefix
        elif nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'shipper_num':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'shipper_num')
            value_ = self.gds_validate_string(value_, node, 'shipper_num')
            self.shipper_num = value_
            self.shipper_num_nsprefix_ = child_.prefix
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class DeleteSTORq


class DeleteSTORs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DeleteSTORs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DeleteSTORs.subclass:
            return DeleteSTORs.subclass(*args_, **kwargs_)
        else:
            return DeleteSTORs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def hasContent_(self):
        if (
            self.error is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DeleteSTORs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('DeleteSTORs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'DeleteSTORs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DeleteSTORs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='DeleteSTORs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='DeleteSTORs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DeleteSTORs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
# end class DeleteSTORs


class SaveProformaRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, id=None, password=None, proforma=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = id
        self.id_nsprefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        self.proforma = proforma
        self.proforma_nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SaveProformaRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SaveProformaRq.subclass:
            return SaveProformaRq.subclass(*args_, **kwargs_)
        else:
            return SaveProformaRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_proforma(self):
        return self.proforma
    def set_proforma(self, proforma):
        self.proforma = proforma
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.id is not None or
            self.password is not None or
            self.proforma is not None or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SaveProformaRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SaveProformaRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SaveProformaRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SaveProformaRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SaveProformaRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SaveProformaRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SaveProformaRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.id is not None:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sid>%s</%sid>%s' % (namespaceprefix_ , self.gds_format_integer(self.id, input_name='id'), namespaceprefix_ , eol_))
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        if self.proforma is not None:
            namespaceprefix_ = self.proforma_nsprefix_ + ':' if (UseCapturedNS_ and self.proforma_nsprefix_) else ''
            self.proforma.export(outfile, level, namespaceprefix_, namespacedef_='', name_='proforma', pretty_print=pretty_print)
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'id' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'id')
            ival_ = self.gds_validate_integer(ival_, node, 'id')
            self.id = ival_
            self.id_nsprefix_ = child_.prefix
        elif nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'proforma':
            obj_ = Proforma.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.proforma = obj_
            obj_.original_tagname_ = 'proforma'
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class SaveProformaRq


class SaveProformaRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, proforma=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
        self.proforma = proforma
        self.proforma_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SaveProformaRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SaveProformaRs.subclass:
            return SaveProformaRs.subclass(*args_, **kwargs_)
        else:
            return SaveProformaRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def get_proforma(self):
        return self.proforma
    def set_proforma(self, proforma):
        self.proforma = proforma
    def hasContent_(self):
        if (
            self.error is not None or
            self.proforma is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SaveProformaRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SaveProformaRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SaveProformaRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SaveProformaRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SaveProformaRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SaveProformaRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SaveProformaRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
        if self.proforma is not None:
            namespaceprefix_ = self.proforma_nsprefix_ + ':' if (UseCapturedNS_ and self.proforma_nsprefix_) else ''
            self.proforma.export(outfile, level, namespaceprefix_, namespacedef_='', name_='proforma', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
        elif nodeName_ == 'proforma':
            obj_ = Proforma.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.proforma = obj_
            obj_.original_tagname_ = 'proforma'
# end class SaveProformaRs


class DeleteCommodityRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, id=None, password=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = id
        self.id_nsprefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DeleteCommodityRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DeleteCommodityRq.subclass:
            return DeleteCommodityRq.subclass(*args_, **kwargs_)
        else:
            return DeleteCommodityRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.id is not None or
            self.password is not None or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DeleteCommodityRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('DeleteCommodityRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'DeleteCommodityRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DeleteCommodityRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='DeleteCommodityRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='DeleteCommodityRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DeleteCommodityRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.id is not None:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sid>%s</%sid>%s' % (namespaceprefix_ , self.gds_format_integer(self.id, input_name='id'), namespaceprefix_ , eol_))
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'id' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'id')
            ival_ = self.gds_validate_integer(ival_, node, 'id')
            self.id = ival_
            self.id_nsprefix_ = child_.prefix
        elif nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class DeleteCommodityRq


class DeleteCommodityRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DeleteCommodityRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DeleteCommodityRs.subclass:
            return DeleteCommodityRs.subclass(*args_, **kwargs_)
        else:
            return DeleteCommodityRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def hasContent_(self):
        if (
            self.error is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DeleteCommodityRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('DeleteCommodityRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'DeleteCommodityRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DeleteCommodityRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='DeleteCommodityRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='DeleteCommodityRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DeleteCommodityRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
# end class DeleteCommodityRs


class DeleteUserRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, id=None, password=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = id
        self.id_nsprefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DeleteUserRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DeleteUserRq.subclass:
            return DeleteUserRq.subclass(*args_, **kwargs_)
        else:
            return DeleteUserRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.id is not None or
            self.password is not None or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DeleteUserRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('DeleteUserRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'DeleteUserRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DeleteUserRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='DeleteUserRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='DeleteUserRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DeleteUserRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.id is not None:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sid>%s</%sid>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.id), input_name='id')), namespaceprefix_ , eol_))
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'id')
            value_ = self.gds_validate_string(value_, node, 'id')
            self.id = value_
            self.id_nsprefix_ = child_.prefix
        elif nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class DeleteUserRq


class DeleteUserRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DeleteUserRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DeleteUserRs.subclass:
            return DeleteUserRs.subclass(*args_, **kwargs_)
        else:
            return DeleteUserRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def hasContent_(self):
        if (
            self.error is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DeleteUserRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('DeleteUserRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'DeleteUserRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DeleteUserRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='DeleteUserRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='DeleteUserRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DeleteUserRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
            self.error_nsprefix_ = child_.prefix
# end class DeleteUserRs


class HoldShipmentRq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, password=None, shipment=None, user_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.password = password
        self.password_nsprefix_ = None
        self.shipment = shipment
        self.shipment_nsprefix_ = None
        self.user_id = user_id
        self.user_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, HoldShipmentRq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if HoldShipmentRq.subclass:
            return HoldShipmentRq.subclass(*args_, **kwargs_)
        else:
            return HoldShipmentRq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_password(self):
        return self.password
    def set_password(self, password):
        self.password = password
    def get_shipment(self):
        return self.shipment
    def set_shipment(self, shipment):
        self.shipment = shipment
    def get_user_id(self):
        return self.user_id
    def set_user_id(self, user_id):
        self.user_id = user_id
    def hasContent_(self):
        if (
            self.password is not None or
            self.shipment is not None or
            self.user_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='HoldShipmentRq', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('HoldShipmentRq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'HoldShipmentRq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='HoldShipmentRq')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='HoldShipmentRq', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='HoldShipmentRq'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='HoldShipmentRq', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.password is not None:
            namespaceprefix_ = self.password_nsprefix_ + ':' if (UseCapturedNS_ and self.password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.password), input_name='password')), namespaceprefix_ , eol_))
        if self.shipment is not None:
            namespaceprefix_ = self.shipment_nsprefix_ + ':' if (UseCapturedNS_ and self.shipment_nsprefix_) else ''
            self.shipment.export(outfile, level, namespaceprefix_, namespacedef_='', name_='shipment', pretty_print=pretty_print)
        if self.user_id is not None:
            namespaceprefix_ = self.user_id_nsprefix_ + ':' if (UseCapturedNS_ and self.user_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_id>%s</%suser_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.user_id), input_name='user_id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'password')
            value_ = self.gds_validate_string(value_, node, 'password')
            self.password = value_
            self.password_nsprefix_ = child_.prefix
        elif nodeName_ == 'shipment':
            obj_ = Shipment.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.shipment = obj_
            obj_.original_tagname_ = 'shipment'
        elif nodeName_ == 'user_id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'user_id')
            value_ = self.gds_validate_string(value_, node, 'user_id')
            self.user_id = value_
            self.user_id_nsprefix_ = child_.prefix
# end class HoldShipmentRq


class HoldShipmentRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, error=None, shipment=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.error = error
        self.error_nsprefix_ = None
        self.shipment = shipment
        self.shipment_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, HoldShipmentRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if HoldShipmentRs.subclass:
            return HoldShipmentRs.subclass(*args_, **kwargs_)
        else:
            return HoldShipmentRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_error(self):
        return self.error
    def set_error(self, error):
        self.error = error
    def get_shipment(self):
        return self.shipment
    def set_shipment(self, shipment):
        self.shipment = shipment
    def hasContent_(self):
        if (
            self.error is not None or
            self.shipment is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='HoldShipmentRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('HoldShipmentRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'HoldShipmentRs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='HoldShipmentRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='HoldShipmentRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='HoldShipmentRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='HoldShipmentRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.error is not None:
            namespaceprefix_ = self.error_nsprefix_ + ':' if (UseCapturedNS_ and self.error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.error), input_name='error')), namespaceprefix_ , eol_))
        if self.shipment is not None:
            namespaceprefix_ = self.shipment_nsprefix_ + ':' if (UseCapturedNS_ and self.shipment_nsprefix_) else ''
            self.shipment.export(outfile, level, namespaceprefix_, namespacedef_='', name_='shipment', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'error':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'error')
            value_ = self.gds_validate_string(value_, node, 'error')
            self.error = value_
      