from __future__ import annotations
import weakref
from sqlalchemy.engine.base import Connection
from sqlalchemy.orm.mapper import Mapper
from sqlalchemy.orm.session import Session, sessionmaker
from sqlalchemy.orm.unitofwork import UOWTransaction
from sqlalchemy.sql.schema import Column, Table
from typing import Any, Union

def mptt_before_insert(mapper: Mapper, connection: Connection, instance: Any) -> None: ...
def mptt_before_delete(mapper: Mapper, connection: Connection, instance: Any, delete: bool=...) -> None: ...
def mptt_before_update(mapper: Mapper, connection: Connection, instance: Any) -> None: ...

class _WeakDictBasedSet(weakref.WeakKeyDictionary):
    def add(self, obj: Any) -> None: ...
    def discard(self, obj: Any) -> None: ...
    def pop(self) -> Any: ...

class _WeakDefaultDict(weakref.WeakKeyDictionary):
    def __getitem__(self, key: Session) -> _WeakDictBasedSet: ...

class TreesManager:
    base_class: Any = ...
    classes: Any = ...
    instances: Any = ...
    def __init__(self, base_class: Any) -> None: ...
    def register_events(self, remove: bool=...) -> TreesManager: ...
    def register_factory(self, sessionmaker: sessionmaker) -> sessionmaker: ...
    def before_insert(self, mapper: Mapper, connection: Connection, instance: Any) -> None: ...
    def before_update(self, mapper: Mapper, connection: Connection, instance: Any) -> None: ...
    def before_delete(self, mapper: Mapper, connection: Connection, instance: Any) -> None: ...
    def after_flush_postexec(self, session: Session, context: UOWTransaction) -> None: ...
    @staticmethod
    def get_parent_value(instance: Any) -> Any: ...
    @staticmethod
    def expire_session_for_children(session: Session, instance: Any) -> None: ...
