# coding: utf-8

"""
    Beckn Protocol Meta API

    This document contains all the meta API endpoints that are implemented by the network participants. The information returned from these endpoints typically contain cacheable information.

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr

class MediaFile(BaseModel):
    """
    This object contains a url to a media file.  # noqa: E501
    """
    mimetype: Optional[StrictStr] = Field(default=None, description="indicates the nature and format of the document, file, or assortment of bytes. MIME types are defined and standardized in IETF's RFC 6838")
    url: Optional[StrictStr] = Field(default=None, description="The URL of the file")
    signature: Optional[StrictStr] = Field(default=None, description="The digital signature of the file signed by the sender")
    dsa: Optional[StrictStr] = Field(default=None, description="The signing algorithm used by the sender")
    __properties = ["mimetype", "url", "signature", "dsa"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MediaFile:
        """Create an instance of MediaFile from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> MediaFile:
        """Create an instance of MediaFile from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return MediaFile.parse_obj(obj)

        _obj = MediaFile.parse_obj({
            "mimetype": obj.get("mimetype"),
            "url": obj.get("url"),
            "signature": obj.get("signature"),
            "dsa": obj.get("dsa")
        })
        return _obj


