# coding: utf-8

"""
    Beckn Protocol Meta API

    This document contains all the meta API endpoints that are implemented by the network participants. The information returned from these endpoints typically contain cacheable information.

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List
from pydantic import BaseModel, Field, conlist
from meta.models.option import Option

class ReturnReasonsMessage(BaseModel):
    """
    ReturnReasonsMessage
    """
    return_reasons: conlist(Option) = Field(...)
    __properties = ["return_reasons"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ReturnReasonsMessage:
        """Create an instance of ReturnReasonsMessage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in return_reasons (list)
        _items = []
        if self.return_reasons:
            for _item in self.return_reasons:
                if _item:
                    _items.append(_item.to_dict())
            _dict['return_reasons'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ReturnReasonsMessage:
        """Create an instance of ReturnReasonsMessage from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ReturnReasonsMessage.parse_obj(obj)

        _obj = ReturnReasonsMessage.parse_obj({
            "return_reasons": [Option.from_dict(_item) for _item in obj.get("return_reasons")] if obj.get("return_reasons") is not None else None
        })
        return _obj


