# coding: utf-8

"""
    Beckn Protocol Registry Infrastructure API

    This document contains the API specification for the Registry infrastructure of a beckn-enabled network. The Registry API forms the trust layer of beckn protocol. When implemented, they enable creation of an infrastructure that allow trusted transactions between network participants to take place by means of digital signature authentication. The core infrastructure is called the Network Registry or simply, Registry. Any network participant that is listed on the registry can be assumed to have successfully passed the certfication and compliance process of the network, and hence be trusted to transact with.

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError

from typing import Optional

from registry.models.inline_object1 import InlineObject1
from registry.models.on_subscribe import OnSubscribe

from registry.api_client import ApiClient
from registry.api_response import ApiResponse
from registry.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class SubscriberBAPBPPBGApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def on_subscribe_post(self, on_subscribe : Optional[OnSubscribe] = None, **kwargs) -> InlineObject1:  # noqa: E501
        """on_subscribe_post  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.on_subscribe_post(on_subscribe, async_req=True)
        >>> result = thread.get()

        :param on_subscribe:
        :type on_subscribe: OnSubscribe
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: InlineObject1
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the on_subscribe_post_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.on_subscribe_post_with_http_info(on_subscribe, **kwargs)  # noqa: E501

    @validate_arguments
    def on_subscribe_post_with_http_info(self, on_subscribe : Optional[OnSubscribe] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """on_subscribe_post  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.on_subscribe_post_with_http_info(on_subscribe, async_req=True)
        >>> result = thread.get()

        :param on_subscribe:
        :type on_subscribe: OnSubscribe
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(InlineObject1, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'on_subscribe'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method on_subscribe_post" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['on_subscribe'] is not None:
            _body_params = _params['on_subscribe']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['SubscriberAuth']  # noqa: E501

        _response_types_map = {
        }

        return self.api_client.call_api(
            '/on_subscribe', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
