# coding: utf-8

"""
    Beckn Protocol Registry Infrastructure API

    This document contains the API specification for the Registry infrastructure of a beckn-enabled network. The Registry API forms the trust layer of beckn protocol. When implemented, they enable creation of an infrastructure that allow trusted transactions between network participants to take place by means of digital signature authentication. The core infrastructure is called the Network Registry or simply, Registry. Any network participant that is listed on the registry can be assumed to have successfully passed the certfication and compliance process of the network, and hence be trusted to transact with.

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel, Field, StrictStr

class InlineObject1(BaseModel):
    """
    InlineObject1
    """
    answer: StrictStr = Field(default=..., description="Decrypted challenge string")
    __properties = ["answer"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> InlineObject1:
        """Create an instance of InlineObject1 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> InlineObject1:
        """Create an instance of InlineObject1 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return InlineObject1.parse_obj(obj)

        _obj = InlineObject1.parse_obj({
            "answer": obj.get("answer")
        })
        return _obj


