# coding: utf-8

"""
    Beckn Protocol Core

    Beckn Core Transaction API specification

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictStr

class Authorization(BaseModel):
    """
    Describes an authorization mechanism used to start or end the fulfillment of an order. For example, in the mobility sector, the driver may require a one-time password to initiate the ride. In the healthcare sector, a patient may need to provide a password to open a video conference link during a teleconsultation.  # noqa: E501
    """
    type: Optional[StrictStr] = Field(default=None, description="Type of authorization mechanism used. The allowed values for this field can be published as part of the network policy.")
    token: Optional[StrictStr] = Field(default=None, description="Token used for authorization. This is typically generated at the BPP. The BAP can send this value to the user via any channel that it uses to authenticate the user like SMS, Email, Push notification, or in-app rendering.")
    valid_from: Optional[datetime] = Field(default=None, description="Timestamp in RFC3339 format from which token is valid")
    valid_to: Optional[datetime] = Field(default=None, description="Timestamp in RFC3339 format until which token is valid")
    status: Optional[StrictStr] = Field(default=None, description="Status of the token")
    __properties = ["type", "token", "valid_from", "valid_to", "status"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Authorization:
        """Create an instance of Authorization from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Authorization:
        """Create an instance of Authorization from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Authorization.parse_obj(obj)

        _obj = Authorization.parse_obj({
            "type": obj.get("type"),
            "token": obj.get("token"),
            "valid_from": obj.get("valid_from"),
            "valid_to": obj.get("valid_to"),
            "status": obj.get("status")
        })
        return _obj


