# coding: utf-8

"""
    Beckn Protocol Core

    Beckn Core Transaction API specification

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr
from transaction.models.descriptor import Descriptor

class CancelMessage(BaseModel):
    """
    CancelMessage
    """
    order_id: StrictStr = Field(default=..., description="Human-readable ID of the order. This is generated at the BPP layer. The BPP can either generate order id within its system or forward the order ID created at the provider level.")
    cancellation_reason_id: Optional[StrictStr] = None
    descriptor: Optional[Descriptor] = None
    __properties = ["order_id", "cancellation_reason_id", "descriptor"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CancelMessage:
        """Create an instance of CancelMessage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of descriptor
        if self.descriptor:
            _dict['descriptor'] = self.descriptor.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CancelMessage:
        """Create an instance of CancelMessage from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CancelMessage.parse_obj(obj)

        _obj = CancelMessage.parse_obj({
            "order_id": obj.get("order_id"),
            "cancellation_reason_id": obj.get("cancellation_reason_id"),
            "descriptor": Descriptor.from_dict(obj.get("descriptor")) if obj.get("descriptor") is not None else None
        })
        return _obj


