# coding: utf-8

"""
    Beckn Protocol Core

    Beckn Core Transaction API specification

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictStr, validator
from transaction.models.descriptor import Descriptor
from transaction.models.option import Option

class Cancellation(BaseModel):
    """
    Describes a cancellation event  # noqa: E501
    """
    time: Optional[datetime] = Field(default=None, description="Date-time when the order was cancelled by the buyer")
    cancelled_by: Optional[StrictStr] = None
    reason: Optional[Option] = Field(default=None, description="The reason for cancellation")
    additional_description: Optional[Descriptor] = Field(default=None, description="Any additional information regarding the nature of cancellation")
    __properties = ["time", "cancelled_by", "reason", "additional_description"]

    @validator('cancelled_by')
    def cancelled_by_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('CONSUMER', 'PROVIDER',):
            raise ValueError("must be one of enum values ('CONSUMER', 'PROVIDER')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Cancellation:
        """Create an instance of Cancellation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of reason
        if self.reason:
            _dict['reason'] = self.reason.to_dict()
        # override the default output from pydantic by calling `to_dict()` of additional_description
        if self.additional_description:
            _dict['additional_description'] = self.additional_description.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Cancellation:
        """Create an instance of Cancellation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Cancellation.parse_obj(obj)

        _obj = Cancellation.parse_obj({
            "time": obj.get("time"),
            "cancelled_by": obj.get("cancelled_by"),
            "reason": Option.from_dict(obj.get("reason")) if obj.get("reason") is not None else None,
            "additional_description": Descriptor.from_dict(obj.get("additional_description")) if obj.get("additional_description") is not None else None
        })
        return _obj


