# coding: utf-8

"""
    Beckn Protocol Core

    Beckn Core Transaction API specification

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Dict, Optional
from pydantic import BaseModel, Field, StrictStr, validator

class Form(BaseModel):
    """
    Describes a form  # noqa: E501
    """
    url: Optional[StrictStr] = Field(default=None, description="The URL from where the form can be fetched. The content fetched from the url must be processed as per the mime_type specified in this object. Once fetched, the rendering platform can choosed to render the form as-is as an embeddable element; or process it further to blend with the theme of the application. In case the interface is non-visual, the the render can process the form data and reproduce it as per the standard specified in the form.")
    data: Optional[Dict[str, StrictStr]] = Field(default=None, description="The form submission data")
    mime_type: Optional[StrictStr] = Field(default=None, description="This field indicates the nature and format of the form received by querying the url. MIME types are defined and standardized in IETF's RFC 6838.")
    submission_id: Optional[StrictStr] = None
    __properties = ["url", "data", "mime_type", "submission_id"]

    @validator('mime_type')
    def mime_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('text/html', 'application/xml',):
            raise ValueError("must be one of enum values ('text/html', 'application/xml')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Form:
        """Create an instance of Form from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Form:
        """Create an instance of Form from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Form.parse_obj(obj)

        _obj = Form.parse_obj({
            "url": obj.get("url"),
            "data": obj.get("data"),
            "mime_type": obj.get("mime_type"),
            "submission_id": obj.get("submission_id")
        })
        return _obj


