# coding: utf-8

"""
    Beckn Protocol Core

    Beckn Core Transaction API specification

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist
from transaction.models.agent import Agent
from transaction.models.contact import Contact
from transaction.models.customer import Customer
from transaction.models.fulfillment_state import FulfillmentState
from transaction.models.stop import Stop
from transaction.models.tag_group import TagGroup
from transaction.models.vehicle import Vehicle

class Fulfillment(BaseModel):
    """
    Describes how a an order will be rendered/fulfilled to the end-customer  # noqa: E501
    """
    id: Optional[StrictStr] = Field(default=None, description="Unique reference ID to the fulfillment of an order")
    type: Optional[StrictStr] = Field(default=None, description="A code that describes the mode of fulfillment. This is typically set when there are multiple ways an order can be fulfilled. For example, a retail order can be fulfilled either via store pickup or a home delivery. Similarly, a medical consultation can be provided either in-person or via tele-consultation. The network policy must publish standard fulfillment type codes for the different modes of fulfillment.")
    rateable: Optional[StrictBool] = Field(default=None, description="Whether the fulfillment can be rated or not")
    rating: Optional[StrictStr] = Field(default=None, description="The rating value of the fulfullment service.")
    state: Optional[FulfillmentState] = Field(default=None, description="The current state of fulfillment. The BPP must set this value whenever the state of the order fulfillment changes and fire an unsolicited `on_status` call.")
    tracking: Optional[StrictBool] = Field(default=False, description="Indicates whether the fulfillment allows tracking")
    customer: Optional[Customer] = Field(default=None, description="The person that will ultimately receive the order")
    agent: Optional[Agent] = Field(default=None, description="The agent that is currently handling the fulfillment of the order")
    contact: Optional[Contact] = None
    vehicle: Optional[Vehicle] = None
    stops: Optional[conlist(Stop)] = Field(default=None, description="The list of logical stops encountered during the fulfillment of an order.")
    path: Optional[StrictStr] = Field(default=None, description="The physical path taken by the agent that can be rendered on a map. The allowed format of this property can be set by the network.")
    tags: Optional[conlist(TagGroup)] = None
    __properties = ["id", "type", "rateable", "rating", "state", "tracking", "customer", "agent", "contact", "vehicle", "stops", "path", "tags"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Fulfillment:
        """Create an instance of Fulfillment from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of state
        if self.state:
            _dict['state'] = self.state.to_dict()
        # override the default output from pydantic by calling `to_dict()` of customer
        if self.customer:
            _dict['customer'] = self.customer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of agent
        if self.agent:
            _dict['agent'] = self.agent.to_dict()
        # override the default output from pydantic by calling `to_dict()` of contact
        if self.contact:
            _dict['contact'] = self.contact.to_dict()
        # override the default output from pydantic by calling `to_dict()` of vehicle
        if self.vehicle:
            _dict['vehicle'] = self.vehicle.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in stops (list)
        _items = []
        if self.stops:
            for _item in self.stops:
                if _item:
                    _items.append(_item.to_dict())
            _dict['stops'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item in self.tags:
                if _item:
                    _items.append(_item.to_dict())
            _dict['tags'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Fulfillment:
        """Create an instance of Fulfillment from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Fulfillment.parse_obj(obj)

        _obj = Fulfillment.parse_obj({
            "id": obj.get("id"),
            "type": obj.get("type"),
            "rateable": obj.get("rateable"),
            "rating": obj.get("rating"),
            "state": FulfillmentState.from_dict(obj.get("state")) if obj.get("state") is not None else None,
            "tracking": obj.get("tracking") if obj.get("tracking") is not None else False,
            "customer": Customer.from_dict(obj.get("customer")) if obj.get("customer") is not None else None,
            "agent": Agent.from_dict(obj.get("agent")) if obj.get("agent") is not None else None,
            "contact": Contact.from_dict(obj.get("contact")) if obj.get("contact") is not None else None,
            "vehicle": Vehicle.from_dict(obj.get("vehicle")) if obj.get("vehicle") is not None else None,
            "stops": [Stop.from_dict(_item) for _item in obj.get("stops")] if obj.get("stops") is not None else None,
            "path": obj.get("path"),
            "tags": [TagGroup.from_dict(_item) for _item in obj.get("tags")] if obj.get("tags") is not None else None
        })
        return _obj


