# coding: utf-8

"""
    Beckn Protocol Core

    Beckn Core Transaction API specification

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist, validator
from transaction.models.tag_group import TagGroup

class InlineObjectMessageAck(BaseModel):
    """
    InlineObjectMessageAck
    """
    status: Optional[StrictStr] = None
    tags: Optional[conlist(TagGroup)] = Field(default=None, description="A list of tags containing any additional information sent along with the Acknowledgement.")
    __properties = ["status", "tags"]

    @validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('ACK', 'NACK',):
            raise ValueError("must be one of enum values ('ACK', 'NACK')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> InlineObjectMessageAck:
        """Create an instance of InlineObjectMessageAck from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item in self.tags:
                if _item:
                    _items.append(_item.to_dict())
            _dict['tags'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> InlineObjectMessageAck:
        """Create an instance of InlineObjectMessageAck from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return InlineObjectMessageAck.parse_obj(obj)

        _obj = InlineObjectMessageAck.parse_obj({
            "status": obj.get("status"),
            "tags": [TagGroup.from_dict(_item) for _item in obj.get("tags")] if obj.get("tags") is not None else None
        })
        return _obj


