# coding: utf-8

"""
    Beckn Protocol Core

    Beckn Core Transaction API specification

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr
from transaction.models.city import City
from transaction.models.contact import Contact
from transaction.models.descriptor import Descriptor
from transaction.models.state import State

class Organization(BaseModel):
    """
    An organization. Usually a recognized business entity.  # noqa: E501
    """
    descriptor: Optional[Descriptor] = None
    address: Optional[StrictStr] = Field(default=None, description="The postal address of the organization")
    state: Optional[State] = Field(default=None, description="The state where the organization's address is registered")
    city: Optional[City] = Field(default=None, description="The city where the the organization's address is registered")
    contact: Optional[Contact] = None
    __properties = ["descriptor", "address", "state", "city", "contact"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Organization:
        """Create an instance of Organization from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of descriptor
        if self.descriptor:
            _dict['descriptor'] = self.descriptor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of state
        if self.state:
            _dict['state'] = self.state.to_dict()
        # override the default output from pydantic by calling `to_dict()` of city
        if self.city:
            _dict['city'] = self.city.to_dict()
        # override the default output from pydantic by calling `to_dict()` of contact
        if self.contact:
            _dict['contact'] = self.contact.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Organization:
        """Create an instance of Organization from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Organization.parse_obj(obj)

        _obj = Organization.parse_obj({
            "descriptor": Descriptor.from_dict(obj.get("descriptor")) if obj.get("descriptor") is not None else None,
            "address": obj.get("address"),
            "state": State.from_dict(obj.get("state")) if obj.get("state") is not None else None,
            "city": City.from_dict(obj.get("city")) if obj.get("city") is not None else None,
            "contact": Contact.from_dict(obj.get("contact")) if obj.get("contact") is not None else None
        })
        return _obj


