# coding: utf-8

"""
    Beckn Protocol Core

    Beckn Core Transaction API specification

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist, validator
from transaction.models.payment_params import PaymentParams
from transaction.models.tag_group import TagGroup
from transaction.models.time import Time

class Payment(BaseModel):
    """
    Describes the terms of settlement between the BAP and the BPP for a single transaction. When instantiated, this object contains <ol><li>the amount that has to be settled,</li><li>The payment destination destination details</li><li>When the settlement should happen, and</li><li>A transaction reference ID</li></ol>. During a transaction, the BPP reserves the right to decide the terms of payment. However, the BAP can send its terms to the BPP first. If the BPP does not agree to those terms, it must overwrite the terms and return them to the BAP. If overridden, the BAP must either agree to the terms sent by the BPP in order to preserve the provider's autonomy, or abort the transaction. In case of such disagreements, the BAP and the BPP can perform offline negotiations on the payment terms. Once an agreement is reached, the BAP and BPP can resume transactions.  # noqa: E501
    """
    id: Optional[StrictStr] = Field(default=None, description="ID of the payment term that can be referred at an item or an order level in a catalog")
    collected_by: Optional[Any] = None
    url: Optional[StrictStr] = Field(default=None, description="A payment url to be called by the BAP. If empty, then the payment is to be done offline. The details of payment should be present in the params object. If tl_method = http/get, then the payment details will be sent as url params. Two url param values, ```$transaction_id``` and ```$amount``` are mandatory.")
    params: Optional[PaymentParams] = None
    type: Optional[StrictStr] = None
    status: Optional[StrictStr] = None
    time: Optional[Time] = None
    tags: Optional[conlist(TagGroup)] = None
    __properties = ["id", "collected_by", "url", "params", "type", "status", "time", "tags"]

    @validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('PRE-ORDER', 'PRE-FULFILLMENT', 'ON-FULFILLMENT', 'POST-FULFILLMENT',):
            raise ValueError("must be one of enum values ('PRE-ORDER', 'PRE-FULFILLMENT', 'ON-FULFILLMENT', 'POST-FULFILLMENT')")
        return value

    @validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('PAID', 'NOT-PAID',):
            raise ValueError("must be one of enum values ('PAID', 'NOT-PAID')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Payment:
        """Create an instance of Payment from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of params
        if self.params:
            _dict['params'] = self.params.to_dict()
        # override the default output from pydantic by calling `to_dict()` of time
        if self.time:
            _dict['time'] = self.time.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item in self.tags:
                if _item:
                    _items.append(_item.to_dict())
            _dict['tags'] = _items
        # set to None if collected_by (nullable) is None
        # and __fields_set__ contains the field
        if self.collected_by is None and "collected_by" in self.__fields_set__:
            _dict['collected_by'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Payment:
        """Create an instance of Payment from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Payment.parse_obj(obj)

        _obj = Payment.parse_obj({
            "id": obj.get("id"),
            "collected_by": obj.get("collected_by"),
            "url": obj.get("url"),
            "params": PaymentParams.from_dict(obj.get("params")) if obj.get("params") is not None else None,
            "type": obj.get("type"),
            "status": obj.get("status"),
            "time": Time.from_dict(obj.get("time")) if obj.get("time") is not None else None,
            "tags": [TagGroup.from_dict(_item) for _item in obj.get("tags")] if obj.get("tags") is not None else None
        })
        return _obj


