# coding: utf-8

"""
    Beckn Protocol Core

    Beckn Core Transaction API specification

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr, constr, validator

class Price(BaseModel):
    """
    Describes the price of a product or service  # noqa: E501
    """
    currency: Optional[StrictStr] = None
    value: Optional[constr(strict=True)] = Field(default=None, description="Describes a numerical value in decimal form")
    estimated_value: Optional[constr(strict=True)] = Field(default=None, description="Describes a numerical value in decimal form")
    computed_value: Optional[constr(strict=True)] = Field(default=None, description="Describes a numerical value in decimal form")
    listed_value: Optional[constr(strict=True)] = Field(default=None, description="Describes a numerical value in decimal form")
    offered_value: Optional[constr(strict=True)] = Field(default=None, description="Describes a numerical value in decimal form")
    minimum_value: Optional[constr(strict=True)] = Field(default=None, description="Describes a numerical value in decimal form")
    maximum_value: Optional[constr(strict=True)] = Field(default=None, description="Describes a numerical value in decimal form")
    __properties = ["currency", "value", "estimated_value", "computed_value", "listed_value", "offered_value", "minimum_value", "maximum_value"]

    @validator('value')
    def value_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"[+-]?([0-9]*[.])?[0-9]+", value):
            raise ValueError(r"must validate the regular expression /[+-]?([0-9]*[.])?[0-9]+/")
        return value

    @validator('estimated_value')
    def estimated_value_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"[+-]?([0-9]*[.])?[0-9]+", value):
            raise ValueError(r"must validate the regular expression /[+-]?([0-9]*[.])?[0-9]+/")
        return value

    @validator('computed_value')
    def computed_value_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"[+-]?([0-9]*[.])?[0-9]+", value):
            raise ValueError(r"must validate the regular expression /[+-]?([0-9]*[.])?[0-9]+/")
        return value

    @validator('listed_value')
    def listed_value_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"[+-]?([0-9]*[.])?[0-9]+", value):
            raise ValueError(r"must validate the regular expression /[+-]?([0-9]*[.])?[0-9]+/")
        return value

    @validator('offered_value')
    def offered_value_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"[+-]?([0-9]*[.])?[0-9]+", value):
            raise ValueError(r"must validate the regular expression /[+-]?([0-9]*[.])?[0-9]+/")
        return value

    @validator('minimum_value')
    def minimum_value_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"[+-]?([0-9]*[.])?[0-9]+", value):
            raise ValueError(r"must validate the regular expression /[+-]?([0-9]*[.])?[0-9]+/")
        return value

    @validator('maximum_value')
    def maximum_value_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"[+-]?([0-9]*[.])?[0-9]+", value):
            raise ValueError(r"must validate the regular expression /[+-]?([0-9]*[.])?[0-9]+/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Price:
        """Create an instance of Price from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Price:
        """Create an instance of Price from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Price.parse_obj(obj)

        _obj = Price.parse_obj({
            "currency": obj.get("currency"),
            "value": obj.get("value"),
            "estimated_value": obj.get("estimated_value"),
            "computed_value": obj.get("computed_value"),
            "listed_value": obj.get("listed_value"),
            "offered_value": obj.get("offered_value"),
            "minimum_value": obj.get("minimum_value"),
            "maximum_value": obj.get("maximum_value")
        })
        return _obj


