# coding: utf-8

"""
    Beckn Protocol Core

    Beckn Core Transaction API specification

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conint, conlist
from transaction.models.category import Category
from transaction.models.descriptor import Descriptor
from transaction.models.fulfillment import Fulfillment
from transaction.models.item import Item
from transaction.models.location import Location
from transaction.models.offer import Offer
from transaction.models.payment import Payment
from transaction.models.tag_group import TagGroup
from transaction.models.time import Time

class Provider(BaseModel):
    """
    Describes the catalog of a business.  # noqa: E501
    """
    id: Optional[StrictStr] = Field(default=None, description="Id of the provider")
    descriptor: Optional[Descriptor] = None
    category_id: Optional[StrictStr] = Field(default=None, description="Category Id of the provider at the BPP-level catalog")
    rating: Optional[StrictStr] = Field(default=None, description="Rating value given to the object. This can be a single value or can also contain an inequality operator like gt, gte, lt, lte. This can also contain an inequality expression containing logical operators like && and ||.")
    time: Optional[Time] = None
    categories: Optional[conlist(Category)] = None
    fulfillments: Optional[conlist(Fulfillment)] = None
    payments: Optional[conlist(Payment)] = None
    locations: Optional[conlist(Location)] = None
    offers: Optional[conlist(Offer)] = None
    items: Optional[conlist(Item)] = None
    exp: Optional[datetime] = Field(default=None, description="Time after which catalog has to be refreshed")
    rateable: Optional[StrictBool] = Field(default=None, description="Whether this provider can be rated or not")
    ttl: Optional[conint(strict=True, ge=-1)] = Field(default=None, description="The time-to-live in seconds, for this object. This can be overriden at deeper levels. A value of -1 indicates that this object is not cacheable.")
    tags: Optional[conlist(TagGroup)] = None
    __properties = ["id", "descriptor", "category_id", "rating", "time", "categories", "fulfillments", "payments", "locations", "offers", "items", "exp", "rateable", "ttl", "tags"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Provider:
        """Create an instance of Provider from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of descriptor
        if self.descriptor:
            _dict['descriptor'] = self.descriptor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of time
        if self.time:
            _dict['time'] = self.time.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in categories (list)
        _items = []
        if self.categories:
            for _item in self.categories:
                if _item:
                    _items.append(_item.to_dict())
            _dict['categories'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in fulfillments (list)
        _items = []
        if self.fulfillments:
            for _item in self.fulfillments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['fulfillments'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in payments (list)
        _items = []
        if self.payments:
            for _item in self.payments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['payments'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in locations (list)
        _items = []
        if self.locations:
            for _item in self.locations:
                if _item:
                    _items.append(_item.to_dict())
            _dict['locations'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in offers (list)
        _items = []
        if self.offers:
            for _item in self.offers:
                if _item:
                    _items.append(_item.to_dict())
            _dict['offers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in items (list)
        _items = []
        if self.items:
            for _item in self.items:
                if _item:
                    _items.append(_item.to_dict())
            _dict['items'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item in self.tags:
                if _item:
                    _items.append(_item.to_dict())
            _dict['tags'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Provider:
        """Create an instance of Provider from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Provider.parse_obj(obj)

        _obj = Provider.parse_obj({
            "id": obj.get("id"),
            "descriptor": Descriptor.from_dict(obj.get("descriptor")) if obj.get("descriptor") is not None else None,
            "category_id": obj.get("category_id"),
            "rating": obj.get("rating"),
            "time": Time.from_dict(obj.get("time")) if obj.get("time") is not None else None,
            "categories": [Category.from_dict(_item) for _item in obj.get("categories")] if obj.get("categories") is not None else None,
            "fulfillments": [Fulfillment.from_dict(_item) for _item in obj.get("fulfillments")] if obj.get("fulfillments") is not None else None,
            "payments": [Payment.from_dict(_item) for _item in obj.get("payments")] if obj.get("payments") is not None else None,
            "locations": [Location.from_dict(_item) for _item in obj.get("locations")] if obj.get("locations") is not None else None,
            "offers": [Offer.from_dict(_item) for _item in obj.get("offers")] if obj.get("offers") is not None else None,
            "items": [Item.from_dict(_item) for _item in obj.get("items")] if obj.get("items") is not None else None,
            "exp": obj.get("exp"),
            "rateable": obj.get("rateable"),
            "ttl": obj.get("ttl"),
            "tags": [TagGroup.from_dict(_item) for _item in obj.get("tags")] if obj.get("tags") is not None else None
        })
        return _obj


