# coding: utf-8

"""
    Beckn Protocol Core

    Beckn Core Transaction API specification

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist
from transaction.models.price import Price
from transaction.models.quotation_breakup_inner import QuotationBreakupInner

class Quotation(BaseModel):
    """
    Describes a quote. It is the estimated price of products or services from the BPP.<br>This has properties like price, breakup, ttl  # noqa: E501
    """
    id: Optional[StrictStr] = Field(default=None, description="ID of the quote.")
    price: Optional[Price] = Field(default=None, description="The total quoted price")
    breakup: Optional[conlist(QuotationBreakupInner)] = Field(default=None, description="the breakup of the total quoted price")
    ttl: Optional[StrictStr] = Field(default=None, description="Describes duration as per ISO8601 format")
    __properties = ["id", "price", "breakup", "ttl"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Quotation:
        """Create an instance of Quotation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of price
        if self.price:
            _dict['price'] = self.price.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in breakup (list)
        _items = []
        if self.breakup:
            for _item in self.breakup:
                if _item:
                    _items.append(_item.to_dict())
            _dict['breakup'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Quotation:
        """Create an instance of Quotation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Quotation.parse_obj(obj)

        _obj = Quotation.parse_obj({
            "id": obj.get("id"),
            "price": Price.from_dict(obj.get("price")) if obj.get("price") is not None else None,
            "breakup": [QuotationBreakupInner.from_dict(_item) for _item in obj.get("breakup")] if obj.get("breakup") is not None else None,
            "ttl": obj.get("ttl")
        })
        return _obj


