# coding: utf-8

"""
    Beckn Protocol Core

    Beckn Core Transaction API specification

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, validator
from transaction.models.location import Location
from transaction.models.state import State
from transaction.models.time import Time

class ReturnTerm(BaseModel):
    """
    Describes the return policy of an item or an order  # noqa: E501
    """
    fulfillment_state: Optional[State] = Field(default=None, description="The state of fulfillment during which this term IETF''s applicable.")
    return_eligible: Optional[StrictBool] = Field(default=None, description="Indicates whether the item is eligible for return")
    return_time: Optional[Time] = Field(default=None, description="Applicable only for buyer managed returns where the buyer has to return the item to the origin before a certain date-time, failing which they will not be eligible for refund.")
    return_location: Optional[Location] = Field(default=None, description="The location where the item or order must / will be returned to")
    fulfillment_managed_by: Optional[StrictStr] = Field(default=None, description="The entity that will perform the return")
    __properties = ["fulfillment_state", "return_eligible", "return_time", "return_location", "fulfillment_managed_by"]

    @validator('fulfillment_managed_by')
    def fulfillment_managed_by_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('CONSUMER', 'PROVIDER',):
            raise ValueError("must be one of enum values ('CONSUMER', 'PROVIDER')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ReturnTerm:
        """Create an instance of ReturnTerm from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of fulfillment_state
        if self.fulfillment_state:
            _dict['fulfillment_state'] = self.fulfillment_state.to_dict()
        # override the default output from pydantic by calling `to_dict()` of return_time
        if self.return_time:
            _dict['return_time'] = self.return_time.to_dict()
        # override the default output from pydantic by calling `to_dict()` of return_location
        if self.return_location:
            _dict['return_location'] = self.return_location.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ReturnTerm:
        """Create an instance of ReturnTerm from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ReturnTerm.parse_obj(obj)

        _obj = ReturnTerm.parse_obj({
            "fulfillment_state": State.from_dict(obj.get("fulfillment_state")) if obj.get("fulfillment_state") is not None else None,
            "return_eligible": obj.get("return_eligible"),
            "return_time": Time.from_dict(obj.get("return_time")) if obj.get("return_time") is not None else None,
            "return_location": Location.from_dict(obj.get("return_location")) if obj.get("return_location") is not None else None,
            "fulfillment_managed_by": obj.get("fulfillment_managed_by")
        })
        return _obj


