# coding: utf-8

"""
    Beckn Protocol Core

    Beckn Core Transaction API specification

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr, constr, validator
from transaction.models.scalar_range import ScalarRange

class Scalar(BaseModel):
    """
    Describes a scalar  # noqa: E501
    """
    type: Optional[StrictStr] = None
    value: Optional[constr(strict=True)] = Field(default=None, description="Describes a numerical value in decimal form")
    estimated_value: Optional[constr(strict=True)] = Field(default=None, description="Describes a numerical value in decimal form")
    computed_value: Optional[constr(strict=True)] = Field(default=None, description="Describes a numerical value in decimal form")
    range: Optional[ScalarRange] = None
    unit: Optional[StrictStr] = None
    __properties = ["type", "value", "estimated_value", "computed_value", "range", "unit"]

    @validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('CONSTANT', 'VARIABLE',):
            raise ValueError("must be one of enum values ('CONSTANT', 'VARIABLE')")
        return value

    @validator('value')
    def value_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"[+-]?([0-9]*[.])?[0-9]+", value):
            raise ValueError(r"must validate the regular expression /[+-]?([0-9]*[.])?[0-9]+/")
        return value

    @validator('estimated_value')
    def estimated_value_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"[+-]?([0-9]*[.])?[0-9]+", value):
            raise ValueError(r"must validate the regular expression /[+-]?([0-9]*[.])?[0-9]+/")
        return value

    @validator('computed_value')
    def computed_value_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"[+-]?([0-9]*[.])?[0-9]+", value):
            raise ValueError(r"must validate the regular expression /[+-]?([0-9]*[.])?[0-9]+/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Scalar:
        """Create an instance of Scalar from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of range
        if self.range:
            _dict['range'] = self.range.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Scalar:
        """Create an instance of Scalar from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Scalar.parse_obj(obj)

        _obj = Scalar.parse_obj({
            "type": obj.get("type"),
            "value": obj.get("value"),
            "estimated_value": obj.get("estimated_value"),
            "computed_value": obj.get("computed_value"),
            "range": ScalarRange.from_dict(obj.get("range")) if obj.get("range") is not None else None,
            "unit": obj.get("unit")
        })
        return _obj


