# coding: utf-8

"""
    Beckn Protocol Core

    Beckn Core Transaction API specification

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, constr, validator

class ScalarRange(BaseModel):
    """
    ScalarRange
    """
    min: Optional[constr(strict=True)] = Field(default=None, description="Describes a numerical value in decimal form")
    max: Optional[constr(strict=True)] = Field(default=None, description="Describes a numerical value in decimal form")
    __properties = ["min", "max"]

    @validator('min')
    def min_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"[+-]?([0-9]*[.])?[0-9]+", value):
            raise ValueError(r"must validate the regular expression /[+-]?([0-9]*[.])?[0-9]+/")
        return value

    @validator('max')
    def max_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"[+-]?([0-9]*[.])?[0-9]+", value):
            raise ValueError(r"must validate the regular expression /[+-]?([0-9]*[.])?[0-9]+/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ScalarRange:
        """Create an instance of ScalarRange from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ScalarRange:
        """Create an instance of ScalarRange from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ScalarRange.parse_obj(obj)

        _obj = ScalarRange.parse_obj({
            "min": obj.get("min"),
            "max": obj.get("max")
        })
        return _obj


