# coding: utf-8

"""
    Beckn Protocol Core

    Beckn Core Transaction API specification

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr, validator
from transaction.models.location import Location

class Tracking(BaseModel):
    """
    Contains tracking information that can be used by the BAP to track the fulfillment of an order in real-time. which is useful for knowing the location of time sensitive deliveries.  # noqa: E501
    """
    id: Optional[StrictStr] = Field(default=None, description="A unique tracking reference number")
    url: Optional[StrictStr] = Field(default=None, description="A URL to the tracking endpoint. This can be a link to a tracking webpage, a webhook URL created by the BAP where BPP can push the tracking data, or a GET url creaed by the BPP which the BAP can poll to get the tracking data. It can also be a websocket URL where the BPP can push real-time tracking data.")
    location: Optional[Location] = Field(default=None, description="In case there is no real-time tracking endpoint available, this field will contain the latest location of the entity being tracked. The BPP will update this value everytime the BAP calls the track API.")
    status: Optional[StrictStr] = Field(default=None, description="This value indicates if the tracking is currently active or not. If this value is `active`, then the BAP can begin tracking the order. If this value is `inactive`, the tracking URL is considered to be expired and the BAP should stop tracking the order.")
    __properties = ["id", "url", "location", "status"]

    @validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('active', 'inactive',):
            raise ValueError("must be one of enum values ('active', 'inactive')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Tracking:
        """Create an instance of Tracking from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of location
        if self.location:
            _dict['location'] = self.location.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Tracking:
        """Create an instance of Tracking from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Tracking.parse_obj(obj)

        _obj = Tracking.parse_obj({
            "id": obj.get("id"),
            "url": obj.get("url"),
            "location": Location.from_dict(obj.get("location")) if obj.get("location") is not None else None,
            "status": obj.get("status")
        })
        return _obj


