# coding: utf-8

"""
    Beckn Protocol Core

    Beckn Core Transaction API specification

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel, Field, StrictStr
from transaction.models.order import Order

class UpdateMessage(BaseModel):
    """
    UpdateMessage
    """
    update_target: StrictStr = Field(default=..., description="Comma separated values of order objects being updated. For example: ```\"update_target\":\"item,billing,fulfillment\"```")
    order: Order = Field(default=..., description="Updated order object")
    __properties = ["update_target", "order"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UpdateMessage:
        """Create an instance of UpdateMessage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of order
        if self.order:
            _dict['order'] = self.order.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UpdateMessage:
        """Create an instance of UpdateMessage from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return UpdateMessage.parse_obj(obj)

        _obj = UpdateMessage.parse_obj({
            "update_target": obj.get("update_target"),
            "order": Order.from_dict(obj.get("order")) if obj.get("order") is not None else None
        })
        return _obj


